/* Check arguments */                 

#ifndef(flare_scale)      #declare flare_scale = <0.5, 0.5, 0.5>;   #end
#ifndef(flare_colour)     #declare flare_colour = <0.9, 0.8, 1.1>;  #end
#ifndef(bar_colour)       #declare bar_colour = <0.7, 0.8, 1.1>;    #end
#ifndef(flare_location)   #declare flare_location = <20, 20, -128>; #end
#ifndef(flare_brightness) #declare flare_brightness = 1.5;          #end                    
#ifndef(camera_look_at)   #declare camera_look_at = <0, 0, 1>;      #end                     
#ifndef(camera_location)  #declare camera_location = <0, 0, 0>;     #end
#ifndef(moving_spot)      #declare moving_spot = true;              #end                                          

/* create vars */

#local camtolight = flare_location - camera_location;
#local camtolightdist = vlength(camtolight);
#local invcamtolightdist = 1.0/camtolightdist;
#local camnorm = camtolight * invcamtolightdist;
#local camdir = camera_look_at - camera_location;
#local normcamdir = vnormalize(camdir);
#local beta = 57.29577951*atan2(camdir.y, sqrt(camdir.x*camdir.x + camdir.z*camdir.z));
#local gamma = -57.29577951*atan2(camdir.z, camdir.x);
#local spacing = 0.005;
#local speed1 = 1.0/vlength(camdir);
#local interang = vdot(camtolight, camdir) * invcamtolightdist * speed1; 

//#local spotdir = -camtolight + camdir * (vdot(camdir, camtolight)*speed1);
//#local spotdir = (-camtolight + (camdir * vdot(camtolight, camdir)/vdot(camdir, camdir)));
#local spotdir = camera_location - camtolight + normcamdir * vdot(normcamdir, camtolight);
#local mvspotpos = 1.0 * spotdir;

disc {
      <0, 0, 0>,
      <1, 0, 0>,
      1.0
      
      hollow
      no_shadow

      pigment {
               onion
               colour_map {
                        [0.0 rgb bar_colour transmit (1.0 - 0.4*interang)]
                        [1.0 rgb bar_colour transmit 1.0]
                       }
              }
              
      finish {
              ambient flare_brightness
              diffuse 0.0
             }
             
      scale flare_scale
      scale <1, 0.03, 1>
      scale camtolightdist 
      rotate <0, 0, beta>
      rotate <0, gamma, 0>
      translate (flare_location - 2 * camnorm * spacing)
     }             
     
disc {
      <0, 0, 0>,
      <1, 0, 0>,
      1.0

      hollow
      no_shadow

      pigment {
               onion
               colour_map {
                        [0.1 rgb flare_colour transmit 0.4]                        
                        [1.0 rgb flare_colour transmit 1.0]
                       }
              }
              
      finish {
              ambient flare_brightness
              diffuse 0.0
             }
             
      scale flare_scale
      scale <0.275, 0.176, 0.275>      
      scale camtolightdist 
      rotate <0, 0, beta>
      rotate <0, gamma, 0>
      translate (flare_location)
      
     }                            
disc {
      <0, 0, 0>,
      <1, 0, 0>,
      1.0

      hollow
      no_shadow

      pigment {
               onion
               colour_map {
                        [0.42 rgb flare_colour transmit 1.0]
                        [0.48 rgb flare_colour transmit (1.0 - 0.15 * interang)]
                        [0.5 rgb flare_colour transmit (1.0 - 0.3 * interang)]
                        [0.52 rgb flare_colour transmit (1.0 - 0.15 * interang)]
                        [0.58 rgb flare_colour transmit 1.0]
                       }
              }
              
      finish {
              ambient flare_brightness
              diffuse 0.0
             }
             
      scale flare_scale
      scale <0.65, .36, 0.65>
      scale camtolightdist 
      rotate <0, 0, beta>
      rotate <0, gamma, 0>
      translate (flare_location + 2 * camnorm * spacing)
     }     

#local RL = seed(1300);     

merge {     
#declare loop = 0;
#while(loop<7)
disc {
      <0, 0, 0>,
      <1, 0, 0>,
      1.0

      pigment {
               onion
               colour_map {
                        [0.0 rgb bar_colour transmit 0.6]
                        [1.0 rgb bar_colour transmit 1.0]
                       }
              }
              
      finish {
              ambient flare_brightness
              diffuse 0.0
             }
             
      scale flare_scale
      scale camtolightdist      
      scale <0.15, 0.01, 0.115*(1+rand(RL))>                         
      rotate <90 + 24 * loop, 0, 0>                 
      rotate <0, 0, beta>
      rotate <0, gamma, 0>            
      translate (flare_location + camnorm * spacing)
     }       

#declare loop = loop + 1;
#end
}

// moving spot
#if(moving_spot)
disc {
      <0, 0, 0>,
      //<1, 0, 0>,
      (camera_location - mvspotpos - flare_location) 
      1.0

      hollow
      no_shadow

      pigment {
               onion    
               colour_map {
                        [0.22 rgb flare_colour transmit 1.0]
                        [0.33 rgb flare_colour transmit 0.90]
                        [0.5 rgb flare_colour transmit 0.75]
                        [0.67 rgb flare_colour transmit 0.90]
                        [0.78 rgb flare_colour transmit 1.0]
                       }
              }
              
      finish {
              ambient flare_brightness
              diffuse 0.0
             }
             
      scale flare_scale
      scale <0.300, 0.180, 0.300>      
      scale camtolightdist 
      translate (flare_location + mvspotpos + camtolight * 8 * spacing)
     }
#end

     
global_settings { max_trace_level 30 }