// Absorption shield file


// Speedups

#local decay = exp(-s_decay*sclock);

// Colours/Materials

#declare s_plas = pigment {
                           bozo    
                           turbulence s_turbulence             
                           scale s_shield_grain                           
                           color_map {
                                      [(1-decay) rgb s_shield_colour transmit 1.0]                                      
                                      [1.0       rgb s_shot_colour transmit (1-s_shot_intensity)]
                                     }                                                    
                                     
                           rotate (sclock*s_scramble)    // Make the shield look 'randomised' in an animation
                          }
                          
#declare s_bubble = pigment { color rgb s_shield_colour transmit 1.0}           // Shield background colour


// Shield texture

#declare s_shield_texture = texture {
                                     pigment {                          
                                              gradient y    // this provides the fade from weapon colour to shield colour
                                            
                                              pigment_map {
                                                           [0.00               s_plas]
                                                           [(s_coverage*decay) s_bubble]
                                                          }               
                                             }
                         
                                     finish {
                                             ambient s_shield_intensity*decay
                                             diffuse 0.0
                                            }                                                        // The shield does not depend on outside light sources for illumination                                                         
                                    } 
               
