/* Persistence of Vision Ray Tracer include Description File
   File: shield.inc
   Vers: Pov 3.1
   Desc: Energy shield generator
   Date: 5/5/1999
   Auth: Thomas York (mbcx7tdy@stud.man.ac.uk)
*/


/* Settings */

// Convert color -> colour

#ifdef(s_shot_color)            
#declare s_shot_colour = s_shot_color;
#end
#ifdef(s_shield_color)          
#declare s_shield_colour = s_shield_color;      
#end

// Check settings and impose default values if necessary

#ifndef(s_create)
#declare s_create = true;
#end

#ifndef(s_current_shield)
#declare s_current_shield = 1;
#else
#declare s_current_shield = s_current_shield + 1;
#end

#ifndef(s_shield_style)         
#declare s_shield_style = "absorption"            // Shield style
#else
#declare s_shield_style = strlwr(s_shield_style)  // Ensure that s_shield_style is lower case
#end

#ifndef(s_shot_dir)             
#declare s_shot_dir = <0, 0, 1>;                // Direction weapons fire is travelling in
#else
#declare s_shot_dir = vnormalize(s_shot_dir);   // If defined, check that s_shot_dir is normalised
#end

#ifndef(s_centre)               
#declare s_centre = <0, 0, 0>;    // Centre of shield bubble
#end 

#ifndef(s_shot_colour)          
#declare s_shot_colour = <1.2, 0.7, 0.7>;    // Colour of shot
#end

#ifndef(s_shield_colour)
#declare s_shield_colour = <0.6, 0.6, 0.9>;  // Colour of shield
#end  

#ifndef(s_scale)                
#declare s_scale = <1, 1, 1>;     // Scale factor for making ellipsoidal shields
#end

#ifndef(s_decay)                
#declare s_decay = 3;             // Rate of disappearance of the shield flare effect
#end

#ifndef(s_shield_intensity)     
#declare s_shield_intensity = 0.81;   // Intensity of the shield flare
#end

#ifndef(s_shot_intensity)       
#declare s_shot_intensity = 1.0;      // Intensity of the weapons fire                                      
#end

#ifndef(s_cstart)               
#declare s_cstart = 0;                // Starting clock value for the effect
#end
#ifndef(s_cend)                 
#declare s_cend = 1;                  // Ending clock value for the effect
#end
#ifndef(s_coverage)             
#declare s_coverage = 0.2;            // Percentage of the shield energised by the weapons fire
#end
#ifndef(s_shield_grain)         
#declare s_shield_grain = <0.05, 0.05, 0.05>;  // Scale factor of the 'details' in the shield
#end
#ifndef(s_background)           
#declare s_background = <0.0, 0.0, 0.0>;       // Don't reflect by default
#end
#ifndef(s_scramble)           
#declare s_scramble = <3e4, 3e4, 3e4>;       // sparkle for absorption and hybrid shields
#end
#ifndef(s_turbulence)           
#declare s_turbulence = <0.4, 0.4, 0.4>;       // turbulence vector for shield pigments
#end
                                     
/* Internals */

// Timing

#if(clock>=s_cstart & clock<=s_cend)                        // start actual shield 'generation'

#declare sclock = (clock - s_cstart)/(s_cend - s_cstart);    // Set the internal clock


// Macros and helper 'functions'
    
    
#macro convert_coords(dir, h_sangle, v_sangle)

#declare v_sangle = 180*acos(dir.y)/pi; // Find vertical impact angle 

#if((v_sangle = 0) | (v_sangle = 180))  
#declare h_sangle = 0;
#else                
#declare h_sangle = 180*atan2(dir.z, dir.x)/pi;                
#end

#end


// Choose shield style - Add your custom shield type here

#declare s_spatial = false;                     // Avoid problems with multiple shields

#if(strcmp(s_shield_style, "absorption") = 0)        
#include "shield\absorb.inc"
#end 
#if(strcmp(s_shield_style, "reflection") = 0)
#include "shield\reflect.inc"
#end
#if(strcmp(s_shield_style, "distortion") = 0)
#include "shield\distort.inc"
#end
#if(strcmp(s_shield_style, "flat") = 0)
#include "shield\flat.inc"
#end                          
#if(strcmp(s_shield_style, "lightening") = 0)
#include "shield\light.inc"
#end                          
#if(strcmp(s_shield_style, "hybrid") = 0)
#include "shield\hybrid.inc"
#end
#if(strcmp(s_shield_style, "ripple") = 0)
#include "shield\ripple.inc"
#end


/* Make Shield object */
#if(s_create=true) 
sphere {
        <0, 0, 0>,
        1
        
        texture {                 
                 s_shield_texture

                 scale <1, 2, 1>  
                 
                 // Find intersection of weapon with shield              
                 
                 #declare phi = 0;
                 #declare theta = 0;
                 
                 convert_coords(s_shot_dir, phi, theta)
                 
                 rotate <0, 0, -theta>                 
                 rotate <0, -phi, 0>                                 
                 translate -s_shot_dir                                                                             
                }
       
        // Provision for interior effects
       
        #if(s_spatial = true)
                       
        interior {
                  s_shield_interior
                 } 
                
        #else
        hollow        
        #end 
        
        scale s_scale       
        translate s_centre        
       } 

#else
#declare myshield = sphere {
        <0, 0, 0>,
        1
        
        texture {                 
                 s_shield_texture

                 scale <1, 2, 1>  
                 
                 // Find intersection of weapon with shield              
                 
                 #declare phi = 0;
                 #declare theta = 0;
                 
                 convert_coords(s_shot_dir, phi, theta)
                 
                 rotate <0, 0, -theta>                 
                 rotate <0, -phi, 0>                                 
                 translate -s_shot_dir                                                                             
                }
       
        // Provision for interior effects
       
        #if(s_spatial = true)
                       
        interior {
                  s_shield_interior
                 } 
                
        #else
        hollow        
        #end 
        
        scale s_scale       
        translate s_centre        
       } 
#end


#else           // If outside time range
#warning concat("Shield ", concat(str(s_current_shield, 0, 0), " not generated for this frame\n"))
#end   // End include


