//AlienSpin.pov

//#version unofficial MegaPov 0.5;  // version number may be different

#include "colors.inc"
#include "Alien.inc"
#include "planet.inc"

#declare EClock = clock * 5;
//#declare EClock = 4.8;        //For Test Renders

camera
{
  location  <0.0, 10, -20.0 + EClock/4>
  look_at   <0.0, -5,  0.0>
}

difference
{
  object
  {
    MyGround
    normal
    {
      bumps
      scale 0.5
    }
  }
  #if (EClock > 4)
    cylinder { -20 * y, 50 * y, (EClock - 3.5) }
  #else
    sphere { 50 * y, 0.001 pigment { color rgbt 1 } }
  #end
}
//plane { y, -4 }
#declare Light_Spot = <0, -3.75, 0>;


light_source
{
  Light_Spot
  color rgb <0.5, 0.5, 0.9>
  looks_like 
  {
    sphere { 0, 1 texture {pigment {radial frequency 8} finish{specular 1} } }
  }
}

//The Aliens
#macro AlienCircleR(MaxCount, Texture1, Texture2, AlienRadius, AlienElev, Rotation)
  union {
  #declare Count = 0;
  #while (Count < MaxCount)
    object 
    {
      BasicAlien 
      #if (mod(Count, 2))
        pigment { Texture1 }
      #else
        pigment { Texture2 }
      #end

      rotate (Rotation) * y      
      translate AlienRadius*z
      rotate (360/MaxCount)*Count*y
      translate <0, AlienElev, 0>
    }
    #declare Count = Count + 1;
  #end
  }
#end

#declare AlienDist = 8.5;
#declare NumAliens = 12;
#declare AlienElev = -10;
#declare Texture1 = pigment { color rgb<0, 0, 1> }
#declare Texture2 = pigment { color rgb<1, 0, 0> }
#declare Emis1 = color rgb<0, 0.5, 1>;
#declare Emis2 = color rgb<1, 0.5, 0>;

#declare RotAccel = 120;
#declare GRotate = 0.5 * EClock * EClock * RotAccel ;
#declare IRotate = GRotate;

#declare DispAccel = -10/9;
#declare Displacement = 0.5 * EClock * EClock * DispAccel;

object
{ 
  AlienCircleR(NumAliens, Texture1, Texture2, AlienDist - EClock, AlienElev, IRotate)
  rotate GRotate * y
  translate <0, Displacement, 0>
}

object 
{ PowerWeave(NumAliens, Emis1, Emis2, AlienDist - EClock, AlienElev + 6, 0.65, 0, 2, 0)
  pigment { color rgbt 1 }
  rotate GRotate * y
  translate <0, Displacement, 0>
}

cylinder
{ Light_Spot, <0, Displacement + AlienElev + 6, 0>, 1
  pigment { color rgbt 1 }
  hollow
  interior { media { emission rgb<1, 1, 2> } }
}


#if (EClock >= 4)
  #declare Padding = 0.05;
  #declare Max_Count = 3;
  #declare Count = 0;
  #while (Count < Max_Count)
    #if ( ((EClock - 3.5) - (Count * Padding)) > 0)
      cylinder
      {
        -20 * y, 50 * y, ((EClock - 3.5) - (Count * Padding)) * 15
        texture
        {
          pigment
          {
            bozo
            scale 1/(5 * EClock - 10)
            color_map
            {
              [0 color Clear]
              [0.4 color Clear]
              [0.6 color Red]
              [0.8 color Red]
            }
          }
        }
        hollow
        interior
        {
          media { emission rgb<0.3, 0.1, 0.2> * 3}
        }
        no_shadow
      }
    #end
    #declare Count = Count + 1;
  #end
#end
