//EdPlanet.pov

#version unofficial MegaPOV 0.5;

#include "colors.inc"   
#include "textures.inc"

#include "planet.inc"
#include "alien.inc"

#declare EClock = clock * 1.6;
//#declare EClock = 0.999999999;    //For Test Renders

#declare IsCrtr = (EClock >= 1.2);


difference
{
  Planet(IsCrtr)
  #if (EClock >= 1)
    cylinder { <0, -15, 0>, <0, 1, 0>, (EClock - 1) * 150 pigment { Clear }}
  #end
  translate <0, -0.1, 0>
}

#if (EClock >= 1)
  intersection
  {
    object { MyGround normal { bumps scale 0.5 } }
    cylinder { <0, -15, 0>, <0, 1, 0>, (EClock - 1) * 150 pigment { Clear }}
  }
#end


#macro Pod(FPodLoc, FMPodLoc, BMPodLoc, BPodLoc, PodRad, PodTex)
merge
{
  cone{ FPodLoc, 0, FMPodLoc, PodRad }
  cylinder{ FMPodLoc, BMPodLoc, PodRad }
  cone{ BMPodLoc, PodRad BPodLoc, 0 }
  texture { PodTex }
}
#end

#if (EClock <= 1)
  #init_3d_spline
  {
    "PodSpline",
    <50, 400, 50>,
    <25, 300, 0>,
    <15, 200, -15>,
    <7, 100, -7>,
    <0, 0, 0>
  }

  #init_3d_spline
  {
    "CamSpline",
    <0, 360, 0>,
    <5, 275, 5>,
    <10, 210, 10>,
    <15, 140, 15>,
    <50, 50, 25>
  }

  #init_3d_spline
  {
    "CamDev",
    <0, 0, 0>,
    <5, 0, 0>,
    <5, 5, 0>,
    <0, 5, 5>,
    <-5, 0, 5>,
    <-5, -5, 0>,
    <-5, 0, -5>,
    <0, 0, -5>  
  }
#else
  #init_3d_spline
  {
    "CamSpotSpline",
    <50, 50, 25>,
    <25, 50, 50>,
    <-25, 50, 50>,
    <-25, 25, 0>,
    <0, 15, -15>, //New
    <0, 10, -20>
  } 

  #init_3d_spline
  {
    "CamLookSpline",
    <0, 0, 0>,
    <0, 5, 0>,
    <0, -5, 0>
  }
#end

//Pod(FPodLoc, FMPodLoc, BMPodLoc, BPodLoc, PodRad, PodTex)
#if (EClock <= 1.1)
  #declare PTex = texture { Chrome_Metal }
  Pod(
    eval_3d_spline ("PodSpline", EClock) + <0, -1, 0>,
    eval_3d_spline ("PodSpline", EClock) + <0, -0.3, 0>,
    eval_3d_spline ("PodSpline", EClock) + <0, 0.3, 0>,
    eval_3d_spline ("PodSpline", EClock) + <0, 1, 0>,
    1, PTex
  )
#end

#if (EClock <= 1)
  camera
  {
    location eval_3d_spline("CamSpline", EClock)
    look_at eval_3d_spline("PodSpline", EClock) + eval_3d_spline("CamDev", mod(EClock,9) / 8)
  }
#else
  camera
  {
    location eval_3d_spline("CamSpotSpline", (EClock - 1) / 0.6) 
    look_at eval_3d_spline("CamLookSpline", (EClock - 1) / 0.6) 
  }
#end

//Flash!
#if (abs(EClock - 1) <= 0.001)
  sphere { eval_3d_spline("CamSpline", EClock), 1 hollow pigment { color White * 100 } }
#end



#macro BlowUp(Rad)
  sphere
  {
    <0, 0, 0>, Rad
    texture
    {
      pigment
      {
        bozo
        color_map
        {
          [0 color Clear]
          [0.4 color Clear]
          [0.6 color Red]
          [0.8 color Red]
        }
      }
    }
    hollow
    interior
    {
      media { emission rgb<0.3, 0.1, 0.2> }
    }
    no_shadow
  }
#end


//Touchdown!
#if (EClock >= 1)
  #declare bClock = (EClock - 1) / 0.6;
  #declare LDif = 1;

    
  //Chromatic Lamp
  light_source
  {
    <0, -5, 0>
    color rgb <0.5, 0.5, 0.9>
    looks_like 
    {
      sphere { 0, 1 texture {pigment {radial frequency 8} finish{specular 1} } }
    }
  }

  //Boom!  
  
  #if (EClock <= 1.2)
    #declare LDif = 1;
    #while (EClock - LDif > 0)
      BlowUp((EClock - LDif) * 100)
      #declare LDif = LDif + 0.01;
    #end
  #else
    #declare LDif = 1.4;
    #while (LDif >= 1)
      BlowUp( (LDif - EClock) * 100)
      #declare LDif = LDif - 0.01;
    #end
  #end
  
  torus
  {
    (EClock - 1) * 150,
    (EClock - 1) * 25
    texture
    {
      pigment
      {
        bozo
        color_map
        {
          [0 color Clear]
          [0.4 color Clear]
          [0.6 color Red]
          [0.8 color Red]
        }
      }
    }
    hollow
    interior
    {
      media { emission rgb<0.3, 0.1, 0.2> }
    }
    no_shadow
  }
#end