//Planet.inc

#version unofficial MegaPOV 0.5;

//MUST include "colors.inc" before this file!!!

global_settings
{
  assumed_gamma 1.0
  //ambient_light 2
}

//The Sky (stars)
sky_sphere
{
  pigment
  {
    bozo
    turbulence 100
    color_map
    {
      [0.0 color Black]
      [0.448 color Black]
      [0.45 color White]
      [0.452 color Black]
      [0.975 color Black]
//      [0.98 color White]
      [0.99 color Black]
      [1.0 color Black]
    }
    scale 10
  }
}


light_source
{
  <-100000, 100000, 100000>
  color red 1.0  green 1.0  blue 1.0  // light's color
  looks_like
  {
    sphere
    {
      <-100000, 100000, 100000>, 1000
      pigment { color Yellow }
    }
  }
}


//The Planet
#macro Planet(IsCrater)
  intersection
  {
    sphere 
    { 
      <0, -10000, 0>, 10000
    }
  
    #if (IsCrater != false)
      cone { <0, -10, 0>, 10, <0, 1, 0>, 15 inverse }
    #end
  
    pigment {color rgb <0.7,0.5,0.3>}
    normal
    {
      bumps
      scale 75
    }
    normal
    {
      bumps
      scale 0.5
    }
  }
#end