/*

   Dave Attacks! by Dave Blandston for POV 3.1g. To use this file, you'll
   need to supply your favorite image and bump maps of the Earth (or whatever
   planet you want, I suppose), and also Chris Colefax's Galaxy Include File.

   You can animate the opening on the bottom of the UFOs by using the
   ApertureClock variable (see below).

   For a quick test render, set the HighQuality variable to false.

*/

global_settings {max_trace_level 200}

#local HighQuality = true;

#local MinRotations = 2;
#local MaxRotations = 5;

#local nUFOs = 280;

#include "colors.inc"
#include "metals.inc"

#local Randomizer = seed (1);
#local LocRandomizer = seed (12);

camera {
   location <0, 0, -200>
   direction <0, 0, 1.5>
   look_at 0
} //camera

light_source {<-1000, 200, -800> color White * 1.4}

#if (HighQuality)
   #local UFOColor = texture {
      pigment {
         granite
         color_map {[0, 1 color rgb <.9020, .8196, .6824> color rgb <.552, .468, .372>]}
         scale 2.3
      } //pigment
      finish {phong .2 reflection .1 metallic}
      normal {bumps .12 scale .1}
   } //texture
   texture {
      pigment {
         crackle
         turbulence .6
         lambda 3
         omega .4
         color_map {
            [0 color DarkOliveGreen * .33 filter .5]
            [1 color Black filter 1]
         } //color_map
      } //pigment
      finish {phong .1 reflection .06}
   } //texture
   #local BubbleColor = texture {T_Silver_1D}
#else
   #local UFOColor = texture {
      pigment {
         granite
         color_map {
            [0 color DarkOliveGreen]
            [1 color NewTan]
         } //color_map
      } //pigment
      scale 2.6
   } //texture
   #local BubbleColor = texture {
      pigment {
         bozo
         color_map {
            [0 color Gray40]
            [1 color Gray60]
         } //color_map
      } //pigment
      scale .5
   } //texture
#end //if

#local GlowColor = <.05, .4, .16> * .4;

#local UFOHalf = object {
   intersection {
      sphere {0, 1 scale <2.5, 1, 2.5>}
      box {<-4, .35, -4> <4, 1.1, 4>}
   } //intersection
   translate -.35 * y
} //object

#local Bubble = object {
   difference {
      sphere {0, 1.2 translate -.03 * y}
      sphere {0, 1.18 translate -.03 * y}
      box {<-2, -2, -2> <2, .3, 2>}
   } //difference
   texture {BubbleColor}
} //object

#local CutOut = object {
   box {<-2.04, -1.1, -.03> <-1.2, 1.1, .03>}
} //object

#local TopHalf = object {
   difference {
      union {
         difference {
            object {UFOHalf}
            #local i = 4;
            #while (i >= 0)
               object {CutOut rotate (i * 72) * y}
               #local i = i - 1;
            #end //while
         } //difference
         object {UFOHalf scale .97}
      } //union
      sphere {0, 1.2} //Hole for the bubble
      object {UFOHalf translate -.1 * y}
      texture {UFOColor}
   } //difference
} //object

#local CutOut = object {
   box {<-2.16, -1.1, -.03> <-1.72, 1.1, .03>}
} //object

#local BottomHalf = object {
   difference {
      union {
         difference {
            object {UFOHalf rotate 180 * x}
            box {<-4, -.42, -4> <4, -2, 4>} //Chop off bottom
            #local i = 8;
            #while (i >= 0)
               object {CutOut rotate (i * 40) * y}
               #local i = i - 1;
            #end //while
         } //difference
         difference {
            object {UFOHalf rotate 180 * x scale .97}
            box {<-4, -.42, -4> <4, -2, 4>} //Chop off bottom
         } //difference
      } //union
      object {UFOHalf rotate 180 * x translate .1 * y}
      cylinder {<0, -.5, 0> <0, -.3, 0> 1.6} //Hole in bottom
   } //difference
   texture {UFOColor translate 20 * y}
} //object

#local Plate = object {
   intersection {
      #local PlateWidth = .485;
      #local PlateDepth = .5;
      #local PlateHeight = .02;
      box {<0, 0, -PlateWidth / 2> <PlateDepth, PlateHeight, PlateWidth / 2>}
      #local PlaneAngle = 9;
      #local PlaneOffset = -1;
      plane {z, 0 rotate PlaneAngle * y inverse translate PlaneOffset * x}
      plane {z, 0 rotate -PlaneAngle * y translate PlaneOffset * x}
   } //intersection
} //object

#local Ring = object {
   union {
      #local i = 19;
      #while (i >= 0)
         object {Plate translate <1.59 - PlateDepth, -.415, 0> rotate (i * 18) * y}
         #local i = i - 1;
      #end //while
      texture {UFOColor}
   } //union
} //object

//The variable ApertureClock controls the opening of the bottom of the UFO. When
//ApertureClock = 0, the UFO is closed. When ApertureClock = 1, the UFO is open.
#if (clock < .5)
   #local ApertureClock = clock * 2;
#else
   #local ApertureClock = (1 - clock) * 2;
#end

#local ApertureClock = 0; //Cancel out the opening of the UFO

#local BladeRad = 3.2;

#local Blade = array [10]

#local i = 9;

#while (i >= 0)
   #local Blade [i] = object {
      object {
         difference {
            cylinder {<0, 0, 0> <0, .01, 0> BladeRad * .5}
            cylinder {<0, -.1, 0> <0, .2, 0> BladeRad translate -BladeRad * x}
            cylinder {<0, -.2, 0> <0, .3, 0> BladeRad translate -BladeRad * x rotate 60 * y inverse}
            texture {UFOColor scale <1/2.76, 1/4, 1/2.76> translate (i * -12) * y}
         } //difference
      } //object
      translate <-BladeRad * .5, 0, -BladeRad * .5>
      rotate (-ApertureClock * 30) * y
      translate <BladeRad * .5, 0, BladeRad * .5>
      rotate 1.2 * z //Twist to make overlap
      rotate .2 * x
      scale <2.76, 4, 2.76>
   } //object
   #local i = i - 1;
#end //while

#local Aperture = object {
   intersection {
      union {
         #local i = 9;
         #while (i >= 0)
            object {
               Blade [i]
               rotate (i * 36) * y
            } //object
            #local i = i - 1;
         #end //while
      } //union
      cylinder  {<0, -.5, 0> <0, 1, 0> 1.6 texture {UFOColor}}
   } //intersection
   translate (-.42 + PlateHeight + .025) * y
} //object

#local Glow = object {
   sphere {
      0, 8
      hollow
      pigment {color rgbf 1}
      interior {
         media {
            emission rgb GlowColor
            density {spherical scale <4, 2, 4>}
         } //media
      } //interior
   } //sphere
   translate .2 * y
} //object

#local UFOX = array [nUFOs]
#local UFOY = array [nUFOs]
#local UFOZ = array [nUFOs]

#local MinGap = .5;

#local i = 0;

#while (i < nUFOs)
   #local CurNRotations = int (rand (Randomizer) * (MaxRotations - MinRotations + 1)) + MinRotations;
   #local UFO = object {
      union {
         object {Bubble}
         object {TopHalf rotate (CurNRotations * 360 * clock) * y}
         object {BottomHalf rotate (CurNRotations * -360 * clock) * y}
         object {Ring}
         object {Aperture}
         #if (HighQuality)
            object {Glow}
         #end //if
      } //union
   } //object
   #local GoodLoc = false;
   #while (GoodLoc = false)
      #local GoodLoc = true;
      #local CurX = rand (LocRandomizer) * 40 - 20;
      #local CurY = rand (LocRandomizer) * 20 - 8;
      #local CurZ = rand (LocRandomizer) * -212;
      #local j = i - 1;
      #while (j >= 0)
         #local DeltaX = abs (CurX - UFOX [j]);
         #local DeltaY = abs (CurY - UFOY [j]);
         #local DeltaZ = abs (CurZ - UFOZ [j]);
         #if (DeltaX < 4.7 + MinGap & DeltaY < 1.589 + MinGap & DeltaZ < 4.7 + MinGap)
            #local GoodLoc = false;
            //From center to outside edge = 2.35
            //From center to top = 1.17
            //From center fo bottom = -.419
         #end //if
         #local j = j - 1;
      #end //while
      #if (CurX > -2.342 & CurX < 2.342 & CurY > -1.18 & CurY < .5)
         #local GoodLoc = false;
      #end //if
   #end //while
   #local UFOX [i] = CurX;
   #local UFOY [i] = CurY;
   #local UFOZ [i] = CurZ;
   #local CurZ = CurZ + clock * 212;
   #if (CurZ >= 0)
      #local CurZ = CurZ - 212;
   #end //if
   #local CurScale = CurZ / -204;
   #if (CurScale > 1)
      #local CurScale = 1;
   #end //if
   object {UFO scale CurScale rotate (rand (Randomizer) * 90) * y translate <CurX, CurY, CurZ>}
   #local i = i + 1;
#end //while

//STARFIELD BACKGROUND - Requires Chris Colefax's Galaxy Include File package.
#declare star_count = 12000;
#declare star_type = 1;
#declare star_scale = .3;
#declare star_colour_turb = .3;
#if (HighQuality)
   #include "Galaxy.sf"
#end //if

//EARTH OBJECT - Supply your favorite image and bump maps of the Earth here.
#declare EARTH = sphere {
   0, 40
   pigment {image_map {tga "Earth.tga" map_type 1 interpolate 2}}
   normal {bump_map {tga "EarthBump.tga" map_type 1 interpolate 2 bump_size 3}}
   finish {ambient 0 diffuse 1}
} //sphere

#declare Atmos = media {
   scattering {4, rgb <.4, .5, 1> * .02 extinction .00005}
   intervals 5
   samples 2, 20
   confidence .9999
   variance 1/1000
   density {
      spherical
      color_map { 
         [0, rgbf <0, 0, 0, 1>] 
         [.055, rgbf <.75, .75, .75, .01>] 
         [.075, rgbf <.2, .5, 1, .01>] 
         [.6, rgbf <.2, .5, 1, 1>] 
         [.61, rgbf <0, 0, 0, 1>] 
         [1, rgbf <0, 0, 0, 1>]
      } //color_map
   } //density
} //media

#if (HighQuality)
   #local EARTH = object {
      union {
         object {EARTH}
         sphere {0, 1 hollow pigment {rgbt 1} interior {media {Atmos}} scale 43}
      } //union
   } //object
#end //if

object {EARTH rotate (200 - clock * 360) * y translate 42.5 * z}
