// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

global_settings {
  assumed_gamma 1.8
}                  

//#declare tron=on;
#declare amb_light=0;
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end  

#declare cam_loc=<0,.2,-1>;
#declare cam_tgt=<0,.2,0>;
                                
camera
{           
  location cam_loc
  direction <0,0,1.1>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  rotate <0,-0,0>
}                           

plane { y,0 texture { pigment { color rgb<1,1,1> } } }
light_source { 0,1 translate <-10,20,-5> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*
#include "bug1.inc"

object { bug            
  rotate <0,60,0>
  translate <.9,.25,.45>
}*/
//    5         2
//       \ ^ /
//    4 --| |-- 1
//       / V \
//    3         0
//       front


//      Bugs:
#include "bug2.inc"
#local foot_def=array[6] { <.26,.0,-.15>,<.29,.0,.0>,<.25,.0,.16>,<-.26,.0,-.15>,<-.29,.0,-.01>,<-.25,.0,.16> }
#macro step_to(tgt_pos,dr_leg_num,lift_time,l_clock)
  flight_spline(foot_pos[dr_leg_num],<foot_pos[dr_leg_num].x,foot_pos[dr_leg_num].y+.1,foot_pos[dr_leg_num].z>,<tgt_pos.x,tgt_pos.y+.05,tgt_pos.z>,tgt_pos,lift_time,lift_time+.18,l_clock) // +.18 secs for step duration
#end



#macro heading_of(foot_array)
  // calculates the x,y and z angles of the bug based on the foot positions.
  //      copy foot positions, but based on land height (ie ignores the effect of lifting a foot)
  #local foot_loc=array[6] //{ <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
  #local index=0;
  #while ( index < 6 )
    #local foot_loc[index]=<foot_array[index].x,mesh_height(foot_array[index].x,foot_array[index].z),foot_array[index].z>;
    #local foot_loc[index]=(foot_loc[index]+foot_pos[index])/2;
    #local index=index+1;
  #end
  
  #local p1_pos=( foot_loc[0]+foot_loc[3] ) / 2;
  #local p2_pos=( foot_loc[2]+foot_loc[5] ) / 2;
  #local fr_vect=p1_pos-p2_pos;
  
  #local bug_yaw=(180+180*atan2(fr_vect.x,fr_vect.z)/pi);
  #local bug_pitch=atan2(fr_vect.y,vlength(fr_vect))*130/pi;
  
            
  #local p1_pos=( foot_loc[0]+foot_loc[1]+foot_loc[2] ) / 3;
  #local p2_pos=( foot_loc[3]+foot_loc[4]+foot_loc[5] ) / 3;    
  #local lr_vect=p1_pos-p2_pos;
  
  #local bug_roll=atan2(lr_vect.y,vlength(lr_vect))*180/pi;
  
  <bug_pitch,bug_yaw,bug_roll>
  
#end

#macro position_of(foot_array)
  // calculates the median of the foot positions (centre of bug)
  ( foot_array[0]+
    foot_array[1]+
    foot_array[2]+
    foot_array[3]+
    foot_array[4]+
    foot_array[5] ) / 6
#end
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#macro mesh_height(xpos,ypos)
  (0)
#end
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1\n"       //      1st left
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
                      
#local bug_ang=<0,-90,0>;
#local bug_pos=<0,0,0>;

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock+2;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=0;
#local march_time=0;


#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
