// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

global_settings {
  assumed_gamma 1.8
}                  

//#declare tron=on;
#declare amb_light=0;
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end  

//#declare cam_loc=<-30,9,0>;
//#declare cam_tgt=<-10,9,-2>;

#declare cam_loc=<-5.5,9.5,-3>;
//#declare cam_loc=<-0,9.5,-3>;
#declare cam_tgt=<-1,8.8,.525>;

//#declare cam_loc=<-3.2,8,-3>;
//#declare cam_tgt=<-3.2,8,.525>;
                                
camera
{           
  location cam_loc
  direction <0,0,1.5>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  rotate <0,-0,0>
}                           
#declare fade=(flight_spline(0,0,1,1,2,2.2,clock));
#declare fade=(flight_spline(fade,fade,0,0,10.8,11,clock));
//#declare fade=1;
#if (fade<1)
  sphere { 0,.1
    texture {
      pigment {
        color rgbt<0,0,0,fade>
      }
      finish {
        ambient 0
        diffuse 0
      }
    }
    translate cam_loc
    hollow
  }
#end

#declare light_pos=<-1000,2000,-3000>;

light_source
{
  0 
  color .9
  translate light_pos
}
light_source
{
  0 
  color .1
  translate light_pos
  shadowless 
}

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// earth
#declare NightSky =
    texture {
      pigment { color rgb<0,0,.05> }
      finish { ambient 1 }
    }

#declare Stars =
    texture {
      pigment {
        granite
        poly_wave 2
        color_map {
          [ 0 color rgbf<1,1,1,1> ]
          [ .8 color rgbf<1,1,1,1> ]
          [ .81 color rgbf<1,1,1,0> ]
          [ 1 color rgbf<1,1,1,0> ]
        }
      }
      scale 100
    }

#declare BackDrop =
    texture { NightSky }
    texture { Stars rotate <0,0,-60> scale <2,2,2> }
    texture { Stars rotate <0,0,30> scale <3,2,3> }

object {
    sphere { <0,0,0>,20000 inverse }
    texture {
        BackDrop
        scale 8
        finish {ambient 1 }
    }
    rotate <-5,0,0>
    translate <0,0,0>
    rotate <0,135,0> 
}
/*
sphere { 0,1
  translate <0,-1,0>
  scale 50000
  texture {
    pigment {
      bozo
      scale 50
      color_map {
        [0 color rgb<.55,.5,.5>]
        [1 color rgb<.5,.45,.45>]
      }
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .3
      specular .05
    }
    normal {
      granite
      turbulence .3
      omega .65
      lambda 2
      octaves 6            
      scale 10
    }
  }
}  
*/
#declare LandArea =
  texture {
    pigment {
      agate
      turbulence 1
      lambda 1.5
      omega .8
      octaves 8
      color_map {
        [0.00 color rgb <.5, .25, .15>]
        [0.33 color rgb <.1, .5, .4>]
        [0.86 color rgb <.6, .3, .1>]
        [1.00 color rgb <.5, .25, .15>]
      }
    }
  }

#declare OceanArea =
  texture {
    pigment {
      bozo
      turbulence .5
      lambda 2
      color_map {
        [0.00, 0.33 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
        [0.33, 0.66 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1>]
        [0.66, 1.00 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
      }
    }
  }

#declare CloudArea =
  texture {
    pigment {
      granite scale 3
      poly_wave 1.4
      turbulence 1.65
      lambda 2.3
      omega .5
      octaves 7
      
      color_map {
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.05 color rgbf <1, 1, 1, 1>]
        [0.65 color rgbf <1, 1, 1, .2>]
        [2 color rgbf <1, 1, 1, 1>]
      }
    }
    finish {
      ambient .0 diffuse .7
    }
  }


#declare planet =
  union {
    object {
      sphere { <0,0,0>,1 }
/*      texture { LandArea }
      texture { OceanArea }*/
      texture {
        material_map {
          gif "planet.gif"
          map_type 1
          texture { pigment { color rgb<1,1,1> } finish { ambient .0 diffuse .7 } }
          texture { pigment { color rgb<.2,.3,1> } finish { ambient .0 diffuse .7  } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
          texture { pigment { color rgb<0,.5,0> } finish { ambient .0 diffuse .7 } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
        }
      }
      //rotate <0,70,0>
      rotate <0,245,0>  //  -ve = rotate for eastern sunrise
      rotate <-23.5,0,0>
      hollow
      scale <3000,3000,3000>
    }
    object {
      sphere { <0,0,0>,1.01 }
      texture {
        CloudArea
      }
      scale <3010,3010,3010>
    }
    scale .6
    //translate <-600,600,10000>
    translate <0,1000,10000> //-825,1000,10000>
  }


object { planet no_shadow rotate <0,90,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// height field
//#include "hf_mesh4.inc"
#declare mesh_div=4;
#declare mesh_pretrans=<0,0,0>;
#declare mesh_scale=<2000,150,2000>;
#declare mesh_postrans=<-340,-47,-1420>;
#declare tga_land_mesh=
  object {
    object {
      height_field {
        tga "hf_moon3.tga"
        hierarchy on
        smooth
        water_level .1
      }
      translate mesh_pretrans
      scale mesh_scale
    }
    texture {
      pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>]
          [1 color rgb<.6,.55,.55>]
        }
      }
      finish { 
        ambient .0
        diffuse .9
        //roughness .4
        //specular .2
      }
      normal {
        granite
        turbulence .3
        omega .65
        lambda 2
        octaves 6            
        scale 10
      } 
    }
    translate mesh_postrans
  } 


#declare sph_land=
sphere { 0,1
  translate <0,-1,0>
  scale 5000
  texture {
    pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>*.8]
          [1 color rgb<.6,.55,.55>*.8]
        }
      }
    finish { 
      ambient .0
      diffuse .9
    }
    normal {
      granite
      turbulence .2
      omega .75
      lambda 2
      octaves 6            
      scale <8,16,8>
    }
  }
}
object { tga_land_mesh }
//object { sph_land }
/*
union {
#local xp=-4;
#while (xp<4)
  #local yp=-4;
  #while (yp<4)
    sphere { <xp,mesh_height(xp,yp),yp>,.05 }
    #local yp=yp+.5;
  #end
  #local xp=xp+.5;
#end
  texture { 
    pigment { color rgb<1,1,0> }
    finish { ambient 0 diffuse .7 }
  }
}
*/
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------




#declare sidepan_pin_pos=<0,59,95>;



//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*
#include "bug1.inc"

object { bug            
  rotate <0,60,0>
  translate <.9,.25,.45>
}*/
//    5         2
//       \ ^ /
//    4 --| |-- 1
//       / V \
//    3         0
//       front

//      Bugs:
#include "bug2.inc"

#macro mesh_height(xpos,ypos)   //      because of the maths required to 'float' the bug on an uneven surface,
                                //      it s no longer able to climb a sheer wall. This is overcome by calculating
                                //      the bugs while horizontal, and rotating afterwards to position on the side
                                //      of the craft.                                        
  0
#end

#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#declare bug1_rotate=<-90,0,0>;
#declare bug1_translate=<-3.1,7.9,.75>;
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1\n"   // left bug (pushes the panel)

#local bug_ang=<0,-90,0>;
#local bug_pos=<0,0,0>;
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=2;
#local march_time=-2;

#while (march_time<8)
  #if (march_time<=m_clock+.15)
    
    #local m_pos=(flight_spline(<-2,0,0>,<-1.4,0,0>,<-.6,0,0>,<0,0,0>,0,8,march_time+.1) );
    #local m_angle=(flight_spline(<0,-90,0>,<0,-90,0>,<0,-90,0>,<0,-90,0>,0,10,march_time+.1) );
    
#ifdef(tron)
#if (firing_order[foot]=0 | firing_order[foot]=3 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug1_rotate translate bug1_translate }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug1_rotate translate bug1_translate }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<0,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

#declare dip=(flight_spline(0,0,15,30,7.8,8.1,clock));
#declare stretch=(flight_spline(0,0,.07,.08,7.8,8.1,clock));
#declare push=(flight_spline(0,0,.07,.08,8.3,8.6,clock));

#declare dip=(flight_spline(dip,dip,0,0,8.7,9.1,clock));
#declare stretch=(flight_spline(stretch,stretch,0,0,8.8,9.2,clock));
#declare push=(flight_spline(push,push,0,0,8.9,9.5,clock));

#declare push=(flight_spline(push,push,.075,.075,9.75,10.25,clock));

#declare bug_head=bug_head+(flight_spline(<0,0,0>,<0,0,0>,<-.5,-1,-.5>,<-.5,-1,-.5>,9.5,11,clock));
#declare bug_ang=bug_ang+(flight_spline(<0,0,0>,<0,0,0>,<0,-10,0>,<0,-10,0>,10.25,11,clock));

#declare ml_panel_spin=0;
#declare ml_panel_drop=0;
#declare panel_pop=(flight_spline(0,0,45,90,7,8,clock));
#if (panel_pop<20)
  #declare ml_panel_tilt=panel_pop;
#else
  #declare ml_panel_tilt=20;
  #declare ml_panel_spin=(flight_spline(0,0,45,120,8.3,9.7,clock));
  #declare ml_panel_drop=(flight_spline(0,0,100,100,9.5,10,clock));
#end

#declare bug1=object { bug_macro(bug_pos+(stretch+.13)*y+push*x,<bug_ang.x+dip,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

object {bug1 rotate bug1_rotate translate bug1_translate }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#declare bug2_rotate=<-90,0,0>;
#declare bug2_translate=<-2.25,3.3,0>;
#declare bug2_postrans=<0,6.9,.525>;
#ifdef(tron)
  sphere { 0,.1 texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug2_rotate translate bug2_translate+bug2_postrans }
#end
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 2\n"   // the one that opens the catch and flies off
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local bug_ang=<0,180,0>;
#local bug_pos=<0,0,-1>;
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=0;
#local march_time=-2;

#while (march_time<7.0)
  #if (march_time<=m_clock+.15)
    #local m_pos=(flight_spline(<0,0,-1>,<0,0,-.8>,<0,0,-.5>,<0,0,-.3>,-1,3,march_time+.1) ); 
    
    #local m_pos=(flight_spline(m_pos,<.1,0,-.3>,<.3,0,-.1>,<.3,0,0>,3,7,march_time+.1) );
    #local m_angle=(flight_spline(<0,180,0>,<0,145,0>,<0,125,0>,<0,90,0>,3,7,march_time+.1) );
    
    #local m_pos=(flight_spline(m_pos,<.4,0,0>,<.5,0,0>,<.5,0,0>,7,8,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=0 | firing_order[foot]=3 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug2_rotate translate bug2_translate+bug2_postrans }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug2_rotate translate bug1_translate+bug2_postrans }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local calc_pos=position_of(foot_pos);
#local calc_ang=heading_of(foot_pos)+<10,0,0>;

#local calc_bias=(flight_spline(1,1,0,0,2.8,3.2,clock));
#local calc_bias=(flight_spline(calc_bias,0,1,1,6.8,7.2,clock));

#local bug_pos=(flight_spline(m_pos,m_pos,calc_pos,calc_pos,0,1,calc_bias ));
#local bug_ang=(flight_spline(m_angle,m_angle,calc_ang,calc_ang,0,1,calc_bias ));


#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

#if (m_clock>3)
  #if (m_clock<=6.8)
    #declare sidepan_pin_angle=bug_ang.y-90;
  #else
    #declare sidepan_pin_angle=0;
  #end
#else
  #declare sidepan_pin_angle=90;
#end
#declare dip=(flight_spline(0,3,-5,-5,2.8,3.2,clock) );
#declare dip=(flight_spline(dip,dip,3,0,6.8,7.2,clock) );

#declare bug_head=(bug_head+flight_spline(<0,0,0>,<0,0,0>,<-1,0,0>,<-1,0,0>,2.8,3.2,clock) );
#declare bug_head=(bug_head+flight_spline(<0,0,0>,<0,0,0>,<1,0,0>,<1,0,0>,6.8,7.2,clock) );

#declare bug_eyelid=(flight_spline(bug_eyelid,<0,0,0>,<.5,0,0>,<1,0,0>,7.32,7.4,clock) );
#declare bug_eyelid=(flight_spline(bug_eyelid,<.5,0,0>,<0,0,0>,<0,0,0>,7.4,7.48,clock) );

#declare bug_eyelid=(flight_spline(bug_eyelid,<0,0,0>,<.5,0,0>,<1,0,0>,7.52,7.6,clock) );
#declare bug_eyelid=(flight_spline(bug_eyelid,<.5,0,0>,<0,0,0>,<0,0,0>,7.6,7.68,clock) );
        
#declare bug2=object { bug_macro(bug_pos+.13*y,<bug_ang.x+dip,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

#declare bug2_postrans=bug2_postrans+y*(flight_spline(0,0,-1,-1,7.42,10,clock)); // uh-oh, gravity works !
#render concat("Pan=",str(ml_panel_tilt,0,0)," Bug=",str(panel_pop,0,0),"\n")

object {bug2 rotate bug2_rotate translate bug2_translate rotate <-panel_pop,0,0> translate bug2_postrans  }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#declare bug3_rotate=<0,0,0>;
#declare bug3_translate=<1.4,7.35,1.8>;
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*

#render "bug 3\n"   // behind the panel
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local bug_ang=<0,70,0>;
#local bug_pos=<0,0,0>;
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<0,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

#declare bug_head=(flight_spline(<0,0,0>,<.2,-.2,0>,<.2,-.1,-1>,<1,-.2,-1>,9,10,clock) );
#declare bug_head=(flight_spline(bug_head,<.2,0,-1>,<1,0,-1>,<-.2,1,0>,10,11,clock) );

#declare bug3=object { bug_macro(bug_pos+.13*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }

object {bug3 rotate bug3_rotate translate bug3_translate }
*/

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#declare bug4_rotate=<-90,0,0>;
#declare bug4_translate=<-3.1,8.9,.75>;
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 4\n"   // middle (arrives late)
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local bug_ang=<0,-45,0>;
#local bug_pos=<-2,0,0>;
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=2;
#local march_time=-2;

#while (march_time<10)
  #if (march_time<=m_clock+.15)
    
    #local m_pos=vrotate((flight_spline(<-2,0,0>,<-1.4,0,0>,<-.6,0,0>,<0,0,0>,0,10,march_time+.1) ),<0,45,0>);
    #local m_angle=(flight_spline(<0,-45,0>,<0,-45,0>,<0,-45,0>,<0,-45,0>,0,10,march_time+.1) );
    
#ifdef(tron)
#if (firing_order[foot]=0 | firing_order[foot]=3 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug4_rotate translate bug4_translate }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug4_rotate translate bug4_translate }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<0,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

#local bug_head=(flight_spline(bug_head,bug_head,<-.6,-.4,0>,<-.6,-.4,0>,9.5,10,clock));
#local bug_head=bug_head+(flight_spline(<0,0,0>,<.5,0,0>,<.5,0,0>,<0,0,0>,10.25,10.5,clock));
#local bug_head=bug_head+(flight_spline(<0,0,0>,<.5,0,0>,<.5,0,0>,<0,0,0>,10.5,10.75,clock));

#declare bug4=object { bug_macro(bug_pos+.13*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }

object {bug4 rotate bug4_rotate translate bug4_translate }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#declare bug5_rotate=<-90,0,0>;
#declare bug5_translate=<-3.1,9.9,.75>;
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 5\n"   // left top (arrives later)
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local bug_ang=<0,-75,0>;
#local bug_pos=<-2,0,0>;
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=5;
#local march_time=-2;

#while (march_time<11)
  #if (march_time<=m_clock+.15)
    
    #local m_pos=vrotate((flight_spline(<-2,0,0>,<-1.4,0,0>,<-.6,0,0>,<0,0,0>,1,11,march_time+.1) ),<0,25,0>);
    #local m_angle=(flight_spline(<0,-75,0>,<0,-75,0>,<0,-75,0>,<0,-75,0>,1,11,march_time+.1) );
    
#ifdef(tron)
#if (firing_order[foot]=0 | firing_order[foot]=3 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug5_rotate translate bug5_translate }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } rotate bug5_rotate translate bug5_translate }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<0,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

#declare bug5=object { bug_macro(bug_pos+.13*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }

object {bug5 rotate bug5_rotate translate bug5_translate }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------




#declare ml_noz_clock=-.6;
#declare ml_noz_clock=-.0;

#include "cut_lander.inc"

object { lander
  translate <0,0,100> 
  scale .15
}

#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")
         
