// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#declare b_c_body=
  union {
    object { b_abdo rotate <-5,0,0> }
    object { b_body_r rotate <10,10,10> translate <.05,.0,0> }
    object { b_body_r scale <-1,1,1> rotate <5,-5,-5> translate <-.05,.0,0> }
    rotate <5,0,0>
  }
#declare cross_tex=
  texture {
    pigment {
      gradient x
      color_map {
        [ 0 color rgbf<0,0,0,0> ]
        [ .07 color rgbf<0,0,0,0> ]
        [ .08 color rgbf<1,1,1,1> ]
        [ 1 color rgbf<1,1,1,1> ]
      }
    }
  }
#declare circ_tex=
  texture {
    pigment {
      cylindrical
      rotate 90*x
      color_map {
        [ 0 color rgbf<1,1,1,0> ]
        [ .6 color rgbf<1,1,1,0> ]
        [ .601 color rgbf<1,1,1,1> ]
        [ 1 color rgbf<1,1,1,1> ]
      }
    }
  }
#declare splat_eye=
    sphere {
      0,1
      texture { pigment { color rgb<1,1,1> } }
      texture { cross_tex rotate <0,0,0> }
      texture { cross_tex rotate <0,0,90> }
      texture { circ_tex }
      finish { 
        ambient 0.0
        diffuse .9
      }
      rotate <20,0,0>
    }
#declare b_c_head=
  union {
    object { b_head_t }
    object { b_head_t scale <1,.1,1> }
    object { splat_eye scale .075 translate <.12,.13,-.05> }
    object { b_eye(-.1,-.3,.12) scale .075 translate <-.12,.13,-.05> }
    
    object { b_eyelid_half scale <.076,.076,.076>     rotate <0,-10,-30> rotate <40,0,0> translate <.12,.13,-.05> }
    object { b_eyelid_half scale <.0755,-.0755,.0755> rotate <0,-10,0> rotate <-20,0,0> translate <.12,.13,-.05> }
    
    object { b_eyelid_half scale <.076,.076,.076>     rotate <0,10,30> rotate <10,0,0> translate <-.12,.13,-.05> }
    object { b_eyelid_half scale <.0755,-.0755,.0755> rotate <0,10,0> rotate <-80,0,0> translate <-.12,.13,-.05> }
    
    texture { bug_green }
  }
#declare bug_goo=
  texture {
    pigment { color rgb<.6,.1,.1> }
    finish { 
      ambient 0.0
      diffuse .9
      roughness .05
      specular .6
    }
    normal { bumps 1  scale .1 }
  }
#declare splat=
  blob {
    threshold .5
    sphere { 0,1,1 }
    sphere { 0,1,1 translate <.3,0,.6> }
    sphere { 0,1,1 translate <-.3,0,.6> }
    scale <1,.2,1>  
    texture { bug_goo }
  }

#macro broken_leg(knee_angle)
  union {
    union {
      cone { <0,0,0>,.025,<0,.12,0>,.01 }
      sphere { <0,.12,0>,.01 }
      rotate <0,0,knee_angle>
      translate <0,.15,0>
    }
    sphere { <0,0,0>,.03 }
    cone { <0,0,0>,.03,<0,.15,0>,.025 }
    sphere { <0,.15,0>,.025 }
    texture { bug_green }
  }    
#end


#declare brother_quark_deceased=union {
  object { splat scale .4 rotate <0,-90,0> translate <-.1,.0,-.2> scale .5 }
  object { splat scale .45 rotate <0,20,0> translate <.05,.0,-.45> scale .5 }
  object { b_c_body translate <.0,.05,.1> scale .5 }
  object { b_c_head rotate <10,0,0> translate <-.05,0,-.55> scale .5 }
  
  object { broken_leg(-45) rotate <-15,20,-80> translate <.15,0,-.11> }
  object { broken_leg(-22) rotate <0,0,-80> translate <.17,0,0> }
  object { broken_leg(-45) rotate <20,0,-70> translate <.16,0,.13> }
    
  object { broken_leg(-7-45*leg_clock) rotate <-15,-20,90> translate <-.15,0,-.11> }
  object { broken_leg(5) rotate <0,0,80> translate <-.17,0,0> }
  object { broken_leg(30) rotate <20,0,70> translate <-.16,0,.13> }  
  rotate <0,0,-3>
}
