// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

#declare bald=1;
#if (clock<3)
  #declare bald=0;
#end
//#declare bald=1;        //      dimples - 0=slow, 1=quick, 2=transparent
#declare amb_light=0.1;
//#declare tron=on;

global_settings {
  assumed_gamma 1.8
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     
/*
light_source
{
  0 
  color .9
  translate <0, 1000, -500>
}
light_source
{
  0 
  color .1
  translate <0, 1000, -500>
  shadowless 
}
*/
light_source
{
  0 
  color .9
  translate <-500, 2000, -500>
}
light_source
{
  0
  color .1
  translate <-500, 2000, -500>
  shadowless
}

#declare sky_color=
  texture {
    pigment {
      gradient y
      color_map {
        [ 0 MidnightBlue*.2 ]
        [ 1 color <.4,.6,.8> ]
      }
    }
    finish {
      ambient 1
    }
  }

#declare sky_cloud=
  texture {
    pigment {
      bozo
      turbulence .2
      lambda 1.5
      omega .85
      octaves 11
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.4 color rgbt<1,1,1,1> ]
        [ 0.8 color rgbt<1,1,1,.5> ]
        [ 2 color rgbt<1,1,1,0> ]
      }
    }
    finish {
      ambient 1
    }
    scale <.5,.05,.5>
    scale .25
    rotate <0,-40,0>
  }


object {
  sphere { <0,0,0> 1 inverse  }
  texture { sky_color }
  texture { sky_cloud translate <0,-.006,0> }
  translate <0,-.93,0>
  scale 10000
  translate <0,1,0>
  hollow
  no_shadow
}
      


sphere { 0,1
  translate <0,-1,0>
  scale 5000
  texture {
    pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>]
          [1 color rgb<.6,.55,.55>]
        }
      }
    finish { 
      ambient .0
      diffuse .9
    }
    normal {
      granite
      turbulence .2
      omega .75
      lambda 2
      octaves 6            
      scale <8,16,8>
    }
  }
}
#include "hf_mesh.inc"
object { tga_land_mesh }
object { tga_horizon }


#if (bald=0)
#declare dimples=
  object {
    union {              
      #declare ri=90.0;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.073;     
      #declare dr=.095;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd)-1);
      #declare r1=rs1/2;
      //#declare r1=0;
      
      #declare ri=83;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.087;     
      #declare dr=.13;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd));
      #declare r1=rs1/2;
            
      #while (r1<89)
        #declare h=(1+(dr/1.25))*sin(radians(r1));
        #declare r=(1+(dr/1.25))*cos(radians(r1));
        #declare rs2=120/int(2*pi*r/(6*dd));
        #declare r2=-60;
        #while (r2<59)
          sphere { <r,h,0>,dr rotate <0,r2,0> }
          sphere { <r,h,0>,dr rotate <0,r2+120,0> }
          sphere { <r,h,0>,dr rotate <0,r2+240,0> }          
          #if (r1>0)          
            sphere { <r,-h,0>,dr rotate <0,r2,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+120,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+240,0> }
          #end          
          #declare r2=r2+rs2;
       #end
        #declare r1=r1+rs1;
      #end
    }
  }
#else
  #declare dimples=sphere { 0,.1 }
#end

#declare fin_ball=           
  difference {
    sphere { 0,1 }    
    object { dimples } 
  }       

#declare rnd1=seed(123456);
   
    
object { fin_ball         
//  rotate <360*rand(rnd1),360*rand(rnd1),360*rand(rnd1)>
  #if (bald=2)
    texture { pigment { color rgbt<.5,.5,.5,.5> } }
  #else
  texture { 
    pigment { 
      image_map { tga "bal_logo.tga" map_type 1 } 
    }
    finish { 
      ambient amb_light
      diffuse .7
      roughness .01
      specular .1
    }                       
    rotate <0,-90,0>
  }    
  #end
  rotate <45,0,30>
  rotate <0,90,0> 
  translate <0,.8,0>
  scale .3     
  translate <-1.3,mesh_height(-1.3,1.3),1.3>
}

#render concat("ball height adjusted +",str(mesh_height(-1.3,1.3),3,3),"\n")


#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")

#declare cam_loc=<-2.2,.75,1.85>
camera
{           
  location cam_loc
  direction <0,0,1.5>
  up <0,1,0>
  right <4/3,0,0> 
  look_at <-1.3,.2+mesh_height(1.3,1.3),1.3>
}


