// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

#declare bgc=9;
#declare bald=1;
#if (clock>13)
  #declare bald=0;
#end
//#declare bald=1;        //      dimples - 0=slow, 1=quick, 2=transparent
//#declare quick=on;
//#declare tron=on;
//#declare numbers=on;

#declare shr_count=100;

#declare amb_light=.2;
global_settings {
  assumed_gamma 1.8
  max_intersections 50
  max_trace_level 350
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     

#include "hf_mesh5a.inc"
#include "hf_mesh5.inc"
                                     
#declare cam_loc=<0,0,-4>;
#declare cam_loc=cam_loc+<0,2.5,0>;       //2.5
#declare cam_tgt=cam_loc+<0,0,4>;        //0
#render concat("Placing camera @ <",str(cam_loc.x,1,5),",",str(cam_loc.y,1,5),",",str(cam_loc.z,1,5),">\n")
camera
{           
  location cam_loc
  direction <0,0,1.4>
//  direction <0,0,4.4>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
}

#declare fade=(flight_spline(0,0,1,1,0,.25,clock));
#declare fade=(flight_spline(fade,fade,0,0,17.8,18,clock));
#if (fade<1) 
  sphere { 0,.1 texture { pigment { color rgbt<0,0,0,fade> } finish { ambient 0 diffuse 0 } } translate cam_loc hollow no_shadow }
#end

//#declare sun_source=<250,1000,-400>;
#declare sun_source=<500,1000,-1000>;
light_source { 0 color .9 translate sun_source }
light_source { 0 color .2 translate sun_source shadowless }     // directional 'ambient' light

#declare sky_color=
  texture {
    pigment {
      gradient y
      color_map {
        [ 0 MidnightBlue*.2 ]
        [ 1 color <.4,.6,.8> ]
      }
    }
    finish {
      ambient 1
    }
  }

#declare sky_cloud=
  texture {
    pigment {
      bozo
      turbulence .2
      lambda 1.5
      omega .85
      octaves 11
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.4 color rgbt<1,1,1,1> ]
        [ 0.8 color rgbt<1,1,1,.5> ]
        [ 2 color rgbt<1,1,1,0> ]
      }
    }
    finish {
      ambient 1
    }
    scale <.5,.05,.5>
    scale .25
    rotate <0,-40,0>
  }


object {
  sphere { <0,0,0> 1 inverse  }
  texture { sky_color }
  texture { sky_cloud translate <0,-.006,0> }
  translate <0,-.93,0>
  scale 10000
  translate <0,1,0>
  hollow
  no_shadow
}

#ifdef(quick)
  #declare water=
    texture {
      pigment {
        color rgb<.05,.1,.3>
      }
      finish {
        ambient amb_light
        diffuse .9
      }
    }
#else
#declare water=
  texture { 
    pigment {
      color rgb<.05,.05,.2>
    }
    normal {   
      ripples
      frequency 6
      phase mod(clock/3,1)
      translate <-.5,-3.5,-.5>
      scale <15,15,15>
      translate <0,0,35>  
    }
    finish {
      ambient 0//amb_light
      diffuse .9
      roughness .1
      specular 1
      reflection .3
      phong 1
      phong_size 50
    }
  }  
#end  
plane { y,0 texture { water } }
//texture { pigment { color rgb<.25,.6,0> } finish { ambient 0 diffuse .7 } } }
//box { -1,1 translate <0,0,1> scale <20,1,150> texture { water } }
                                                                

#macro smoke_puff(pos,drift,age,max_dens)
  #if (age>0 & age<1)
    #local app_dens=(flight_spline(0,.75,1,1,0,1,age));//pow(2,age)-1;//(1-(max_dens*pow((.8-(.8*age)),10)));
    #local app_dens=(.9+.1*app_dens);
    #local app_dens=(1-((1-app_dens)*max_dens));
    #if (app_dens<.998)
      disc { 0,(pos+(drift*age)-cam_loc),1
        texture {
          pigment {
            spherical
            color_map {
              [ 0 color <1,1,1,1> ]
              [ 0.5 color <1,1,1,app_dens> ]
              [ 1 color <1,1,1,app_dens> ]
            }
          }
          finish {
            ambient .75
          }
        }
        scale ((.05+(pow(2,age)-1))*10)
        translate (pos+(drift*age))
        no_shadow
        hollow
      }
    #end
    //disc { (pos+(drift*age)),(pos+(drift*age)-cam_loc),((.2+age)*2.5) texture { pigment { color rgbf<1,1,1,(1-(max_dens*pow((.9-(.9*age)),5)))> } finish { ambient .75 } } no_shadow }
    //sphere { (pos+(drift*age)),((.2+age)*3.5) texture { pigment { color rgbf<1,1,1,(1-(max_dens*pow((.8-(.8*age)),5)))> } finish { ambient .5 } } hollow no_shadow }
  #end
#end

#declare impact_pos=<15,0,65>;
#declare gravity=<0,3.6,0>;
#declare tge=(y*gravity*((pow(2,5)-1)));
#declare impact_pos=<impact_pos.x,mesh_height(impact_pos.x,impact_pos.z),impact_pos.z>;
#declare velocity=<45,0,150>;                   //30
#declare shot_clock=-1;  
#declare impacted=0;
#while (shot_clock<clock)// & shot_clock<7)
  #declare impact_cd=5-shot_clock;
  #if (impact_cd<0 & impacted=0)
    #declare impacted=1;
    //#declare velocity=(velocity-(5*gravity))*<.3,.6,.3>;
    #declare velocity=(velocity-(gravity*((pow(2,shot_clock)-1))))*<.12,.09,.12>;
    #render concat("Bounce Velocity is <",str(velocity.x,1,3),",",str(velocity.y,1,3),",",str(velocity.z,1,3),">\n")
  #end
  #if (impact_cd>=0 & impact_cd<=6)
    #declare cluster_abs=(impact_cd*velocity)+impact_pos-(gravity*((pow(2,shot_clock)-1)))+tge;
  #else
    #declare cluster_abs=(impact_cd*velocity)+impact_pos-(gravity*((pow(2,shot_clock-5)-1)));    
  #end
    
  #if (shot_clock>=5)
    #declare p1=impact_pos;
    #declare p4=<15,0,65>-<18.5,0,76>;
    #declare p4=<p4.x,impact_pos.y,p4.z>;
    #declare p2=p1+((p4-p1)*1/3)+y*7;
    #declare p3=p4+((p1-p4)*1/3)+y*7;
    #declare cluster_abs=(flight_spline(p1,p2,p3,p4,5,8.7,shot_clock));
  #end
  
  #declare smoke_density=(flight_spline(1,1,0,0,5,7,shot_clock));
  
  #ifdef(tron)     
    sphere { 0,.2 translate cluster_abs texture { pigment { color rgb<1,1,1> } } }
  #end
  
  #if (smoke_density>0)
    #if (impact_cd>=0)  
      smoke_puff(cluster_abs,<0,0,0>,clock-shot_clock,smoke_density)
    #else
      smoke_puff(cluster_abs,<0,0,0>,clock-shot_clock,smoke_density/3)
    #end
  #end  
  
  #declare shot_clock=shot_clock+1/75;
#end
#if (impact_cd>0)
  #declare cluster_spin=(<-720*impact_cd,atan2(abs(velocity.z),abs(velocity.x))*180/pi,0>);
#else
  // cluster_spin must be <0,0,0> at t=7 !
  #declare flight_dir=atan2(abs(velocity.z),abs(velocity.x));
  #declare cluster_spin=(flight_spline(<720,flight_dir,0>,<270,flight_dir/2,0>,<10,0,0>,<0,0,0>,5,7,clock));
  //#declare cluster_spin=(<180*impact_cd,atan2(abs(velocity.z),abs(velocity.x))*180/pi,0>);
#end      
//#declare cluster_spin=(flight_spline(<-2100,900,0>,<-720,300,0>,<-20,28,0>,<20,28,0>,0,5,clock));

#if (clock>=4.97)
  #declare velocity=(velocity-(gravity*((pow(2,5)-1))))*<.12,.12,.12>;
  #declare shr_vel=<0,0,0>;
  #declare rnd=seed(50);
  #declare i0=0;
  union {
  #while (i0<shr_count)
    #declare shr_vel=velocity*<-1,-.3*(.5+rand(rnd)),-1>;
    #declare shr_vel=shr_vel+<(rand(rnd)*4)-1.5,1,(rand(rnd)*4)-2>;
    
    #declare shr_clock=0;
    #while (shr_clock<=clock-4.97)
      #declare shr_abs=(shr_vel*shr_clock)+impact_pos-(gravity*((pow(2,shr_clock-.12)-1)));
      #if (mesh_height(shr_abs.x,shr_abs.z)>shr_abs.y & shr_clock>.2)
        #declare shr_clock=100; // quit calc for this shrapnel
        #declare shr_abs=<shr_abs.x,mesh_height(shr_abs.x,shr_abs.z),shr_abs.z>;
      #end
      #declare shr_clock=shr_clock+1/25;
    #end
    
    #render concat("Placing shrapnel @ <",str(shr_abs.x,1,5),",",str(shr_abs.y,1,5),",",str(shr_abs.z,1,5),">\n")
    sphere { 0,.25 translate shr_abs }
    
    #declare i0=i0+1;
  #end
  texture { pigment { color rgb<.2,.2,0> } finish { ambient amb_light diffuse .9 } }
  }
#end

#declare hole=cylinder { <0,-1,0>,<0,2,0>,.75 texture { pigment { color rgb<.6,.6,.6> } finish { ambient amb_light diffuse .9 } } }
#declare pole=cylinder { <0,-1,0>,<0,7,0>,.15 texture { pigment { gradient y scale 2 color_map { [ 0 color rgb<1,1,1> ][.5 color rgb<1,1,1>][.5 color rgb<1,.1,.1>][1 color rgb<1,.1,.1>]}}finish { ambient amb_light diffuse .9 } } }
#declare hole_pos=impact_pos+<-8,0,-7>;
#declare hole_pos=<hole_pos.x,mesh_height(hole_pos.x,hole_pos.z),hole_pos.z>;

#declare flag_clock=clock;

#declare flag=
  mesh {
    #declare ls=.02;
    #declare ll=ls;
    #while ( ll<1)
      #declare c1=.5*(ll*sin(2*pi*(ll-flag_clock)));
      #declare c0=.5*((ll-ls)*sin(2*pi*(ll-ls-flag_clock)));
      #declare r1=(1-ll);
      #declare r0=(1-(ll-ls));
      triangle { <ll-ls,r0-(ll/2),c0/3>,<ll-ls,-r0-(ll/2),c0>,<ll,r1-(ll/2),c1/3> }
      triangle { <ll-ls,-r0-(ll/2),c0>,<ll,r1-(ll/2),c1/3>,<ll,-r1-(ll/2),c1> }
      #declare ll=ll+ls;
    #end
    texture { pigment { color rgb<1,1,1> } finish { ambient amb_light diffuse .9 } }
    scale <2,1,1>
  } 


#declare crater=(flight_spline(0,0,1,1,4.96,5.04,clock));

  difference { 
    object { tga_land_mesh }
    object { hole translate hole_pos }
    sphere { 0,crater translate impact_pos+y*.5 texture { pigment { color rgb<.2,.2,0> } finish { ambient amb_light diffuse .9 } } }
  }
  object { mesh_flora }
  union {
    object { pole translate hole_pos }
    object { flag rotate <0,180,0> translate hole_pos+y*6 }
  }

object { tga_land_mesh2 }
#render concat("Placing cluster @ <",str(cluster_abs.x,1,5),",",str(cluster_abs.y,1,5),",",str(cluster_abs.z,1,5),">\n")
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#include "bug3.inc"
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Bundle o' bugs
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#declare foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#declare land_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#declare bug_ang=<2,0,0>;
#declare bug_pos=<0,0,0>;
#declare bug_head=<-1.3,0,0>;       //      <1/3 up,1/2 right,1/2 twist lower left>
#declare bug_eye=<0,0,.5>;   
#declare bug_eyelid=<1,0,0>;      //      <close,vulcan,snake>
#declare bug_eyelid=(flight_spline(<1,0,0>,<1,0,0>,<0,0,0>,<0,0,0>,6,7,clock));
#declare bug_flaps=0;//(flight_spline(0,0,1,1,4.8,4.9,clock));     // coincide with smoke fade
#declare i0=0;
#while (i0<6)
  #declare foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #declare foot_pos[i0]=.9*foot_pos[i0];
  //#declare foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #declare i0=i0+1;
#end
#declare clustered_bug=object { bug_macro(bug_pos+.17*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head,bug_flaps,0) }

#if (clock<7)   // if bugs still bunched

#declare bug_cluster=
  union {
        
    object { clustered_bug rotate <-45,0,0> translate <0,.2,-.12> rotate <0,0,60> }     //front
    object { clustered_bug rotate <-45,0,0> translate <0,.2,-.12> rotate <0,0,180> }
    object { clustered_bug rotate <-45,0,0> translate <0,.2,-.12> rotate <0,0,300> }
    
    object { clustered_bug translate <0,.2,0> rotate <0,0,0> }                          //middle
    object { clustered_bug translate <0,.2,0> rotate <0,0,120> }
    object { clustered_bug translate <0,.2,0> rotate <0,0,-120> }

    object { clustered_bug rotate <45,0,0> translate <0,.2,.15> rotate <0,0,60> }       //back
    object { clustered_bug rotate <45,0,0> translate <0,.2,.15> rotate <0,0,180> }
    object { clustered_bug rotate <45,0,0> translate <0,.2,.15> rotate <0,0,300> }
        
  }

object { bug_cluster rotate cluster_spin translate cluster_abs }

#else   //      if bugs have (or are) separating

#declare cb_p=array[9] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#declare cb_a=array[9] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#declare cb_a=array[9] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#declare cb_t=array[9] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#declare cb_h=array[9] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#declare cb_f=array[9] { 0,0,0,0,0,0,0,0,0 }

#declare cb_p[0]=vrotate(vrotate(<0,.2,-.12>,<0,0,60>),cluster_spin)+cluster_abs;
#declare cb_a[0]=<-45,0,60>+cluster_spin;
#declare cb_t[0]=<7.35,7.65,9>;
#declare cb_p[1]=vrotate(vrotate(<0,.2,-.12>,<0,0,-180>),cluster_spin)+cluster_abs;
#declare cb_a[1]=<-45,0,-180>+cluster_spin;
#declare cb_t[1]=<7.3,8.4,8.6>;
#declare cb_p[2]=vrotate(vrotate(<0,.2,-.12>,<0,0,-60>),cluster_spin)+cluster_abs;
#declare cb_a[2]=<-45,0,-60>+cluster_spin;
#declare cb_t[2]=<7.37,7.75,9.05>;

#declare cb_p[3]=vrotate(vrotate(<0,.2,0>,<0,0,0>),cluster_spin)+cluster_abs;
#declare cb_a[3]=<0,0,0>+cluster_spin;
#declare cb_t[3]=<7.28,7.35,10.3>;
#declare cb_p[4]=vrotate(vrotate(<0,.2,0>,<0,0,120>),cluster_spin)+cluster_abs;
#declare cb_a[4]=<0,0,120>+cluster_spin;
#declare cb_t[4]=<7.23,8.2,9.3>;
#declare cb_p[5]=vrotate(vrotate(<0,.2,0>,<0,0,-120>),cluster_spin)+cluster_abs;
#declare cb_a[5]=<0,0,-120>+cluster_spin;
#declare cb_t[5]=<7.21,8.2,8.3>;
                                         
#declare cb_p[6]=vrotate(vrotate(<0,.2,.15>,<0,0,60>),cluster_spin)+cluster_abs;
#declare cb_a[6]=<45,0,60>+cluster_spin;
#declare cb_t[6]=<7.2,8,8.6>;
#declare cb_p[7]=vrotate(vrotate(<0,.2,.15>,<0,0,180>),cluster_spin)+cluster_abs;
#declare cb_a[7]=<45,0,180>+cluster_spin;
#declare cb_t[7]=<7.15,7.8,9.3>;
#declare cb_p[8]=vrotate(vrotate(<0,.2,.15>,<0,0,-60>),cluster_spin)+cluster_abs;
#declare cb_a[8]=<45,0,-60>+cluster_spin;
#declare cb_t[8]=<7.18,7.9,9.3>;

#declare bug_a=array[9]


#declare bn=0;
#while (bn<bgc)
  #render concat("Bug number ",str(bn,0,0),"\n")
  #declare sep_count=cb_t[bn].x;      // start of separation  
  #if (clock>sep_count)
      
    #declare cb_ab_s=cb_p[bn]-cluster_abs+(flight_spline(p1,p2,p3,p4,5,8.7,cb_t[bn].x)); // position at start
    #declare cb_p[bn]=cb_ab_s;
    #declare cb_h[bn]=bug_head;
    #declare cb_ve_s=(flight_spline(p1,p2,p3,p4,5,8.7,cb_t[bn].x+1/25))-(flight_spline(p1,p2,p3,p4,5,8.7,cb_t[bn].x)); // velocity at start
    #declare cb_an_s=cb_a[bn];  // bug angle at start
    #declare cb_av_s=<0,0,0>;   // angular velocity at start    
    #declare height=cb_p[bn].y-mesh2_height(cb_p[bn].x,cb_p[bn].z);
    
    #while (sep_count<=clock & height>0)
      #if (sep_count>cb_t[bn].x) 
        #declare cb_f[bn]=(flight_spline(0,0,.5,.5,cb_t[bn].y,cb_t[bn].z,sep_count));
        #declare cb_f[bn]=(flight_spline(1,1,cb_f[bn],cb_f[bn],.5,1.5,cb_ab_s.y-mesh2_height(cb_ab_s.x,cb_ab_s.z)));        // open flaps at 1.5 irrelevant of timing
        
        //#declare cb_ab_a=(flight_spline(cb_a[bn],cb_a[bn],<10,5,0>,<10,5,0>,cb_t[bn].x+.05,cb_t[bn].x+2.2,sep_count));
        #if (cb_an_s.x>1)
          #declare cb_av_s=cb_av_s-1*x;
        #else
          #if (cb_an_s.x<-1)
            #declare cb_av_s=cb_av_s+1*x;
          #end
        #end
        #if (cb_an_s.z>1)
          #declare cb_av_s=cb_av_s-1*z;
        #else
          #if (cb_an_s.z<-1)
            #declare cb_av_s=cb_av_s+1*z;
          #end
        #end
        #declare cb_an_s=cb_an_s+cb_av_s;
        #declare cb_av_s=cb_av_s*<.97,.97,.97>;
        #declare cb_av_s=cb_av_s*<1-(cb_f[bn]*.13),1-(cb_f[bn]*.13),1-(cb_f[bn]*.13)>;
        #declare cb_an_s=cb_an_s*<1-(cb_f[bn]*.13),1-(cb_f[bn]*.13),1-(cb_f[bn]*.13)>;
        
        #declare cb_ab_s=cb_ab_s+(cb_ve_s);
        #declare cb_ve_s=cb_ve_s-(gravity/<1,375,1>);
        #declare cb_ve_s=cb_ve_s*<.97,.97,.97>;
        #declare cb_ve_s=<cb_ve_s.x-(cb_an_s.z/20000),cb_ve_s.y,cb_ve_s.z>;
        #declare cb_ve_s=cb_ve_s*<1-(cb_f[bn]*.13),1-(cb_f[bn]*.13),1-(cb_f[bn]*.13)>;
      #end
      #declare height=cb_ab_s.y-mesh2_height(cb_ab_s.x,cb_ab_s.z);
      #declare sep_count=sep_count+1/25;
      
      #ifdef(tron)
        sphere { 0,.1 translate cb_ab_s texture { pigment { color rgb<1,1,1> } } }
      #end
    #end
    #render concat("Bug_height = ",str(cb_ab_s.y-mesh2_height(cb_ab_s.x,cb_ab_s.z),0,2),"\n")
    #declare cb_a[bn]=cb_an_s;
    #declare cb_a[bn]=cb_a[bn]+<40*bug_flaps,0,0>;
    #declare cb_p[bn]=cb_ab_s;
  #end
  // create bug                             
  #declare height=cb_p[bn].y-mesh2_height(cb_p[bn].x,cb_p[bn].z);
  #if (height<0)
    #declare height=0;
  #end
  #if (cb_a[bn].y>180)
   #declare cb_a[bn]=cb_a[bn]-360*y;
  #end
  #declare cb_a[bn]=(flight_spline(<0,0,0>,<0,0,0>,cb_a[bn],cb_a[bn],0,.2,height));
  #render "Calculating foot positions\n"
  #declare i0=0;
  #while (i0<6)
    #declare foot_pos[i0]=vrotate(foot_def[i0],cb_a[bn])+cb_p[bn];
    
    #declare ground_height=mesh2_height(foot_pos[i0].x,foot_pos[i0].z);
    #if (ground_height>foot_pos[i0].y)
      #declare foot_pos[i0]=<foot_pos[i0].x,ground_height,foot_pos[i0].z>;
    #end
    #declare foot_pos[i0]=foot_pos[i0]-cb_p[bn];
    
    #declare i0=i0+1;
  #end

    
  #declare i0=0;
  #while (i0<6)
    #local land_pos[i0]=foot_pos[i0]+cb_p[bn];
    #local land_pos[i0]=<land_pos[i0].x,mesh2_height(land_pos[i0].x,land_pos[i0].z),land_pos[i0].z>;
    #declare i0=i0+1;
  #end
  
  // insert program here to continue bug walk. Bug landed at sep_count seconds.
  
  #declare ang_adj=(flight_spline(<20,0,0>,<25,0,0>,<25,0,0>,<0,0,0>,0,.4,height));
  #declare ang_adj=(flight_spline(ang_adj,<-10,0,0>,<0,0,0>,<0,0,0>,sep_count,sep_count+.4,clock));
  #declare pos_adj=(flight_spline(<0,0,0>,<0,-.13,-.1>,<0,-.05,0>,<0,0,0>,sep_count,sep_count+.4,clock));
  #declare cb_f[bn]=(flight_spline(cb_f[bn],cb_f[bn],0,0,sep_count,sep_count+.3,clock));
  #declare cb_h[bn]=(flight_spline(cb_h[bn],cb_h[bn]+<1,0,0>,<0,0,0>,<0,0,0>,sep_count,sep_count+.4,clock));

  #declare ang_adj=(flight_spline(ang_adj,<10,0,0>,<15,0,0>,<15,0,0>,sep_count+3,sep_count+4,clock));
  #declare pos_adj=(flight_spline(pos_adj,<0,0,0>,<0,-.05,0>,<0,-.05,0>,sep_count+3,sep_count+4,clock));
  #declare bug_eye=<0,0,.5>;
  #declare bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>
  
//  #if (height=0)
  #switch (bn)
  #case (0)     
// Bug0 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=bn;
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<sep_count+3)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,0,0>,<0,-80,0>,<0,-80,0>,sep_count+.3,sep_count+3,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<.1,0,-.2>,<.2,0,-.4>,<.4,0,-.4>,sep_count+.3,sep_count+3,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end
#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,13.75,14.5,clock));
#declare cb_h[bn]=(flight_spline(cb_h[bn],<0,-.25,0>,<0,-.5,0>,<0,-.75,0>,13.6,16,clock));

#declare bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>
#declare cb_h[bn]=(flight_spline(cb_h[bn],<-.1,-.25,0>,<-.3,.25,0>,<-.4,.5,0>,17.3,17.8,clock));
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.5,1,.5>,17.3,17.8,clock) ); 
#declare ang_adj=(flight_spline(ang_adj,<15,2,0>,<15,4,0>,<15,6,0>,17.3,18,clock));
#declare pos_adj=(flight_spline(pos_adj,<0,.05,0>,<0,-.075,0>,<0,-.09,0>,17.3,18,clock));

// Bug0 Ends--------------------------------------------------------------------------------------------
  #break     
  #case (1)                                                                                               
// Bug1 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=bn;
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<12.5)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,30,0>,<0,100,0>,<0,100,0>,sep_count+.3,12.5,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<0,0,0>,<.2,0,0>,<.2,0,0>,sep_count+.3,12.5,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end

#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,12.5,13,clock));
#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,13,13.5,clock));
#declare cb_h[bn]=(flight_spline(cb_h[bn],<0,-.5,0>,<0,0,0>,<0,.15,0>,14,16,clock));
#declare cb_h[bn]=(flight_spline(cb_h[bn],<0,-.15,0>,<0,-.35,0>,<0,-.55,0>,17.3,18,clock));

#declare bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.5,1,.5>,17.3,17.8,clock) ); 
#declare ang_adj=(flight_spline(ang_adj,<10,-2,0>,<0,-4,0>,<0,-6,0>,17.3,18,clock));
#declare pos_adj=(flight_spline(pos_adj,<0,-.05,0>,<0,-.075,0>,<0,-.09,0>,17.3,18,clock));

  
// Bug1 Ends--------------------------------------------------------------------------------------------
  #break
  #case (2)
// Bug2 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=bn;
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<13)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,0,0>,<0,-90,0>,<0,-90,0>,sep_count+.3,13,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<.1,0,-.2>,<.2,0,-.4>,<.4,0,-.4>,sep_count+.3,13,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end  
#declare cb_h[bn]=(flight_spline(cb_h[bn],cb_h[bn],<0,-.5,0>,<0,-.5,0>,12,13,clock));
#declare cb_h[bn]=(flight_spline(cb_h[bn],cb_h[bn],<0,.5,0>,<0,.5,0>,13.2,13.6,clock));
#declare cb_h[bn]=(flight_spline(cb_h[bn],<0,-.55,0>,<0,-.75,0>,<0,-.75,0>,13.6,16,clock));
#declare cb_h[bn]=(flight_spline(cb_h[bn],<0,-.75,0>,<0,.7,0>,<0,.7,0>,16,17,clock));
#declare bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.6,1,.5>,16.5,17.5,clock) ); 
#declare ang_adj=(flight_spline(ang_adj,<10,0,0>,<0,0,0>,<0,0,0>,16,17.5,clock));
#declare pos_adj=(flight_spline(pos_adj,<0,-.05,0>,<0,-.075,0>,<0,-.1,0>,16.5,17.5,clock));

// Bug2 Ends--------------------------------------------------------------------------------------------
  #break
  #case (3)
// Bug3 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=bn;
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<sep_count+3)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,0,0>,<0,-80,0>,<0,-80,0>,sep_count+.3,sep_count+3,march_time+.15) );
    #local m_pos=cb_p[bn];
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end
#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,13.5,14.25,clock));

#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.5,1,.5>,17.3,17.8,clock) ); 

// Bug3 Ends--------------------------------------------------------------------------------------------
  #break
  #case (4)
// Bug4 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=bn;
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<sep_count+3)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,0,0>,<0,-90,0>,<0,-90,0>,sep_count+.3,sep_count+3,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<0,0,-.1>,<0,0,-.2>,<0,0,-.3>,sep_count+.3,sep_count+3,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end


// Bug4 Ends--------------------------------------------------------------------------------------------
  #break
  #case (5)
// Bug5 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=bn;
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<sep_count+3)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,sep_count+.3,sep_count+3,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<.1,0,-.2>,<.2,0,-.4>,<.3,0,-.6>,sep_count+.3,sep_count+3,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end
#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,12.75,13.5,clock));
#declare cb_h[bn]=(flight_spline(cb_h[bn],<.3,.1,0>,<.3,.15,0>,<-1,.15,0>,17.36,18,clock));

// Bug5 Ends--------------------------------------------------------------------------------------------
  #break
  #case (6)
// Bug6 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=mod(bn,6);
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<sep_count+3)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,0,0>,<0,-45,0>,<0,-45,0>,sep_count+.3,sep_count+3,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<0,0,-.2>,<0,0,-.4>,<0,0,-.5>,sep_count+.3,sep_count+3,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end
#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,13.25,14,clock));
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.5,1,.5>,17.5,18,clock) );

// Bug6 Ends--------------------------------------------------------------------------------------------
  #break
  #case (7)
// Bug7 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=mod(bn,6);
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<sep_count+4)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<0,0,0>,<0,-55,0>,<0,-55,0>,sep_count+.3,sep_count+4,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<.1,0,-.2>,<.2,0,-.6>,<.3,0,-.8>,sep_count+.3,sep_count+4,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end
#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,13.5,14.25,clock));

// Bug7 Ends--------------------------------------------------------------------------------------------
  #break
  #case (8)
// Bug8 Starts------------------------------------------------------------------------------------------

#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }
#local m_clock=clock;
#local foot=mod(bn,6);
#local march_time=sep_count+.3;
#while (march_time<clock & march_time<sep_count+3)
  #if (march_time<=m_clock+.15)
    #local m_angle=cb_a[bn]+(flight_spline(<0,0,0>,<.1,0,0>,<0,-20,0>,<0,-20,0>,sep_count+.3,sep_count+3,march_time+.15) );
    #local m_pos=cb_p[bn]+(flight_spline(<0,0,0>,<.1,0,0>,<.2,0,0>,<.3,0,0>,sep_count+.3,sep_count+3,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate land_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh2_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh2_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local land_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh2_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock,land_pos) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end
#declare cb_h[bn]=cb_h[bn]+(flight_spline(<0,0,0>,<-1,0,0>,<-1,0,0>,<0,0,0>,13,13.75,clock));

// Bug8 Ends--------------------------------------------------------------------------------------------
  #break
  #end
//#end
  
  #declare transition=(flight_spline(1,1,0,0,0,.4,height));  
  #declare inv_trans=1-transition;
  #declare cb_p[bn]=cb_p[bn]*inv_trans;
  #declare cb_a[bn]=cb_a[bn]*inv_trans;  
  
  #declare calc_pos=position_of(land_pos);
  #declare calc_ang=heading_of(land_pos);

#render concat("Bug",str(bn,0,0)," calc_a=",str(calc_ang.y,0,0),"\n")

  #if (calc_ang.y>180)
    #declare calc_ang=calc_ang-360*y;
  #end    
  #local i0=0;
  #while (i0<6)
    #declare foot_pos[i0]=foot_pos[i0]*inv_trans+land_pos[i0]*transition;
  #declare i0=i0+1;
  #end
  #declare bug_pos=calc_pos*transition;
  #declare bug_ang=calc_ang*transition;  
    
  #declare bug_a[bn]=object { bug_macro(bug_pos+.15*y+pos_adj,bug_ang+ang_adj,clock,foot_pos,bug_eye,bug_eyelid,cb_h[bn],cb_f[bn],bn) }  

  #declare bn=bn+1;
#end

    #declare bug_cluster=
      union {
        #declare bn=0;
        #while (bn<bgc)
          object { bug_a[bn] rotate cb_a[bn] translate cb_p[bn] }
          #declare bn=bn+1;
        #end
      }
      
    object { bug_cluster }

#end
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------


#if (bald=0)
#declare dimples=
  object {
    union {              
      #declare ri=90.0;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.073;     
      #declare dr=.095;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd)-1);
      #declare r1=rs1/2;
      //#declare r1=0;
      
      #declare ri=83;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.087;     
      #declare dr=.13;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd));
      #declare r1=rs1/2;
            
      #while (r1<89)
        #declare h=(1+(dr/1.25))*sin(radians(r1));
        #declare r=(1+(dr/1.25))*cos(radians(r1));
        #declare rs2=120/int(2*pi*r/(6*dd));
        #declare r2=-60;
        #while (r2<59)
          sphere { <r,h,0>,dr rotate <0,r2,0> }
          sphere { <r,h,0>,dr rotate <0,r2+120,0> }
          sphere { <r,h,0>,dr rotate <0,r2+240,0> }          
          #if (r1>0)          
            sphere { <r,-h,0>,dr rotate <0,r2,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+120,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+240,0> }
          #end          
          #declare r2=r2+rs2;
       #end
        #declare r1=r1+rs1;
      #end
    }
  }
#else
  #declare dimples=sphere { 0,.1 }
#end

#declare fin_ball=           
  difference {
    sphere { 0,1 }    
    object { dimples } 
  }       

object { fin_ball         
  #if (bald=2)
    texture { pigment { color rgbt<.5,.5,.5,.5> } }
  #else
    #if (bald=1)
      texture { 
        pigment { 
          color rgb<1,1,1>
        }
        normal {
          bumps
          scale .1
        }
        finish { 
          ambient .0
          diffuse .9
          roughness .01
          specular .1
        }                       
      }
    #else
      texture { 
        pigment { 
          color rgb<1,1,1>
        }
        finish { 
          ambient .0
          diffuse .9
          roughness .01
          specular .1
        }                       
      }
    #end  
  #end
  #declare opos=<0,0,-.5>+<1.5,0,-2.1>;
  #declare bc=13;
  #declare npos=<0,0,-.5>+(flight_spline(<1.5,0,-2>,<.4,0,-1.3>,<.1,0,-.3>,<.1,0,-.3>,13,16,bc));
  #while (bc<clock & bc<16)
    #declare npos=<0,0,-.5>+(flight_spline(<1.5,0,-2>,<.4,0,-1.3>,<.1,0,-.3>,<.1,0,-.3>,13,16,bc));
    #declare npos=<npos.x,mesh2_height(npos.x,npos.z),npos.z>;
    #declare dpos=npos-opos;
    #declare yang=degrees(atan2(dpos.x,dpos.z));
    #declare xrot=vlength(dpos)/(2*pi*.3)*360;
    rotate <0,-yang,0>
    rotate <xrot,0,0>
    rotate <0,yang,0>
    #declare opos=npos;
    #declare bc=bc+1/25;
  #end
  
  translate <0,.9,0>
  scale .3
  translate <npos.x,mesh2_height(npos.x,npos.z),npos.z>
}

#render concat("ball height adjusted +",str(mesh2_height(-.1,.3),3,3),"\n")


#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")