// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
global_settings {
  assumed_gamma 1
  max_intersections 50
  max_trace_level 50
}

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     


camera {
  location <0,0,-15>
  direction <0,0,1>
  orthographic
  up<0,1,0>
  right <1,0,0>
  look_at <0,0,0>
}

/*sphere { 0,1
    translate <0,-1,0>
    scale 10000
    texture {
      pigment {
        granite
        turbulence .2
        omega .75
        lambda 2
        octaves 6
        color_map {
          [ 0 color rgbt<.2,.2,.2,.8> ]
          [ 1 color rgbt<.5,.5,.5,.8> ]
        }
      }
      finish { 
        ambient 1
      }
      //scale <8,15,8>
    }
    rotate <-90,0,0>
    translate <0,0,-1>
  }*/ 



plane { -z,0
  texture {     
    pigment {
      gradient -z
      turbulence .5
      omega .35
      lambda 2
      octaves 7
      poly_wave 1.5
      color_map {
        [ 0 color rgb<0,0,0> ]
        //[ 0.5 color rgb<0,0,0> ]
        //[ 0.3 color rgb<0,0,0> ]
        //[ 0.4 color rgb<1,1,1> ]
        [ 1 color rgb<1,1,1> ]
      }
    }
    finish { 
      ambient 1
    }
    translate <0,0,-.4>
    scale .4 
    rotate <0,0,-75>
    translate <-.4,-.5,0>
  }
  translate <0,0,0>
}



sphere { 0,5     
  scale <3,5,1/10>
  rotate <0,0,-5>
  texture { 
    pigment { 
      gradient z
      poly_wave .6
      translate <0,0,.01> 
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.666 color rgbt<.2,.2,.2,1> ]
        [ .667 color rgbt<.2,.2,.2,.4> ]
        [ 1. color rgbt<.2,.2,.2,.4> ]      
        
      }
    }
    finish { 
      ambient 1
    }
  }  
  scale <.1,.1,.001> 
  translate <.07,.05,-2.1>
  hollow
  no_shadow
}
                     
sphere { 0,5     
  scale <4,7,1/10>
  rotate <0,0,20>
  texture { 
    pigment { 
      gradient z
      poly_wave .6
      translate <0,0,.01> 
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.666 color rgbt<.2,.2,.2,1> ]
        [ .667 color rgbt<.2,.2,.2,.4> ]
        [ 1. color rgbt<.2,.2,.2,.4> ]      
        
      }
    }
    finish { 
      ambient 1
    }
  }  
  scale <.1,.1,.001> 
  translate <.05,-.25,-2.1>
  hollow
  no_shadow
}
/*
sphere { 0,5     
  scale <7,4,1/10>
  rotate <0,0,-5>
  texture { 
    pigment { 
      gradient z
      poly_wave .6
      translate <0,0,.01> 
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.666 color rgbt<.2,.2,.2,1> ]
        [ .667 color rgbt<.2,.2,.2,.4> ]
        [ 1. color rgbt<.2,.2,.2,.4> ]      
        
      }
    }
    finish { 
      ambient 1
    }
  }  
  scale <.2,.1,.001> 
  translate <-.1,-.3,-2.1>
  hollow
  no_shadow
}
*/ 
/*
#local ls=.05;
#declare w1=<0,-1,0>;
#declare w2=<0,0,0>;
#declare w3=<2,1,0>;
#declare w4=<3,3,0>;
#declare fairwy=
  merge {     
    #local l0=0;
    #while (l0<1)
      
      sphere { ( flight_spline(w1,w2,w3,w4,0,1,l0) ),2.5 }
      cylinder { ( flight_spline(w1,w2,w3,w4,0,1,l0) ) , ( flight_spline(w1,w2,w3,w4,0,1,l0+ls) ) ,2.5 }
      
      #local l0=l0+ls;
    #end
    sphere { ( flight_spline(w1,w2,w3,w4,0,1,l0) ),2.5 }
    scale <.1,.1,1/5>
    texture { 
      pigment { 
        gradient z
        poly_wave .6
        translate <0,0,.01> 
        color_map {
          [ 0 color rgbt<1,1,1,1> ]
          [ 0.665 color rgbt<.1,.1,.1,1> ]
          [ .667 color rgbt<.1,.1,.1,.2> ]
          [ 1. color rgbt<.1,.1,.1,.1> ]      
          
        }
      }
      finish { 
        ambient 1
      }
    }
    translate <0,0,-1>  
  }
*/      