// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "hf_moon2.inc"
       
#declare mesh_div=4;
#declare mesh_pretrans=<0,0,0>;
#declare mesh_scale=<8,2,8>;
#declare mesh_postrans=<-4,-.0001,-4>;

#macro mesh_height(parmx,parmz)
  #local posheight=-1;
  #local mesh_localpos=<parmx,0,parmz>;
  #local mesh_localpos=mesh_localpos-mesh_postrans;
  #local mesh_localpos=mesh_localpos/mesh_scale;
  #local mesh_localpos=mesh_localpos-mesh_pretrans;
  #local mesh_localpos=mesh_localpos*<dimx,0,dimy>;

  #local locx=mesh_localpos.x;
  #local locz=mesh_localpos.z;
  #local intx=int(locx);
  #local intz=int(locz);
  #local remx=locx-intx;
  #local remz=locz-intz;

  #if ((intx>=0) & (intx<=dimx))
    #if ((intz>=0) & (intz<=dimy))
      #local h1=hf_arr[intz][intx]/255;
      #local h2=hf_arr[intz][intx+1]/255;
      #local ha=h1*(1-remx)+h2*remx;
      #local h1=hf_arr[intz+1][intx]/255;
      #local h2=hf_arr[intz+1][intx+1]/255;
      #local hb=h1*(1-remx)+h2*remx;
      #local h=ha*(1-remz)+hb*remz;
      #local mesh_localpos=<mesh_localpos.x,h,mesh_localpos.z>;
      #local mesh_localpos=mesh_localpos+mesh_pretrans;
      #local mesh_localpos=mesh_localpos*mesh_scale;
      #local mesh_localpos=mesh_localpos+mesh_postrans;
      #local posheight=mesh_localpos.y;
    #else
      #render concat("HF Error - outside field ",str(parmx,0,0),",",str(parmz,0,0)," -> ",str(intx,0,0),",",str(intz,0,0),"\n")
    #end
  #else
    #render concat("HF Error - outside field ",str(parmx,0,0),",",str(parmz,0,0)," -> ",str(intx,0,0),",",str(intz,0,0),"\n")
  #end
  posheight
#end  

#render "Creating Mesh ("
#render str((mesh_pretrans.z*mesh_scale.z+mesh_postrans.z),0,0)
#render ","
#render str((mesh_pretrans.x*mesh_scale.x+mesh_postrans.x),0,0)
#render ") - ("
#render str(((1+mesh_pretrans.z)*mesh_scale.z+mesh_postrans.z),0,0)
#render ","
#render str(((1+mesh_pretrans.x)*mesh_scale.x+mesh_postrans.x),0,0)
#render ")\n"

/*
#declare inc_land_mesh=mesh{
  #local i1=(mesh_pretrans.z*mesh_scale.z+mesh_postrans.z)+mesh_div;
  #while (i1<((1+mesh_pretrans.z)*mesh_scale.z+mesh_postrans.z)-mesh_div)
    #local i0=(mesh_pretrans.x*mesh_scale.x+mesh_postrans.x)+mesh_div;
    #while (i0<((1+mesh_pretrans.x)*mesh_scale.x+mesh_postrans.x)-mesh_div)    
    
      #local p1=<i0+mesh_div,0,i1+mesh_div>;
      #local ph=mesh_height(p1.x,p1.z);
      #local p1=<p1.x,ph,p1.z>;
      
      #local p2=<i0+mesh_div,0,i1>;
      #local ph=mesh_height(p2.x,p2.z);
      #local p2=<p2.x,ph,p2.z>;
      
      #local p3=<i0,0,i1+mesh_div>;
      #local ph=mesh_height(p3.x,p3.z);
      #local p3=<p3.x,ph,p3.z>;
      
      #local p4=<i0,0,i1>;
      #local ph=mesh_height(p4.x,p4.z);
      #local p4=<p4.x,ph,p4.z>;
    
       triangle { p1,p2,p3 }
       triangle { p2,p3,p4 }
    
      #local i0=i0+mesh_div;
    #end
    #local i1=i1+mesh_div;  
  #end
  texture { 
    pigment { color rgb<.7,.7,.7> } 
    finish { ambient 0 diffuse .7 }
  }
}
*/
#render "Loading TGA image_map to Mesh Co-ords\n"

#declare tga_land_mesh=
  object {
    object {
      height_field {
        tga "hf_moon2.tga"
        //hierarchy on
        smooth   
      }
      translate mesh_pretrans
      scale mesh_scale
      translate mesh_postrans
    }
    texture {
      pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>]
          [1 color rgb<.6,.55,.55>]
        }
      }
      finish { 
        ambient .0
        diffuse .9
        //roughness .4
        //specular .2
      }
      normal {
        granite
        turbulence .3
        omega .65
        lambda 2
        octaves 6            
        scale 10
      } 
    }
  } 
