// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
// mesh1        // firway
#include "hf_fair2.inc"       
#declare mesh_pretrans=<0,0,0>;
#declare mesh_scale=<70,20,70>;
#declare mesh_postrans=<-35,0,-0>;

#macro mesh_height(parmx,parmz)
  #local posheight=-1;
  #local mesh_localpos=<parmx,0,parmz>;
  #local mesh_localpos=mesh_localpos-mesh_postrans;
  #local mesh_localpos=mesh_localpos/mesh_scale;
  #local mesh_localpos=mesh_localpos-mesh_pretrans;
  #local mesh_localpos=mesh_localpos*<dimx,0,dimy>;

  #local locx=mesh_localpos.x;
  #local locz=mesh_localpos.z;
  #local intx=int(locx);
  #local intz=int(locz);
  #local remx=locx-intx;
  #local remz=locz-intz;

  #if ((intx>=0) & (intx<dimx))
    #if ((intz>=0) & (intz<dimy))
      #local h1=hf_arr[intz][intx]/255;
      #local h2=hf_arr[intz][intx+1]/255;
      #local ha=h1*(1-remx)+h2*remx;
      #local h1=hf_arr[intz+1][intx]/255;
      #local h2=hf_arr[intz+1][intx+1]/255;
      #local hb=h1*(1-remx)+h2*remx;
      #local h=ha*(1-remz)+hb*remz;
      #local mesh_localpos=<mesh_localpos.x,h,mesh_localpos.z>;
      #local mesh_localpos=mesh_localpos+mesh_pretrans;
      #local mesh_localpos=mesh_localpos*mesh_scale;
      #local mesh_localpos=mesh_localpos+mesh_postrans;
      #local posheight=mesh_localpos.y;
    #else
      #render concat("HF Error - outside field ",str(parmx,0,0),",",str(parmz,0,0)," -> ",str(intx,0,0),",",str(intz,0,0),"\n")
    #end
  #else
    #render concat("HF Error - outside field ",str(parmx,0,0),",",str(parmz,0,0)," -> ",str(intx,0,0),",",str(intz,0,0),"\n")
  #end
  posheight
#end  

#render "Creating Mesh ("
#render str((mesh_pretrans.z*mesh_scale.z+mesh_postrans.z),0,0)
#render ","
#render str((mesh_pretrans.x*mesh_scale.x+mesh_postrans.x),0,0)
#render ") - ("
#render str(((1+mesh_pretrans.z)*mesh_scale.z+mesh_postrans.z),0,0)
#render ","
#render str(((1+mesh_pretrans.x)*mesh_scale.x+mesh_postrans.x),0,0)
#render ")\n"

#render "Loading TGA image_map to Mesh Co-ords\n"

#declare tga_land_mesh=
  object {
    object {
      height_field {
        tga "hf_fair2.tga"
        hierarchy on
        smooth
      }
      translate mesh_pretrans
      scale mesh_scale
    }
    texture { 
      //pigment { color rgb<.1,.4,.01> }
      pigment { 
        bozo
        scale 2.5
        color_map {
          [ 0 color rgb<.1,.4,.01>*.95 ]
          [ 1 color rgb<.1,.4,.01>*1.05 ]
        }
        rotate <0,15,0>
      }
      finish { ambient amb_light diffuse .9 }
      normal {
        bumps .25
        scale .25
      }
    } 
    translate mesh_postrans
  } 




#macro rnd_vect(r_seed)
  <(640*rand(r_seed)-360),(640*rand(r_seed)-360),(640*rand(r_seed)-360)>
#end

#declare leaf_texture=
  texture {
    pigment {
      crackle
      color_map {
        [ 0  color rgbt<.2,.8,.1,1> ]
        [ .2 color rgbt<.2,.8,.1,1> ]
        [ .3 color rgbt<.2,.8,.1,.2> ]
        [ 1  color rgbt<.2,.8,.1,.2> ]
      }
    }
    finish {
      ambient amb_light
      diffuse .9
    }
    scale .9
  }
  
#declare tree_texture=
texture {
  pigment {
    color rgb<.5,.3,.1>
  }
  finish {
    ambient amb_light
    diffuse .9
  }
} 

#macro trunk_node(t_pos,t_vector,t_seed,t_octave,t_length,t_init_len,t_thick)
  #declare t_nodes=t_nodes+1;
    union {
      #local t_sub_len=(t_length-t_init_len)/(t_branch_threshold-t_init_len);
      
      #local rnd_seed=seed(t_seed);
      #local t_bias=rand(rnd_seed);
      #local t_cut=pow(t_limb_cut,t_octave);
      #local t_weighta=(1-t_cut)+t_cut*(t_bias);
      #local t_weightb=(1-t_cut)+t_cut*(1-t_bias);

      #local t_weighta=1;
      #local t_weightb=(1-t_cut*t_bias);
                                                 
      #if ( (t_vector.x!=0) | (t_vector.z!=0) )
        #local t_bearing=degrees(atan2(t_vector.x,t_vector.z));
      #else
        #local t_bearing=0;
      #end
      #if (t_weighta>t_weightb)
        #local a_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<-t_angle*(t_weightb/t_weighta),0,0>),<0,t_bearing,0>);
        #local b_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<t_angle*(t_weighta/t_weightb),0,0>),<0,t_bearing,0>);
      #else
        #local a_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<t_angle*(t_weightb/t_weighta),0,0>),<0,t_bearing,0>);
        #local b_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<-t_angle*(t_weighta/t_weightb),0,0>),<0,t_bearing,0>);
      #end
      
      #local t_axis_rotation=(t_axis_angle*2*(rand(rnd_seed)-.5))+t_axis_preset;
      #local a_vector=(vaxis_rotate(a_vector,t_vector,t_axis_rotation) );
      #local b_vector=(vaxis_rotate(b_vector,t_vector,t_axis_rotation) );
        
      #local a_vector=vnormalize(a_vector+t_vector*t_vector_attract+l_vector*t_light_attract);
      #local b_vector=vnormalize(b_vector+t_vector*t_vector_attract+l_vector*t_light_attract);
      
      #local t_init_lena=t_branch_threshold*t_shorten*t_weighta*(1-pow(t_limb_shorten,t_octave));
      #local t_init_lenb=t_branch_threshold*t_shorten*t_weightb*(1-pow(t_limb_shorten,t_octave));
      #local a_length=t_length*t_shorten*t_weighta*(1-pow(t_limb_shorten,t_octave));
      #local b_length=t_length*t_shorten*t_weightb*(1-pow(t_limb_shorten,t_octave));
      
      #local a_thick=t_thick*t_diminish*t_weighta;
      #local b_thick=t_thick*t_diminish*t_weightb;
      
      #if (t_length>t_branch_threshold)                                                                                    
      
        cone { t_pos,t_thick,t_pos+(t_vector*t_length),(t_thick*t_diminish) }
        sphere { t_pos+(t_vector*t_length),(t_thick*t_diminish) }
      
        object { trunk_node (t_pos+(t_vector*t_length),a_vector,32768*rand(rnd_seed),t_octave+1,a_length,t_init_lena,a_thick) }
        object { trunk_node (t_pos+(t_vector*t_length),b_vector,32768*rand(rnd_seed),t_octave+1,b_length,t_init_lenb,b_thick) }
      #else
        #if (t_length*t_sub_len>0)
          cone { t_pos,t_thick,t_pos+(t_vector*t_length*t_sub_len),(t_thick*t_diminish) }
        #end
        sphere { t_pos+(t_vector*t_length*t_sub_len),(t_thick*t_diminish) }
      #end
    }
#end

#macro foliage_node(t_pos,t_vector,t_seed,t_octave,t_length,t_init_len,t_thick)
  #declare t_nodes=t_nodes+1;
    
      #local t_sub_len=(t_length-t_init_len)/(t_branch_threshold-t_init_len);
      
      #local rnd_seed=seed(t_seed);
      #local t_bias=rand(rnd_seed);
      #local t_cut=pow(t_limb_cut,t_octave);
      #local t_weighta=(1-t_cut)+t_cut*(t_bias);
      #local t_weightb=(1-t_cut)+t_cut*(1-t_bias);

      #local t_weighta=1;
      #local t_weightb=(1-t_cut*t_bias);
                                                 
      #if ( (t_vector.x!=0) | (t_vector.z!=0) )
        #local t_bearing=degrees(atan2(t_vector.x,t_vector.z));
      #else
        #local t_bearing=0;
      #end
      #if (t_weighta>t_weightb)
        #local a_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<-t_angle*(t_weightb/t_weighta),0,0>),<0,t_bearing,0>);
        #local b_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<t_angle*(t_weighta/t_weightb),0,0>),<0,t_bearing,0>);
      #else
        #local a_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<t_angle*(t_weightb/t_weighta),0,0>),<0,t_bearing,0>);
        #local b_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<-t_angle*(t_weighta/t_weightb),0,0>),<0,t_bearing,0>);
      #end
      
      #local t_axis_rotation=(t_axis_angle*2*(rand(rnd_seed)-.5))+t_axis_preset;
      #local a_vector=(vaxis_rotate(a_vector,t_vector,t_axis_rotation) );
      #local b_vector=(vaxis_rotate(b_vector,t_vector,t_axis_rotation) );
        
      #local a_vector=vnormalize(a_vector+t_vector*t_vector_attract+l_vector*t_light_attract);
      #local b_vector=vnormalize(b_vector+t_vector*t_vector_attract+l_vector*t_light_attract);
      
      #local t_init_lena=t_branch_threshold*t_shorten*t_weighta*(1-pow(t_limb_shorten,t_octave));
      #local t_init_lenb=t_branch_threshold*t_shorten*t_weightb*(1-pow(t_limb_shorten,t_octave));
      #local a_length=t_length*t_shorten*t_weighta*(1-pow(t_limb_shorten,t_octave));
      #local b_length=t_length*t_shorten*t_weightb*(1-pow(t_limb_shorten,t_octave));
      
      #local a_thick=t_thick*t_diminish*t_weighta;
      #local b_thick=t_thick*t_diminish*t_weightb;
      
      #if (t_length>t_branch_threshold)                                                                                    
      
        
      
        foliage_node (t_pos+(t_vector*t_length),a_vector,32768*rand(rnd_seed),t_octave+1,a_length,t_init_lena,a_thick)
        foliage_node (t_pos+(t_vector*t_length),b_vector,32768*rand(rnd_seed),t_octave+1,b_length,t_init_lenb,b_thick)
      #else
        #declare t_leaves=t_leaves+1;
        
        //disc { t_pos+(t_vector*t_length*t_sub_len),vnormalize(t_vector*t_leaf_branch+t_l_vector*t_leaf_light),t_leaf_radius
        sphere { t_pos+(t_vector*t_length*t_sub_len),t_leaf_radius } 
        
      #end
    
#end

#macro b_foliage_node(t_pos,t_vector,t_seed,t_octave,t_length,t_init_len,t_thick)
  #declare t_nodes=t_nodes+1;
    
      #local t_sub_len=(t_length-t_init_len)/(t_branch_threshold-t_init_len);
      
      #local rnd_seed=seed(t_seed);
      #local t_bias=rand(rnd_seed);
      #local t_cut=pow(t_limb_cut,t_octave);
      #local t_weighta=(1-t_cut)+t_cut*(t_bias);
      #local t_weightb=(1-t_cut)+t_cut*(1-t_bias);

      #local t_weighta=1;
      #local t_weightb=(1-t_cut*t_bias);
                                                 
      #if ( (t_vector.x!=0) | (t_vector.z!=0) )
        #local t_bearing=degrees(atan2(t_vector.x,t_vector.z));
      #else
        #local t_bearing=0;
      #end
      #if (t_weighta>t_weightb)
        #local a_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<-t_angle*(t_weightb/t_weighta),0,0>),<0,t_bearing,0>);
        #local b_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<t_angle*(t_weighta/t_weightb),0,0>),<0,t_bearing,0>);
      #else
        #local a_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<t_angle*(t_weightb/t_weighta),0,0>),<0,t_bearing,0>);
        #local b_vector=vrotate(vrotate(vrotate(t_vector,<0,-t_bearing,0>),<-t_angle*(t_weighta/t_weightb),0,0>),<0,t_bearing,0>);
      #end
      
      #local t_axis_rotation=(t_axis_angle*2*(rand(rnd_seed)-.5))+t_axis_preset;
      #local a_vector=(vaxis_rotate(a_vector,t_vector,t_axis_rotation) );
      #local b_vector=(vaxis_rotate(b_vector,t_vector,t_axis_rotation) );
        
      #local a_vector=vnormalize(a_vector+t_vector*t_vector_attract+l_vector*t_light_attract);
      #local b_vector=vnormalize(b_vector+t_vector*t_vector_attract+l_vector*t_light_attract);
      
      #local t_init_lena=t_branch_threshold*t_shorten*t_weighta*(1-pow(t_limb_shorten,t_octave));
      #local t_init_lenb=t_branch_threshold*t_shorten*t_weightb*(1-pow(t_limb_shorten,t_octave));
      #local a_length=t_length*t_shorten*t_weighta*(1-pow(t_limb_shorten,t_octave));
      #local b_length=t_length*t_shorten*t_weightb*(1-pow(t_limb_shorten,t_octave));
      
      #local a_thick=t_thick*t_diminish*t_weighta;
      #local b_thick=t_thick*t_diminish*t_weightb;
      
      #if (t_length>t_branch_threshold)                                                                                    
      
        
      
        b_foliage_node (t_pos+(t_vector*t_length),a_vector,32768*rand(rnd_seed),t_octave+1,a_length,t_init_lena,a_thick)
        b_foliage_node (t_pos+(t_vector*t_length),b_vector,32768*rand(rnd_seed),t_octave+1,b_length,t_init_lenb,b_thick)
      #else
        #declare t_leaves=t_leaves+1;
        
        //disc { t_pos+(t_vector*t_length*t_sub_len),vnormalize(t_vector*t_leaf_branch+t_l_vector*t_leaf_light),t_leaf_radius
        sphere { t_pos+(t_vector*t_length*t_sub_len),t_leaf_radius,1 } 
        
      #end
    
#end

#macro j_random_tree (t_pos,t_vector,t_seed,t_length,t_thick)
  #declare t_branch_threshold=.75;      // value required by node to initiate branch pair
  #declare t_diminish=.78;              // reduction in thickness per recursion
  #declare t_shorten=.95;               // reduction in limb length per recursion
  #declare t_limb_cut=0.5;              // limb weight cut in early stages (effects nearer base)
  #declare t_limb_shorten=.55;          // limb shorten in early stages (affect nearer base)  
  #declare t_vector_attract=0.05;       // attraction of child branches toward parent vector
  #declare l_vector=<0,1,0>;            // tree growth direction (incomming light)
  #declare t_light_attract=0.075;       // tendency to reach for light 
  #declare t_angle=40;                  // natural angle of branch split
  #declare t_axis_angle=90;             // rotation of branch pair about parent
  #declare t_axis_preset=0;             // initial angle (before rotate) 0=heavier branch upper.
  #declare t_anglet=10;
  #declare t_nodes=0;                   // statistical counter, not parameter
  #declare t_leaves=0;                  // statistical counter, not paramerer
  #declare t_l_vector=<0,1,0>;          // light-alighnent vector for leaves
  #declare t_leaf_radius=1;             // radius of leaf disc
  #declare t_leaf_branch=1;             // tendency for leaf to alight to parent branch
  #declare t_leaf_light=.5;             // tendency for leaf to align to t_l_vector.
  #render concat("Building Tree from seed #",str(t_seed,0,0),": ")
  union {
    object { trunk_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick) texture { tree_texture } }
    //union { foliage_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick) texture { leaf_texture } }
    blob { 
      threshold .35
      b_foliage_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick)
      texture { leaf_texture }
    }
  }                  
  #render concat(str(t_nodes,0,0)," node(s) generated; ",str(t_leaves,0,0)," leaf node(s).\n")
#end

#declare bush_texture=
  texture {
    pigment {
      crackle
      color_map {
        [ 0  color rgbt<.2,.6,.1,1> ]
        [ .2 color rgbt<.2,.6,.1,1> ]
        [ .21 color rgbt<.2,.6,.1,.3> ]
        [ 1  color rgbt<.2,.6,.1,.3> ]
      }
    }
    finish {
      ambient amb_light
      diffuse .9
    }
    scale .5
  }                          

#macro j_random_bush (t_pos,t_vector,t_seed,t_length,t_thick)
  #declare t_branch_threshold=.65;      // value required by node to initiate branch pair
  #declare t_diminish=.78;              // reduction in thickness per recursion
  #declare t_shorten=.9;                // reduction in limb length per recursion
  #declare t_limb_cut=0.25;             // limb weight cut in early stages (effects nearer base)
  #declare t_limb_shorten=.25;          // limb shorten in early stages (affect nearer base)  
  #declare t_vector_attract=0.05;       // attraction of child branches toward parent vector
  #declare l_vector=<0,1,0>;            // tree growth direction (incomming light)
  #declare t_light_attract=0.075;       // tendency to reach for light 
  #declare t_angle=40;                  // natural angle of branch split
  #declare t_axis_angle=90;             // rotation of branch pair about parent
  #declare t_axis_preset=0;             // initial angle (before rotate) 0=heavier branch upper.
  #declare t_anglet=10;
  #declare t_nodes=0;                   // statistical counter, not parameter
  #declare t_leaves=0;                  // statistical counter, not paramerer
  #declare t_l_vector=<0,1,0>;          // light-alighnent vector for leaves
  #declare t_leaf_radius=1.4;           // radius of leaf disc
  #declare t_leaf_branch=1;             // tendency for leaf to alight to parent branch
  #declare t_leaf_light=.5;             // tendency for leaf to align to t_l_vector.
  #render concat("Building Bush from seed #",str(t_seed,0,0),": ")
  union {
    object { trunk_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick) texture { tree_texture } }
    //union { foliage_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick) texture { leaf_texture } }
    blob { 
      threshold .85
      b_foliage_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick)
      texture { bush_texture }
    }
  }                  
  #render concat(str(t_nodes,0,0)," node(s) generated; ",str(t_leaves,0,0)," leaf node(s).\n")
#end

#declare shrub_texture=
  texture {
    pigment {
      crackle
      color_map {
        [ 0  color rgbt<.2,.5,.1,1> ]
        [ .2 color rgbt<.2,.5,.1,1> ]
        [ .21 color rgbt<.2,.5,.1,.3> ]
        [ 1  color rgbt<.2,.5,.1,.3> ]
      }
    }
    finish {
      ambient amb_light
      diffuse .9
    }
    scale .25
  }                  
    
#macro j_random_shrub (t_pos,t_vector,t_seed,t_length,t_thick)
  #declare t_branch_threshold=.75;      // value required by node to initiate branch pair
  #declare t_diminish=.78;              // reduction in thickness per recursion
  #declare t_shorten=.9;                // reduction in limb length per recursion
  #declare t_limb_cut=0.25;             // limb weight cut in early stages (effects nearer base)
  #declare t_limb_shorten=.25;          // limb shorten in early stages (affect nearer base)  
  #declare t_vector_attract=0.05;       // attraction of child branches toward parent vector
  #declare l_vector=<0,1,0>;            // tree growth direction (incomming light)
  #declare t_light_attract=0.075;       // tendency to reach for light 
  #declare t_angle=40;                  // natural angle of branch split
  #declare t_axis_angle=90;             // rotation of branch pair about parent
  #declare t_axis_preset=0;             // initial angle (before rotate) 0=heavier branch upper.
  #declare t_anglet=10;
  #declare t_nodes=0;                   // statistical counter, not parameter
  #declare t_leaves=0;                  // statistical counter, not paramerer
  #declare t_l_vector=<0,1,0>;          // light-alighnent vector for leaves
  #declare t_leaf_radius=1.2;           // radius of leaf disc
  #declare t_leaf_branch=1;             // tendency for leaf to alight to parent branch
  #declare t_leaf_light=.5;             // tendency for leaf to align to t_l_vector.
  #render concat("Building Shrub from seed #",str(t_seed,0,0),": ")
  union {
    object { trunk_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick) texture { tree_texture } }
    //union { foliage_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick) texture { leaf_texture } }
    blob { 
      threshold .85
      b_foliage_node(t_pos,t_vector,t_seed,1,t_length,.0001,t_thick)
      texture { shrub_texture }
    }
  }                  
  #render concat(str(t_nodes,0,0)," node(s) generated; ",str(t_leaves,0,0)," leaf node(s).\n")
#end

#ifdef(quick)
#declare mesh_flora=
  sphere { 0,.1}
#else

#declare bush1=j_random_bush(<0,-3,0>,<0,1,0>,42,2.1,.2)
#declare tree1=j_random_tree(<0,-1,0>,<0,1,0>,4,5.85,.45)
#declare tree2=j_random_tree(<0,-1,0>,<0,1,0>,5,5.8,.45)
#declare tree3=j_random_tree(<0,-1,0>,<0,1,0>,32767,5.8,.45)
#declare shrub=j_random_shrub(<0,-3,0>,<0,1,0>,3,2.4,.2)

#declare bush_seed=seed(1);
#declare shrub_seed=seed(1);

#declare mesh_flora=
union {
  object { tree1 translate <-20,mesh_height(-20,40),40> } 
  object { tree2 rotate <0,-60,0> translate <-14,mesh_height(-14,47),47> } 
  object { tree3 translate < -9,mesh_height(-9,58),58> } 

  object { tree3 rotate <0,-120,0> translate <-20,mesh_height(-20,53),53> } 
  object { tree3 rotate <0,120,0> translate < -13,mesh_height(-13,65),65> }   
                           
  #declare ls=.25;
  #declare ll=0;
  #while (ll<=1.01)
     #declare bp=(flight_spline(<-22,0,50>,<-17,0,57>,<-12,0,67>,<-7,0,60>,0,1,ll));
     #declare bp=<bp.x,mesh_height(bp.x,bp.z),bp.z>;
     object { bush1 scale .5 rotate <0,360*rand(bush_seed),0> translate bp } 
     #declare ll=ll+ls;
  #end
  
  #declare ls=.2;
  #declare ll=0;
  #while (ll<=1.01)
     #declare bp=(flight_spline(<22,0,38>,<22,0,44>,<22,0,52>,<25,0,60>,0,1,ll));
     #declare bp=<bp.x,mesh_height(bp.x,bp.z),bp.z>;
     object { bush1 scale .5 rotate <0,360*rand(bush_seed),0> translate bp } 
     #declare ll=ll+ls;
  #end
  
  //object { shrub scale .2 rotate <0,360*rand(shrub_seed),0> translate <2.5,mesh2_height(2.5,4),4> }
  //object { shrub scale .16 rotate <0,360*rand(shrub_seed),0> translate <2.35,mesh2_height(2.35,.5),.5> }
  //object { j_random_tree(<0,-1,0>,<0,1,0>,3,6.1,.5) translate < 0,mesh_height(0,85),85> }   

}
#end