// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
// mesh2        // green
#include "hf_green.inc"
#declare mesh2_pretrans=<0,0,0>;
#declare mesh2_scale=<15,5,25>;
#declare mesh2_postrans=<-7.5,-2,-6>;
                                     
#macro mesh2_height(parm2x,parm2z)
  #local pos2height=-1;
  #local mesh2_localpos=<parm2x,0,parm2z>;
  #local mesh2_localpos=mesh2_localpos-mesh2_postrans;
  #local mesh2_localpos=mesh2_localpos/mesh2_scale;
  #local mesh2_localpos=mesh2_localpos-mesh2_pretrans;
  #local mesh2_localpos=mesh2_localpos*<dimx,0,dimy>;

  #local locx2=mesh2_localpos.x;
  #local locz2=mesh2_localpos.z;
  #local intx2=int(locx2);
  #local intz2=int(locz2);
  #local remx2=locx2-intx2;
  #local remz2=locz2-intz2;

  #if ((intx2>=0) & (intx2<dimx-1))
    #if ((intz2>=0) & (intz2<dimy-1))
      #local h1g=hf_arr2[intz2][intx2]/255;
      #local h2g=hf_arr2[intz2][intx2+1]/255;
      #local hag=h1g*(1-remx2)+h2g*remx2;
      #local h1g=hf_arr2[intz2+1][intx2]/255;
      #local h2g=hf_arr2[intz2+1][intx2+1]/255;
      #local hbg=h1g*(1-remx2)+h2g*remx2;
      #local hg=hag*(1-remz2)+hbg*remz2;
      #local mesh2_localpos=<mesh2_localpos.x,hg,mesh2_localpos.z>;
      #local mesh2_localpos=mesh2_localpos+mesh2_pretrans;
      #local mesh2_localpos=mesh2_localpos*mesh2_scale;
      #local mesh2_localpos=mesh2_localpos+mesh2_postrans;
      #local pos2height=mesh2_localpos.y;
    #else
      #render concat("HF Error - outside field ",str(parm2x,0,0),",",str(parm2z,0,0)," -> ",str(intx2,0,0),",",str(intz2,0,0),"\n")
    #end
  #else
    #render concat("HF Error - outside field ",str(parm2x,0,0),",",str(parm2z,0,0)," -> ",str(intx2,0,0),",",str(intz2,0,0),"\n")
  #end
  pos2height
#end  

#render "Creating Mesh ("
#render str((mesh2_pretrans.z*mesh2_scale.z+mesh2_postrans.z),0,0)
#render ","
#render str((mesh2_pretrans.x*mesh2_scale.x+mesh2_postrans.x),0,0)
#render ") - ("
#render str(((1+mesh2_pretrans.z)*mesh2_scale.z+mesh2_postrans.z),0,0)
#render ","
#render str(((1+mesh2_pretrans.x)*mesh2_scale.x+mesh2_postrans.x),0,0)
#render ")\n"

#render "Loading TGA image_map to Mesh Co-ords\n"

#declare tga_land_mesh2=
  object {
    object {
      height_field {
        tga "hf_green.tga"
        hierarchy on
        smooth
      }
      translate mesh2_pretrans
      scale mesh2_scale
    }
    texture { 
      pigment { 
        bozo
        scale .5
        color_map {
          [ 0 color rgb<.1,.4,.01>*.95 ]
          [ 1 color rgb<.1,.4,.01>*1.15 ]
        }
        rotate <0,15,0>
      }
      finish { ambient amb_light diffuse .9 } 
    }
    translate mesh2_postrans
  } 

