// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     


camera {
  location <0,0,-15>
  direction <0,0,1>
  orthographic
  up<0,20,0>
  right <20,0,0>
  look_at <0,0,0>
}

#declare fade_in_pic=(flight_spline(0,0,1,1,2,5,clock));
#declare titlefade=(flight_spline(1,1,0,0,0,.5,clock));
#declare titlefade=(flight_spline(titlefade,0,1,1,4.5,5,clock));
#declare myname=(flight_spline(1,1,0,0,2,3,clock));
#declare myname=(flight_spline(myname,0,1,1,5,6,clock));
#declare themoon=(flight_spline(1,1,0,0,5,5.5,clock));
#declare themoon=(flight_spline(themoon,0,1,1,6.5,7,clock));
#declare theyear=(flight_spline(1,1,0,0,6.5,7,clock));
#declare theyear=(flight_spline(theyear,0,1,1,8,8.5,clock));
#declare thetime=(flight_spline(1,1,0,0,8,8.5,clock));      
#declare thetime=(flight_spline(thetime,0,1,1,9.5,10,clock));

#if (titlefade<1)

  text {
    ttf "c:\winnt\fonts\comicbd.ttf"
    "Revenge is a dish"
    1,0            
    translate <-4.1,1.5,0>
    scale <2,3,.01>
    texture { 
      pigment { color rgbt<1,1,1,titlefade> } 
      finish { ambient 1 diffuse 0 }
    }
    translate <0,0,-.3>
    no_shadow
  }
    text {
    ttf "c:\winnt\fonts\comicbd.ttf"
     "best served cold"
    1,0
    translate <-3.95,.5,0>
    scale <2,3,.01>
    texture { 
      pigment { color rgbt<1,1,1,titlefade> } 
      finish { ambient 1 diffuse 0 }
    }
    translate <0,0,-.3>
    no_shadow
  }
   
#end
#if (myname<1)

  text {
    ttf "c:\winnt\fonts\comic.ttf"
    "an animation by Duncan Gray"
    1,0            
    translate <-6.5,-4,0>
    scale <1,1.5,.01>
    texture { 
      pigment { color rgbt<1,1,1,myname> } 
      finish { ambient 1 diffuse 0 }
    }
    translate <0,0,-.3>
    no_shadow
  }

#end

#if (themoon<1)

  text {
    ttf "c:\winnt\fonts\comicbd.ttf"
    "The Moon"
    1,0            
    translate <-2.4,-3,0>
    scale <2,3,.01>
    texture { 
      pigment { color rgbt<1,1,1,themoon> } 
      finish { ambient 1 diffuse 0 }
    }
    translate <0,0,-.3>
    no_shadow
  } 
  
#end

#if (theyear<1)

  text {
    ttf "c:\winnt\fonts\comicbd.ttf"
    "6 Feb 1971"
    1,0            
    translate <-2.75,-3,0>
    scale <2,3,.01>
    texture { 
      pigment { color rgbt<1,1,1,theyear> } 
      finish { ambient 1 diffuse 0 }
    }
    translate <0,0,-.3>
    no_shadow
  } 
  
#end

#if (thetime<1)

  text {
    ttf "c:\winnt\fonts\comicbd.ttf"
    "About Tea-Time"
    1,0            
    translate <-4,-3,0>
    scale <2,3,.01>
    texture { 
      pigment { color rgbt<1,1,1,thetime> } 
      finish { ambient 1 diffuse 0 }
    }
    translate <0,0,-.3>
    no_shadow
  } 
  
#end

box { <0,0,0>,<1,1,.01>
  texture {
    pigment {
      image_map {
        tga "moon001.tga"
        map_type 0
        once
      }     
    }
    finish { ambient 1 diffuse 0 }
  }
  translate <-.5,-.5,0>
  scale <20,20,20>
  translate <0,0,-.1>
  translate <-.5/20,-.5/20,0>
}
box { <0,0,0>,<1,1,.01>
  texture {
    pigment {
      color rgbt<0,0,0,fade_in_pic>
    }
    finish { ambient 1 diffuse 0 }
  }
  translate <-.5,-.5,0>
  scale <20,20,20>
  translate <0,0,-.2>
}
