// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
                                              
#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

#declare lm_goldfoil=
  texture { 
    pigment {
      color rgb<.95,.95,.1>
    }
    finish {
      ambient 0
      diffuse .7
      roughness .02
      specular .8
      brilliance 2
      metallic
//      reflection .1
    }
    normal {
      bumps .5
      turbulence .5
      omega .5
      lambda 2
      octaves 6   
    }          
    scale 2.5
  }
  
#declare lm_white=
  texture {
    pigment { 
      color rgb<1,1,1>
    }
    finish {     
      ambient 0
      diffuse .7
      roughness .1
      specular .3
    }
  }

#declare lm_badge_tex=
texture {
  pigment {
    image_map {
      gif "apollo_badge.gif"
      map_type 0
      once
    }     
    translate <-.5,-.5,0>
    scale <-20,20,20>
  }
  finish {     
    ambient 0
    diffuse .7
    roughness .1
    specular .3
  }
}
                
#declare lm_alumin=
  texture {
    pigment { 
      color rgb<.75,.75,.75>
    }
    finish {
      
      metallic
      brilliance 2
      ambient 0
      diffuse .7
      roughness .1
      specular .6
//      reflection 0.1
    }
  }


#declare th_cone=
  union {
    difference {
      cone { <0,0,0>,1,<0,6,0>,3.5 }
      cone { <0,-.1,0>,.8,<0,6.1,0>,3.3 }
    }
    torus { 3.4,.2 translate <0,6,0> }
    translate <0,1,0>
  }
 
#declare lm_thruster=
union {
    cylinder { <0,0,-20>,<0,0,2>,2 }
    superellipsoid { <.2,.2> scale 3 translate <0,0,2> }
    object { th_cone rotate <0,0,0> translate <0,0,2> }
    object { th_cone rotate <0,0,90> translate <0,0,2> }
    object { th_cone rotate <0,0,180> translate <0,0,2> }
    object { th_cone rotate <0,0,270> translate <0,0,2> }
    texture { lm_white }
}

#declare lm_thrust_cutout=
   cylinder { <0,0,-5>,<0,0,5>,3 }


#declare lm_plate_recess=
  union {
    cone { <0,0,2.25>,3,<0,0,3.2>,4 }
    cylinder { <0,0,5>,<0,0,-5>,1 scale <1,2,1> }
    scale <.5,.5,1>
  }
  
#declare lm_plate_catch=
  difference {
    cone { <0,0,2.25>,3,<0,0,2.75>,2.2 }
    cylinder { <0,0,5>,<0,0,-5>,1 scale <1,2,1> }
    texture { lm_alumin }
    scale <.5,.5,1>
  }  

#declare lm_plate_pin=
  union {
    cylinder { <0,0,-3>,<0,0,3.3>,1 }
    sphere { 0,1 translate <0,0,1> scale <1,2,1> translate <0,0,2.3> }
    scale <.5,.5,1>
    texture { lm_alumin }
  }
  
#declare lm_cover_plate=
  union {
    difference {
      superellipsoid { <.2,.2> scale .5 scale <76,52,6> }
      object { lm_plate_recess translate <30,18,0> }
      object { lm_plate_recess translate <-30,18,0> }
    }
    object { lm_plate_catch translate <30,18,0> }
    object { lm_plate_catch translate <-30,18,0> }  
    scale .5
    translate <0,13,0>         //      final y=55(*.15)
  }

#declare lm_badge_plate=                                         
  object {
    union {
      difference {
        superellipsoid { <.2,.2> scale .5 scale <76,52,6> texture { lm_goldfoil scale 2 } }
        box { <-1,-1,0>,<1,1,-2> scale <76,52,6> texture { pigment { color rgb<1,1,1> } finish { ambient 0 diffuse .7 roughness .1 specular .3 } } }
        cone { <0,0,1.75>,7,<0,0,3.05>,10 texture { lm_badge_tex } scale <2,2,1> translate <0,4,0> }
        object { lm_thrust_cutout scale 2 translate <0,-26,0> texture { lm_goldfoil } }
        
        object { lm_plate_recess translate <30,18,0> texture { lm_goldfoil } }
        object { lm_plate_recess translate <-30,18,0> texture { lm_goldfoil } }
      }
      object { lm_plate_catch translate <30,18,0> }
      object { lm_plate_catch translate <-30,18,0> }  
    }
    scale .5
    translate <0,13,0>         //      final y=55(*.15)
  }

#declare lm_sidepan=
  union {
    superellipsoid { <.2,.2>
      translate <0,1,-1>
      scale <75,56,30>
      scale .5
    }
    object { lm_cover_plate translate <0,9,0> }
    union {
      object { lm_plate_pin rotate <0,0,90> translate <30,18,0> }               //      alter rotate as bug unlocks it.
      object { lm_plate_pin rotate <0,0,90> translate <-30,18,0> }
      scale .5
      translate <0,22,0>
    }
    texture { lm_goldfoil }
    translate <0,37,95>
  }

#declare lm_us_plaque=
  box { 0,1
    texture {
      pigment {
        image_map {
          tga "lm_plaque.tga"
        }
      }
      finish {     
        ambient 0
        diffuse .7
        roughness .1
        specular .3
      }
    }      
    translate <-.5,-1,0>    
    scale <75,50,5>     //56
    scale .35
    translate <0,90.5,-95.5>
  }

#declare ac_sidepan=
  union {
    difference {
      difference {
        superellipsoid { <.2,.2> translate <0,1,-1> scale <75,56,30> scale .5 }
        object { lm_cover_plate translate <0,9,0> }
        texture { lm_goldfoil }
      }
      superellipsoid { <.2,.2> scale .98 translate <0,1,-1> scale <75,56,30> scale .5 texture { pigment { color rgb<1,1,1> } finish { ambient 0 diffuse .7 roughness .1 specular .3 } } }
      object { lm_thrust_cutout translate <0,9,0> texture { lm_goldfoil } }
      translate <0,37,95>
    }
    object { lm_us_plaque rotate <0,180,0> }
    object { lm_badge_plate translate <0,9,0> translate <0,37,95> }
    object { lm_thruster translate <0,46,100> }
    union {
      object { lm_plate_pin rotate <0,0,90> translate <30,18,0> }
      object { lm_plate_pin translate <-30,18,0> }
      scale .5
      translate <0,59,95>
    }
  }  
    
#declare lm_body=
  difference {
    union {
      object { lm_sidepan rotate <0,0,0> }
      object { lm_sidepan rotate <0,45,0> }
      object { lm_thruster translate <0,46,100> rotate <0,45,0> }
      object { lm_sidepan rotate <0,90,0> }
      object { lm_sidepan rotate <0,135,0> }  
      object { lm_thruster translate <0,46,100> rotate <0,135,0> }
      object { lm_sidepan rotate <0,180,0> }
      object { ac_sidepan rotate <0,225,0> }
      object { lm_sidepan rotate <0,270,0> }
      object { lm_sidepan rotate <0,315,0> }
      object { lm_thruster translate <0,46,100> rotate <0,315,0> }
    }
    object { lm_thrust_cutout translate <0,46,100> rotate <0,45,0> texture { lm_goldfoil } }
    object { lm_thrust_cutout translate <0,46,100> rotate <0,135,0> texture { lm_goldfoil } }
    object { lm_thrust_cutout translate <0,46,100> rotate <0,315,0> texture { lm_goldfoil } }
    cylinder { <0,-2,0>,<0,200,0>,65.1 texture { lm_goldfoil } }   
  }
  
#declare leg_strut=
  cylinder { <0,0,200>,<0,100,120>,3 }
  
#declare leg_group=
  union {
    difference { sphere { 0,1 } box { <-2,-.1,-2>,2 } translate <0,.8,0> scale <10,10,10> rotate <-30,0,0> translate <0,0,185> }
    cylinder { <0,0,185>,<0,85,120>,3.5 }         // main leg; bottom to top

    cylinder { <5.5,42.5,152.5>,<36,40,100>,2.5 }   // lower strut - right
    cylinder { <-5.5,42.5,152.5>,<-36,40,100>,2.5 } // lower strut left        
    
    cylinder { <-39.2,40,100>,<39.2,40,100>,2 }   // lower inner axle pivot
    cone { <-39.5,40,100>,1.7,<-39.2,40,100>,2 }   // lower inner axle pivot end
    cone { <39.5,40,100>,1.7,<39.2,40,100>,2 }   // lower inner axle pivot end
    
    cylinder { <-38.5,40,100>,<-32,40,100>,4 }    // lower inner left casting
    cylinder { <32,40,100>,<38.5,40,100>,4 }      // lower inner right casting

    cylinder { <31.5,40,100>,<25.5,40,100>,4 }    // lower right chassis casting
    box { <31.5,36,100>,<25.5,44,80> } 
    cylinder { <-31.5,40,100>,<-25.5,40,100>,4 }  // lower left chassis casting
    box { <-31.5,36,100>,<-25.5,44,80> }

    cylinder { <-11.2,42.5,152.5>,<11.2,42.5,152.5>,2 }   // lower outer axle pivot
    cone { <-11.5,42.5,152.5>,1.7,<-11.2,42.5,152.5>,2 }  // lower outer axle pivot end
    cone { <11.5,42.5,152.5>,1.7,<11.2,42.5,152.5>,2 }    // lower outer axle pivot end
    
    cylinder { <-10.5,42.5,152.5>,<-4,42.5,152.5>,4 }     // lower outer left casting
    cylinder { <3.5,42.5,152.5>,<-3.5,42.5,152.5>,4 }     // lower outer centre casting
    cylinder { <4,42.5,152.5>,<10.5,42.5,152.5>,4 }       // lower outer right casting

    cylinder { <6.5,90,100>,<6.5,85,120>,3 }      // upper strut - right
    cylinder { <-6.5,90,100>,<-6.5,85,120>,3 }    // upper strut - left
    
    cylinder { <-16.2,90,100>,<16.2,90,100>,2 }   // upper inner axle pivot
    cone { <-16.5,90,100>,1.7,<-16.2,90,100>,2 }   // upper inner axle pivot end
    cone { <16.5,90,100>,1.7,<16.2,90,100>,2 }   // upper inner axle pivot end
    
    cylinder { <-9,90,100>,<-3,90,100>,4 }        // upper inner left casting
    cylinder { <3,90,100>,<9,90,100>,4 }          // upper inner right casting
    
    cylinder { <9.5,90,100>,<15.5,90,100>,4 }     // upper right chassis casting
    box { <9.5,86,100>,<15.5,94,80> } 
    cylinder { <-9.5,90,100>,<-15.5,90,100>,4 }   // upper left chassis casting
    box { <-9.5,86,100>,<-15.5,94,80> }
    
    cylinder { <-10.7,85,120>,<10.7,85,120>,2 }       // upper outer axle pivot
    cone { <-11,85,120>,1.7,<-10.7,85,120>,2 }       // upper outer axle pivot end
    cone { <11,85,120>,1.7,<10.7,85,120>,2 }       // upper outer axle pivot end
    
    cylinder { <-10,85,120>,<-4,85,120>,4 }       // upper outer left casting
    cylinder { <3.5,85,120>,<-3.5,85,120>,4 }     // upper outer centre casting
    cylinder { <4,85,120>,<10,85,120>,4 }         // upper outer right casting
             
    box { <-8,37,67>,<8,93,88> rotate <0,45/2,0> }
    box { <-8,37,67>,<8,93,88> rotate <0,-45/2,0> }
    
    cylinder { <0,32.25,82.5>,<0,97.75,77.5>,2 rotate <0,45/2,0> }
    cylinder { <0,32.25,82.5>,<0,97.75,77.5>,2 rotate <0,-45/2,0> }
  }

#declare lm_chassis=
  union {
    difference { 
      cylinder { <0,33,0>,<0,97,0>,90 }
      cylinder { <0,30,0>,<0,100,0>,65 }
      cylinder { <0,44,0>,<0,86,0>,91 }
      torus { 90,5 translate <0,99,0> }
      torus { 90,5 translate <0,31,0> } 
      torus { 65,5 translate <0,99,0> }
      torus { 65,5 translate <0,31,0> }
    }
    object { leg_group }
    object { leg_group rotate <0,90,0> }
    object { leg_group rotate <0,180,0> }
    object { leg_group rotate <0,270,0> }
    texture { lm_alumin }
  }  
  
#declare lm_petal=
  union {
    difference {
      box { <-15,9,-.01>,<15,18,.01> rotate <30,0,0> }
      box { <0,0,-10>,<15,30,20> rotate <0,0,-22.5> }
      box { <0,0,-10>,<-15,30,20> rotate <0,0,22.5> }
    }
    cylinder { <0,0,0>,<0,20,0>,.25 rotate <0,0,22.5> rotate <30,0,0> } 
  }
    
#declare lm_dish=
  union {
    object { lm_petal rotate <0,0,0> }
    object { lm_petal rotate <0,0,45> }
    object { lm_petal rotate <0,0,90> }
    object { lm_petal rotate <0,0,135> }
    object { lm_petal rotate <0,0,180> }
    object { lm_petal rotate <0,0,225> }
    object { lm_petal rotate <0,0,270> }
    object { lm_petal rotate <0,0,315> }
    cylinder { <0,0,-5>,<0,0,5>,2 }
    sphere { <0,0,20>,2 }
    cylinder { <0,0,0>,<0,0,20>,1 }
    cylinder { <0,0,-1>,<0,-25,-1>,1 }
    translate <0,21,1>
    texture { lm_white }
  }
  
#declare lander=
  union {
    object { lm_body }
    object { lm_chassis }
    object { lm_dish rotate<0,135,0> translate <0,90,-90> }
    translate <0,0,0>
    rotate <0,-45,0>
  }