// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

global_settings {
  assumed_gamma 1.8
}                  

//#declare tron=on;
#declare amb_light=0;
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end  

#declare cam_loc=<-5,10.4,3>;
#declare cam_tgt=<750,1,-450>;
#declare floor_height=(flight_spline(9.1,9.1,8,8,10,14,clock));
#declare scene_float=(flight_spline(<.2,0,-.2>,<.2,0,-.2>,<0,0,0>,<0,0,0>,10,14,clock));

//#declare cam_loc=<-2.25,6+floor_height,2.25>+scene_float;
//#declare cam_tgt=<-1.6,floor_height,1.6>+scene_float;
                                
camera
{           
  location cam_loc
  direction <0,0,1.1>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  rotate <0,-0,0>
}                                                  
#declare fade=0;
#declare fade=(flight_spline(0,0,1,1,6,6.2,clock));
#declare fade=(flight_spline(fade,fade,0,0,15.8,16,clock));
//#declare fade=1;
#if (fade<1)
  sphere { 0,.1
    texture {
      pigment {
        color rgbt<0,0,0,fade>
      }
      finish {
        ambient 0
        diffuse 0
      }
    }
    translate cam_loc
    hollow
  }
#end

light_source
{
  0 
  color .9
  translate <-750, 800, 0>
}
light_source
{
  0 
  color .1
  translate <-750, 800, 0>
  shadowless  
}

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// earth
#declare NightSky =
    texture {
      pigment { color rgb<0,0,.05> }
      finish { ambient 1 }
    }

#declare Stars =
    texture {
      pigment {
        granite
        poly_wave 2
        color_map {
          [ 0 color rgbf<1,1,1,1> ]
          [ .8 color rgbf<1,1,1,1> ]
          [ .81 color rgbf<1,1,1,0> ]
          [ 1 color rgbf<1,1,1,0> ]
        }
      }
      scale 100
    }

#declare BackDrop =
    texture { NightSky }
    texture { Stars rotate <0,0,-60> scale <2,2,2> }
    texture { Stars rotate <0,0,30> scale <3,2,3> }

object {
    sphere { <0,0,0>,20000 inverse }
    texture {
        BackDrop
        scale 8
        finish {ambient 1 }
    }
    rotate <-5,0,0>
    translate <0,0,0>
    rotate <0,135,0> 
}
/*
sphere { 0,1
  translate <0,-1,0>
  scale 50000
  texture {
    pigment {
      bozo
      scale 50
      color_map {
        [0 color rgb<.55,.5,.5>]
        [1 color rgb<.5,.45,.45>]
      }
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .3
      specular .05
    }
    normal {
      granite
      turbulence .3
      omega .65
      lambda 2
      octaves 6            
      scale 10
    }
  }
}  
*/
#declare LandArea =
  texture {
    pigment {
      agate
      turbulence 1
      lambda 1.5
      omega .8
      octaves 8
      color_map {
        [0.00 color rgb <.5, .25, .15>]
        [0.33 color rgb <.1, .5, .4>]
        [0.86 color rgb <.6, .3, .1>]
        [1.00 color rgb <.5, .25, .15>]
      }
    }
  }

#declare OceanArea =
  texture {
    pigment {
      bozo
      turbulence .5
      lambda 2
      color_map {
        [0.00, 0.33 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
        [0.33, 0.66 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1>]
        [0.66, 1.00 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
      }
    }
  }

#declare CloudArea =
  texture {
    pigment {
      granite scale 3
      poly_wave 1.4
      turbulence 1.65
      lambda 2.3
      omega .5
      octaves 7
      
      color_map {
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.05 color rgbf <1, 1, 1, 1>]
        [0.65 color rgbf <1, 1, 1, .2>]
        [2 color rgbf <1, 1, 1, 1>]
      }
    }
    finish {
      ambient .0 diffuse .7
    }
  }


#declare planet =
  union {
    object {
      sphere { <0,0,0>,1 }
/*      texture { LandArea }
      texture { OceanArea }*/
      texture {
        material_map {
          gif "planet.gif"
          map_type 1
          texture { pigment { color rgb<1,1,1> } finish { ambient .0 diffuse .7 } }
          texture { pigment { color rgb<.2,.3,1> } finish { ambient .0 diffuse .7  } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
          texture { pigment { color rgb<0,.5,0> } finish { ambient .0 diffuse .7 } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
        }
      }
      //rotate <0,70,0>
      rotate <0,245,0>  //  -ve = rotate for eastern sunrise
      rotate <-23.5,0,0>
      hollow
      scale <3000,3000,3000>
    }
    object {
      sphere { <0,0,0>,1.01 }
      texture {
        CloudArea
      }
      scale <3010,3010,3010>
    }
    scale .8
    //translate <-825,1000,10000>
    translate <0,1000,10000>
  }

//object { planet no_shadow rotate <0,90,0> }
object { planet no_shadow rotate <0,105,0> }


//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// height field
#include "hf_mesh3.inc"
object { tga_land_mesh }
object { tga_horizon }
object { sph_land }
/*
union {
#local xp=-4;
#while (xp<4)
  #local yp=-4;
  #while (yp<4)
    sphere { <xp,mesh_height(xp,yp),yp>,.05 }
    #local yp=yp+.5;
  #end
  #local xp=xp+.5;
#end
  texture { 
    pigment { color rgb<1,1,0> }
    finish { ambient 0 diffuse .7 }
  }
}
*/
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------








//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
/*
#include "bug1.inc"

object { bug            
  rotate <0,60,0>
  translate <.9,.25,.45>
}*/
//    5         2
//       \ ^ /
//    4 --| |-- 1
//       / V \
//    3         0
//       front


//      Bugs:
#include "bug2.inc"

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1\n"       //      1st left
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<.5,0,.5>;
#local start_angle=0;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock+2;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=0;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 2\n"               //     1st right
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<-.5,0,-.5>;
#local start_angle=-135;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock+1.5;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=1;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 3\n"       //      2nd left
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<-.25,0,-.25>;
#local start_angle=10;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=2;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 4\n"               //     2st right
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<-.5,0,-.5>;
#local start_angle=-95;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock-2;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=3;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 5\n"       //      3rd left
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<.35,0,.35>;
#local start_angle=-10;
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock-2;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=2;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 6\n"               //     4th left
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<-.1,0,-.1>;
#local start_angle=-30;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock-4;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=3;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------



// second wave
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 7\n"       //      1st left
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<.5,0,.5>;
#local start_angle=0;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock-6;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=0;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 8\n"               //     1st right
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<-.6,0,-.6>;
#local start_angle=-125;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock-5;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=1;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 9\n"       //      2nd left
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<-.25,0,-.25>;
#local start_angle=10;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock-8;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=2;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 10\n"               //     2nd right
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local end_pos=scene_float+<-.2,0,-.2>;
#local start_angle=-95;                           
#local bug_ang=<0,start_angle,0>;
#local bug_pos=end_pos-vrotate(-5*z,y*(start_angle-45)/2);
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock-6;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=3;
#local march_time=0;

#while (march_time<20)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,start_angle,0>,<0,(start_angle-45)/3,0><0,2*(start_angle-45)/3,0>,<0,-45,0>,0,20,march_time+.1) );
    #local m_pos=(flight_spline(end_pos-vrotate(-5*z,y*(start_angle-45)/2),end_pos-vrotate(-5*z,y*(start_angle-45)/2)+vrotate(-2*z,start_angle*y),vrotate(2*z,-45*y)+end_pos,end_pos,0,20,march_time+.1) );

#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_ang.x)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
                     
#declare ml_panel_clock=0;
#declare ml_noz_clock=0;
#declare sidepan_pin_angle=90;

#include "lander.inc"

object { lander rotate <0,20,0> translate <950,1,-750> scale .05 translate <60,0,-30> }
                                             

#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")
         
