// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

global_settings {
  assumed_gamma 1.8
}                  

//#declare tron=on;
#declare amb_light=0;
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end  


#declare light_pos=<1500,2500,-3000>;

light_source
{
  0 
  color .9
  translate light_pos
}
light_source
{
  0 
  color .1
  translate light_pos
  shadowless 
}

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// earth
#declare NightSky =
    texture {
      pigment { color rgb<0,0,.05> }
      finish { ambient 1 }
    }

#declare Stars =
    texture {
      pigment {
        granite
        poly_wave 2
        color_map {
          [ 0 color rgbf<1,1,1,1> ]
          [ .8 color rgbf<1,1,1,1> ]
          [ .81 color rgbf<1,1,1,0> ]
          [ 1 color rgbf<1,1,1,0> ]
        }
      }
      scale 100
    }

#declare BackDrop =
    texture { NightSky }
    texture { Stars rotate <0,0,-60> scale <2,2,2> }
    texture { Stars rotate <0,0,30> scale <3,2,3> }

object {
    sphere { <0,0,0>,20000 inverse }
    texture {
        BackDrop
        scale 8
        finish {ambient 1 }
    }
    rotate <-5,0,0>
    translate <0,0,0>
    rotate <0,135,0> 
}
/*
sphere { 0,1
  translate <0,-1,0>
  scale 50000
  texture {
    pigment {
      bozo
      scale 50
      color_map {
        [0 color rgb<.55,.5,.5>]
        [1 color rgb<.5,.45,.45>]
      }
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .3
      specular .05
    }
    normal {
      granite
      turbulence .3
      omega .65
      lambda 2
      octaves 6            
      scale 10
    }
  }
}  
*/
#declare LandArea =
  texture {
    pigment {
      agate
      turbulence 1
      lambda 1.5
      omega .8
      octaves 8
      color_map {
        [0.00 color rgb <.5, .25, .15>]
        [0.33 color rgb <.1, .5, .4>]
        [0.86 color rgb <.6, .3, .1>]
        [1.00 color rgb <.5, .25, .15>]
      }
    }
  }

#declare OceanArea =
  texture {
    pigment {
      bozo
      turbulence .5
      lambda 2
      color_map {
        [0.00, 0.33 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
        [0.33, 0.66 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1>]
        [0.66, 1.00 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
      }
    }
  }

#declare CloudArea =
  texture {
    pigment {
      granite scale 3
      poly_wave 1.4
      turbulence 1.65
      lambda 2.3
      omega .5
      octaves 7
      
      color_map {
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.05 color rgbf <1, 1, 1, 1>]
        [0.65 color rgbf <1, 1, 1, .2>]
        [2 color rgbf <1, 1, 1, 1>]
      }
    }
    finish {
      ambient .0 diffuse .7
    }
  }


#declare planet =
  union {
    object {
      sphere { <0,0,0>,1 }
/*      texture { LandArea }
      texture { OceanArea }*/
      texture {
        material_map {
          gif "planet.gif"
          map_type 1
          texture { pigment { color rgb<1,1,1> } finish { ambient .0 diffuse .7 } }
          texture { pigment { color rgb<.2,.3,1> } finish { ambient .0 diffuse .7  } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
          texture { pigment { color rgb<0,.5,0> } finish { ambient .0 diffuse .7 } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
        }
      }
      //rotate <0,70,0>
      rotate <0,245,0>  //  -ve = rotate for eastern sunrise
      rotate <-23.5,0,0>
      hollow
      scale <3000,3000,3000>
    }
    object {
      sphere { <0,0,0>,1.01 }
      texture {
        CloudArea
      }
      scale <3010,3010,3010>
    }
    scale .6
    //translate <-600,600,10000>
    translate <0,1300,10000> //-825,1000,10000>
  }


object { planet no_shadow rotate <0,87,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// height field
//#include "hf_mesh4.inc"
#declare mesh_div=4;
#declare mesh_pretrans=<0,0,0>;
#declare mesh_scale=<2000,150,2000>;
#declare mesh_postrans=<-340,-47,-1420>;
#declare tga_land_mesh=
  object {
    object {
      height_field {
        tga "hf_moon3.tga"
        hierarchy on
        smooth
        water_level .1
      }
      translate mesh_pretrans
      scale mesh_scale
    }
    texture {
      pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>]
          [1 color rgb<.6,.55,.55>]
        }
      }
      finish { 
        ambient .0
        diffuse .9
        //roughness .4
        //specular .2
      }
      normal {
        granite
        turbulence .3
        omega .65
        lambda 2
        octaves 6            
        scale 10
      } 
    }
    translate mesh_postrans
  } 


#declare sph_land=
sphere { 0,1
  translate <0,-1,0>
  scale 5000
  texture {
    pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>*.8]
          [1 color rgb<.6,.55,.55>*.8]
        }
      }
    finish { 
      ambient .0
      diffuse .9
    }
    normal {
      granite
      turbulence .2
      omega .75
      lambda 2
      octaves 6            
      scale <8,16,8>
    }
  }
}
object { tga_land_mesh }
//object { sph_land }
/*
union {
#local xp=-4;
#while (xp<4)
  #local yp=-4;
  #while (yp<4)
    sphere { <xp,mesh_height(xp,yp),yp>,.05 }
    #local yp=yp+.5;
  #end
  #local xp=xp+.5;
#end
  texture { 
    pigment { color rgb<1,1,0> }
    finish { ambient 0 diffuse .7 }
  }
}
*/

         

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------


#declare r_wire_pos=<.2,7.53,1.25>;
#declare g_wire_pos=<-.2,7.53,1.25>;

#declare wire_clock=(flight_spline(0,0,1,1,1.5,2.25,clock));
#declare wire_clock=(flight_spline(wire_clock,wire_clock,0,0,2.25,2.6,clock));
#declare r_wire_pos=<(flight_spline(r_wire_pos.x,r_wire_pos.x,r_wire_pos.x*.75,r_wire_pos.x*.5,0,1,wire_clock)),r_wire_pos.y,r_wire_pos.z>;
#declare g_wire_pos=<(flight_spline(g_wire_pos.x,g_wire_pos.x,g_wire_pos.x*.75,g_wire_pos.x*.5,0,1,wire_clock)),g_wire_pos.y,g_wire_pos.z>;

#declare r_wire_pos=<1.35,0,0>+r_wire_pos;
#declare g_wire_pos=<1.35,0,0>+g_wire_pos;





#declare sidepan_pin_pos=<0,59,95>;
#declare ml_noz_clock=-.4;
#declare sidepan_pin_angle=0;
#declare ml_panel_spin=0;
#declare ml_panel_drop=20;
#declare ml_panel_tilt=0;
#declare ml_panel_spin=180;

#include "cut_lander2.inc"
object { lander  translate <0,0,100> scale .15 }        
#declare spark_bright=(flight_spline(0,1,-.5,1,1.9,2.3,clock));
#declare spark_bright=(flight_spline(spark_bright,-.5,1,0,2.3,2.5,clock));
#if (vlength(spark_point1-spark_point2) < 1)
  #render concat("Spark from <",str(spark_point1.x,2,2),",",str(spark_point1.y,2,2),",",str(spark_point1.z,2,2),">")
  #render concat(" to <",str(spark_point2.x,2,2),",",str(spark_point2.y,2,2),",",str(spark_point2.z,2,2),">\n")
  #render concat(" Length of spark is ",str(vlength(spark_point1-spark_point2),2,2),"\n")
  //light_source { 0 color rgb<.2,.4,.5> translate spark_point1+<.1,.1,-.1> rotate<0,180,0> translate <0,0,100> scale .15 }  
  //light_source { 0 color rgb<.2,.4,.5> translate spark_point2+<-.1,.1,-.1> rotate<0,180,0> translate <0,0,100> scale .15 }  

  //sphere { 0,.1 translate spark_point1+<-.1,.1,-.1> rotate<0,180,0> translate <0,0,100> scale .15 texture { pigment { color rgb<1,1,1> } finish { ambient 1 } } }
  //sphere { 0,.1 translate spark_point2+<-.1,.1,-.1> rotate<0,180,0> translate <0,0,100> scale .15 texture { pigment { color rgb<1,1,1> } finish { ambient 1 } } }
  //#declare spark_bright=1-(vlength(spark_point1-spark_point2))
  //light_source { 0 color rgb<.3,.8,1> scale spark_bright translate (spark_point2+spark_point1)/2 rotate<0,180,0> translate <0,0,100> scale .15 }  
#end

#declare spark_point1=(vrotate(spark_point1,<0,180,0>)+<0,0,100>)*.15;
#declare spark_point2=(vrotate(spark_point2,<0,180,0>)+<0,0,100>)*.15;

#macro spark(sp1,sp2,sbr)
  #local spm=(sp1+sp2)/2;
  #local spl=vlength(sp1-sp2);
  
  light_source { 0 color rgb<.3,.8,1>*<sbr,sbr,sbr> translate spm+<0,.1,0> fade_distance 2.5 fade_power 1 }
  cylinder { sp1,sp2,.01
    texture { 
      pigment { 
        color rgb <.1,.8,1>
        transmit (1-sbr)
      }
      finish {
        ambient 2*sbr
      }
    }
    no_shadow
  }
  sphere { 0,1
    scale <spl,.2,.2>
    texture { 
      pigment { 
        color rgbf 1
      } 
      finish { 
        ambient 1
      }
    }
    interior {
      media {
        emission <.1,.8,1>*5*sbr
        intervals 15
        samples 5,10
        density {
          spherical
          poly_wave .1
        }
        scale <spl,.05,.05> 
        scale .5
      }
    }
    scale 2
    translate spm
    hollow
    //no_shadow
  }
  
#end

#if(spark_bright>0)
  spark(spark_point1,spark_point2,spark_bright)
#end
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#include "bug2.inc"

#macro mesh_height(xpos,ypos)   //      because of the maths required to 'float' the bug on an uneven surface,
                                //      it s no longer able to climb a sheer wall. This is overcome by calculating
                                //      the bugs while horizontal, and rotating afterwards to position on the side
                                //      of the craft.                                        
  0
#end

#declare bug3_rotate=<0,0,0>;
#declare bug3_translate=<1.35,7.35,1.65>;
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1(3)\n"   // bug with the wires
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local bug_ang=<0,5,0>;
#local bug_pos=<.05,0,0>;
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang.y)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local bug_pos=position_of(foot_pos)+<0,0,-.02>;
#local bug_ang=heading_of(foot_pos)+<35,0,0>;

#local bug_eye=<0,.2,.5>;        //      <1/2 right,1/3 up,iris>
#local bug_head=<-1,-.1,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

#local bug_head=(flight_spline(bug_head,bug_head,<-1.2,-.1,0>,<-1.2,-.1,0>,1,1.1,clock));
#local bug_head=(flight_spline(bug_head,bug_head,<-0.6,-.1,0>,<-0.6,-.1,0>,1.1,1.3,clock));
#local bug_head=(flight_spline(bug_head,bug_head,<-1.2,-.1,0>,<-1.2,-.1,0>,1.3,1.5,clock));

#local bug_head=(flight_spline(bug_head,bug_head,<-1.6,0,0>,<-1.6,0,0>,1.5,1.6,clock));

#local bug_eye=<bug_eye.x,bug_eye.y,(flight_spline(.5,.5,.2,.2,0,.1,spark_bright))>;
#local bug_eyelid=(flight_spline(<0,0,0>,<0,0,0>,<1,0,0>,<.8,0,0>,0,1,spark_bright));

#local foot_pos[0]=r_wire_pos-bug3_translate;
#local foot_pos[3]=g_wire_pos-bug3_translate;

#local foot_pos[4]=foot_pos[4]+.05*x;
#local foot_pos[1]=foot_pos[1]-z*.035-.05*x;

#declare bug3=object { bug_macro(bug_pos+.18*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }

object {bug3 rotate bug3_rotate translate bug3_translate }
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Bundle o' bugs
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#local bug_ang=<2,0,0>;
#local bug_pos=<0,0,0>;
#local bug_head=<-1.3,0,0>;       //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eye=<0,0,.5>;   
#local bug_eyelid=<1,0,0>;      //      <close,vulcan,snake>
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=.9*foot_pos[i0];
  //#local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end
#declare clustered_bug=object { bug_macro(bug_pos+.17*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }

#declare bug_ang=(flight_spline(<25,0,0>,<25,0,0>,<25,-10,0>,<25,-10,0>,0,.5,clock));

#declare bug_height=(flight_spline(.1,.1,0,0,1.35,1.8,clock));
#declare bug_head=(flight_spline(<-.8,0,0>,<-.8,0,0>,<-1.3,-.5,0>,<-1.3,-.5,0>,.3,.5,clock));

#declare bug_head=(flight_spline(bug_head,bug_head,<-.8,-.5,0>,<-.8,-.5,0>,.5,.7,clock));
#declare bug_head=(flight_spline(bug_head,bug_head,<-1.3,-.5,0>,<-1.3,-.5,0>,.7,.9,clock));
#declare bug_head=(flight_spline(bug_head,bug_head,<-.8,-.5,0>,<-.8,-.5,0>,.9,1.1,clock));

#declare bug_head=(flight_spline(bug_head,bug_head,<-1.3,0,0>,<-1.3,0,0>,1.4,1.6,clock));
#declare bug_ang=(flight_spline(bug_ang,bug_ang,<2,0,0>,<2,0,0>,1.3,1.85,clock));
#declare bug_eyelid=(flight_spline(<0,0,0>,<0,0,0>,<1,0,0>,<1,0,0>,1.85,1.95,clock));

#declare clustered_bug_animat=object { bug_macro(bug_pos+.17*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) } 
    
#declare bug_cluster=
  union {

    object { clustered_bug rotate <-45,0,0> translate <0,.2,-.12> rotate <0,0,60> }     //front
    object { clustered_bug rotate <-45,0,0> translate <0,.2,-.12> rotate <0,0,180> }
    object { clustered_bug rotate <-45,0,0> translate <0,.2,-.12> rotate <0,0,300> }
    
    object { clustered_bug_animat translate <0,.2+bug_height,0> rotate <0,0,0> }                          //middle
    object { clustered_bug translate <0,.2,0> rotate <0,0,120> }
    object { clustered_bug translate <0,.2,0> rotate <0,0,-120> }

    object { clustered_bug rotate <45,0,0> translate <0,.2,.15> rotate <0,0,60> }       //back
    object { clustered_bug rotate <45,0,0> translate <0,.2,.15> rotate <0,0,180> }
    object { clustered_bug rotate <45,0,0> translate <0,.2,.15> rotate <0,0,300> }

  }
#declare vel_applied=<0,0,0>;
#declare shot_clock=0;  
#if (clock>2.2)
  #declare shot_clock=clock-2.2;
#end
#declare vel_applied=vrotate(<20*shot_clock,0,0>,<0,0,-45*ml_noz_clock>);
  #declare vel_applied=vel_applied-y*(pow(1.2,shot_clock)-1);
#declare thruster_pos=<0,6.9,-.3>;
#declare cluster_pos=vrotate(<1.35,0,0>,<0,0,-45*ml_noz_clock>);
#declare cluster_ang=<0,-90,(-45*ml_noz_clock)>;
#declare cluster_abs=cluster_pos+thruster_pos+vel_applied;
object { bug_cluster rotate <0,0,0> rotate cluster_ang rotate <20*shot_clock,0,275*shot_clock> translate cluster_abs }




#declare bug1_rotate=<0,-80,0>;
#declare bug1_translate=<15.4,7,-2>;
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1\n"   // the one on the leg
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }

#local bug_ang=<0,0,0>;
#local bug_pos=<0,0,0>;
#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang.y)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local foot_pos[0]=foot_pos[0]+<0,-.03,0>;
#local foot_pos[1]=foot_pos[1]+<0,-.03,0>;
#local foot_pos[2]=foot_pos[2]+<0,-.08,0>;
#local foot_pos[3]=foot_pos[3]+<.02,-.07,.09>;
#local foot_pos[4]=foot_pos[4]+<0,-.05,0>;
#local foot_pos[5]=foot_pos[5]+<0,-.02,0>;

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<10,0,0>;

#local bug_eye=<0,0,.5>;        //      <1/2 right,1/3 up,iris>
#local bug_head=<0,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

#local bug_ang=bug_ang+<15,0,0>;

#declare bug1=object { bug_macro(bug_pos+.12*y,bug_ang,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }

object {bug1 rotate bug1_rotate translate bug1_translate }


#declare cam_loc=<3.5,8.9,-3.5>;//<-3.5,7.9,-3.5>;
#declare cam_tgt=<1,7.9,.4>;
#declare cam_tgt=(flight_spline(cam_tgt,cam_tgt,<12,9,-2>,<12,9,-2>,2.25,2.8,clock));

//#declare cam_loc=bug_pos+bug1_translate-<-1,-.2,2>;
//#declare cam_tgt=bug_pos+bug1_translate;  
//light_source{ cam_loc+<0,1,-1> color White }

camera
{           
  location cam_loc
  direction <0,0,1.5>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  rotate <0,-0,0>
}                           
#declare fade=(flight_spline(0,0,1,1,0,0.2,clock));
#declare fade=(flight_spline(fade,fade,0,0,5.8,6,clock));
//#declare fade=1;
#if (fade<1)
  sphere { 0,.1
    texture {
      pigment {
        color rgbt<0,0,0,fade>
      }
      finish {
        ambient 0
        diffuse 0
      }
    }
    translate cam_loc
    hollow
  }
#end

#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")








