// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

#declare bald=1;
#if (clock<3)
  #declare bald=0;
#end
#declare bald=1;        //      dimples - 0=slow, 1=quick, 2=transparent
#declare amb_light=0;
//#declare tron=on;

global_settings {
  assumed_gamma 1.8
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     
/*
light_source
{
  0 
  color .9
  translate <0, 1000, -500>
}
light_source
{
  0 
  color .1
  translate <0, 1000, -500>
  shadowless 
}
*/
light_source
{
  0 
  color .9
  translate <-500, 2000, -500>
}
light_source
{
  0
  color .1
  translate <-500, 2000, -500>
  shadowless
}

      

#declare NightSky =
    texture {
      pigment { color rgb<0,0,.05> }
      finish { ambient 1 }
    }

#declare Stars =
    texture {
      pigment {
        granite
        poly_wave 2
        color_map {
          [ 0 color rgbf<1,1,1,1> ]
          [ .8 color rgbf<1,1,1,1> ]
          [ .81 color rgbf<1,1,1,0> ]
          [ 1 color rgbf<1,1,1,0> ]
        }
      }
      scale 100
    }

#declare BackDrop =
    texture { NightSky }
    texture { Stars rotate <0,0,-60> scale <2,2,2> }
    texture { Stars rotate <0,0,30> scale <3,2,3> }

object {
    sphere { <0,0,0>,20000 inverse }
    texture {
        BackDrop
        scale 8
        finish {ambient 1 }
    }
    rotate <-5,0,0>
    translate <0,0,0>
    rotate <0,135,0> 
}

sphere { 0,1
  translate <0,-1,0>
  scale 5000
  texture {
    pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>]
          [1 color rgb<.6,.55,.55>]
        }
      }
    finish { 
      ambient .0
      diffuse .9
    }
    normal {
      granite
      turbulence .2
      omega .75
      lambda 2
      octaves 6            
      scale <8,16,8>
    }
  }
}
#include "hf_mesh.inc"
object { tga_land_mesh }
object { tga_horizon }

#declare LandArea =
  texture {
    pigment {
      agate
      turbulence 1
      lambda 1.5
      omega .8
      octaves 8
      color_map {
        [0.00 color rgb <.5, .25, .15>]
        [0.33 color rgb <.1, .5, .4>]
        [0.86 color rgb <.6, .3, .1>]
        [1.00 color rgb <.5, .25, .15>]
      }
    }
  }

#declare OceanArea =
  texture {
    pigment {
      bozo
      turbulence .5
      lambda 2
      color_map {
        [0.00, 0.33 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
        [0.33, 0.66 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1>]
        [0.66, 1.00 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
      }
    }
  }

#declare CloudArea =
  texture {
    pigment {
      granite scale 3
      poly_wave 1.4
      turbulence 1.65
      lambda 2.3
      omega .5
      octaves 7
      
      color_map {
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.05 color rgbf <1, 1, 1, 1>]
        [0.65 color rgbf <1, 1, 1, .2>]
        [2 color rgbf <1, 1, 1, 1>]
      }
    }
    finish {
      ambient .0 diffuse .7
    }
  }

#declare planet =
  union {
    object {
      sphere { <0,0,0>,1 }
/*      texture { LandArea }
      texture { OceanArea }*/
      texture {
        material_map {
          gif "planet.gif"
          map_type 1
          texture { pigment { color rgb<1,1,1> } finish { ambient .0 diffuse .7 } }
          texture { pigment { color rgb<.2,.3,1> } finish { ambient .0 diffuse .7  } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
          texture { pigment { color rgb<0,.5,0> } finish { ambient .0 diffuse .7 } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
        }
      }
      //rotate <0,70,0>
      rotate <0,245,0>  //  -ve = rotate for eastern sunrise
      rotate <-23.5,0,0>
      hollow
      scale <3000,3000,3000>
    }
    object {
      sphere { <0,0,0>,1.01 }
      texture {
        CloudArea
      }                         
      scale <3010,3010,3010>
    }
    scale .8
    //translate <-600,600,10000>
    translate <825,400,10000>
  }


object { planet no_shadow rotate <0,135,0> }


#if (bald=0)
#declare dimples=
  object {
    union {              
      #declare ri=90.0;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.073;     
      #declare dr=.095;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd)-1);
      #declare r1=rs1/2;
      //#declare r1=0;
      
      #declare ri=83;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.087;     
      #declare dr=.13;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd));
      #declare r1=rs1/2;
            
      #while (r1<89)
        #declare h=(1+(dr/1.25))*sin(radians(r1));
        #declare r=(1+(dr/1.25))*cos(radians(r1));
        #declare rs2=120/int(2*pi*r/(6*dd));
        #declare r2=-60;
        #while (r2<59)
          sphere { <r,h,0>,dr rotate <0,r2,0> }
          sphere { <r,h,0>,dr rotate <0,r2+120,0> }
          sphere { <r,h,0>,dr rotate <0,r2+240,0> }          
          #if (r1>0)          
            sphere { <r,-h,0>,dr rotate <0,r2,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+120,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+240,0> }
          #end          
          #declare r2=r2+rs2;
       #end
        #declare r1=r1+rs1;
      #end
    }
  }
#else
  #declare dimples=sphere { 0,.1 }
#end

#declare fin_ball=           
  difference {
    sphere { 0,1 }    
    object { dimples } 
  }       

#declare rnd1=seed(123456);
   
    
object { fin_ball         
//  rotate <360*rand(rnd1),360*rand(rnd1),360*rand(rnd1)>
  #if (bald=2)
    texture { pigment { color rgbt<.5,.5,.5,.5> } }
  #else
  texture { 
    pigment { 
      image_map { tga "bal_logo.tga" map_type 1 } 
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .01
      specular .1
    }                       
    rotate <0,-90,0>
  }    
  #end
  rotate <45,0,30>
  rotate <0,90,0> 
  translate <0,.8,0>
  scale .3     
  translate <-1.3,mesh_height(-1.3,1.3),1.3>
}

#render concat("ball height adjusted +",str(mesh_height(-1.3,1.3),3,3),"\n")











/*
#include "bug1.inc"

object { bug            
  rotate <0,60,0>
  translate <.9,.25,.45>
}*/
//    5         2
//       \ ^ /
//    4 --| |-- 1
//       / V \
//    3         0
//       front

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//      Bugs:
#include "bug2.inc"

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1\n"                                                                            
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#local bug_ang=<0,0,0>;
#local bug_pos=<.6,0,1.2>;                           

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 1 , 3 , 2 ,4 ,0 , 5 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=0;
#local march_time=0;
#while (march_time<6)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,0,0>,<0,0,0>,<0,10,0>,<0,10,0>,-2,6,march_time+.15) );
    #local m_pos=(flight_spline(<.6,0,1.2>,<.6,0,.8>,(<.46,0,.04>+vrotate(<0,0,.25>,<0,9,0>)),<.47,0,.04>,-2,6,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(slow_step( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.15;   //      step time (.2 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<5,0,0>;
               
#local bug_eye=<0,-.1,.5>;
#local bug_eyelid=<0,0,0>;      //      <close/vulcan/snake>
#local bug_head=<0,0,0>;

#local bob=(flight_spline(0,0,.6,.6,5.25,6.25,clock) );
#local dip=(flight_spline(0,0,-15,-15,5.25,6.75,clock) );
#local nudge=(flight_spline(0,0,1,1,5.25,7.5,clock) );  

#local bug_head=(flight_spline(bug_head,bug_head,<-.75,0,0>,<-.75,0,0>,5,6.75,clock) );//down
#local bug_head=(flight_spline(bug_head,bug_head,<0,0,0>,<0,0,0>,6.75,7.25,clock) );//up
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.7,.4>,<0,-.7,.4>,5,6.75,clock) );
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.1,.4>,<0,-.1,.4>,6.75,7.25,clock) );

#local bug_head=(flight_spline(bug_head,bug_head,<-.25,0,0>,<-.25,0,0>,7.5,7.75,clock) );//down
#local bug_head=(flight_spline(bug_head,bug_head,<0,0,0>,<0,0,0>,7.75,8.0,clock) );//up
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.7,.4>,<0,-.7,.4>,7.5,8,clock) );
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.1,.4>,<0,-.1,.4>,7.5,8,clock) );

#local leg_clock=(flight_spline(1,1,.5,0,7.95,8.45,clock) );   //      set to zero for dead bugs leg to lie flat.

#local bug_head=(flight_spline(bug_head,bug_head,<-.8,0,0>,<-.8,0,0>,8.05,8.55,clock) );
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.2,.6>,<0,-.2,.6>,8,8.5,clock) );
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.9,-.25,-.5>,<.9,-.25,-.5>,8.5,9,clock) );

#local bob=(flight_spline(bob,bob,0,0,7.5,8.5,clock) );
#local dip=(flight_spline(dip,dip,10,10,7.5,8.25,clock) );
#local nudge=(flight_spline(nudge,nudge-.5,0,0,7.5,8.25,clock) );
                                                                                          
#local bug_head=(flight_spline(bug_head,bug_head,<.1,-.2,0>,<.1,-.4,0>,9,10,clock) );                                                                                          
#local bug_eye=(flight_spline(bug_eye,bug_eye,<-.1,-.2,.3>,<-.1,-.2,.3>,8.75,9.75,clock) );
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.6,1,.5>,9,10,clock) );

#local nudge_ang=vrotate(<0,0,-nudge*.07>,<0,bug_ang.y,0>);

object { bug_macro(nudge_ang+bug_pos+(.11-.04*bob)*y,<dip+bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 2\n"
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
                           
#local bug_ang=<0,45,0>;
#local bug_pos=<.8,0,2.2>;                           

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
#local firing_order=array[6] { 2,4,0,5,1,3 }
#local foot=0;
#local march_time=0;
#while (march_time<8)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,30,0>,<0,30,0>,<0,30,0>,<0,30,0>,.1,8,march_time+.15) );
    #local m_pos=(flight_spline(<.8,0,2.2>,(<.8,0,2.2>+vrotate(<0,0,-.25>,<0,30,0>)),(<.2,0,1.2>+vrotate(<0,0,.25>,<0,30,0>)),<.2,0,1.2>,.1,8,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(slow_step( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.15;   //      step time (.2 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<0,0,0>;
               
#local bug_eye=<0,0,.5>;
#local bug_head=<0,0,0>;
#local bug_eyelid=<0,0,0>;      //      <close/vulcan/snake>

#local bug_eye=(flight_spline(bug_eye,bug_eye,<.75,.05,.5>,<.75,.05,.5>,4,5,clock) );      // <right,up,iris>    // look at ball
#local bug_head=(flight_spline(bug_head,bug_head,<.1,.5,0>,<.1,.5,0>,4,5,clock) );        // <headup,turn,shake>

#local bug_eye=(flight_spline(bug_eye,bug_eye,<-.25,-.15,.5>,<-.25,-.15,.5>,5.5,6.5,clock) );  // look at brother quark (deceased)
#local bug_head=(flight_spline(bug_head,bug_head,<-.25,-.25,0>,<-.25,-.25,0>,5.5,6.5,clock) );        
                                                                                     
#local bug_eye=(flight_spline(bug_eye,bug_eye,<.0,-.35,.5>,<.0,-.35,.5>,7,8,clock) );  // look at elder for help
#local bug_head=(flight_spline(bug_head,bug_head,<-.4,0,0>,<-.2,0,0>,7,8,clock) );        
                                                                                     
#local bug_eye=(flight_spline(bug_eye,bug_eye,<-.25,0,.3>,<-.25,0,.3>,9,10,clock) );     // look at earth
#local bug_head=(flight_spline(bug_head,bug_head,<0,-.8,0>,<0,-.8,0>,9,10,clock) );        
#local dip=(flight_spline(10,10,15,15,8,9,clock) );

#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.6,1,.5>,9,10,clock) );

object { bug_macro(bug_pos+.11*y,<dip+bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 3\n"
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
                           
#local bug_ang=<0,-80,0>;
#local bug_pos=<-2.1,0,-.7>;                           

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
#local firing_order=array[6] { 0,5,1,3,2,4 }
#local foot=0;
#local march_time=0;
#while (march_time<8)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,-80,0>,<0,-80,0>,<0,-80,0>,<0,-80,0>,1,9,march_time+.15) );
    #local m_pos=(flight_spline(<-2.1,0,-.7>,<-1.5,0,-.7>,(<-.75,0,-.9>+vrotate(<0,0,.25>,<0,-80,0>)),<-.75,0,-.9>,1,9,march_time+.15) );
  
#ifdef(tron)
#if (firing_order[foot]=3 | firing_order[foot]=0 )
sphere { 0,.03 translate foot_pos[firing_order[foot]] texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end
cone { 0,.05,-.3*z,.0 rotate <0,m_angle.y,0> scale .5 translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z> texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } } }
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(slow_step( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.15;   //      step time (.2 sec between lifts)
#end 

#local bug_pos=position_of(foot_pos);
#local bug_ang=heading_of(foot_pos)+<0,0,0>;
               
#local bug_eye=<0,0,.5>;
#local bug_head=<0,0,0>;
#local bug_eyelid=<0,0,0>;      //      <close/vulcan/snake>

#local bug_head=(flight_spline(bug_head,bug_head,<-.75,.45,0>,<-.75,.45,0>,7.75,8.25,clock) );        
#local dip=(flight_spline(10,10,35,35,7.75,8.25,clock) );
#local rise=(flight_spline(0,0,.01,.01,7.75,8.25,clock) );

#local bug_eye=(flight_spline(bug_eye,bug_eye,<.6,.2,.3>,<.6,.2,.3>,7.5,8.5,clock) );
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.6,1,.5>,7.5,9.5,clock) ); 

#local foot_pos[3]=( flight_spline(foot_pos[3],foot_pos[3],foot_pos[3]+<.03,.23,-.03>,foot_pos[3]+<.18,.19,-.09>,8.25,9,clock) );

object { bug_macro(bug_pos+(rise+.11)*y,<dip+bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------






#include "dead_bug.inc"

object { brother_quark_deceased
  rotate <0,70,0>
  translate <.66,.096,-.64>
}


                        




#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")

#declare cam_loc=(flight_spline( <-2.2,.35,1.85>,<-2.2,.35,1.85>,<-2.2,.85,1>,<-2.2,.9,0>,0, 1.5,clock ) );
#declare cam_loc=(flight_spline(    cam_loc    ,<-2.2,.95,-1> ,<-1,1,-2>,<-1,1,-2>,1.5,3,clock) );
#declare cam_tgt=(flight_spline( <-.25,.3,.24>,<-.25,.3,.24>,<0,.1,-.35>,<0,.1,-.35>,0,3,clock) );


//#declare cam_loc=<-.6,4,0>;
//#declare cam_tgt=<-.6,1,0.1>; 
camera
{           
  location cam_loc
  direction <0,0,1.5>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
}

#declare fade=(flight_spline(1,1,0,0,9.75,10,clock));
#if (fade<1)
  sphere { 0,.1
    texture {
      pigment {
        color rgbt<0,0,0,fade>
      }
      finish {
        ambient 0
        diffuse 0
      }
    }
    translate cam_loc
    hollow
    no_shadow
  }
#end