// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

global_settings {
  assumed_gamma 1.8
}                  

//#declare tron=on;
#declare amb_light=0;
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end  

#declare view_clock=val(str((clock-.5),0,0));
#declare fade_clock=mod(clock,1);
#render concat("view=",str(view_clock,3,10)," fade=",str(fade_clock,0,10),"\n")

#declare cam_loc=(flight_spline(<-1400,150,400>,<-1100,150,200>,<-300,53,-150>,<-100,53,-150>,0,2,view_clock))*.15;
#declare cam_tgt=<0,44,0>*.15; 
                               
camera
{           
  location cam_loc
  direction <0,0,1.4>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  rotate <0,-0,0>
}
#declare fade=0;                           
#declare fade=(flight_spline(0,0,1,1,0,.2,fade_clock));
#declare fade=(flight_spline(fade,fade,0,0,.8,1,fade_clock));
//#declare fade=1;
#if (fade<1)
  sphere { 0,.1
    texture {
      pigment {
        color rgbt<0,0,0,fade>
      }
      finish {
        ambient 0
        diffuse 0
      }
    }
    translate cam_loc
    hollow
  }
#end

#declare light_pos=<-1000,3000,-2500>;
#declare light_pos=(flight_spline(<-750, 800, 0>,<-750, 800, 0>,<-1000,1000,-2500>,<-1000,1000,-2500>,0,3,view_clock) );

light_source
{
  0 
  color .9
  translate light_pos
}
light_source
{
  0 
  color .1
  translate light_pos
  shadowless 
}

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// earth
#declare NightSky =
    texture {
      pigment { color rgb<0,0,.05> }
      finish { ambient 1 }
    }

#declare Stars =
    texture {
      pigment {
        granite
        poly_wave 2
        color_map {
          [ 0 color rgbf<1,1,1,1> ]
          [ .8 color rgbf<1,1,1,1> ]
          [ .81 color rgbf<1,1,1,0> ]
          [ 1 color rgbf<1,1,1,0> ]
        }
      }
      scale 100
    }

#declare BackDrop =
    texture { NightSky }
    texture { Stars rotate <0,0,-60> scale <2,2,2> }
    texture { Stars rotate <0,0,30> scale <3,2,3> }

object {
    sphere { <0,0,0>,20000 inverse }
    texture {
        BackDrop
        scale 8
        finish {ambient 1 }
    }
    rotate <-5,0,0>
    translate <0,0,0>
    rotate <0,135,0> 
}
/*
sphere { 0,1
  translate <0,-1,0>
  scale 50000
  texture {
    pigment {
      bozo
      scale 50
      color_map {
        [0 color rgb<.55,.5,.5>]
        [1 color rgb<.5,.45,.45>]
      }
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .3
      specular .05
    }
    normal {
      granite
      turbulence .3
      omega .65
      lambda 2
      octaves 6            
      scale 10
    }
  }
}  
*/
#declare LandArea =
  texture {
    pigment {
      agate
      turbulence 1
      lambda 1.5
      omega .8
      octaves 8
      color_map {
        [0.00 color rgb <.5, .25, .15>]
        [0.33 color rgb <.1, .5, .4>]
        [0.86 color rgb <.6, .3, .1>]
        [1.00 color rgb <.5, .25, .15>]
      }
    }
  }

#declare OceanArea =
  texture {
    pigment {
      bozo
      turbulence .5
      lambda 2
      color_map {
        [0.00, 0.33 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
        [0.33, 0.66 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1>]
        [0.66, 1.00 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
      }
    }
  }

#declare CloudArea =
  texture {
    pigment {
      granite scale 3
      poly_wave 1.4
      turbulence 1.65
      lambda 2.3
      omega .5
      octaves 7
      
      color_map {
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.05 color rgbf <1, 1, 1, 1>]
        [0.65 color rgbf <1, 1, 1, .2>]
        [2 color rgbf <1, 1, 1, 1>]
      }
    }
    finish {
      ambient .0 diffuse .7
    }
  }


#declare planet =
  union {
    object {
      sphere { <0,0,0>,1 }
/*      texture { LandArea }
      texture { OceanArea }*/
      texture {
        material_map {
          gif "planet.gif"
          map_type 1
          texture { pigment { color rgb<1,1,1> } finish { ambient .0 diffuse .7 } }
          texture { pigment { color rgb<.2,.3,1> } finish { ambient .0 diffuse .7  } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
          texture { pigment { color rgb<0,.5,0> } finish { ambient .0 diffuse .7 } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
        }
      }
      //rotate <0,70,0>
      rotate <0,245,0>  //  -ve = rotate for eastern sunrise
      rotate <-23.5,0,0>
      hollow
      scale <3000,3000,3000>
    }
    object {
      sphere { <0,0,0>,1.01 }
      texture {
        CloudArea
      }
      scale <3010,3010,3010>
    }
    scale .6
    //translate <-600,600,10000>
    translate <0,1000,10000> //-825,1000,10000>
  }

object { planet no_shadow rotate <0,90,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// height field
#include "hf_mesh4.inc"
object { tga_land_mesh }
//object { sph_land }
/*
union {
#local xp=-4;
#while (xp<4)
  #local yp=-4;
  #while (yp<4)
    sphere { <xp,mesh_height(xp,yp),yp>,.05 }
    #local yp=yp+.5;
  #end
  #local xp=xp+.5;
#end
  texture { 
    pigment { color rgb<1,1,0> }
    finish { ambient 0 diffuse .7 }
  }
}
*/
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//#declare ml_panel_clock=0;
//#declare ml_noz_clock=0;
#include "lander.inc"

object { lander
  translate <0,0,100> 
  scale .15
}

#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")
         
