// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"


#declare amb_light=.2;

global_settings {
  assumed_gamma 1.8
  max_intersections 50
  max_trace_level 350
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     

#declare sun_source=<20,1000,-100>;
light_source { 0 color 1 translate sun_source }
                                     
#declare cam_loc=(flight_spline(<2,2,-3>,<1,1.9,-2.5>,<0,1.6,-1>,<0,1.6,-1>,0,.52,clock));
#declare cam_tgt=<0,0,0>;        

camera
{           
  location cam_loc
  direction <0,0,1.4>
  direction <0,0,4.4>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
}
#declare fade=(flight_spline(0,0,1,1,0,.25,clock));
#declare fade=(flight_spline(fade,fade,0,0,17.8,18,clock));
#if (fade<1) 
  sphere { 0,.1 texture { pigment { color rgbt<0,0,0,fade> } finish { ambient 0 diffuse 0 } } translate cam_loc hollow no_shadow }
#end

#declare size=(flight_spline(.1,.1,1,1,0,3,clock));
#declare rota=-360*clock/3;
#declare fade=(flight_spline(1,1,0,0,0,1,clock)); 


#declare news_page_top=
mesh {
    #declare tm0=0;
    #while (tm0<1)
      #declare lf0=(flight_spline(<0,.075,1>,<0,.01,.75>,<0,.18,.05>,<0,0,.05>,0,1,tm0));
      #declare lf1=(flight_spline(<0,.075,1>,<0,.01,.75>,<0,.18,.05>,<0,0,.05>,0,1,tm0+1/50));
          
      #declare rt0=lf0+x*1;
      #declare rt1=lf1+x*1;

      triangle { lf0,rt0,lf1 }
      triangle { lf1,rt0,rt1 }  
  
      #declare tm0=tm0+1/50;
    
  #end
    rotate <-90,0,0>
      
    texture {
      pigment {
        image_map {
          gif "tattle.gif"
          map_type 0
          once
          transmit all fade
        }
      }
      finish {
        ambient amb_light
        diffuse .7
      }
    }
  }     
  
#declare news_page_bot=
mesh {
    #declare tm0=0;
    #while (tm0<1)                                                                   
    
      #declare lf0=(flight_spline(<0,0,.05>,<0,-.1,.05>,<0,-.075,.75>,<.01,-.075,.98>,0,1,tm0));
      #declare lf1=(flight_spline(<0,0,.05>,<0,-.1,.05>,<0,-.075,.75>,<.01,-.075,.98>,0,1,tm0+1/50));  
          
      #declare rt0=lf0+x*1;
      #declare rt1=lf1+x*1;

      triangle { lf0,rt0,lf1 }
      triangle { lf1,rt0,rt1 }  
  
      #declare tm0=tm0+1/50;
    
  #end
    rotate <-90,0,0>          
    texture {
      pigment {
        color rgb<1,.95,.9>
      }
      finish {
        ambient amb_light
        diffuse .7
      }
    }
  }     
  
#declare news_slab=
  union { 
  #declare page=.3;
  #while (page<1)
    union {
      object { news_page_top }
      object { news_page_bot }
      scale <1,1,page> 
      translate <-.01*page,.06*(.8-page),0> 
      rotate <0,0,page>
    }
          
    #declare page=page+1/10;
  #end
  
  translate <-.5,-.5,0>
  rotate <90,0,0>
  translate <0,.075,0> 
  scale <.5,.5,.4>
  }
    
object {news_slab rotate <0,25,0> }

plane { y,0
  texture { 
    pigment { 
      color rgb<.5,.5,.5>
    }
    finish { 
      ambient amb_light
      diffuse .7
    }
  }
}

#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")