// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"


#declare amb_light=.2;

global_settings {
  assumed_gamma 1.8
  max_intersections 50
  max_trace_level 350
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     

#declare sun_source=<500,1000,-1000>;
light_source { 0 color .9 translate sun_source }
                                     
#declare cam_loc=<0,0,-4>;
#declare cam_tgt=<0,0,0>;        

camera
{           
  location cam_loc
  direction <0,0,1.4>
  direction <0,0,4.4>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
}


#declare size=(flight_spline(.1,.1,1,1,0,3,clock));
#declare rota=-360*clock/3;
#declare fade=(flight_spline(1,1,0,0,0,1,clock)); 

#declare news_page=
  box { <0,0,0>,<1,1,.01>
    texture {
      pigment {
        image_map {
          gif "tattle_img.gif"
          map_type 0
          once
          transmit all fade
        }
      }
      finish {
        ambient amb_light
        diffuse .7
      }
    }
    translate <-.5,-.5,0>
    rotate <0,0,rota>
    scale size
  }

object {news_page translate <0,.05,-.1> no_shadow }

plane { -z,0
  texture { 
    pigment { 
      color rgb<0,0,0>
    }
    finish { 
      ambient 0
      diffuse 0
    }
  }
}
