// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

//#declare quick=on;
//#declare tron=on;
#declare shr_count=100;

#declare amb_light=.2;
global_settings {
  assumed_gamma 1.8
  max_intersections 50
  max_trace_level 350
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     

#declare sun_source=<500,1000,-1000>;
light_source { 0 color .9 translate sun_source }
light_source { 0 color .2 translate sun_source shadowless }     // directional 'ambient' light

#declare sky_color=
  texture {
    pigment {
      gradient y
      color_map {
        [ 0 MidnightBlue*.2 ]
        [ 1 color <.4,.6,.8> ]
      }
    }
    finish {
      ambient 1
    }
  }

#declare sky_cloud=
  texture {
    pigment {
      bozo
      turbulence .2
      lambda 1.5
      omega .85
      octaves 11
      color_map {
        [ 0 color rgbt<1,1,1,1> ]
        [ 0.4 color rgbt<1,1,1,1> ]
        [ 0.8 color rgbt<1,1,1,.5> ]
        [ 2 color rgbt<1,1,1,0> ]
      }
    }
    finish {
      ambient 1
    }
    scale <.5,.05,.5>
    scale .25
    rotate <0,-40,0>
  }


object {
  sphere { <0,0,0> 1 inverse  }
  texture { sky_color }
  texture { sky_cloud translate <0,-.006,0> }
  translate <0,-.93,0>
  scale 10000
  translate <0,1,0>
  hollow
  no_shadow
}

#include "hf_mesh5_copy.inc"

#declare cam_loc=<-20,0,15>;
#declare cam_loc=<cam_loc.x,mesh_height(cam_loc.x,cam_loc.z),cam_loc.z>;
#declare cam_loc=cam_loc+<1,2.5,0>;
#declare cam_tgt=cam_loc+<14,-2,14>; 


#render concat("Placing camera @ <",str(cam_loc.x,1,5),",",str(cam_loc.y,1,5),",",str(cam_loc.z,1,5),">\n")
camera
{           
  location cam_loc
  direction <0,0,1.4>
//  direction <0,0,4.4>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
}

#declare fade=(flight_spline(0,0,1,1,0,.25,clock));
#declare fade=(flight_spline(fade,fade,0,0,9.8,10,clock));
#if (fade<1) 
  sphere { 0,.1 texture { pigment { color rgbt<0,0,0,fade> } finish { ambient 0 diffuse 0 } } translate cam_loc hollow no_shadow }
#end


#ifdef(quick)
  #declare water=
    texture {
      pigment {
        color rgb<.05,.1,.3>
      }
      finish {
        ambient amb_light
        diffuse .9
      }
    }
#else
#declare water=
  texture { 
    pigment {
      color rgb<.05,.05,.2>
    }
    normal {   
      ripples
      frequency 6
      phase mod(clock/3,1)
      translate <-.5,-3.5,-.5>
      scale <15,15,15>
      translate <0,0,35>  
    }
    finish {
      ambient 0//amb_light
      diffuse .9
      roughness .1
      specular 1
      reflection .3
      phong 1
      phong_size 50
    }
  }  
#end  
plane { y,0 
  texture { 
      //pigment { color rgb<.1,.4,.01> }
      pigment { 
        bozo
        scale 2.5
        color_map {
          [ 0 color rgb<.1,.4,.01>*.95 ]
          [ 1 color rgb<.1,.4,.01>*1.05 ]
        }
        rotate <0,15,0>
      }
      finish { ambient amb_light diffuse .9 }
      normal {
        bumps .25
        scale .25
      }
    } 
    translate mesh_postrans
  }
//texture { water } }

#declare impact_pos=<15,0,65>;
#declare hole=cylinder { <0,-1,0>,<0,2,0>,.75 texture { pigment { color rgb<.6,.6,.6> } finish { ambient amb_light diffuse .9 } } }
#declare pole=cylinder { <0,-1,0>,<0,7,0>,.15 texture { pigment { gradient y scale 2 color_map { [ 0 color rgb<1,1,1> ][.5 color rgb<1,1,1>][.5 color rgb<1,.1,.1>][1 color rgb<1,.1,.1>]}}finish { ambient amb_light diffuse .9 } } }
#declare hole_pos=impact_pos+<-8,0,-7>;
#declare hole_pos=<hole_pos.x,mesh_height(hole_pos.x,hole_pos.z),hole_pos.z>;

#declare flag_clock=clock;

#declare flag=
  mesh {
    #declare ls=.02;
    #declare ll=ls;
    #while ( ll<1)
      #declare c1=.5*(ll*sin(2*pi*(ll-flag_clock)));
      #declare c0=.5*((ll-ls)*sin(2*pi*(ll-ls-flag_clock)));
      #declare r1=(1-ll);
      #declare r0=(1-(ll-ls));
      triangle { <ll-ls,r0-(ll/2),c0/3>,<ll-ls,-r0-(ll/2),c0>,<ll,r1-(ll/2),c1/3> }
      triangle { <ll-ls,-r0-(ll/2),c0>,<ll,r1-(ll/2),c1/3>,<ll,-r1-(ll/2),c1> }
      #declare ll=ll+ls;
    #end
    texture { pigment { color rgb<1,1,1> } finish { ambient amb_light diffuse .9 } }
    scale <2,1,1>
  } 




  difference { 
    object { tga_land_mesh }
    object { hole translate hole_pos }
    sphere { 0,1 translate impact_pos+y*.5 texture { pigment { color rgb<.2,.2,0> } finish { ambient amb_light diffuse .9 } } }
  }
  object { mesh_flora }
  union {
    object { pole translate hole_pos }
    object { flag rotate <0,180,0> translate hole_pos+y*6 }
  }


//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")