// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

#declare bald=1;
#if (clock<3)
  #declare bald=0;
#end
//#declare bald=1;        //      dimples - 0=slow, 1=quick, 2=transparent
#declare amb_light=0;
global_settings {
  assumed_gamma 1.8
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     


#declare cam_loc=(flight_spline( <-2.2,.25,1.85>,<-2.2,.25,1.85>,<-2.2,.25,1>,<-2.2,.5,0>,0, 4,clock ) );
#declare cam_loc=(flight_spline(    cam_loc    ,<-2.2,.75,-1> ,<-1,.9,-2>,<-1,.9,-2>,4,8,clock) );
#declare cam_tgt=(flight_spline( <-.25,.25,.24>,<-.25,.25,.24>,<0,.20,-.35>,<0,.20,-.35>,0,8,clock) );
camera
{           
  location cam_loc
  direction <0,0,1.5>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  
//  location  < -2.2,.8,-1>     // finale
//  look_at   <-2,.8,0>

//  location  < 0,.2,-.315>     // near end
//  look_at   <0,.06,0>


//  location  < 0,.6,-4>         // near start
//  look_at   <0,.06,0>         

//  location  < 0,3,-2>         // start
//  look_at   <0,.06,0>         


     
//  location <-1,1,0> 
//  look_at <.64,0,-.64>    

  rotate <0,-0,0>

}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-1000, 4000, -500>
}

#declare NightSky =
    texture {
      pigment { color rgb<0,0,.05> }
      finish { ambient 1 }
    }

#declare Stars =
    texture {
      pigment {
        granite
        poly_wave 2
        color_map {
          [ 0 color rgbf<1,1,1,1> ]
          [ .8 color rgbf<1,1,1,1> ]
          [ .81 color rgbf<1,1,1,0> ]
          [ 1 color rgbf<1,1,1,0> ]
        }
      }
      scale 100
    }

#declare BackDrop =
    texture { NightSky }
    texture { Stars rotate <0,0,-60> scale <2,2,2> }
    texture { Stars rotate <0,0,30> scale <3,2,3> }

object {
    sphere { <0,0,0>,20000 inverse }
    texture {
        BackDrop
        scale 8
        finish {ambient 1 }
    }
    rotate <-5,0,0>
    translate <0,0,0>
    rotate <0,135,0> 
}
/*
object {
  object {
    height_field {
      tga "hf_moon.tga"
      //hierarchy on
      smooth   
    }
    translate <-.5,-.37,-.5>
    scale <8,.25,8>
  }
  texture {
    pigment {
      color rgb<.7,.7,.7>
    }
    finish { 
      ambient .0
      diffuse .7
    }  
  }
} 
sphere { 0,1
  translate <0,-1,0>
  scale 5000
  texture {
    pigment {
      color rgb<.7,.7,.7>
    }
    finish { 
      ambient .0
      diffuse .7
    }
    normal {
      granite
      turbulence .2
      omega .75
      lambda 2
      octaves 6            
      scale <8,8,8>
    }
  }
}
*/
sphere { 0,1
  translate <0,-1,0>
  scale 5000
  texture {
    pigment {
      color rgb<.5,.5,.5>
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .3
      specular .05
    }
    normal {
      granite
      turbulence .2
      omega .75
      lambda 2
      octaves 6            
      scale <8,8,8>
    }
  }
}  

#declare LandArea =
  texture {
    pigment {
      agate
      turbulence 1
      lambda 1.5
      omega .8
      octaves 8
      color_map {
        [0.00 color rgb <.5, .25, .15>]
        [0.33 color rgb <.1, .5, .4>]
        [0.86 color rgb <.6, .3, .1>]
        [1.00 color rgb <.5, .25, .15>]
      }
    }
  }

#declare OceanArea =
  texture {
    pigment {
      bozo
      turbulence .5
      lambda 2
      color_map {
        [0.00, 0.33 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
        [0.33, 0.66 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1>]
        [0.66, 1.00 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
      }
    }
  }

#declare CloudArea =
  texture {
    pigment {
      granite scale 3
      poly_wave 1.4
      turbulence 1.65
      lambda 2.3
      omega .5
      octaves 7
      
      color_map {
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.05 color rgbf <1, 1, 1, 1>]
        [0.65 color rgbf <1, 1, 1, .2>]
        [2 color rgbf <1, 1, 1, 1>]
      }
    }
    finish {
      ambient .0 diffuse .7
    }
  }

#declare planet =
  union {
    object {
      sphere { <0,0,0>,1 }
/*      texture { LandArea }
      texture { OceanArea }*/
      texture {
        material_map {
          gif "planet.gif"
          map_type 1
          texture { pigment { color rgb<1,1,1> } finish { ambient .0 diffuse .7 } }
          texture { pigment { color rgb<.2,.3,1> } finish { ambient .0 diffuse .7  } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
          texture { pigment { color rgb<0,.5,0> } finish { ambient .0 diffuse .7 } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
        }
      }
      //rotate <0,70,0>
      rotate <0,245,0>  //  -ve = rotate for eastern sunrise
      rotate <-23.5,0,0>
      hollow
      scale <3000,3000,3000>
    }
    object {
      sphere { <0,0,0>,1.01 }
      texture {
        CloudArea
      }
      scale <3010,3010,3010>
    }
    scale .8
    //translate <-600,600,10000>
    translate <825,400,10000>
  }


object { planet no_shadow rotate <0,135,0> }


#if (bald=0)
#declare dimples=
  object {
    union {              
      #declare ri=90.0;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.073;     
      #declare dr=.095;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd)-1);
      #declare r1=rs1/2;
      //#declare r1=0;
      
      #declare ri=83;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.087;     
      #declare dr=.13;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd));
      #declare r1=rs1/2;
            
      #while (r1<89)
        #declare h=(1+(dr/1.25))*sin(radians(r1));
        #declare r=(1+(dr/1.25))*cos(radians(r1));
        #declare rs2=120/int(2*pi*r/(6*dd));
        #declare r2=-60;
        #while (r2<59)
          sphere { <r,h,0>,dr rotate <0,r2,0> }
          sphere { <r,h,0>,dr rotate <0,r2+120,0> }
          sphere { <r,h,0>,dr rotate <0,r2+240,0> }          
          #if (r1>0)          
            sphere { <r,-h,0>,dr rotate <0,r2,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+120,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+240,0> }
          #end          
          #declare r2=r2+rs2;
       #end
        #declare r1=r1+rs1;
      #end
    }
  }
#else
  #declare dimples=sphere { 0,.1 }
#end

#declare fin_ball=           
  difference {
    sphere { 0,1 }    
    object { dimples } 
  }       

#declare rnd1=seed(123456);
   
    
object { fin_ball         
//  rotate <360*rand(rnd1),360*rand(rnd1),360*rand(rnd1)>
  #if (bald=2)
    texture { pigment { color rgbt<.5,.5,.5,.5> } }
  #else
  texture { 
    pigment { 
      image_map { tga "bal_logo.tga" map_type 1 } 
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .01
      specular .1
    }                       
    rotate <0,-90,0>
  }    
  #end
  rotate <45,0,30>
  rotate <0,90,0> 
  translate <0,.8,0>
  scale .3     
  translate <-1.3,0,1.3>
}













/*
#include "bug1.inc"

object { bug            
  rotate <0,60,0>
  translate <.9,.25,.45>
}*/
//    5         2
//       \ ^ /
//    4 --| |-- 1
//       / V \
//    3         0
//       front

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//      Bugs:
#include "bug2.inc"
#local foot_def=array[6] { <.26,.0,-.15>,<.29,.0,.0>,<.25,.0,.16>,<-.26,.0,-.15>,<-.29,.0,-.01>,<-.25,.0,.16> }
#macro step_to(tgt_pos,dr_leg_num,lift_time,l_clock)
  flight_spline(foot_pos[dr_leg_num],<foot_pos[dr_leg_num].x,foot_pos[dr_leg_num].y+.01,foot_pos[dr_leg_num].z>,<tgt_pos.x,tgt_pos.y+.1,tgt_pos.z>,tgt_pos,lift_time,lift_time+.3,l_clock) // +.3 secs for step duration
#end
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1\n"                                                                            
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
#local bug_ang=<0,0,0>;
#local bug_pos=<.6,0,1.2>;                           

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local i0=i0+1;
#end

#local m_clock=clock;
//#local firing_order=array[6] { 3 , 1 , 5 , 0 , 4 , 2 } // walk 'from back' - stride length must be kept less than distance between adjacent feet.
#local firing_order=array[6] { 2 , 4 , 0 , 5 , 1 , 3 }   // walk 'from front' - allows slightly longer stride as fwd foot moves before foot behind.
#local foot=0;
#local march_time=0;
#while (march_time<6)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,0,0>,<0,0,0>,<0,10,0>,<0,10,0>,-2,6,march_time+.15) );
    #local m_pos=(flight_spline(<.6,0,1.2>,<.6,0,.8>,(<.45,0,.05>+vrotate(<0,0,.25>,<0,10,0>)),<.45,0,.05>,-2,6,march_time+.15) );
  
    #local foot_pos[firing_order[foot]]=(step_to( (<m_pos.x,0,m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>) ),firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.15;   //      step time (.25 sec between lifts)
#end 

#local bug_pos=( foot_pos[0]+
                 foot_pos[1]+
                 foot_pos[2]+
                 foot_pos[3]+
                 foot_pos[4]+
                 foot_pos[5] ) / 6;
#local bug_pos=<bug_pos.x,0,bug_pos.z>;

#local f_med=(foot_pos[0]+foot_pos[3])/2;
#local r_med=(foot_pos[2]+foot_pos[5])/2;
#local med_vect=f_med-r_med;
#local bug_ang=<bug_ang.x,180+180*atan2(med_vect.x,med_vect.z)/pi,bug_ang.z>;
               
#local bug_eye=<0,-.1,.5>;
#local bug_eyelid=<0,0,0>;      //      <close/vulcan/snake>
#local bug_head=<0,0,0>;

#local bob=(flight_spline(0,0,.6,.6,5.25,6.25,clock) );
#local dip=(flight_spline(10,10,-5,-5,5.25,6.75,clock) );
#local nudge=(flight_spline(0,0,1,1,5.25,7.5,clock) );  

#local bug_head=(flight_spline(bug_head,bug_head,<-.75,0,0>,<-.75,0,0>,5,6.75,clock) );//down
#local bug_head=(flight_spline(bug_head,bug_head,<0,0,0>,<0,0,0>,6.75,7.25,clock) );//up
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.7,.4>,<0,-.7,.4>,5,6.75,clock) );
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.1,.4>,<0,-.1,.4>,6.75,7.25,clock) );

#local bug_head=(flight_spline(bug_head,bug_head,<-.25,0,0>,<-.25,0,0>,7.5,7.75,clock) );//down
#local bug_head=(flight_spline(bug_head,bug_head,<0,0,0>,<0,0,0>,7.75,8.0,clock) );//up
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.7,.4>,<0,-.7,.4>,7.5,8,clock) );
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.1,.4>,<0,-.1,.4>,7.5,8,clock) );

#local leg_clock=(flight_spline(1,1,.5,0,7.95,8.45,clock) );   //      set to zero for dead bugs leg to lie flat.

#local bug_head=(flight_spline(bug_head,bug_head,<-.8,0,0>,<-.8,0,0>,8.05,8.55,clock) );
#local bug_eye=(flight_spline(bug_eye,bug_eye,<0,-.2,.6>,<0,-.2,.6>,8,8.5,clock) );
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.9,-.25,-.5>,<.9,-.25,-.5>,8.5,9,clock) );

#local bob=(flight_spline(bob,bob,0,0,7.5,8.5,clock) );
#local dip=(flight_spline(dip,dip,10,10,7.5,8.25,clock) );
#local nudge=(flight_spline(nudge,nudge-.5,0,0,7.5,8.25,clock) );
                                                                                          
#local bug_head=(flight_spline(bug_head,bug_head,<.1,-.2,0>,<.1,-.4,0>,9,10,clock) );                                                                                          
#local bug_eye=(flight_spline(bug_eye,bug_eye,<-.1,-.2,.3>,<-.1,-.2,.3>,8.75,9.75,clock) );
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.1,1,.5>,<.5,1,.5>,8.75,10,clock) );



#local nudge_ang=vrotate(<0,0,-nudge*.055>,<0,bug_ang.y,0>);

object { bug_macro(nudge_ang+bug_pos+(.1-.05*bob)*y,<dip,bug_ang.y,0>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 2\n"
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
                           
#local bug_ang=<0,0,0>;
#local bug_pos=<.7,0,2.2>;                           

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local i0=i0+1;
#end

#local m_clock=clock;
#local firing_order=array[6] { 2,4,0,5,1,3 }
#local foot=0;
#local march_time=0;
#while (march_time<8)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,0,0>,<0,0,0>,<0,45,0>,<0,45,0>,.1,8,march_time+.15) );
    #local m_pos=(flight_spline(<.7,0,2.2>,<.7,0,1.8>,(<.6,0,1>+vrotate(<0,0,.25>,<0,45,0>)),<.6,0,1>,.1,8,march_time+.15) );
  
    #local foot_pos[firing_order[foot]]=(step_to( (<m_pos.x,0,m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>) ),firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.15;   //      step time (.25 sec between lifts)
#end 

#local bug_pos=( foot_pos[0]+
                 foot_pos[1]+
                 foot_pos[2]+
                 foot_pos[3]+
                 foot_pos[4]+
                 foot_pos[5] ) / 6;
#local bug_pos=<bug_pos.x,0,bug_pos.z>;
//#local bug_ang=(flight_spline(<0,0,0>,<0,0,0>,<0,45,0>,<0,45,0>,0,8,m_clock) );
#local f_med=(foot_pos[0]+foot_pos[3])/2;
#local r_med=(foot_pos[2]+foot_pos[5])/2;
#local med_vect=f_med-r_med;
#local bug_ang=<bug_ang.x,180+180*atan2(med_vect.x,med_vect.z)/pi,bug_ang.z>;
               
#local bug_eye=<0,0,.5>;
#local bug_head=<0,0,0>;
#local bug_eyelid=<0,0,0>;      //      <close/vulcan/snake>

#local bug_eye=(flight_spline(bug_eye,bug_eye,<.75,.1,.5>,<.75,.1,.5>,6,7,clock) );      // <right,up,iris>
#local bug_head=(flight_spline(bug_head,bug_head,<.1,.5,0>,<.1,.5,0>,6,7,clock) );        // <headup,turn,shake>

#local bug_eye=(flight_spline(bug_eye,bug_eye,<-.65,-.2,.5>,<-.65,-.2,.5>,7,8,clock) );
#local bug_head=(flight_spline(bug_head,bug_head,<-.2,-.5,0>,<-.2,-.5,0>,7,8,clock) );        

#local bug_eye=(flight_spline(bug_eye,bug_eye,<-.2,0,.3>,<-.2,0,.3>,8,9.5,clock) );
#local bug_head=(flight_spline(bug_head,bug_head,<0,-.8,0>,<0,-.8,0>,8,9.5,clock) );        
#local dip=(flight_spline(10,10,15,15,8,9,clock) );

#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.5,1,.5>,<.5,1,.5>,8.5,9.5,clock) );

object { bug_macro(bug_pos+.1*y,<dip,bug_ang.y,0>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 3\n"
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
                           
#local bug_ang=<0,-80,0>;
#local bug_pos=<-1.7,0,-.1>;                           

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local i0=i0+1;
#end

#local m_clock=clock;
#local firing_order=array[6] { 2,4,0,5,1,3 }
#local foot=0;
#local march_time=0;
#while (march_time<8)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,-80,0>,<0,-80,0>,<0,-80,0>,<0,-80,0>,1,9,march_time+.15) );
    #local m_pos=(flight_spline(<-1.7,0,-.1>,<-1.4,0,-.2>,(<-.6,0,-.5>+vrotate(<0,0,.25>,<0,-80,0>)),<-.6,0,-.5>,1,9,march_time+.15) );
  
    #local foot_pos[firing_order[foot]]=(step_to( (<m_pos.x,0,m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>) ),firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.15;   //      step time (.25 sec between lifts)
#end 

#local bug_pos=( foot_pos[0]+
                 foot_pos[1]+
                 foot_pos[2]+
                 foot_pos[3]+
                 foot_pos[4]+
                 foot_pos[5] ) / 6;
#local bug_pos=<bug_pos.x,0,bug_pos.z>;
//#local bug_ang=(flight_spline(<0,0,0>,<0,0,0>,<0,45,0>,<0,45,0>,0,8,m_clock) );
#local f_med=(foot_pos[0]+foot_pos[3])/2;
#local r_med=(foot_pos[2]+foot_pos[5])/2;
#local med_vect=f_med-r_med;
#local bug_ang=<bug_ang.x,180+180*atan2(med_vect.x,med_vect.z)/pi,bug_ang.z>;
               
#local bug_eye=<0,0,.5>;
#local bug_head=<0,0,0>;
#local bug_eyelid=<0,0,0>;      //      <close/vulcan/snake>

#local bug_head=(flight_spline(bug_head,bug_head,<-.2,.4,0>,<-.2,.4,0>,8,9,clock) );        
#local dip=(flight_spline(10,10,25,25,8,9,clock) );
#local rise=(flight_spline(0,0,.01,.01,8,9,clock) );

#local bug_eye=(flight_spline(bug_eye,bug_eye,<.5,-.1,.3>,<.5,-.1,.3>,8.5,10,clock) );
#local bug_eyelid=(flight_spline(bug_eyelid,bug_eyelid,<.2,1,.5>,<.5,1,.5>,8.5,10,clock) ); 

#local foot_pos[3]=( flight_spline(foot_pos[3],foot_pos[3],foot_pos[3]+<.01,.21,-.01>,foot_pos[3]+<.14,.18,-.09>,9.25,10,clock) );

object { bug_macro(bug_pos+(rise+.1)*y,<dip,bug_ang.y,0>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------






#include "dead_bug.inc"

object { brother_quark_deceased
  rotate <0,70,0>
  translate <.66,.0,-.64>
}







#render concat("frame=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")
