// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#include "colors.inc"
#include "shapes.inc"

//#declare tron=on;

#declare bald=1;
#if (clock<3)
  #declare bald=0;
#end
#declare bald=1;        //      dimples - 0=slow, 1=quick, 2=transparent
#declare amb_light=0;
global_settings {
  assumed_gamma 1.8
}                  

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end  
   
light_source
{
  0 
  color .9
  translate <0, 1000, -500>
}
light_source
{
  0 
  color .1
  translate <0, 1000, -500>
  shadowless 
}
/*
light_source
{
  0 
  color .9
  translate <-1000, 4000, -500>
}
light_source
{
  0
  color .1  // light's color
  translate <-1000, 4000, -500>
  shadowless
}
*/

#declare NightSky =
    texture {
      pigment { color rgb<0,0,.05> }
      finish { ambient 1 }
    }

#declare Stars =
    texture {
      pigment {
        granite
        poly_wave 2
        color_map {
          [ 0 color rgbf<1,1,1,1> ]
          [ .8 color rgbf<1,1,1,1> ]
          [ .81 color rgbf<1,1,1,0> ]
          [ 1 color rgbf<1,1,1,0> ]
        }
      }
      scale 100
    }

#declare BackDrop =
    texture { NightSky }
    texture { Stars rotate <0,0,-60> scale <2,2,2> }
    texture { Stars rotate <0,0,30> scale <3,2,3> }

object {
    sphere { <0,0,0>,20000 inverse }
    texture {
        BackDrop
        scale 8
        finish {ambient 1 }
    }
    rotate <-5,0,0>
    translate <0,0,0>
    rotate <0,135,0> 
}
/*
sphere { 0,1
  translate <0,-1,0>
  scale 50000
  texture {
    pigment {
      bozo
      scale 50
      color_map {
        [0 color rgb<.55,.5,.5>]
        [1 color rgb<.5,.45,.45>]
      }
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .3
      specular .05
    }
    normal {
      granite
      turbulence .3
      omega .65
      lambda 2
      octaves 6            
      scale 10
    }
  }
}  
*/
#declare LandArea =
  texture {
    pigment {
      agate
      turbulence 1
      lambda 1.5
      omega .8
      octaves 8
      color_map {
        [0.00 color rgb <.5, .25, .15>]
        [0.33 color rgb <.1, .5, .4>]
        [0.86 color rgb <.6, .3, .1>]
        [1.00 color rgb <.5, .25, .15>]
      }
    }
  }

#declare OceanArea =
  texture {
    pigment {
      bozo
      turbulence .5
      lambda 2
      color_map {
        [0.00, 0.33 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
        [0.33, 0.66 color rgbf <1, 1, 1, 1>   color rgbf <1, 1, 1, 1>]
        [0.66, 1.00 color rgb <0, 0, 1>       color rgb <0, 0, 1>]
      }
    }
  }

#declare CloudArea =
  texture {
    pigment {
      granite scale 3
      poly_wave 1.4
      turbulence 1.65
      lambda 2.3
      omega .5
      octaves 7
      
      color_map {
        [0.0 color rgbf <1, 1, 1, 1>]
        [0.05 color rgbf <1, 1, 1, 1>]
        [0.65 color rgbf <1, 1, 1, .2>]
        [2 color rgbf <1, 1, 1, 1>]
      }
    }
    finish {
      ambient .0 diffuse .7
    }
  }


#declare planet =
  union {
    object {
      sphere { <0,0,0>,1 }
/*      texture { LandArea }
      texture { OceanArea }*/
      texture {
        material_map {
          gif "planet.gif"
          map_type 1
          texture { pigment { color rgb<1,1,1> } finish { ambient .0 diffuse .7 } }
          texture { pigment { color rgb<.2,.3,1> } finish { ambient .0 diffuse .7  } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
          texture { pigment { color rgb<0,.5,0> } finish { ambient .0 diffuse .7 } }//normal { wrinkles turbulence 1 } scale <.1,.1,.1> }
        }
      }
      //rotate <0,70,0>
      rotate <0,245,0>  //  -ve = rotate for eastern sunrise
      rotate <-23.5,0,0>
      hollow
      scale <3000,3000,3000>
    }
    object {
      sphere { <0,0,0>,1.01 }
      texture {
        CloudArea
      }
      scale <3010,3010,3010>
    }
    scale .8
    //translate <-600,600,10000>
    translate <825,400,10000>
  }


object { planet no_shadow rotate <0,135,0> }


#if (bald=0)
#declare dimples=
  object {
    union {              
      #declare ri=90.0;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.073;     
      #declare dr=.095;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd)-1);
      #declare r1=rs1/2;
      //#declare r1=0;
      
      #declare ri=83;
      #declare r2=0;
      #declare rs1=0;
      #declare rs2=0;
      #declare dd=.087;     
      #declare dr=.13;
      #declare h=0;
      #declare r=0;
      #declare rs1=(ri*4)/(2*pi*(1+dd/2)/(2*dd));
      #declare r1=rs1/2;
            
      #while (r1<89)
        #declare h=(1+(dr/1.25))*sin(radians(r1));
        #declare r=(1+(dr/1.25))*cos(radians(r1));
        #declare rs2=120/int(2*pi*r/(6*dd));
        #declare r2=-60;
        #while (r2<59)
          sphere { <r,h,0>,dr rotate <0,r2,0> }
          sphere { <r,h,0>,dr rotate <0,r2+120,0> }
          sphere { <r,h,0>,dr rotate <0,r2+240,0> }          
          #if (r1>0)          
            sphere { <r,-h,0>,dr rotate <0,r2,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+120,0> }
            sphere { <r,-h,0>,dr rotate <0,r2+240,0> }
          #end          
          #declare r2=r2+rs2;
       #end
        #declare r1=r1+rs1;
      #end
    }
  }
#else
  #declare dimples=sphere { 0,.1 }
#end

#declare fin_ball=           
  difference {
    sphere { 0,1 }    
    object { dimples } 
  }       

#declare rnd1=seed(123456);
   
    
object { fin_ball         
//  rotate <360*rand(rnd1),360*rand(rnd1),360*rand(rnd1)>
  #if (bald=2)
    texture { pigment { color rgbt<.5,.5,.5,.5> } }
  #else
  texture { 
    pigment { 
      image_map { tga "bal_logo.tga" map_type 1 } 
    }
    finish { 
      ambient .0
      diffuse .9
      roughness .01
      specular .1
    }                       
    rotate <0,-90,0>
  }    
  #end
  rotate <45,0,30>
  rotate <0,90,0> 
  translate <0,.8,0>
  scale .3     
  translate <-1.3,0,1.3>
}



//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------

#include "hf_mesh2.inc"         
object { tga_land_mesh }
sphere { 0,1
  translate <0,-1,0>
  scale 5000
  texture {
    pigment {
        granite
        scale .5
        color_map {
          [0 color rgb<.4,.35,.35>]
          [1 color rgb<.6,.55,.55>]
        }
      }
    finish { 
      ambient .0
      diffuse .9
    }
    normal {
      granite
      turbulence .2
      omega .75
      lambda 2
      octaves 6            
      scale <8,16,8>
    }
  }
}
//object { inc_land_mesh }
/*
union {
#local xp=-8;
#while (xp<8)
  #local yp=-8;
  #while (yp<8)
    sphere { <xp,mesh_height(xp,yp),yp>,.05 }
    #local yp=yp+.25;
  #end
  #local xp=xp+.25;
#end
  texture { 
    pigment { color rgb<1,1,0> }
    finish { ambient 0 diffuse .7 }
  }
}
*/
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------









/*
#include "bug1.inc"

object { bug            
  rotate <0,60,0>
  translate <.9,.25,.45>
}*/
//    5         2
//       \ ^ /
//    4 --| |-- 1
//       / V \
//    3         0
//       front

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//      Bugs:
#include "bug2.inc"
#local foot_def=array[6] { <.26,.0,-.15>,<.29,.0,.0>,<.25,.0,.16>,<-.26,.0,-.15>,<-.29,.0,-.01>,<-.25,.0,.16> }
#macro step_to(tgt_pos,dr_leg_num,lift_time,l_clock)
  flight_spline(foot_pos[dr_leg_num],<foot_pos[dr_leg_num].x,foot_pos[dr_leg_num].y+.01,foot_pos[dr_leg_num].z>,<tgt_pos.x,tgt_pos.y+.05,tgt_pos.z>,tgt_pos,lift_time,lift_time+.18,l_clock) // +.18 secs for step duration
#end
//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#render "bug 1\n"
#local foot_pos=array[6] { <0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0> }
                           
#local bug_ang=<0,-55,0>;
#local bug_pos=<.8,0,1.5>;                           

#local i0=0;
#while (i0<6)
  #local foot_pos[i0]=vrotate(foot_def[i0],bug_ang)+<bug_pos.x,0,bug_pos.z>;
  #local foot_pos[i0]=<foot_pos[i0].x,mesh_height(foot_pos[i0].x,foot_pos[i0].z),foot_pos[i0].z>; 
  #local i0=i0+1;
#end

#local m_clock=clock;
#local firing_order=array[6] { 2,4,0,5,1,3 }
#local foot=0;
#local march_time=0;
#while (march_time<16)
  #if (march_time<=m_clock+.15)
    #local m_angle=(flight_spline(<0,-55,0>,<0,50,0>,<0,20,0>,<0,-50,0>,0,14,march_time+.1) );
    #local m_pos=(flight_spline(<.8,0,1.5>,<2,0,.1>,<-.5,2,-1.2>,<1.5,0,-2.5>,0,14,march_time+.1) );

#ifdef(tron)
object {
cone { 0,.05,-.1*z,.02 rotate <0,m_angle.y,0> }
scale .3
translate <m_pos.x,mesh_height(m_pos.x,m_pos.z)+.1,m_pos.z>
texture { pigment { color rgb<1,1,0> } finish { ambient .1 diffuse .7 } }
//#local march_time=march_time+.3;
}
#end

    #local tgt_pos=(<m_pos.x,mesh_height(m_pos.x,m_pos.y),m_pos.z>+vrotate(foot_def[firing_order[foot]],<0,m_angle.y,0>));
    #local foot_pos[firing_order[foot]]=(step_to( <tgt_pos.x,mesh_height(tgt_pos.x,tgt_pos.z),tgt_pos.z>,firing_order[foot],march_time,m_clock) );
    #local foot=foot+1;
  #end
  #if (foot>5)
    #local foot=0;
  #end
  #local march_time=march_time+.1;   //      step time (.1 sec between lifts)
#end 

#local bug_pos=( foot_pos[0]+
                 foot_pos[1]+
                 foot_pos[2]+
                 foot_pos[3]+
                 foot_pos[4]+
                 foot_pos[5] ) / 6;

#local f_med=(foot_pos[0]+foot_pos[3])/2;
#local r_med=(foot_pos[2]+foot_pos[5])/2;
#local med_vect=f_med-r_med;
#local r_med=( foot_pos[0]+foot_pos[1]+foot_pos[2] ) /3;
#local l_med=( foot_pos[3]+foot_pos[4]+foot_pos[5] ) /3;
#local tilt_vect=r_med-l_med;
#local bug_rtilt=atan2(tilt_vect.y,vlength(tilt_vect))*180/pi;
#local bug_heading=(180+180*atan2(med_vect.x,med_vect.z)/pi);
#local bug_inclination=atan2(med_vect.y,vlength(med_vect))*130/pi;
#local bug_ang=<bug_ang.x+bug_inclination,bug_heading,bug_ang.z+bug_rtilt>;
               
#local bug_eye=<0,0,.5>;        //      <1/3 down tilt,1/2 right,iris>
#local bug_head=<(-bug_inclination)/60,0,0>;        //      <1/3 up,1/2 right,1/2 twist lower left>
#local bug_eyelid=<0,0,0>;      //      <close,vulcan,snake>

object { bug_macro(bug_pos+.12*y,<bug_ang.x,bug_ang.y,bug_ang.z>,clock,foot_pos,bug_eye,bug_eyelid,bug_head) }//rotate <0,0,-90> translate <0,.2,0> }

//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------



#render concat("\nframe=",str(clock*25,-4,0),"\n")
#render concat("clock=",str(clock,0,3),"\n")
         



#declare cam_loc=<-3,.75,-3.5>;
#declare cam_tgt=<0,.35,1>;

//#declare cam_loc=<0,7,-.5>;
//#declare cam_tgt=<0,.35,-.49>;
                                
//#declare cam_loc=<-3,1,-2.5>;
//#declare cam_tgt=<45,.35,-45>;
                                
camera
{           
  location cam_loc
  direction <0,0,1.1>
  up <0,1,0>
  right <4/3,0,0> 
  look_at cam_tgt
  
  rotate <0,-0,0>

}

#declare fade=(flight_spline(0,0,1,1,0,.5,clock));
#if (fade<1)
  sphere { 0,.1
    texture {
      pigment {
        color rgbt<0,0,0,fade>
      }
      finish {
        ambient 0
        diffuse 0
      }
    }
    translate cam_loc
    hollow
  }
#end