// Copyright (c) Duncan Gray 12.10.2000
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself !
//
#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     


camera {
  location <0,0,-15>
  direction <0,0,1>
  orthographic
  up<0,20,0>
  right <20,0,0>
  look_at <0,0,0>
}
#declare t1=(flight_spline(0,0,1,1,0,1,clock));
#declare t2=(flight_spline(1,1,0,0,0,1,clock));
//plane { -z,0 texture { pigment { color rgb<1,1,1> } finish { ambient 1 diffuse 0 } } }
box { <0,0,0>,<1,1,.01>
  texture {
    pigment {
      image_map {
        gif "movein12.gif"
        transmit all t1
        map_type 0
        once
      }     
    }
    finish { ambient 1 diffuse 0 }
  }
  translate <-.5,-.5,0>
  scale <20,20,20>
  translate <0,0,-.1>
}
box { <0,0,0>,<1,1,.01>
  texture {
    pigment {
      image_map {
        gif "movein37.gif"
        transmit all t2
        map_type 0
        once        
      }     
    }
    finish { ambient 1 diffuse 0 }
  }
  translate <-.5,-.5,0>
  scale <20,20,20>
  translate <0,0,-.2>
}