#version unofficial MegaPov 0.5;
#declare BreadRim=
spline {
cubic_spline 
0,  < 4,0,-5>, // point#5 ... MUST MATCH THIS POINT
1/8,< 4,0, 5>, // point#2  ... THIS POINT ... 
2/8,< 1,0, 5>, // point#3 
3/8,<-4,0, 5>, // point#3     
4/8,<-4,0,-5>, // point#3      
5/8,< 1,0,-5>, // point#3
6/8,< 4,0,-5>, // point#4   
7/8,< 4.5,0,3.5>, // point#5 ... MUST MATCH THIS POINT  
1,  < 4,0,5>, // point#5 ... MUST MATCH THIS POINT  
}

#declare SliceofWhite =
union {  
//difference {
prism {
cubic_spline
0, // sweep the following shape from here ...
.4, // ... up through here
9, // the number of points making up the shape ...
< 4, -5>, // point#1 (control point... not on curve)
< 4,  5>, // point#2  ... THIS POINT ... 
<1,  5>, // point#3 
<-4,  5>, // point#3     
<-4,  -5>, // point#3      
<1,  -5>, // point#3
< 4, -5>, // point#4
< 4,  5>, // point#5 ... MUST MATCH THIS POINT
<-2,  0>  // point#6 (control point... not on curve)
}
//box {<-10,.4,-10>,<10,1.1,10>}
//}

blob {
threshold .1
#declare C=0
#while (C<400)
sphere {0,.25,1 scale <2,.9,2>  translate BreadRim((C/400)*7/8+1/8)+y*.2}
#declare C=C+1
#end 
}

texture {
pigment {slope y 
pigment_map {
[0 granite color_map {[0 rgb <1,.9,.8>][1 rgb (<1,.9,.8>+<.4,.25,.1>)/2*.75]} scale 2] 
[.125 rgb <.4,.25,.1>*1.5]
[.875 rgb <.4,.25,.1>*1.5]
[1 granite color_map {[0 rgb <1,.9,.8>][1 rgb (<1,.9,.8>+<.4,.25,.1>)/2*.75]} scale 2] 
} 
}
normal {wrinkles bump_size 4 scale 8*z scale 8*x scale 1/15}
finish {ambient .25 diffuse 0}   
} 
texture {
pigment {
slope <1/2,-1/8,-1> 
color_map {
[.25 rgb <1,.9,.8> filter .625]
[.3  rgb <1,.9,.8> filter .75]
[.5  rgb <1,.9,.8> filter .75]      
[.55 rgb <1,.9,.8> filter .875]       
[.75 rgb <1,.9,.8> filter .875]
[.8  rgb <1,.9,.8> filter 1]
}  
}
finish {ambient 1.25 diffuse 0 brilliance 0}     
}




scale y*4
}
union {
object {SliceofWhite}
object {SliceofWhite rotate <0,10,0> translate y*2}
#declare Frogleg = 
blob {threshold .1
sphere {0,1,1 scale <1.5,1,5>}  
sphere {0,1,1 scale <1,1,5> rotate 10*y}  
sphere {0,1,1 scale <1,1,5> rotate 10*y translate -.5*x}  
sphere {0,1,1 scale <1,.75,4> translate 6*z}  

sphere {0,1,1/2 scale <.25,.25,2> translate 2*z rotate 45*y translate 8.25*z}
sphere {0,1,1/2 scale <.25,.25,3> translate 3*z rotate 15*y translate 8.25*z}
sphere {0,1,1/2 scale <.25,.25,3> translate 3*z rotate -15*y translate 8.25*z}
sphere {0,1,1/2 scale <.25,.25,2> translate 2*z rotate -45*y translate 8.25*z}  

sphere {0,1.1,1/4 scale <.3,.25,2> translate 2*z rotate 45*y translate 8.25*z}
sphere {0,1.1,1/4 scale <.3,.25,3> translate 3*z rotate 15*y translate 8.25*z}
sphere {0,1.1,1/4 scale <.3,.25,3> translate 3*z rotate -15*y translate 8.25*z}
sphere {0,1.1,1/4 scale <.3,.25,2> translate 2*z rotate -45*y translate 8.25*z}
               
sphere {0,1.2,1/4 scale <.5,.25,2> translate 2*z rotate 45*y translate 8.25*z}
sphere {0,1.2,1/4 scale <.5,.25,3> translate 3*z rotate 15*y translate 8.25*z}
sphere {0,1.2,1/4 scale <.5,.25,3> translate 3*z rotate -15*y translate 8.25*z}
sphere {0,1.2,1/4 scale <.5,.25,2> translate 2*z rotate -45*y translate 8.25*z}

sphere {0,1,1/10 scale <5,.05,5> translate 11*z 
pigment {rgb <.6,.75,.25>/4}
finish {ambient .5 diffuse 0 phong 0}
}
sphere {0,1,1/20 scale <4,.05,4> translate 11*z 
pigment {rgb <.6,.75,.25>/4} 
finish {ambient .5 diffuse 0 phong 0}
}       
sphere {0,1,1/20 scale <3,.05,3> translate 11*z
pigment {rgb <.6,.75,.25>/4}
finish {ambient .5 diffuse 0 phong 0}
}
texture {pigment {rgb <.5,.75,.25>*.75} finish {ambient .5 diffuse 0}}      
texture {
pigment {
slope <1/2,-1/8,-1> 
color_map {
[.25 rgb <.5,.75,.25> filter .625]
[.3  rgb <.5,.75,.25> filter .75]
[.5  rgb <.5,.75,.25> filter .75]      
[.55 rgb <.5,.75,.25> filter .875]       
[.75 rgb <.5,.75,.25> filter .875]
[.8  rgb <.5,.75,.25> filter 1]
}  
}
finish {ambient 1.25 diffuse 0 brilliance 0}     
}
}     

#declare Frogarm = 
blob {threshold .1
sphere {0,1,1 scale <1.5,1,5>}  
sphere {0,1,1 scale <1,1,5> rotate 10*y}  
sphere {0,1,1 scale <1,1,5> rotate 10*y translate -.5*x}  
sphere {0,1,1 scale <1,.75,4> translate 6*z}  

sphere {0,1,1/2 scale <.25,.25,2> translate 2*z rotate 45*y translate 8.25*z}
sphere {0,1,1/2 scale <.25,.25,3> translate 3*z rotate 15*y translate 8.25*z}
sphere {0,1,1/2 scale <.25,.25,3> translate 3*z rotate -15*y translate 8.25*z}
sphere {0,1,1/2 scale <.25,.25,2> translate 2*z rotate -45*y translate 8.25*z}  

sphere {0,1.1,1/4 scale <.3,.25,2> translate 2*z rotate 45*y translate 8.25*z}
sphere {0,1.1,1/4 scale <.3,.25,3> translate 3*z rotate 15*y translate 8.25*z}
sphere {0,1.1,1/4 scale <.3,.25,3> translate 3*z rotate -15*y translate 8.25*z}
sphere {0,1.1,1/4 scale <.3,.25,2> translate 2*z rotate -45*y translate 8.25*z}
               
sphere {0,1.2,1/4 scale <.5,.25,2> translate 2*z rotate 45*y translate 8.25*z}
sphere {0,1.2,1/4 scale <.5,.25,3> translate 3*z rotate 15*y translate 8.25*z}
sphere {0,1.2,1/4 scale <.5,.25,3> translate 3*z rotate -15*y translate 8.25*z}
sphere {0,1.2,1/4 scale <.5,.25,2> translate 2*z rotate -45*y translate 8.25*z}

texture {pigment {rgb <.5,.75,.25>*.75} finish {ambient .25 diffuse 0}}      
texture {
pigment {
slope <1/2,-1/8,-1> 
color_map {
[.25 rgb <.5,.75,.25> filter .625]
[.3  rgb <.5,.75,.25> filter .75]
[.5  rgb <.5,.75,.25> filter .75]      
[.55 rgb <.5,.75,.25> filter .875]       
[.75 rgb <.5,.75,.25> filter .875]
[.8  rgb <.5,.75,.25> filter 1]
}  
}
finish {ambient 1.25 diffuse 0 brilliance 0}     
}


}  
union {Frogleg scale .625 rotate 10*x rotate 20*y translate <.5,2,4.5>}
union {Frogleg scale .625 rotate 10*x rotate -20*y translate <-.5,2,4.5>} 
union {Frogarm scale .5   rotate 10*x rotate -120*y translate <-2.5,2,0>}
union {Frogarm scale .5   rotate 10*x rotate 120*y translate <2.5,2,0>}   
scale 1/3
}


union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<2.250, 0.000, 0.000> <2.250, 0.000, -0.955> <0.955, 0.000, -2.250> <0.000, 0.000, -2.250> 
		<2.066, -0.037, 0.000> <2.066, -0.037, -0.955> <0.955, -0.037, -2.066> <0.000, -0.037, -2.066> 
		<1.811, 0.027, 0.000> <1.811, 0.027, -0.689> <0.689, 0.027, -1.811> <0.000, 0.027, -1.811> 
		<1.625, 0.000, 0.000> <1.625, 0.000, -0.689> <0.689, 0.000, -1.625> <0.000, 0.000, -1.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<2.250, 0.000, 0.000> <2.066, -0.037, 0.000> <1.811, 0.027, 0.000> <1.625, 0.000, 0.000> 
		<2.250, 0.000, 0.955> <2.066, -0.037, 0.955> <1.811, 0.027, 0.689> <1.625, 0.000, 0.689> 
		<0.955, 0.000, 2.250> <0.955, -0.037, 2.066> <0.689, 0.027, 1.811> <0.689, 0.000, 1.625> 
		<-0.000, 0.000, 2.250> <-0.000, -0.037, 2.066> <-0.000, 0.027, 1.811> <-0.000, 0.000, 1.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<2.250, 0.000, 0.000> <2.287, 0.007, 0.000> <2.287, 0.119, 0.000> <2.250, 0.125, 0.000> 
		<2.250, 0.000, -0.955> <2.287, 0.007, -0.955> <2.287, 0.119, -0.955> <2.250, 0.125, -0.955> 
		<0.955, 0.000, -2.250> <0.955, 0.007, -2.287> <0.955, 0.119, -2.287> <0.955, 0.125, -2.250> 
		<0.000, 0.000, -2.250> <0.000, 0.007, -2.287> <0.000, 0.119, -2.287> <0.000, 0.125, -2.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<2.250, 0.000, 0.000> <2.250, 0.000, 0.955> <0.955, 0.000, 2.250> <-0.000, 0.000, 2.250> 
		<2.287, 0.007, 0.000> <2.287, 0.007, 0.955> <0.955, 0.007, 2.287> <-0.000, 0.007, 2.287> 
		<2.287, 0.119, 0.000> <2.287, 0.119, 0.955> <0.955, 0.119, 2.287> <-0.000, 0.119, 2.287> 
		<2.250, 0.125, 0.000> <2.250, 0.125, 0.955> <0.955, 0.125, 2.250> <-0.000, 0.125, 2.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.250, 0.000, 0.000> <1.250, 0.000, -0.530> <0.530, 0.000, -1.250> <0.000, 0.000, -1.250> 
		<1.264, 0.001, 0.000> <1.264, 0.001, -0.530> <0.530, 0.001, -1.264> <0.000, 0.001, -1.264> 
		<1.482, 0.123, 0.000> <1.482, 0.123, -0.636> <0.636, 0.123, -1.482> <0.000, 0.123, -1.482> 
		<1.500, 0.125, 0.000> <1.500, 0.125, -0.636> <0.636, 0.125, -1.500> <0.000, 0.125, -1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.250, 0.000, 0.000> <1.264, 0.001, 0.000> <1.482, 0.123, 0.000> <1.500, 0.125, 0.000> 
		<1.250, 0.000, 0.530> <1.264, 0.001, 0.530> <1.482, 0.123, 0.636> <1.500, 0.125, 0.636> 
		<0.530, 0.000, 1.250> <0.530, 0.001, 1.264> <0.636, 0.123, 1.482> <0.636, 0.125, 1.500> 
		<-0.000, 0.000, 1.250> <-0.000, 0.001, 1.264> <-0.000, 0.123, 1.482> <-0.000, 0.125, 1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.250, 0.000, 0.000> <1.186, -0.005, 0.000> <0.375, 0.000, 0.000> <0.000, 0.000, 0.000> 
		<1.250, 0.000, -0.530> <1.186, -0.005, -0.530> <0.375, 0.000, 0.000> <0.000, 0.000, 0.000> 
		<0.530, 0.000, -1.250> <0.530, -0.005, -1.186> <0.000, 0.000, -0.375> <0.000, 0.000, 0.000> 
		<0.000, 0.000, -1.250> <0.000, -0.005, -1.186> <0.000, 0.000, -0.375> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.250, 0.000, 0.000> <1.250, 0.000, 0.530> <0.530, 0.000, 1.250> <-0.000, 0.000, 1.250> 
		<1.186, -0.005, 0.000> <1.186, -0.005, 0.530> <0.530, -0.005, 1.186> <-0.000, -0.005, 1.186> 
		<0.375, 0.000, 0.000> <0.375, 0.000, 0.000> <-0.000, 0.000, 0.375> <-0.000, 0.000, 0.375> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<2.250, 0.125, 0.000> <2.028, 0.162, 0.000> <1.547, 0.131, 0.000> <1.500, 0.125, 0.000> 
		<2.250, 0.125, -0.955> <2.028, 0.162, -0.955> <1.547, 0.131, -0.636> <1.500, 0.125, -0.636> 
		<0.955, 0.125, -2.250> <0.955, 0.162, -2.028> <0.636, 0.131, -1.547> <0.636, 0.125, -1.500> 
		<0.000, 0.125, -2.250> <0.000, 0.162, -2.028> <0.000, 0.131, -1.547> <0.000, 0.125, -1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<2.250, 0.125, 0.000> <2.250, 0.125, 0.955> <0.955, 0.125, 2.250> <-0.000, 0.125, 2.250> 
		<2.028, 0.162, 0.000> <2.028, 0.162, 0.955> <0.955, 0.162, 2.028> <-0.000, 0.162, 2.028> 
		<1.547, 0.131, 0.000> <1.547, 0.131, 0.636> <0.636, 0.131, 1.547> <-0.000, 0.131, 1.547> 
		<1.500, 0.125, 0.000> <1.500, 0.125, 0.636> <0.636, 0.125, 1.500> <-0.000, 0.125, 1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.625, 0.000, 0.000> <1.625, 0.000, -0.689> <0.689, 0.000, -1.625> <0.000, 0.000, -1.625> 
		<1.542, -0.012, 0.000> <1.542, -0.012, -0.689> <0.689, -0.012, -1.542> <0.000, -0.012, -1.542> 
		<1.459, -0.119, 0.000> <1.459, -0.119, -0.583> <0.583, -0.119, -1.459> <0.000, -0.119, -1.459> 
		<1.375, -0.125, 0.000> <1.375, -0.125, -0.583> <0.583, -0.125, -1.375> <0.000, -0.125, -1.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.625, 0.000, 0.000> <1.542, -0.012, 0.000> <1.459, -0.119, 0.000> <1.375, -0.125, 0.000> 
		<1.625, 0.000, 0.689> <1.542, -0.012, 0.689> <1.459, -0.119, 0.583> <1.375, -0.125, 0.583> 
		<0.689, 0.000, 1.625> <0.689, -0.012, 1.542> <0.583, -0.119, 1.459> <0.583, -0.125, 1.375> 
		<-0.000, 0.000, 1.625> <-0.000, -0.012, 1.542> <-0.000, -0.119, 1.459> <-0.000, -0.125, 1.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.375, -0.125, 0.000> <1.375, -0.125, -0.583> <0.583, -0.125, -1.375> <0.000, -0.125, -1.375> 
		<0.964, -0.157, 0.000> <0.964, -0.157, -0.583> <0.583, -0.157, -0.964> <0.000, -0.157, -0.964> 
		<0.413, -0.125, 0.000> <0.413, -0.125, 0.000> <0.000, -0.125, -0.413> <0.000, -0.125, -0.413> 
		<0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<1.375, -0.125, 0.000> <0.964, -0.157, 0.000> <0.413, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<1.375, -0.125, 0.583> <0.964, -0.157, 0.583> <0.413, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<0.583, -0.125, 1.375> <0.583, -0.157, 0.964> <-0.000, -0.125, 0.413> <0.000, -0.125, 0.000> 
		<-0.000, -0.125, 1.375> <-0.000, -0.157, 0.964> <-0.000, -0.125, 0.413> <0.000, -0.125, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<-0.000, -0.125, 0.413> <-0.000, -0.125, 0.413> <-0.413, -0.125, -0.000> <-0.413, -0.125, -0.000> 
		<-0.000, -0.157, 0.964> <-0.583, -0.157, 0.964> <-0.964, -0.157, 0.583> <-0.964, -0.157, -0.000> 
		<-0.000, -0.125, 1.375> <-0.583, -0.125, 1.375> <-1.375, -0.125, 0.583> <-1.375, -0.125, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<-0.413, -0.125, -0.000> <-0.413, -0.125, -0.000> <0.000, -0.125, -0.413> <0.000, -0.125, -0.413> 
		<-0.964, -0.157, -0.000> <-0.964, -0.157, -0.583> <-0.583, -0.157, -0.964> <0.000, -0.157, -0.964> 
		<-1.375, -0.125, -0.000> <-1.375, -0.125, -0.583> <-0.583, -0.125, -1.375> <0.000, -0.125, -1.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, -0.125, 1.375> <-0.583, -0.125, 1.375> <-1.375, -0.125, 0.583> <-1.375, -0.125, -0.000> 
		<-0.000, -0.119, 1.459> <-0.583, -0.119, 1.459> <-1.459, -0.119, 0.583> <-1.459, -0.119, -0.000> 
		<-0.000, -0.012, 1.542> <-0.689, -0.012, 1.542> <-1.542, -0.012, 0.689> <-1.542, -0.012, -0.000> 
		<-0.000, 0.000, 1.625> <-0.689, 0.000, 1.625> <-1.625, 0.000, 0.689> <-1.625, 0.000, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-1.375, -0.125, -0.000> <-1.375, -0.125, -0.583> <-0.583, -0.125, -1.375> <0.000, -0.125, -1.375> 
		<-1.459, -0.119, -0.000> <-1.459, -0.119, -0.583> <-0.583, -0.119, -1.459> <0.000, -0.119, -1.459> 
		<-1.542, -0.012, -0.000> <-1.542, -0.012, -0.689> <-0.689, -0.012, -1.542> <0.000, -0.012, -1.542> 
		<-1.625, 0.000, -0.000> <-1.625, 0.000, -0.689> <-0.689, 0.000, -1.625> <0.000, 0.000, -1.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 0.000, 1.625> <-0.689, 0.000, 1.625> <-1.625, 0.000, 0.689> <-1.625, 0.000, -0.000> 
		<-0.000, 0.027, 1.811> <-0.689, 0.027, 1.811> <-1.811, 0.027, 0.689> <-1.811, 0.027, -0.000> 
		<-0.000, -0.037, 2.066> <-0.955, -0.037, 2.066> <-2.066, -0.037, 0.955> <-2.066, -0.037, -0.000> 
		<-0.000, 0.000, 2.250> <-0.955, 0.000, 2.250> <-2.250, 0.000, 0.955> <-2.250, 0.000, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-1.625, 0.000, -0.000> <-1.625, 0.000, -0.689> <-0.689, 0.000, -1.625> <0.000, 0.000, -1.625> 
		<-1.811, 0.027, -0.000> <-1.811, 0.027, -0.689> <-0.689, 0.027, -1.811> <0.000, 0.027, -1.811> 
		<-2.066, -0.037, -0.000> <-2.066, -0.037, -0.955> <-0.955, -0.037, -2.066> <0.000, -0.037, -2.066> 
		<-2.250, 0.000, -0.000> <-2.250, 0.000, -0.955> <-0.955, 0.000, -2.250> <0.000, 0.000, -2.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 0.000, 2.250> <-0.955, 0.000, 2.250> <-2.250, 0.000, 0.955> <-2.250, 0.000, -0.000> 
		<-0.000, 0.007, 2.287> <-0.955, 0.007, 2.287> <-2.287, 0.007, 0.955> <-2.287, 0.007, -0.000> 
		<-0.000, 0.119, 2.287> <-0.955, 0.119, 2.287> <-2.287, 0.119, 0.955> <-2.287, 0.119, -0.000> 
		<-0.000, 0.125, 2.250> <-0.955, 0.125, 2.250> <-2.250, 0.125, 0.955> <-2.250, 0.125, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-2.250, 0.000, -0.000> <-2.250, 0.000, -0.955> <-0.955, 0.000, -2.250> <0.000, 0.000, -2.250> 
		<-2.287, 0.007, -0.000> <-2.287, 0.007, -0.955> <-0.955, 0.007, -2.287> <0.000, 0.007, -2.287> 
		<-2.287, 0.119, -0.000> <-2.287, 0.119, -0.955> <-0.955, 0.119, -2.287> <0.000, 0.119, -2.287> 
		<-2.250, 0.125, -0.000> <-2.250, 0.125, -0.955> <-0.955, 0.125, -2.250> <0.000, 0.125, -2.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 0.125, 2.250> <-0.955, 0.125, 2.250> <-2.250, 0.125, 0.955> <-2.250, 0.125, -0.000> 
		<-0.000, 0.162, 2.028> <-0.955, 0.162, 2.028> <-2.028, 0.162, 0.955> <-2.028, 0.162, -0.000> 
		<-0.000, 0.131, 1.547> <-0.636, 0.131, 1.547> <-1.547, 0.131, 0.636> <-1.547, 0.131, -0.000> 
		<-0.000, 0.125, 1.500> <-0.636, 0.125, 1.500> <-1.500, 0.125, 0.636> <-1.500, 0.125, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-2.250, 0.125, -0.000> <-2.250, 0.125, -0.955> <-0.955, 0.125, -2.250> <0.000, 0.125, -2.250> 
		<-2.028, 0.162, -0.000> <-2.028, 0.162, -0.955> <-0.955, 0.162, -2.028> <0.000, 0.162, -2.028> 
		<-1.547, 0.131, -0.000> <-1.547, 0.131, -0.636> <-0.636, 0.131, -1.547> <0.000, 0.131, -1.547> 
		<-1.500, 0.125, -0.000> <-1.500, 0.125, -0.636> <-0.636, 0.125, -1.500> <0.000, 0.125, -1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 0.125, 1.500> <-0.636, 0.125, 1.500> <-1.500, 0.125, 0.636> <-1.500, 0.125, -0.000> 
		<-0.000, 0.123, 1.482> <-0.636, 0.123, 1.482> <-1.482, 0.123, 0.636> <-1.482, 0.123, -0.000> 
		<-0.000, 0.001, 1.264> <-0.530, 0.001, 1.264> <-1.264, 0.001, 0.530> <-1.264, 0.001, -0.000> 
		<-0.000, 0.000, 1.250> <-0.530, 0.000, 1.250> <-1.250, 0.000, 0.530> <-1.250, 0.000, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-1.500, 0.125, -0.000> <-1.500, 0.125, -0.636> <-0.636, 0.125, -1.500> <0.000, 0.125, -1.500> 
		<-1.482, 0.123, -0.000> <-1.482, 0.123, -0.636> <-0.636, 0.123, -1.482> <0.000, 0.123, -1.482> 
		<-1.264, 0.001, -0.000> <-1.264, 0.001, -0.530> <-0.530, 0.001, -1.264> <0.000, 0.001, -1.264> 
		<-1.250, 0.000, -0.000> <-1.250, 0.000, -0.530> <-0.530, 0.000, -1.250> <0.000, 0.000, -1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 0.000, 1.250> <-0.530, 0.000, 1.250> <-1.250, 0.000, 0.530> <-1.250, 0.000, -0.000> 
		<-0.000, -0.005, 1.186> <-0.530, -0.005, 1.186> <-1.186, -0.005, 0.530> <-1.186, -0.005, -0.000> 
		<-0.000, 0.000, 0.375> <-0.000, 0.000, 0.375> <-0.375, 0.000, -0.000> <-0.375, 0.000, -0.000> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-1.250, 0.000, -0.000> <-1.250, 0.000, -0.530> <-0.530, 0.000, -1.250> <0.000, 0.000, -1.250> 
		<-1.186, -0.005, -0.000> <-1.186, -0.005, -0.530> <-0.530, -0.005, -1.186> <0.000, -0.005, -1.186> 
		<-0.375, 0.000, -0.000> <-0.375, 0.000, -0.000> <0.000, 0.000, -0.375> <0.000, 0.000, -0.375> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
texture {pigment {rgb <.75,.875,1>} finish {ambient .125 diffuse 0}}      
texture {
pigment {
slope <1/2,-1/2,-1> 
color_map {
[.25 rgb <.75,.875,1> filter .625]
[.3  rgb <.75,.875,1> filter .75]
[.5  rgb <.75,.875,1> filter .75]      
[.55 rgb <.75,.875,1> filter .875]       
[.75 rgb <.75,.875,1> filter .875]
[.8  rgb <.75,.875,1> filter 1]
}  
}
finish {ambient 1.25 diffuse 0 brilliance 0}     
}
scale 1.5
translate .05*y
}

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.912, 2.319, 0.000> <0.912, 2.319, -0.387> <0.387, 2.319, -0.912> <0.000, 2.319, -0.912> 
		<0.907, 2.307, 0.000> <0.907, 2.307, -0.387> <0.387, 2.307, -0.907> <0.000, 2.307, -0.907> 
		<0.877, 2.307, 0.000> <0.877, 2.307, -0.371> <0.371, 2.307, -0.877> <0.000, 2.307, -0.877> 
		<0.875, 2.294, 0.000> <0.875, 2.294, -0.371> <0.371, 2.294, -0.875> <0.000, 2.294, -0.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.912, 2.319, 0.000> <0.907, 2.307, 0.000> <0.877, 2.307, 0.000> <0.875, 2.294, 0.000> 
		<0.912, 2.319, 0.387> <0.907, 2.307, 0.387> <0.877, 2.307, 0.371> <0.875, 2.294, 0.371> 
		<0.387, 2.319, 0.912> <0.387, 2.307, 0.907> <0.371, 2.307, 0.877> <0.371, 2.294, 0.875> 
		<-0.000, 2.319, 0.912> <-0.000, 2.307, 0.907> <-0.000, 2.307, 0.877> <-0.000, 2.294, 0.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.912, 2.319, 0.000> <0.919, 2.334, 0.000> <0.927, 2.367, 0.000> <0.912, 2.375, 0.000> 
		<0.912, 2.319, -0.387> <0.919, 2.334, -0.387> <0.927, 2.367, -0.387> <0.912, 2.375, -0.387> 
		<0.387, 2.319, -0.912> <0.387, 2.334, -0.919> <0.387, 2.367, -0.927> <0.387, 2.375, -0.912> 
		<0.000, 2.319, -0.912> <0.000, 2.334, -0.919> <0.000, 2.367, -0.927> <0.000, 2.375, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.912, 2.319, 0.000> <0.912, 2.319, 0.387> <0.387, 2.319, 0.912> <-0.000, 2.319, 0.912> 
		<0.919, 2.334, 0.000> <0.919, 2.334, 0.387> <0.387, 2.334, 0.919> <-0.000, 2.334, 0.919> 
		<0.927, 2.367, 0.000> <0.927, 2.367, 0.387> <0.387, 2.367, 0.927> <-0.000, 2.367, 0.927> 
		<0.912, 2.375, 0.000> <0.912, 2.375, 0.387> <0.387, 2.375, 0.912> <-0.000, 2.375, 0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.500, 0.000, 0.000> <0.500, 0.000, -0.212> <0.212, 0.000, -0.500> <0.000, 0.000, -0.500> 
		<0.539, 0.116, 0.000> <0.539, 0.116, -0.212> <0.212, 0.116, -0.539> <0.000, 0.116, -0.539> 
		<0.677, 1.667, 0.000> <0.677, 1.667, -0.339> <0.339, 1.667, -0.677> <0.000, 1.667, -0.677> 
		<0.800, 2.375, 0.000> <0.800, 2.375, -0.339> <0.339, 2.375, -0.800> <0.000, 2.375, -0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.500, 0.000, 0.000> <0.539, 0.116, 0.000> <0.677, 1.667, 0.000> <0.800, 2.375, 0.000> 
		<0.500, 0.000, 0.212> <0.539, 0.116, 0.212> <0.677, 1.667, 0.339> <0.800, 2.375, 0.339> 
		<0.212, 0.000, 0.500> <0.212, 0.116, 0.539> <0.339, 1.667, 0.677> <0.339, 2.375, 0.800> 
		<-0.000, 0.000, 0.500> <-0.000, 0.116, 0.539> <-0.000, 1.667, 0.677> <-0.000, 2.375, 0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.500, 0.000, 0.000> <0.492, -0.024, 0.000> <0.150, 0.000, 0.000> <0.000, 0.000, 0.000> 
		<0.500, 0.000, -0.212> <0.492, -0.024, -0.212> <0.150, 0.000, 0.000> <0.000, 0.000, 0.000> 
		<0.212, 0.000, -0.500> <0.212, -0.024, -0.492> <0.000, 0.000, -0.150> <0.000, 0.000, 0.000> 
		<0.000, 0.000, -0.500> <0.000, -0.024, -0.492> <0.000, 0.000, -0.150> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.500, 0.000, 0.000> <0.500, 0.000, 0.212> <0.212, 0.000, 0.500> <-0.000, 0.000, 0.500> 
		<0.492, -0.024, 0.000> <0.492, -0.024, 0.212> <0.212, -0.024, 0.492> <-0.000, -0.024, 0.492> 
		<0.150, 0.000, 0.000> <0.150, 0.000, 0.000> <-0.000, 0.000, 0.150> <-0.000, 0.000, 0.150> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.912, 2.375, 0.000> <0.882, 2.390, 0.000> <0.806, 2.408, 0.000> <0.800, 2.375, 0.000> 
		<0.912, 2.375, -0.387> <0.882, 2.390, -0.387> <0.806, 2.408, -0.339> <0.800, 2.375, -0.339> 
		<0.387, 2.375, -0.912> <0.387, 2.390, -0.882> <0.339, 2.408, -0.806> <0.339, 2.375, -0.800> 
		<0.000, 2.375, -0.912> <0.000, 2.390, -0.882> <0.000, 2.408, -0.806> <0.000, 2.375, -0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.912, 2.375, 0.000> <0.912, 2.375, 0.387> <0.387, 2.375, 0.912> <-0.000, 2.375, 0.912> 
		<0.882, 2.390, 0.000> <0.882, 2.390, 0.387> <0.387, 2.390, 0.882> <-0.000, 2.390, 0.882> 
		<0.806, 2.408, 0.000> <0.806, 2.408, 0.339> <0.339, 2.408, 0.806> <-0.000, 2.408, 0.806> 
		<0.800, 2.375, 0.000> <0.800, 2.375, 0.339> <0.339, 2.375, 0.800> <-0.000, 2.375, 0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.875, 2.294, 0.000> <0.875, 2.294, -0.371> <0.371, 2.294, -0.875> <0.000, 2.294, -0.875> 
		<0.790, 1.569, 0.000> <0.790, 1.569, -0.371> <0.371, 1.569, -0.790> <0.000, 1.569, -0.790> 
		<0.873, 0.561, 0.000> <0.873, 0.561, -0.265> <0.265, 0.561, -0.873> <0.000, 0.561, -0.873> 
		<0.625, -0.125, 0.000> <0.625, -0.125, -0.265> <0.265, -0.125, -0.625> <0.000, -0.125, -0.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.875, 2.294, 0.000> <0.790, 1.569, 0.000> <0.873, 0.561, 0.000> <0.625, -0.125, 0.000> 
		<0.875, 2.294, 0.371> <0.790, 1.569, 0.371> <0.873, 0.561, 0.265> <0.625, -0.125, 0.265> 
		<0.371, 2.294, 0.875> <0.371, 1.569, 0.790> <0.265, 0.561, 0.873> <0.265, -0.125, 0.625> 
		<-0.000, 2.294, 0.875> <-0.000, 1.569, 0.790> <-0.000, 0.561, 0.873> <-0.000, -0.125, 0.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.625, -0.125, 0.000> <0.625, -0.125, -0.265> <0.265, -0.125, -0.625> <0.000, -0.125, -0.625> 
		<0.561, -0.301, 0.000> <0.561, -0.301, -0.265> <0.265, -0.301, -0.561> <0.000, -0.301, -0.561> 
		<0.188, -0.125, 0.000> <0.188, -0.125, 0.000> <0.000, -0.125, -0.188> <0.000, -0.125, -0.188> 
		<0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.625, -0.125, 0.000> <0.561, -0.301, 0.000> <0.188, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<0.625, -0.125, 0.265> <0.561, -0.301, 0.265> <0.188, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<0.265, -0.125, 0.625> <0.265, -0.301, 0.561> <-0.000, -0.125, 0.188> <0.000, -0.125, 0.000> 
		<-0.000, -0.125, 0.625> <-0.000, -0.301, 0.561> <-0.000, -0.125, 0.188> <0.000, -0.125, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<-0.000, -0.125, 0.188> <-0.000, -0.125, 0.188> <-0.188, -0.125, -0.000> <-0.188, -0.125, -0.000> 
		<-0.000, -0.301, 0.561> <-0.265, -0.301, 0.561> <-0.561, -0.301, 0.265> <-0.561, -0.301, -0.000> 
		<-0.000, -0.125, 0.625> <-0.265, -0.125, 0.625> <-0.625, -0.125, 0.265> <-0.625, -0.125, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> <0.000, -0.125, 0.000> 
		<-0.188, -0.125, -0.000> <-0.188, -0.125, -0.000> <0.000, -0.125, -0.188> <0.000, -0.125, -0.188> 
		<-0.561, -0.301, -0.000> <-0.561, -0.301, -0.265> <-0.265, -0.301, -0.561> <0.000, -0.301, -0.561> 
		<-0.625, -0.125, -0.000> <-0.625, -0.125, -0.265> <-0.265, -0.125, -0.625> <0.000, -0.125, -0.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, -0.125, 0.625> <-0.265, -0.125, 0.625> <-0.625, -0.125, 0.265> <-0.625, -0.125, -0.000> 
		<-0.000, 0.561, 0.873> <-0.265, 0.561, 0.873> <-0.873, 0.561, 0.265> <-0.873, 0.561, -0.000> 
		<-0.000, 1.569, 0.790> <-0.371, 1.569, 0.790> <-0.790, 1.569, 0.371> <-0.790, 1.569, -0.000> 
		<-0.000, 2.294, 0.875> <-0.371, 2.294, 0.875> <-0.875, 2.294, 0.371> <-0.875, 2.294, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.625, -0.125, -0.000> <-0.625, -0.125, -0.265> <-0.265, -0.125, -0.625> <0.000, -0.125, -0.625> 
		<-0.873, 0.561, -0.000> <-0.873, 0.561, -0.265> <-0.265, 0.561, -0.873> <0.000, 0.561, -0.873> 
		<-0.790, 1.569, -0.000> <-0.790, 1.569, -0.371> <-0.371, 1.569, -0.790> <0.000, 1.569, -0.790> 
		<-0.875, 2.294, -0.000> <-0.875, 2.294, -0.371> <-0.371, 2.294, -0.875> <0.000, 2.294, -0.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 2.294, 0.875> <-0.371, 2.294, 0.875> <-0.875, 2.294, 0.371> <-0.875, 2.294, -0.000> 
		<-0.000, 2.307, 0.877> <-0.371, 2.307, 0.877> <-0.877, 2.307, 0.371> <-0.877, 2.307, -0.000> 
		<-0.000, 2.307, 0.907> <-0.387, 2.307, 0.907> <-0.907, 2.307, 0.387> <-0.907, 2.307, -0.000> 
		<-0.000, 2.319, 0.912> <-0.387, 2.319, 0.912> <-0.912, 2.319, 0.387> <-0.912, 2.319, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.875, 2.294, -0.000> <-0.875, 2.294, -0.371> <-0.371, 2.294, -0.875> <0.000, 2.294, -0.875> 
		<-0.877, 2.307, -0.000> <-0.877, 2.307, -0.371> <-0.371, 2.307, -0.877> <0.000, 2.307, -0.877> 
		<-0.907, 2.307, -0.000> <-0.907, 2.307, -0.387> <-0.387, 2.307, -0.907> <0.000, 2.307, -0.907> 
		<-0.912, 2.319, -0.000> <-0.912, 2.319, -0.387> <-0.387, 2.319, -0.912> <0.000, 2.319, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 2.319, 0.912> <-0.387, 2.319, 0.912> <-0.912, 2.319, 0.387> <-0.912, 2.319, -0.000> 
		<-0.000, 2.334, 0.919> <-0.387, 2.334, 0.919> <-0.919, 2.334, 0.387> <-0.919, 2.334, -0.000> 
		<-0.000, 2.367, 0.927> <-0.387, 2.367, 0.927> <-0.927, 2.367, 0.387> <-0.927, 2.367, -0.000> 
		<-0.000, 2.375, 0.912> <-0.387, 2.375, 0.912> <-0.912, 2.375, 0.387> <-0.912, 2.375, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.912, 2.319, -0.000> <-0.912, 2.319, -0.387> <-0.387, 2.319, -0.912> <0.000, 2.319, -0.912> 
		<-0.919, 2.334, -0.000> <-0.919, 2.334, -0.387> <-0.387, 2.334, -0.919> <0.000, 2.334, -0.919> 
		<-0.927, 2.367, -0.000> <-0.927, 2.367, -0.387> <-0.387, 2.367, -0.927> <0.000, 2.367, -0.927> 
		<-0.912, 2.375, -0.000> <-0.912, 2.375, -0.387> <-0.387, 2.375, -0.912> <0.000, 2.375, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 2.375, 0.912> <-0.387, 2.375, 0.912> <-0.912, 2.375, 0.387> <-0.912, 2.375, -0.000> 
		<-0.000, 2.390, 0.882> <-0.387, 2.390, 0.882> <-0.882, 2.390, 0.387> <-0.882, 2.390, -0.000> 
		<-0.000, 2.408, 0.806> <-0.339, 2.408, 0.806> <-0.806, 2.408, 0.339> <-0.806, 2.408, -0.000> 
		<-0.000, 2.375, 0.800> <-0.339, 2.375, 0.800> <-0.800, 2.375, 0.339> <-0.800, 2.375, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.912, 2.375, -0.000> <-0.912, 2.375, -0.387> <-0.387, 2.375, -0.912> <0.000, 2.375, -0.912> 
		<-0.882, 2.390, -0.000> <-0.882, 2.390, -0.387> <-0.387, 2.390, -0.882> <0.000, 2.390, -0.882> 
		<-0.806, 2.408, -0.000> <-0.806, 2.408, -0.339> <-0.339, 2.408, -0.806> <0.000, 2.408, -0.806> 
		<-0.800, 2.375, -0.000> <-0.800, 2.375, -0.339> <-0.339, 2.375, -0.800> <0.000, 2.375, -0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 2.375, 0.800> <-0.339, 2.375, 0.800> <-0.800, 2.375, 0.339> <-0.800, 2.375, -0.000> 
		<-0.000, 1.667, 0.677> <-0.339, 1.667, 0.677> <-0.677, 1.667, 0.339> <-0.677, 1.667, -0.000> 
		<-0.000, 0.116, 0.539> <-0.212, 0.116, 0.539> <-0.539, 0.116, 0.212> <-0.539, 0.116, -0.000> 
		<-0.000, 0.000, 0.500> <-0.212, 0.000, 0.500> <-0.500, 0.000, 0.212> <-0.500, 0.000, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.800, 2.375, -0.000> <-0.800, 2.375, -0.339> <-0.339, 2.375, -0.800> <0.000, 2.375, -0.800> 
		<-0.677, 1.667, -0.000> <-0.677, 1.667, -0.339> <-0.339, 1.667, -0.677> <0.000, 1.667, -0.677> 
		<-0.539, 0.116, -0.000> <-0.539, 0.116, -0.212> <-0.212, 0.116, -0.539> <0.000, 0.116, -0.539> 
		<-0.500, 0.000, -0.000> <-0.500, 0.000, -0.212> <-0.212, 0.000, -0.500> <0.000, 0.000, -0.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.000, 0.000, 0.500> <-0.212, 0.000, 0.500> <-0.500, 0.000, 0.212> <-0.500, 0.000, -0.000> 
		<-0.000, -0.024, 0.492> <-0.212, -0.024, 0.492> <-0.492, -0.024, 0.212> <-0.492, -0.024, -0.000> 
		<-0.000, 0.000, 0.150> <-0.000, 0.000, 0.150> <-0.150, 0.000, -0.000> <-0.150, 0.000, -0.000> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 1
		v_steps 1
		<-0.500, 0.000, -0.000> <-0.500, 0.000, -0.212> <-0.212, 0.000, -0.500> <0.000, 0.000, -0.500> 
		<-0.492, -0.024, -0.000> <-0.492, -0.024, -0.212> <-0.212, -0.024, -0.492> <0.000, -0.024, -0.492> 
		<-0.150, 0.000, -0.000> <-0.150, 0.000, -0.000> <0.000, 0.000, -0.150> <0.000, 0.000, -0.150> 
		<0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> <0.000, 0.000, 0.000> 
	}


/*#declare Bubbles = 
function {
pigment {dents color_map {[0 rgb 1/2][.2 rgb 0][.75 rgb 3/4]}translate 8*y*clock}
}
isosurface {
function {y+Bubbles(x,y,z)}
eval 
accuracy .2
threshold 1
contained_by {sphere {y,2}}   
bounded_by {sphere {y,2 scale 1.5*y}}  
clipped_by {bounded_by}
texture {pigment {rgb <.25,1,0>} finish {ambient .25 diffuse 0}}      
texture {
pigment {
slope <1/2,-1/8,-1> 
color_map {
[.25 rgb <.25,1,0> filter .625]
[.3  rgb <.25,1,0> filter .75]
[.5  rgb <.25,1,0> filter .75]      
[.55 rgb <.25,1,0> filter .875]       
[.75 rgb <.25,1,0> filter .875]
[.8  rgb <.25,1,0> filter 1]
}  
}
finish {ambient .75 diffuse 0 brilliance 0}     
}
scale <.375,.375,.375>
translate y*1.75
}*/
texture {pigment {rgb <.75,.875,1>} finish {ambient .125 diffuse 0}}      
texture {
pigment {
slope <1/2,-1/8,-1> 
color_map {
[.25 rgb <.75,.875,1> filter .625]
[.3  rgb <.75,.875,1> filter .75]
[.5  rgb <.75,.875,1> filter .75]      
[.55 rgb <.75,.875,1> filter .875]       
[.75 rgb <.75,.875,1> filter .875]
[.8  rgb <.75,.875,1> filter 1]
}  
}
finish {ambient 1.25 diffuse 0 brilliance 0}     
}

scale 1.5   
translate <4,0,2>
}