#version unofficial MegaPov 0.5;   
global_settings {
max_trace_level 40  
post_process { overwrite_file find_edges{1,.5,.7,1,2,rgb .05}} 
assumed_gamma 1.25
}
#include "colors.inc"

//camera { location <-3,6.5,7> direction 3/4 look_at <-1.5,6.5,13>} 

//camera { location <-10,15,5> direction 1/2 look_at <0,5,10>}

#declare Camlookat =
spline {
cubic_spline
.6,<-1.5,6.5,13>    
.65,<-1.5,6.75,13>
.75,<-1.5,5.25,13>
.8,<-1.5,5,13>
}

camera { location <-3,5.75,7> direction 3/4 look_at <0,0,0>+Camlookat(clock)} 

//Lights to give Hogwire (and all animated objects) his "Catoony" look. 
//These were discontinued in favor of the slope texture.
/*light_source {<-5,6,15>*20    rgb 1.0 groups "Cartoon"}// shadowless}   
light_source {<-5,8,7.5>*20   rgb 1/4 groups "Cartoon" shadowless}   
light_source {<-5,10,-.25>*20 rgb 1/4 groups "Cartoon" shadowless} */

light_source {<-5,0,12.5>*2000 rgb 3 groups "Sun"}           
light_source {<5,0,12.5>*2000 rgb <.2,.25,.5> groups "Sun" shadowless}  
light_source {<-5,6,12.5>*2000 rgb 3 groups "Sun"}// area_light 1000,1000,2,2 orient adaptive 0}           

//Lights that give highlights 
//Sunlight falling on cedars...
light_source {<5,.1,10>*1.5 rgb 3*<.35,.25,.2>/3 fade_distance 12 fade_power 2 shadowless   groups "RoomDetail1"}  
//Bluish light in upper left-hand corner.
light_source {<-17.5,15,0>*1.5 rgb <.2,.25,.5> fade_distance 10 fade_power 2 shadowless  groups "RoomDetail1"}



#include "Office(closeup).inc"
#include "S7AD.inc"
#include "Hogwire.inc"
object {Hogwire 
scale 1
translate <0,9,15.5> 
no_shadow
}    

#if (clock < .3)
union {#include "kake.inc" 
}   
#else 
union {#include "FrogSandwich.inc" 
scale 1/3 
rotate 0*y
translate <-2.5,5,9>  
}
#end 

#macro CM(S,E)
#if (clock >= S)
#if (clock < E)
#declare keyclock = mod((clock-S)/(E-S),1) 
#else #declare keyclock = 1 #end 
#else #declare keyclock = 0 #end
#end


#macro SmokePuff(Start,End,Loc,Rand)       
#if (clock > Start)
#declare C=0
#while (C<60)
#declare R1 = rand(seed(C*C*C+Rand*Rand))
#declare R2 = rand(seed(C*C*C-56+Rand))
#declare R3 = rand(seed(C*C*C-156+Rand))
#declare R4 = rand(seed(C*C*C-256-Rand))
#declare R5 = rand(seed(C*C*C+156*Rand))
CM(Start,End+(R3*.5-.25))
#if (keyclock < 1)     
sphere {0,(R5-pow(clock,.5+.25*R4)*R5)*1.5 translate pow(keyclock,1+.5*R3)*y*1.5 translate (vrotate(<2*R5+1,0,0>*.75,-R1*19360+R2+360+R3+12360-R4*22720+ R5*60*y))*keyclock
scale 1.5
translate Loc
texture {
pigment {
slope <1,-1/2,-1> 
color_map {
[.25 rgb 1]
[.3  rgb .875]
[.5  rgb .875]      
[.55 rgb .75]       
[.75 rgb .75]
[.8  rgb .5]
}  
}
finish {ambient .875 diffuse 0 brilliance 0}     
}
}
#end
#declare C=C+1
#end
#end 
#end 
SmokePuff(.25,.4,<-2.5,5.5,10>,90) 



#declare BaseSpline2 = 
spline {
cubic_spline 
.5,<2,3,-1>,
.6,<1,2,1>, 
.7,<-1,1,0>, 
.8,<0,5/3/4,0>,
.81,<0,5/3/4,0>, 
.82,<0,5/3/4,0>, 
.85,<1/2,5/3/4,0>,  
.9,<0,5/3/4+1/4,1/2>         
.95,<1/4,5/3/4,0> 
.975,<1/4,5/3/4+1/8,0>
1,<1/4,5/3/4,0>
} 
#declare point3 = <0,0,0>+BaseSpline2(clock)
#declare point4 = <0,0,0>+BaseSpline2(clock)
//merge {
union {
sphere {0,.125/6 scale y/2 pigment {rgb 0}}
disc {0,z,.125/10 pigment {rgbt 1} scale y*2 rotate 45*z rotate 20*x translate .125/6*y translate -.125/6*x
rotate z*(rand(seed(clock*100+clock))*90-45)
}
disc {0,z,.125/10 pigment {rgbt 1} scale y*2 rotate -45*z rotate 20*x translate .125/6*y translate .125/6*x
rotate -z*(rand(seed(clock*100+clock))*90-45)
}
scale 1.5   
translate <-2.5,5,9>+point3
}





glow {color -<1/2,1/2,1>/8 type 1 color -<1/2,1/2,1>/8 location <-15,14,0>}      
glow {color <1,.9,.9>      type 1  location <-5,20,32>}      
glow {color <.125,.25,.5>   type 1  location <5,20,32>} 
sphere {0,.000001} 