   //////////////
   // grass.inc  
   //
   // Declares a 5x5 block of grass
   //
   // Created for the IRTC competition, "Alien Invasion".
   // Deadline for entry Oct. 15, 2000
   //
   // 
   // Copyright 2000, Collins Mark 
   //
   //////////////////////////////////
   
   #declare GrassBlade1 = difference
   {
      union
      { 
         difference
         {
            sphere {<0.1,0,0> 0.4 }
            sphere {<0.1,0,0> 0.39}
         }
         difference
         {
            sphere {<-0.1,0,0> 0.4 }
            sphere {<-0.1,0,0> 0.39}
         }
      }
      box{<0,-1,-1>, <1,1,1> rotate <0,-10,0> translate <-0.03, 0, 0>}
      box{<-1,-1,-1>, <0,1,1> rotate <0,10,0> translate < 0.03, 0, 0>}
      box{<-1,-1,-1>, <1,-0.1,1>}
      sphere {<-0.1,0,0> 0.38999}
      sphere {<0.1,0,0> 0.38999}
       
      pigment {color <0.2,0.5,0.3>}
      translate <0,0,0.395>
      scale 1.0 // 
      finish{ambient 0.2 diffuse 0.5}
   }
   
   #declare GrassSeedx = seed(1);
   #declare GrassSeedz = seed(10);
   #declare GrassSeedR = seed(20);
   #declare NumBlades1 = 1700; // Number of GrassBlades
   #declare GrassBlockSize = 5.0; // The length of the square field of grass
   #declare BreezeStrength = 0.2; 
   #declare i=0;
   #declare GrassBlock = union
   {
      #while (i<NumBlades1)
         object {GrassBlade1
                 rotate BreezeStrength*x*2*sin(2*pi*0.7*time) // individual wind characteristic
                 rotate BreezeStrength*z*2*sin(2*pi*0.7*time+pi/4) // individual wind characteristic 
                 rotate y*360*rand(GrassSeedR) //intrinsic random rotation.
                 rotate BreezeStrength*x*2*sin(2*pi*0.5*time) // General wind
                 rotate BreezeStrength*x*0.5*sin(2*pi*time)
                 rotate BreezeStrength*z*2*sin(2*pi*0.5*time+pi/4)
                 rotate BreezeStrength*z*0.5*sin(2*pi*time+pi/4)
                 
                 scale (1+0.3*(2*(rand(GrassSeedR)-0.5))) 
                 translate <GrassBlockSize*(rand(GrassSeedx)-0.5), 0, GrassBlockSize*(rand(GrassSeedz)-0.5)>}
         #declare i = i+1;
      #end
      box 
      {  <-GrassBlockSize/2, -0.1, -GrassBlockSize/2> <GrassBlockSize/2, 0.01, GrassBlockSize/2> 
         //pigment {color <0.45,0.3,0.3>}
         texture 
            { 
               //pigment {color White}
               pigment
               {
                   bozo //marble
                    turbulence <6,6,6>
                    color_map 
                    {
                        [0.0, 0.1   color <0.45,0.3,0.3> color Black]
                        [0.1, 0.2   color Black color <0.45,0.3,0.3>]
                        [0.2, 0.3   color <0.45,0.3,0.3> color <0.45,0.3,0.3>]
                        [0.3, 0.4   color <0.2,0.5,0.3> color Black]
                        [0.5, 0.5   color Black color Black]
                        [0.5, 0.6   color <0.45,0.3,0.3> color Black]
                        [0.6, 0.7   color Black color Black]
                        [0.7, 0.8   color <0.45,0.3,0.3> color <0.45,0.3,0.3>]
                        [0.8, 0.9   color Black color <0.45,0.3,0.3>] 
                        [0.9, 1.001   color Black color <0.45,0.3,0.3>]
                     }
                }  
                scale 0.125
              } 
           } 
       }
       
   #declare slugStand =              // 1 x 1 block of soil
      box 
      {  <-0.5, -0.1, -0.5> <0.5, 0.01, 0.5> 
         //pigment {color <0.45,0.3,0.3>}
         texture 
            { 
               //pigment {color White}
               pigment
               {
                   bozo //marble
                    turbulence <6,6,6>
                    color_map 
                    {
                        [0.0, 0.1   color <0.45,0.3,0.3> color Black]
                        [0.1, 0.2   color Black color <0.45,0.3,0.3>]
                        [0.2, 0.3   color <0.45,0.3,0.3> color <0.45,0.3,0.3>]
                        [0.3, 0.4   color <0.2,0.5,0.3> color Black]
                        [0.5, 0.5   color Black color Black]
                        [0.5, 0.6   color <0.45,0.3,0.3> color Black]
                        [0.6, 0.7   color Black color Black]
                        [0.7, 0.8   color <0.45,0.3,0.3> color <0.45,0.3,0.3>]
                        [0.8, 0.9   color Black color <0.45,0.3,0.3>] 
                        [0.9, 1.001   color Black color <0.45,0.3,0.3>]
                    }
               }  
               scale 0.125
            } 
      }
      
   
        
           
           