////////////////////////////////////////////////////////////////
// Payload.pov
//
// Created for the IRTC competition, "Alien Invasion".
// Deadline for entry Oct. 15, 2000
//
// 
// Copyright 2000, Collins Mark
/////////////////////////////////////////////////////////////////
/*

////////////////////////////////////////////////////////////////////
//         Storyboard for Payload Animation 
///////////////////////////////////////////////////////////////////

Sequence 1                       (clock 0 - 1)
Camera near grass. Focus on Tree in the background, and text, spelling out
	Payload
	Copyright Collins Mark       
	2000 C. E.
	T -x      (x is the time before liftoff. Recalculate later)
Sequence 2                         (clock 1 - 2)
x changes value.
Sequence 3                        (clock 2 -4)
x changes to new value. Text fades out (gradually becomes transparent)
Camera begins panning down lower to see a slug in the grass starting to take a snack out of a small piece of grass on the ground. Slugs eyes are looking at snack. Pupils start to get a little larger. 
Sequence 4                         (clock 4 - 6)
Camera stops moving.
Slug takes bite of snack
Slug's eyes squint
Sequence 5                         (clock 6  - 8)
Slug stopps squinting fully, and pupils back to normal. Slug stares off into space and begins chewing food. From behind, a driver's license comes into the scene. 
Sequence 6                          (clock 8 - 8.5)
License stops under slug's tail.
Sequence 7                         (clock 8.5 - 9)
License slowly moves under back of slug, and continues for a second. 
Sequence 8                         (clock 9 - 9.5) 
Slug's eyes widen to default wideness, and slug looks a bit more toward the camera, but keeps on chewing.
Sequence 9                        (clock 9.5 - 11.5)
License stops for 2 seconds. Slug looks back a little bit more. 
Sequence 10                   (clock 11.5 - 11.75)      Sequence 11  (clock 11.75 - 12)
License jerks towards head of slug, bringing all of slug barely onto the license. Slug stops chewing.
Sequence 12                    (clock 12 - 12.25)  
License jerks again, bringing the slug fully on to the license, with enough room left for the snack to make it on too.
Sequence 13                       (clock  12.25 - 13.75) 
License begins to lift up a couple feet. Slug starts to look at license. Camera follows. 
License  continues going up, and rotates counter clockwise about 90 degrees. Camera follows lifting, and some of rotation. Slug is still looking around license.
Sequence 14                     (clock 13.75 - 14.25)
License and passengers start to move to the left, seamless with end of rotation.  License slowly moves down with respect to camera. Slug starts to check out landscape ahead of him (landscape which is out of camera shot; the slug is still in the shot as before).
Sequence 15                    (clock 14.25 - 15.25)
First step. License jerks up, and slugs eyes jerk down slightly. License keeps moving up very slowly (slughtly), before moving back down slowly before next step. Slug's eyes start to move out a bit as he checks out the land below getting closer.
Sequence 16                  (clock 15.25 - 16.25)
Second step. Jerks in license and eyes like before. Slug's eyes continue to move out. 
Slug's eyelids open wider than standard, and his eyes begine to move back to standard position, and he starts to look at what would be carrying the license. 
Sequence 17                  (clock 16.25 - 16.75)
Third step. Eyes and licence jerk again. But this time, after the jerk up, continued motion slowly stops. 
Sequence 18                  (clock 16.75 - 17.25)
The slug starts to look down again, but this time without stretching his eyes. 
Sequence 19                  (clock 17.25 to 18.25)
License begins slowly tilting counterclockwise.  Rocket top (wihtout nose cone) comes into view from left of the camera.
Sequence 20                  (clock 18.25 - 19.25)
Snack falls into payload section, as license is tilted about 45 degrees. Slug begines to look at camera. Pupils slowly become smaller than standard.
Sequence 21                  (clock 19.25 - 20.25) 
Slug slowly starts to slide down license, as it keeps tilting. 
Sequence 22                  (clock 20.25 - 20.75)
Slug begins to freefall into payload section.

********************* BREAK. Camera changes position. BREAK ********************

Sequence 23                 (clock 20.75 - 21.75)
Camera is directed horizontally on Slug in payload section. Slug begins to look around.
Sequence 24                 (clock 21.75 - 22.75)
Nosecone section comes into view from above. 
Slug starts to look up toward the nosecone. 
Sequence 25                 (clock 22.75 - 25.75)
Nose cone starts screwing into place. Three screws, each 1 second.  
Slug looks around himself, outside. 
Sequence 26                 (clock 25.75 - 26.25)
Nosecone stops scewing. 
Sequence 27                 (clock 26.25 - 29.25)
Rocket top and occupants begin to arc upward and to the left slightly, coming to a stop after a couple of seconds. Camera follows.
Sequence 28                 (clock 29.25 - 31.25)
Rocket begins to slide down launch rod. This takes a couple seconds. Camera follows. Slug sees snack.
Slug now looks around inside of payload section.
Sequence 29                 (clock 31.25 - 32)
Rocket top has now stopped sliding. 
Sequence 30                 (clock 32 - 36)
Camera tilts down very slowly, a little and starts decending, not quite so slowly, This reveals the writing on the rocket "Alien Invader". When camera ends, movement, after about 4 seconds, fins, launcher and grass is in veiw as seen from above. 

***************** BREAK. Camera changes position. BREAK ************************** 

Sequence 31                (clock 36 - 38)
Camera is a few feet away, and low to the grass. The rocket is in the far forground, and the ballpark can be seen in the background. This shot is held for two seconds. 

**************** BREAK. Camera changes position. Break *****************************

Sequence 32               (clock 38 - 47)
Camera is back on slug in the payload section. Slug has just taken a bite of snack and is returning it's head to normal position. Slug's eyes are squited somewhat. Slug is chewing.
Slug's head is back, and elelids are no longer squited so severly, but are still squnited a little. Slug continues chewing for 10 seconds (suspense shot).
Sequence 33               (clock 47 - 47.25)
Liftoff. Slug stopps chewing. Slugs eye positions begin to drop. Slug's eylids are no longer squinting. 

**************** BREAK. Camera changes position. Break *****************************

Sequence 34               (clock 47.25 - 49.25)
Camera is back to position low near the grass a bit earlier. Rocket is blasting smoke and rising into the air. Camera follows, for around two seconds or so. 

 **************** BREAK. Camera changes position. Break *****************************

Sequence 35                (clock 49.25 - 52.25)
Camera is back vewing slug in payload section, following rocket's motion, with a little shaking. Slug's eyes return to normal position after about a half second   
Slug's eyes are at normal position.
Sequence 36                (clock 52.25 - 55)
Rocket stops shaking. Slug and snack start to rise and float. Rocket Top begins to tilt to the right. After 4 seconds, rocket has tilted 90 deg to the right. Camera follows rocket top's motion, but not tilting. 
Sequence 37                (clock 55 - 57)
Parachute blast occurs. Rocket top shoots to the right shaking around Slug and snack. rocket top keeps moving revealing rolled up parachute attached from behind. These things move out of view. Camera does not follow. 

**************** BREAK. Camera changes position. Break *****************************

Sequence 38                (clock 57 - 59)
Camera is locked on to inverted payload section, nosecone partially shown at the bottom. Rocket top is swirling around, and camera follows complete swirling motion. Visually, rocket top is stable and bacground landscape is swirling around below. Slug and snack are falling towards nosecone (now the bottom of payload section).
Slug and snack fall to bottom of payload section. Slug looks around outside for a couple of seconds. 
Slug begins to look inside payload section for a second eventually seeing snack. 
Sequence 39             (clock 59 - 61)
Slug begins to move head to take bite of snack. Eyes are on snack.
Sequence 40             (clock 61 - 63) 
Slug takes bite of snack. Snack begins to slip in slug's mouth and slug starts chewing. Slug begins to return head to normal position. 
Sequence 41               (clock 63 - 66)
Slug's head is back in normal position. Slug's eyes are slightly squnted, and slug stares off into space. This position lasts for three seconds, but slugs movements continue till end of sequence.  
Sequence 42               (clock 66 - 73)
Camera position begins to move back (and slow down fro falling), while simultaneously, gradually ceacing to track rocket top rotation. Soon rocket top and parachute are seen drifteng down towards ball park. 
Rocket bottom and its chute come into the picture drifting behind rocket top.
Sequence 43              (clock 73 - 74)
Fade to black (dim lights)
Fin. 

*/

//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
// First Create items that will be declared each and every frame throuought the animation.
//%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

   ///////////////
   // Payload.pov
   ///////////////
   global_settings {assumed_gamma  1.3}   // This should likely be a little greater that 1.4 for final production.
   #include "colors.inc"        
   #include "Textures.inc"      
   #include "Stones.inc"
   #include "metals.inc"
   //#include "glass.inc"        
   //#include "frame_clock.inc" // declares a variable "Frame_Clock" that stores the current frame number.
                              // This statement must remain near the top. This is essential for slug's
                              // automatic breathing, automatic blinking, and automatic tail wagging. They are 
                              // frame based, not clock based.
                              // This line has been commented out for source code submission, since the slug
                              // has been replace with a simple sphere (forgive me, but I can't bring myself to make
                              // to make the real slug object public at this time. 
   
  #declare time = clock;      // For now we will start with "time" equal to clock. May override this in some frames.
                              // time is used by trees and grass blowing in the wind. These things assume that
                              // "time" will change from 0 to 1 in one second. As an example, for a 60 second clip,
                              // clock (thus time) must go from 0 to 60. 

  //////////////////////////////////
  //  **** Camera quality. ***** 
  //
  // We must define this up here.
  /////////////////////////////////// 
  #declare camera_focus_en = 0;   // Clear (0) for speedy developement. Set (1) for production quality.
    #declare camera_aperture = 0.01;     
    #declare camera_blur_samples = 3; //8; //16;      // more samples, higher quality image
    #declare camera_angle = 35;
   
  ///////////////////////////////
  /// Ground and fake grass                       // This is in every frame
  ///////////////////////////////
  
  plane {y, 0  
   texture 
   { 
      //pigment {color White}
      pigment
      {
           bozo
           turbulence 10
           color_map 
           {
               [0.0, 0.1   color <0.2,0.5,0.3> color Black]
               [0.1, 0.2   color Black color <0.2,0.5,0.3>]
               [0.2, 0.3   color <0.2,0.5,0.3> color <0.2,0.5,0.3>]
               [0.3, 0.4   color <0.2,0.5,0.3> color Black]
               [0.5, 0.5   color Black color Black]
               [0.5, 0.6   color <0.2,0.5,0.3> color Black]
               [0.6, 0.7   color Black color Black]
               [0.7, 0.8   color <0.2,0.5,0.3> color <0.45,0.3,0.3>]
               [0.8, 0.9   color Black color <0.2,0.5,0.3>] 
               [0.9, 1.001   color Black color <0.2,0.5,0.3>]
            }
         }  
         scale 4
      }
      //pigment {color Green} 
   } 
  
  /////////////////////////////////////////
  // Sky. This is used in all frames.
  /////////////////////////////////////////  
  sky_sphere {
    pigment {
      gradient y
      color_map {
        [0.000 0.002 color rgb <0.5, 0.7, 1.0>
                     color rgb <0.5, 0.7, 1.0>]
        [0.002 0.200 color rgb <0.5, 0.7, 1.0>
                     color rgb <0.4, 0.6, 1.0>]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
  }
#if (clock<73)
   /////////////////////////////////
   // Light from sky, with 8 lights            // Every frame has these, except for the fade to black.
   /////////////////////////////////
   #declare SkyLightStrength = 0.35;
   #declare SkyShineColor = <0.9, 0.9, 1>;
   light_source {<2500*cos(2*pi*0/8), 2000, 2500*sin(0*pi*0/8)> SkyShineColor*SkyLightStrength shadowless}    
   light_source {<2500*cos(2*pi*1/8), 2000, 2500*sin(2*pi*1/8)> SkyShineColor*SkyLightStrength shadowless}     
   light_source {<2500*cos(2*pi*2/8), 2000, 2500*sin(2*pi*2/8)> SkyShineColor*SkyLightStrength shadowless}
   light_source {<2500*cos(2*pi*3/8), 2000, 2500*sin(2*pi*3/8)> SkyShineColor*SkyLightStrength shadowless}    
   light_source {<2500*cos(2*pi*4/8), 2000, 2500*sin(2*pi*4/8)> SkyShineColor*SkyLightStrength shadowless}     
   light_source {<2500*cos(2*pi*5/8), 2000, 2500*sin(2*pi*5/8)> SkyShineColor*SkyLightStrength shadowless} 
   light_source {<2500*cos(2*pi*6/8), 2000, 2500*sin(2*pi*6/8)> SkyShineColor*SkyLightStrength shadowless}    
   light_source {<2500*cos(2*pi*7/8), 2000, 2500*sin(2*pi*7/8)> SkyShineColor*SkyLightStrength shadowless}       
   
   /////////////////////////
   // Sun                                     // Every frame has this, except for the fade to black.
   ///////////////////////// 
   light_source {
     <0, 0, 0> colour <1, 1, 0.7>*1.2 

     looks_like {
        sphere { <0.0, 0.0, 0.0>, 190.0
           pigment { colour <1.0, 1.0, 0.6> }
           finish { ambient 1.0 diffuse 0.0 }
        }
     }
      
     translate <200.0, 2500.0, -900.0>
   } 
#end // end if clock less than 73. 

   ///////////////////////         // Dumb trees are the simple trees in the background. 
   // Dumb Trees                   // These "dumb" trees are in all frames.
   ///////////////////////
   #include "dumbtree.inc"
   #declare NumDumbTrees = 1000;
   #declare DumbSeed = seed (911);  // time to plant some tree seeds.
   #declare i=0;
   #while (i<NumDumbTrees)
      object
      {
         tree_DumbPine 
         scale (0.5+rand(DumbSeed))
         translate <500 + 400*rand(DumbSeed), 0, 0>
         rotate <0, 360*rand(DumbSeed),0>
      }   
      object
      {
         tree_DumbTree 
         scale (0.5+rand(DumbSeed))
         translate <500 + 200*rand(DumbSeed), 0, 0>
         rotate <0, 360*rand(DumbSeed),0>
      }
      #declare i = i+2;
   #end 
   
   //////////////////////////////////////////
   // Mountains
   //////////////////////////////////////////
   height_field 
   {
      tga "rawland.tga"
      smooth    
      //water_level 0.4
      //water_level 0.05
      pigment 
      {
         bozo
           turbulence 10
           color_map 
           {
               [0.0, 0.1   color <0.2,0.5,0.3> color Black]
               [0.1, 0.2   color Black color <0.2,0.5,0.3>]
               [0.2, 0.3   color <0.2,0.5,0.3> color <0.2,0.5,0.3>]
               [0.3, 0.4   color <0.2,0.5,0.3> color Black]
               [0.5, 0.5   color Black color Black]
               [0.5, 0.6   color <0.2,0.5,0.3> color Black]
               [0.6, 0.7   color Black color Black]
               [0.7, 0.8   color <0.2,0.5,0.3> color <0.45,0.3,0.3>]
               [0.8, 0.9   color Black color <0.2,0.5,0.3>] 
               [0.9, 1.001   color Black color <0.2,0.5,0.3>]
            }
            scale 0.001
      }
      rotate -90*y translate <1,0,0>
      translate <-0.5, -0.1, 0>  
      scale 4
      //pigment {color Red}
  
      scale <3.2, 0.23, 2>*1000
      scale <2.0, 0.5, 2.0>
      translate <0, 0, -3000.0>
      //rotate 10*y
      //translate <-80.0, 0.0, -30.0>
      //translate <-80, 180, -30>
   }
   
   
   /////////////////////////////////////////////////////////////////////////////////////
   // Glue Slug Default Definitions. These are included in every frame, but may be individually be overriden by current frame. 
   //                                This way, only those parameters that are not default need to be redefined. 
   //                                Be sure to include the line ' #include "glueslug.inc" '  *after* all definitions are *final* for
   //                                the particular frame. And only after that, create the instance of GlueSlug.
   //
   //                                For the slug in Payload, created for IRTC "Alien Invasion", slug is 1/6 standard size.   
   //////////////////////////////////////////////////////////////////////////////////////   
   #declare slug_Stretch = 1.0;      // Strech along glueslug axis. 1 is relaxed. 
   #declare slug_PupilSize = 1.00;    // Size of pupil. 1 is normal
   #declare slug_LookAt = <0.0, 0.0, -2.0>; // Position the eyes focus on, relative to bottom of head.
   #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6>;  // Really the Right eye position (Left and right eye got swapped somehow. Oops), 
                                              // relative to bottom of head. <0.2, 0.3, 0> is relaxed (at normal scale).
   #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6>; // Really the Left eye position (Left and right eye got swapped somehow. Oops), 
                                               // relative to bottom of head. <-0.2, 0.3, 0> is relaxed (at normal scale).
   #declare slug_AutoEyeMovement_En = 1; // Enables random movement of eyestructure position. If set (1), slug_AutoEyeMovementStrength must be defined.
//#declare slug_AutoEyeMovement_En = 0;
   #declare    slug_AutoEyeMovementStrength = 0.1; // (default 0.1) Zero values cause the eyes to not move at all, 1 moves the eyes around pretty good.
   #declare    slug_AutoEyeMoveCorrectionFactor = 0.05; // (default 0.05) Determines, in part, random distance from specified eye postion. The larger the value, the larger
                                                      // the tendency to drift back to the specified postion. 0.0 causes no tendency to drift back
                                                      // Values greater than 1 are unstable.
   #declare    slug_AutoEyeMoveViscosity = 0.1; // (default 0.1) Adds viscosity to the eye movement. Tendency to move in the opposity direction of 
                                                // the velocity. Proportional to velocity sqared. 0 is no viscosity, and 1 is very viscous.
   #declare    slug_AutoEyeMoveDryFriction = 0.0001;// (default 0.0001) Adds dry friction to the movement. Constant tendency to move in the opposite
                                                 // direction of velocity.    
   #declare    slug_InitialAutoEyeMove = 0; // Initializes auto eye position movement. Initialization performed automatically when clock = 0;
   #declare slug_Eyelids = 1.0; // Eyelids open. 1 corresponds to normal open. 0 completely closed.   
   #declare slug_AutoBlink_En = 1; // Set (1) to enable autoblink. If set, slug_AutoBlinkPeriod must be defined.
//#declare slug_AutoBlink_En = 0;
   #declare   slug_AutoBlinkPeriod = 45; //approximate number of frames until next blink, assumming slug_AutoBlink_En is set (1). 
   #declare slug_Mouth = 0.2; // Mouth open. 1 is very open, 0 is completey closed.
   #declare slug_MoveMouth = <0,0>; // Move mouth by x and y. z is always be 0. This parameter is not effected by slug scaling, only mouth scaling.
   #declare slug_ScaleMouth = <1,1>; // Scales the x and y of mouth, after opening. <1,1> is normal.  
   #declare slug_ForceEyelidsStraight = 0; // If set (1) eyelids will not wander with inner eye. Clear (0) for normal operation.
   #declare slug_Breath = 1.0; // Multiplies size of middle ball times value. 1.0 is relaxed.
   #declare slug_AutoBreath_En =1; // Takes care of breathing for you.
   #declare    slug_AutoBreathPeriod = 2;//3; // units in seconds (30 frame periods) of breath cycle.
   #declare    slug_AutoBreathAmplitude = 0.1; // Fraction of slug's throax of peak expansion and peak compression. 
   #declare slug_MoveHead = <0,0.0,0.0>; // Head movement after stretching. 
   #declare slug_MoveThorax = <0,0,0>; // Middle movement after stretching.
   #declare slug_MoveButt = <0,0,0>; // Buttocks movement after stretching.
   #declare slug_MoveTail = <0,0,0>; // Tail Movement after stretching (wagging).
   #declare slug_TailAutoWag_En = 1; // Enables automatic wagging of tail.
   #declare    slug_TailAutoWagPeriod = 7.56; // units in seconds (30 frame periods) of wag cycle.
   #declare slug_Scale = 1.0/6; // Scaling of entire slug.

   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // That wrapps it up for things in every frame. Start the animation sequence here. 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   
 #declare SequenceRun = 0;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence1. Camera near grass. Focus on tree in background, and text.  clock goes from 0 to 1
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 #declare Sequence1 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence1) )
   
   ///////////////////////////////////////////////
   // Openinc Credits: 
   ///////////////////////////////////////////////
   union
   {
      text { ttf "TIMESBD.ttf" "PAYLOAD" 1, 0              // Title                                         
             rotate y*95                               
             scale 6.0
             scale <0.5,1,1>                                                 
             translate <0, 0, 0> 
           }
      text { ttf "TIMESBD.ttf" "Copyright Collins Mark" 1, 0              // Credits                                         
             rotate y*95                               
             scale 2.8
             scale <0.5,1,1>                                                 
             translate <0, -2, 0> 
           }
      text { ttf "TIMESBD.ttf" "2000 C.E." 1, 0              // Year                                         
             rotate y*95                               
             scale 2.8
             scale <0.5,1,1>                                                 
             translate <0, -5, -6> 
           }
      translate <60, 11, 9>      
      pigment {color rgbf<0.9, 0.9, 0.5, 0.0>}
   }
   text 
   { ttf "TIMESBD.ttf" "T -47" 1, 0              // Time before liftoff                                         
     rotate y*95                               
     scale 2.8
     scale <0.5,1,1>                                                 
     translate <60, 11-6, 9-24>
     pigment {color rgbf<0.9, 0.9, 0.5, 0.0>} 
   }
   
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <10.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3, 0.08+0.35,0.14>;
   #declare camera_look_at = <10-0.1, 0.02+0.35+0.09,0+0.12>; 
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at +<60,5,-10>    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence1;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence2.          clock goes from 1 to 2
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence2 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence2) )
   
   ///////////////////////////////////////////////
   // Openinc Credits: 
   ///////////////////////////////////////////////
   union
   {
      text { ttf "TIMESBD.ttf" "PAYLOAD" 1, 0              // Title                                         
             rotate y*95                               
             scale 6.0
             scale <0.5,1,1>                                                 
             translate <0, 0, 0> 
           }
      text { ttf "TIMESBD.ttf" "Copyright Collins Mark" 1, 0              // Credits                                         
             rotate y*95                               
             scale 2.8
             scale <0.5,1,1>                                                 
             translate <0, -2, 0> 
           }
      text { ttf "TIMESBD.ttf" "2000 C.E." 1, 0              // Year                                         
             rotate y*95                               
             scale 2.8
             scale <0.5,1,1>                                                 
             translate <0, -5, -6> 
           }
      translate <60, 11, 9>      
      pigment {color rgbf<0.9, 0.9, 0.5, 0.0>}
   }
   text 
   { ttf "TIMESBD.ttf" "T -46" 1, 0              // Time before liftoff                                         
     rotate y*95                               
     scale 2.8
     scale <0.5,1,1>                                                 
     translate <60, 5, -15>
     pigment {color rgbf<0.9, 0.9, 0.5, 0.0>} 
   }
   
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <10.5,0,0>}
   
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3, 0.08+0.35,0.14>;
   #declare camera_look_at = <10-0.1, 0.02+0.35+0.09,0+0.12>; 
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at +<60,5,-10>    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence2;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence3.            clock goes from 2 to 4
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  #declare Sequence3 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence3) )
   
   #declare My_clock1 = clock-SequenceRun;
   #declare My_clock2 = My_clock1/Sequence3; 
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end
   
   #if (My_clock2 < 0.5)
      ///////////////////////////////////////////////
      // Openinc Credits:     Fade out in the first second of sequence. 
      ///////////////////////////////////////////////
      union
      {
         text { ttf "TIMESBD.ttf" "PAYLOAD" 1, 0              // Title                                         
                rotate y*95                               
                scale 6.0
                scale <0.5,1,1>                                                 
                translate <0, 0, 0> 
              }
         text { ttf "TIMESBD.ttf" "Copyright Collins Mark" 1, 0              // Credits                                         
                rotate y*95                               
                scale 2.8
                scale <0.5,1,1>                                                 
                translate <0, -2, 0> 
              }
         text { ttf "TIMESBD.ttf" "2000 C.E." 1, 0              // Year                                         
                rotate y*95                               
                scale 2.8
                scale <0.5,1,1>                                                 
                translate <0, -5, -6> 
              }
         translate <60, 11, 9>      
         pigment {color rgbt<0.9*(1-2*My_clock2), 0.9*(1-2*My_clock2), 0.5*(1-2*My_clock2), (2*My_clock2)>}
      }
      text 
      { ttf "TIMESBD.ttf" "T -45" 1, 0              // Time before liftoff                                         
        rotate y*95                               
        scale 2.8
        scale <0.5,1,1>                                                 
        translate <60, 5, -15>
        pigment {color rgbt<0.9*(1-2*My_clock2), 0.9*(1-2*My_clock2), 0.5*(1-2*My_clock2), (2*My_clock2)>} 
      }
    #end // if (My_clock1 < 1)
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
   #declare  slug_LookAt = <0,0.02,-0.05>
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3-(0.2*My_clock3), 0.08+(0.35*(1-My_clock3)),0.14>;
   #declare camera_look_at = <10-0.1, 0.02+((0.35+0.09)*(1-My_clock3)),0+0.12*(1-My_clock3)>;
   
   //This is where we're going. i.e. we can freeze here next time.
   //location <10-0.3-0.2, 0.08,0.14>  // close up of slug in grass
   //look_at <10-0.1,0.02,0>
    
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         #if (My_clock1 < 1)
            focal_point camera_look_at +(<60,5,-10>*(1-My_clock1))
         #else
            focal_point camera_look_at
         #end    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence3;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence4.      clock goes from 4 to 6
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  #declare Sequence4 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence4) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence4;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence4/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   ////////////////////////////////////
   #declare slug_Mouth = 0.2 +0.8*My_clock4;
   #declare slugHeadTempy = 0.0025*My_clock4;
   #declare slugHeadTempz = -0.015*My_clock3;
   #declare slug_MoveHead = <0, slugHeadTempy, slugHeadTempz>; 
    
   #declare  slug_LookAt = <0, 0.02-slugHeadTempy, -0.05-slugHeadTempz>
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3-0.2, 0.08,0.14>;
   #declare camera_look_at = <10-0.1,0.02,0>;  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence4;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence5.           clock goes from 6 to 8
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  #declare Sequence5 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence5) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence5;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence5/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   ////////////////////////////////////
   #declare slug_Eyelids = 1.0-0.4*My_clock2; // ends at 0.6.
   #declare slug_Mouth = 0.2;
   #declare slugHeadTempy = 0;
   #declare slugHeadTempz = -0.015*(1-My_clock3);
   #declare slug_MoveHead = <0, slugHeadTempy, slugHeadTempz>;
   #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>)*My_clock2; // start chewing 
   #declare slug_ScaleMouth = <1 + 0.3*sin(2*pi*clock+pi/4)*My_clock2,1>;        // part of chewing.
    
   #declare  slug_LookAt = <0, 0.02-slugHeadTempy, -0.05-slugHeadTempz -0.4*My_clock2>;
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   #declare tempRotationAngle = 9
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360), -0.15 -0.14*(1-My_clock2)>
      translate <10-0.23, 0.01,-0.0> 
   } 

   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3-0.2, 0.08,0.14>;
   #declare camera_look_at = <10-0.1,0.02,0>;  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence5;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence6.        clock goes from 8 to 8.5
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence6 = 0.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence6) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence6;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence6/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   ////////////////////////////////////
   #declare slug_Eyelids = 0.6; 
   #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
   #declare slug_ScaleMouth = <1 + 0.3*sin(2*pi*clock+pi/4),1>;        // part of chewing.
    
   #declare  slug_LookAt = <0, 0.02, -0.05 -0.4>;
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   #declare tempRotationAngle = 9;
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360), -0.15>
      translate <10-0.23, 0.01,-0.0> 
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3-0.2, 0.08,0.14>;
   #declare camera_look_at = <10-0.1,0.02,0>;  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence6;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence7.             clock goes from 8.5 to 9
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence7 = 0.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence7) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence7;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence7/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
     #declare tempRotationAngle = 9;
   #declare slug_Eyelids = 0.6 +0.4*My_clock2; 
   #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
   #declare slug_ScaleMouth = <1 + 0.3*sin(2*pi*clock+pi/4),1>;        // part of chewing.
   #declare slug_moveButt = <0, 0.015*My_clock2*sin(2*pi*tempRotationAngle/360), 0>;   // license is pushing up butt.
    
   #declare  slug_LookAt = <0, 0.02, -0.05 -0.4>;
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360), -0.15 +0.015*My_clock2>
      translate <10-0.23, 0.01,-0.0> 
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3-0.2, 0.08,0.14>;
   #declare camera_look_at = <10-0.1,0.02,0>;  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence7;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence8.                  clock goes from 9 to 9.5
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence8 = 0.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence8) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence8;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence8/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
     #declare tempRotationAngle = 9;
   #declare slug_Eyelids = 1.0 
   #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
   #declare slug_ScaleMouth = <1 + 0.3*sin(2*pi*clock+pi/4),1>;        // part of chewing.
   #declare slug_MoveButt = <0, 0.015*(1+My_clock2)*sin(2*pi*tempRotationAngle/360), 0>;   // license is pushing up butt.
    
   #if (My_clock2 < 0.5) #declare  slug_LookAt = (<0, 0.02, -0.45> + (<0.2, -0.01, 0.15>*(My_clock2*2)));
   #else #declare slug_LookAt = <0.2, 0.01, -0.3>;
   #end 
   
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360), -0.15 +0.015 +0.015*My_clock2>
      translate <10-0.23, 0.01,-0.0> 
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3-0.2, 0.08,0.14>; 
   #declare camera_look_at = <10-0.1,0.02,0>;  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence8;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence9.                      clock goes from 9.5 to 11.5
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
   #declare Sequence9 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence9) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence9;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence9/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
     #declare tempRotationAngle = 9;
   #declare slug_Eyelids = 1.0; 
   #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
   #declare slug_ScaleMouth = <1 + 0.3*sin(2*pi*clock+pi/4),1>;        // part of chewing.
   #declare slug_MoveButt = <0, 0.03*sin(2*pi*tempRotationAngle/360), 0>;   // license is pushing up butt.
   
   #if (My_clock2 < 0.5) 
      #declare  slug_LookAt = <0.2, 0.01, -0.3>;
   #end 
   
   #if ( (My_clock2 >= 0.5)&(My_clock2 < 0.625) )
      #declare  slug_LookAt = ( <0.2, 0.01, -0.3> + (<2.3, 0, -1.7>*(My_clock2-0.5)*8));
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0,0,0.2>*(My_clock2-0.5)*8;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0.02, 0, -0.01>*(My_clock2-0.5)*8;
   #end 
   
   #if ( (My_clock2 = 0.625) | (My_clock2 > 0.625) )
      #declare slug_LookAt = <2.5,0.01, -2.0>;
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0,0,0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0.02, 0, -0.01>;      
   #end     
   
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360), -0.15 +0.03>
      translate <10-0.23, 0.01,-0.0> 
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = (<10-0.3-0.2, 0.08,0.14> +<0.1, 0, -0.05>*My_clock2); 
   #declare camera_look_at = (<10-0.1,0.02,0> +<0,0,-0.03>*My_clock2);  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence9;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence10.                                   clock goes from 11.5 to 11.75
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
   #declare Sequence10 = 0.25; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence10) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence10;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence10/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
     #declare tempRotationAngle = 9;
   #declare slug_Eyelids = 1.0; 
   #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
   #declare slug_ScaleMouth = <1 + 0.3*sin(2*pi*clock+pi/4),1>;        // part of chewing.
   #declare slug_MoveButt = <0, (0.03+0.04*My_clock3)*sin(2*pi*tempRotationAngle/360), 0>;
   #declare slug_MoveThorax = <0, (0.04*My_clock3)*sin(2*pi*tempRotationAngle/360), 0>;    // license is pushing up butt.
   
   #declare slug_LookAt = <2.5,0.01, -2.0>;
   #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0,0,0.02>;
   #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0.02, 0, -0.01>;      
       
   
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360), -0.12 +0.04*My_clock3>
      translate <10-0.23, 0.01,-0.0> 
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.4, 0.08,0.09>; 
   #declare camera_look_at = <10-0.1,0.02,-0.03> ; 
   
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence10;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence11.                            clock goes from 11.75 to 12.00
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
   #declare Sequence11 = 0.25; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence11) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence11;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence11/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
     #declare tempRotationAngle = 9;
   #declare slug_Eyelids = 1.0; 
   #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>*(1-My_clock2)); // stop chewing 
   #declare slug_ScaleMouth = <1 + (1-My_clock2)*0.3*sin(2*pi*clock+pi/4),1>;        // part of chewing.
   #declare slug_MoveButt = <0, (0.07)*sin(2*pi*tempRotationAngle/360), 0>;
   #declare slug_MoveThorax = <0, (0.04)*sin(2*pi*tempRotationAngle/360), 0>;    // license is pushing up butt.
   
   #declare slug_LookAt = <2.5,0.01, -2.0>;
   #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0,0,0.02>;
   #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0.02, 0, -0.01>;      
       
   
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate <10-0.15,0.01,0>
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07>}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360), -0.08>
      translate <10-0.23, 0.01,-0.0> 
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.4, 0.08,0.09>; 
   #declare camera_look_at = <10-0.1,0.02,-0.03> ;  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence11;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence12.                                        clock goes from 12.0 to 12.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
   #declare Sequence12 = 0.25; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence12) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence12;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence12/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <9.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   //////////////////////////////////// 
     #declare tempRotationAngle = 9;
   #declare slug_MoveButt = <0, (0.07+0.08*My_clock3)*sin(2*pi*tempRotationAngle/360), 0>;     // license pushing up butt.
   #declare slug_MoveThorax = <0, (0.04+0.08*My_clock3)*sin(2*pi*tempRotationAngle/360), 0>;    // license is pushing up thorax.
   #declare slug_MoveHead =  <0, (0.08*My_clock3)*sin(2*pi*tempRotationAngle/360), 0>;    // license is pushing up head.
   
      //////////////// Modify slug position to compensate for license straightening out.
      #declare slug_MoveButt = slug_MoveButt*(1-My_clock3);     // license pushing up butt.
      #declare slug_MoveThorax = slug_MoveThorax*(1-My_clock3);    // license is pushing up thorax.
      #declare slug_MoveHead =  slug_MoveHead*(1-My_clock3);    // license is pushing up head. 
   
   #declare slug_LookAt = <2.5,0.01, -2.0>;
   #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0,0,0.02>;
   #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0.02, 0, -0.01>;      
       
   
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 180*y 
      translate (<10-0.15,0.01,0>+<0,0.001*My_clock2,0>)
   }
     
   ///////////////////////
   // Snack
   ///////////////////////
   #include "snack.inc"
   object {LongSnack1b rotate y*90 translate <10-0.15, 0.01, 0.07> translate (<0,0.001,0>*My_clock2)}
   
   ////////////////////////
   // Driver's Licence
   ////////////////////////
   #include "dlicence.inc"
   object
   {
      object {DLicence}
      rotate tempRotationAngle*x*(1-My_clock3)
      translate <0,0.08854*sin(2*pi*tempRotationAngle/360)*(1-My_clock3), -0.08 +0.08*My_clock3>
      translate <10-0.23, 0.01,-0.0> 
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.4, 0.08,0.09>; 
   #declare camera_look_at = <10-0.1,0.02,-0.03> ;  
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence12;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence13.                         clock goes from 12.25 to 13.75        Bring the slug out of the grass!!! oh, baby.
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@  
   #declare Sequence13 = 1.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence13) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence13;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence13/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #if (My_clock1 < 0.95)            // kick the trees out in this sequence.
      #include "trees.inc"     
      object {Tree translate <80,0,-20>} 
      object {tree_Branch translate <30,0,5>}
   #end
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #if (My_clock1 < 0.75)           // Say goodby to grass. Well, for awile anyway.
      #include "grass.inc"
      object {GrassBlock translate <12.5,0,0>}
      object {slugStand translate <9.5,0,0>}
   #end
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////   
      #if (My_clock2 < 0.1666)
         #declare slug_LookAt = <2.5,0.01, -2.0> +<-2.43, -0.01, 2.00>*(My_clock2/0.1666);
      #else
         #declare slug_LookAt = <0.07,0.00, -0.19>;
      #end
      
      #if (My_clock2 < 0.666)             // move eyes back to new location.
         #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>*(1-(My_clock2/0.666)) +<0, 0, 0.03>*(My_clock2/0.666);
         #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0.02, 0, -0.01>*(1-(My_clock2/0.666)) +<0, 0, 0.03>*(My_clock2/0.666);
      #else
         #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03>;
         #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03>; 
      #end  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y*My_clock3    // rotate the license-slug-snack object all together.
      translate (<7.8, 0.01, 0> +<0, 3.49, 0>*My_clock3) // move the license-slug-snack object all together. 
   } // end of license, slug, snack object.  
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.4, 0.08,0.09> +<-1.8, 0, 0> +<1.8*cos(90*My_clock3*pi/180), 3.49*My_clock3, 2.11*sin(90*My_clock3*pi/180)> ; 
   #declare camera_look_at = <10-0.1,0.02,-0.03> +<-2.1, 0, 0> +<2.1*cos(90*My_clock3*pi/180), 3.49*My_clock3, 2.23*sin(90*My_clock3*pi/180)>;  
   
   // compensate for rotational x <--> z translations
   #declare camera_location = camera_location + <-0.09, 0, -0.4>*My_clock3; 
   #declare camera_look_at  = camera_look_at + <0.03, 0, -0.1>*My_clock3;
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence13;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence14.                                   Clock goes from 13.75 to 14.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence14 = 0.5;  // Dont change this, without redoing acceleration, velocity and position.
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence14) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence14;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence14/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if (My_clock2 < 0.5 )   
           #declare slug_LookAt = <0.07,0.00, -0.19> +<1.93, -3.5, -8.81>*(My_clock2*2); 
      #else
           #declare slug_LookAt = <2, -3.5, -9>;
      #end
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03>;      
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      translate <7.8, 3.50, 0> + <-0.5*6*(My_clock1*My_clock1), 0, 0> // move the license-slug-snack object all together. 
                                                                     // Accelerate to 3 ft/s 
                                                                     // translation ends at <7.05, 3.5, 0>
                 +<0, -0.01+0.01*cos(pi*My_clock2/2), 0> // and a little more for the upcoming step. 
   } // end of license, slug, snack object.  
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-2.2-0.09, 3.57, 2.2-0.4> +<-0.5*6*(My_clock1*My_clock1), 0, 0> 
   #declare camera_look_at =  <10-2.2+0.03, 3.51, 2.2-0.1> +<-0.5*6*(My_clock1*My_clock1), 0, 0>
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence14;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence15.                clock goes from 14.25 to 15.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence15 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence15) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence15;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence15/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////   
      #declare slug_LookAt = <2, -3.5, -9> + <0, 0, 3*My_clock2>;
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03> +<0, 0, -0.03*My_clock2>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03> +<0, 0, -0.03*My_clock2>;
      
      ////////////////////////// bounce for step ///////////
      #if (My_clock2 < 0.125)
         #declare slug_LeftEye = slug_LeftEye +<0, -0.01*(My_clock2/0.125), 0> 
         #declare slug_RightEye = slug_RightEye +<0, -0.01*(My_clock2/0.125), 0>
      #else
         #declare slug_LeftEye = slug_LeftEye +<0, -0.01 +0.01*((My_clock2-0.125)/0.875), 0> 
         #declare slug_RightEye = slug_RightEye +<0, -0.01 +0.01*((My_clock2-0.125)/0.825), 0>
      #end   ///////// End bounce for step.    
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      translate <7.05, 3.50, 0> + <-3*(My_clock1), 0, 0> // move the license-slug-snack object all together. 
                                                                     // Move to left at to 3 ft/s 
                                                                     // translation ends at <4.05, 3.5, 0>
                 +<0, -0.01+0.01*sin(pi*My_clock2), 0> // and a little more for the step. 
   } // end of license, slug, snack object.  
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <7.05-0.09, 3.57, 2.2-0.4> +<-3*(My_clock1), 0, 0> +<0, 0, -0.04*My_clock2>; 
   #declare camera_look_at =  <7.05+0.03, 3.51, 2.2-0.1> +<-3*(My_clock1), 0, 0>;
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence15;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence16.                    clock goes from 15.25 to 16.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence16 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence16) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence16;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence16/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////   
      #declare slug_LookAt = <2, -3.5, -6> + <0, 0, 3*My_clock2>;
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0> +<0, 0, -0.03*My_clock2>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0> +<0, 0, -0.03*My_clock2>;
      
      ////////////////////////// bounce for step ///////////
      #if (My_clock2 < 0.125)
         #declare slug_LeftEye = slug_LeftEye +<0, -0.01*(My_clock2/0.125), 0> 
         #declare slug_RightEye = slug_RightEye +<0, -0.01*(My_clock2/0.125), 0>
      #else
         #declare slug_LeftEye = slug_LeftEye +<0, -0.01 +0.01*((My_clock2-0.125)/0.875), 0> 
         #declare slug_RightEye = slug_RightEye +<0, -0.01 +0.01*((My_clock2-0.125)/0.825), 0>
      #end   ///////// End bounce for step.    
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      translate <4.05, 3.50, 0> + <-3*(My_clock1), 0, 0> // move the license-slug-snack object all together. 
                                                                     // Move to left at to 3 ft/s 
                                                                     // translation ends at <4.05, 3.5, 0>
                 +<0, -0.01+0.01*sin(pi*My_clock2), 0> // and a little more for the step. 
   } // end of license, slug, snack object.  
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <4.05-0.09, 3.57, 2.2-0.44> +<-3*(My_clock1), 0, 0> +<0, 0, -0.04*My_clock2>; 
   #declare camera_look_at =  <4.05+0.03, 3.51, 2.2-0.1> +<-3*(My_clock1), 0, 0>;
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence16;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence17.                 clock goes from 16.25 to 16.75
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence17 = 0.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence17) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence17;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence17/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>} 
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if (My_clock2 < 0.5)   
         #declare slug_LookAt = <2, -3.5, -3> +<2, 8.0, -1>*My_clock2/0.5;
         #declare slug_Eyelids = 1 + 0.2*My_clock2;
      #else
         #declare slug_LookAt = <4, 5.5, -4>
         #declare slug_Eyelids = 1.2;
      #end
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, -0.03> +<0, 0, 0.015*My_clock2>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, -0.03> +<0, 0, 0.015*My_clock2>;
      
      ////////////////////////// bounce for step ///////////
      #if (My_clock2 < 0.125)
         #declare slug_LeftEye = slug_LeftEye +<0, -0.01*(My_clock2/0.125), 0> 
         #declare slug_RightEye = slug_RightEye +<0, -0.01*(My_clock2/0.125), 0>
      #else
         #declare slug_LeftEye = slug_LeftEye +<0, -0.01 +0.01*((My_clock2-0.125)/0.875), 0> 
         #declare slug_RightEye = slug_RightEye +<0, -0.01 +0.01*((My_clock2-0.125)/0.825), 0>
      #end   ///////// End bounce for step.    
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      translate <1.05, 3.50, 0> +<-3*My_clock1, 0, 0> +<0.5*6*(My_clock1*My_clock1),0,0>// move the license-slug-snack object all together. 
                                                                     // Move to left at to 3 ft/s, decelerating to 0 ft/s 
                                                                     // translation ends at <0.3, 3.5, 0>
                 +<0, -0.01+0.01*sin(pi*My_clock2/2), 0> // and a little more for the step. 
   } // end of license, slug, snack object.  
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <1.05-0.09, 3.57, 2.2-0.48> +<-3*My_clock1, 0, 0> +<0.5*6*(My_clock1*My_clock1),0,0> +<0, 0, -0.02*My_clock2>; 
   #declare camera_look_at =  <1.05+0.03, 3.51, 2.2-0.1> +<-3*My_clock1, 0, 0> +<0.5*6*(My_clock1*My_clock1),0,0>;
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence17;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence18.                             clock goes from 16.75 to 17.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence18 = 0.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence18) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence18;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence18/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if (My_clock2 < 0.5)   
         #declare slug_LookAt = <4, 5.5, -4> +<0, -6.0, 0>*My_clock2/0.5;
         #declare slug_Eyelids = 1.2 -0.1*My_clock2;
      #else
         #declare slug_LookAt = <4, -0.5, -4>
         #declare slug_Eyelids = 1.1;
      #end
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, -0.015> +<0, 0, 0.015*My_clock2>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, -0.015> +<0, 0, 0.015*My_clock2>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      translate <0.3, 3.50, 0>                  // move the license-slug-snack object all together. 
                                                                      
   } // end of license, slug, snack object.  
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0.3 -0.09, 3.57, 2.2-0.50> +<0, 0, -0.02*My_clock2>;
   #declare camera_look_at =  <0.3 +0.03, 3.51, 2.2-0.1>; 
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence18;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence19.                          clock goes from 17.25 to 18.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence19 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence19) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence19;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence19/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   //object {Tree translate <-16,0,80>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////

         #declare slug_LookAt = <4, -0.5, -4> +<-4, +0.5, 3.88>*My_clock2; 
         #declare slug_Eyelids = 1.1;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.0> +<0, 0, 0.03*My_clock2>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.0> +<0, 0, 0.03*My_clock2>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      rotate (0+ 22.5*My_clock2)*z      // rotate to get slug in rocket.
      translate <0.3, 3.50, 0>                  // move the license-slug-snack object all together. 
                                                                      
   } // end of license, slug, snack object. 
   
   /////////////////////////////
   // Rocket Top
   /////////////////////////////
   #include "rocket.inc"
   object 
   {
      rocket_Top
      translate <0.22, 3.16, 2.05>  // Desired position.
                + <-0.25, 0, -0.25>*(1-My_clock3) // minus starting position
                
                +<0.02, 0.005,0.003>*sin(2*pi*0.5*clock)  // plus some noise like stuff
                +<0.003, 0.003, 0.015>*sin(2*pi*0.7765*clock +pi/4)
                +<0.007, 0.001, 0.003>*sin(2*pi*1.2*clock +pi/4)
                +<0.002, 0.001, 0.002>*sin(2*pi*1.5*clock +pi/4)
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0.3 -0.09, 3.57, 2.2-0.52>  +<-0.2, 0, 0.05>*My_clock3;
   #declare camera_look_at =  <0.3 +0.03, 3.51, 2.2-0.1>    +<0,-0.02,0>*My_clock2;
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence19;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence20.                   clock goes from 18.25 to 19.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence20 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence20) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence20;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence20/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   //object {Tree translate <-16,0,80>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////       
      #if (My_clock2 < 0.75)
         #if (My_clock2 < 0.25)
            #declare slug_LookAt = <0, 0, -0.12> +<0.63, 0.25, -0.37>*My_clock2;
            #declare slug_Eyelids = 1.1 +0.5*My_clock2;
         #else
            #declare slug_LookAt = <0, 0, -0.12> +<0.63, 0.25, -0.37> +<0.25, 0.07,0>*(My_clock2-0.25)/0.75;
            #declare slug_Eyelids = 1.6;
            #declare slug_PupilSize = 1.0 -0.3*(My_clock2-0.25)/0.75;
         #end
      #else 
         #declare slug_PupilSize = 0.7;
         #declare slug_LookAt = <0, 0, -0.12> + (<0.63, 0.25, -0.37> +<0.25, 0.07,0>)*(1- (My_clock2-0.75)/0.25);
         #declare slug_Eyelids = 1.2 +0.4*(1- (My_clock2-0.75)/0.25);
      #end
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03> ;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03> ;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
      }
     
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object {LongSnack1b rotate y*90 translate <-0.15, 0.001, 0.07>}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      rotate (22.5+ 22.5*My_clock2)*z      // rotate to get slug in rocket.
      translate <0.3, 3.50, 0>                  // move the license-slug-snack object all together. 
                                                                      
   } // end of license, slug, snack object. 
   
   /////////////////////////////
   // Rocket Top
   /////////////////////////////
   #include "rocket.inc"
   object 
   {
      rocket_Top
      translate <0.22, 3.16, 2.05>  // Desired position.
                
                +<0.02, 0.005,0.003>*sin(2*pi*0.5*clock)  // plus some noise like stuff
                +<0.003, 0.003, 0.015>*sin(2*pi*0.7765*clock +pi/4)
                +<0.007, 0.001, 0.003>*sin(2*pi*1.2*clock +pi/4)
                +<0.002, 0.001, 0.002>*sin(2*pi*1.5*clock +pi/4)
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0.3 -0.29, 3.57, 2.2-0.47>;
   #declare camera_look_at =  <0.3 +0.03, 3.49, 2.2-0.1>    +<0,-0.02,0>*My_clock2;
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence20;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence21.                                clock goes from 19.25 to 20.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence21 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence21) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence21;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence21/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   //object {Tree translate <-16,0,80>}
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////       

      #declare slug_PupilSize = 0.7;
      #declare slug_LookAt = <0, 0, -0.12>;
      #declare slug_Eyelids = 1.2; 
      #declare slug_Stretch = 1-0.2*My_clock2*My_clock2;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03> +<0, 0, 0.02*My_clock2>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.03> +<0, 0, 0.02*My_clock2>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)
         #if (My_clock2 > 0.2)
            translate <0,0,0.07*(My_clock2-0.2)/0.8>      // Slug is sliding.
         #end 
      }
      
      #declare snack_acc_temp = 3*My_clock1*My_clock1
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         rotate y*90 
         translate <-0.15, 0.001, 0.07>
         translate <0,0,snack_acc_temp> // We're dropping the snack.
      }
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together.
      rotate (45+ 22.5*My_clock2)*z      // rotate to get slug in rocket.
      translate <0.3, 3.50, 0>                  // move the license-slug-snack object all together. 
                                                                      
   } // end of license, slug, snack object. 
   
   /////////////////////////////
   // Rocket Top
   /////////////////////////////
   include "rocket.inc"
   object 
   {
      rocket_Top
      translate <0.22, 3.16, 2.05>  // Desired position.
                
                +<0.02, 0.005,0.003>*sin(2*pi*0.5*clock)  // plus some noise like stuff
                +<0.003, 0.003, 0.015>*sin(2*pi*0.7765*clock +pi/4)
                +<0.007, 0.001, 0.003>*sin(2*pi*1.2*clock +pi/4)
                +<0.002, 0.001, 0.002>*sin(2*pi*1.5*clock +pi/4)
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0.3 -0.29, 3.57, 2.2-0.47> 
   #declare camera_look_at =  <0.3 +0.03, 3.47, 2.2-0.1>    +<0,-0.02,0>*My_clock2
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence21;   
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence22.                            clock goes from 20.25 to 20.75
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence22 = 0.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence22) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence22;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence22/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   //#include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   //object {tree_Branch translate <30,0,5>}
   #include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>}
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   //object {Tree translate <-16,0,80>} 
   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>}
   
   
   /////////////////////////////////////////////////////
   // Group license, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   union
   { 
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////       

      #declare slug_PupilSize = 0.7;
      #declare slug_LookAt = <0, 0, -0.12>;
      #declare slug_Eyelids = 1.2;
      #if (My_clock2 < 0.2) 
         #declare slug_Stretch = 0.8 +0.2*(My_clock3-0.2)/0.8;
      #end
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.05>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.05>;
      
      #if (My_clock2 < 0.3)   // slug out of view anyway. Prepare new eye positions
         #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
         #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #end  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*y 
         translate (<-0.15,0.001,0>)  
         
         translate <0,0,0.07> +<0, 0, 8*My_clock1*My_clock1>     // Slug is falling. 
      }
        
        
      ///////////////////////
      // Snack
      ///////////////////////
      //#include "snack.inc"
      //object 
      //{
      //   LongSnack1b 
      //   rotate y*90 
      //   translate <-0.15, 0.001, 0.07>
      //}
   
      ////////////////////////
      // Driver's Licence
      ////////////////////////
      #include "dlicence.inc"
      object
      {
         object {DLicence}
         translate <-0.23, 0,-0.0> 
      }
      translate <2.2, 0, 0> // Length of invader's forearm
      
      rotate -90*y    // rotate the license-slug-snack object all together, and speed it up a little this time.
      #if (My_clock2 < 0.3 )
         rotate (67.5 + (22.5)*My_clock2)*z      // rotate to get slug in rocket.
      #else 
         rotate  ((67.5 + (22.5)*My_clock2)*z - (0.5)*(-22.5)*(My_clock2-0.3)*(My_clock2-0.3) ) // decelerate angular movement
      #end
      translate <0.3, 3.50, 0>                  // move the license-slug-snack object all together. 
                                                                      
   } // end of license, slug, snack object.

   /////////////////////////////
   // Rocket Top
   /////////////////////////////
   include "rocket.inc"
   object 
   {
      rocket_Top
      translate <0.22, 3.16, 2.05>  // Desired position.
                
                +<0.02, 0.005,0.003>*sin(2*pi*0.5*clock)  // plus some noise like stuff
                +<0.003, 0.003, 0.015>*sin(2*pi*0.7765*clock +pi/4)
                +<0.007, 0.001, 0.003>*sin(2*pi*1.2*clock +pi/4)
                +<0.002, 0.001, 0.002>*sin(2*pi*1.5*clock +pi/4)
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0.3 -0.29, 3.57, 2.2-0.47> 
   #declare camera_look_at =  <0.3 +0.03, 3.45, 2.2-0.1>    
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence22;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   //
   //     Break. Camera Changes position. Break Camera changes position. We can start fresh. Break Break Break Break. 
   //
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
    
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence23.                         clock goes from 20.75 to 21.75
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence23 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence23) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence23;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence23/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object      // nosecone
         {
            rocket_NoseCone 
            translate <0, 1.9, 0> +<-0.4, 0.4, -0.4>
         } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////       

      #declare slug_LookAt = <0.5, 0, -1.12>;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      
      translate <0, 0, 2.2>  // length of arm      
      translate <0, 0, -2.2>
      translate <0, 1, 0>
      translate <4.5, 0, 0>                                                                
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.4, -0.7> +<0,1,0> +<4.5, 0, 0>; //  moderate close up
   #declare camera_look_at =  <0, 2.47,0> +<0,1,0> +<4.5, 0, 0>; 
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence23; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 24                           clock goes from 21.75 to 22.75
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence24 = 1.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence24) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence24;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence24/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object      // nosecone
         {
            rocket_NoseCone 
            translate <0, 1.9, 0> +<-0.4, 0.4, -0.4> +<0.4, -0.35, 0.4>*My_clock3
         } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////       
      #if (My_clock2 < 0.25)
         #declare slug_LookAt = <0.5, 0, -1.12> + <-0.5, 0.2, 0.97>*My_clock2/0.25;
      #else
         #declare slug_LookAt = <0, 0.2, -0.15>;
      #end
      
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      
      translate <0, 0, 2.2>  // length of arm      
      translate <0, 0, -2.2>
      translate <0, 1, 0>
      translate <4.5, 0, 0>                                                                
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.4, -0.7> +<0,1,0> +<4.5, 0, 0>; //  moderate close up
   #declare camera_look_at =  <0, 2.47,0> +<0,1,0> +<4.5, 0, 0>; 
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence24; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 25                clock goes from 22.75 to 25.75
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 
   #declare Sequence25 = 3.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence25) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence25;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence25/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   //Temporary clocks for nosecone screwing.
   #declare My_clock1over3 = My_clock2/0.333;
   #if (My_clock1over3 < 0.5)
      #declare My_clock5 = 2*My_clock1over3*My_clock1over3;
   #else 
      #declare My_clock5 = 1-( (1.0-My_clock1over3)*(1-My_clock1over3)*2.0 );
   #end
   #declare My_clock2over3 = (My_clock2-0.333)/0.333;
   #if (My_clock2over3 < 0.5)
      #declare My_clock6 = 2*My_clock2over3*My_clock2over3;
   #else 
      #declare My_clock6 = 1-( (1.0-My_clock2over3)*(1-My_clock2over3)*2.0 );
   #end
   #declare My_clock3over3 = (My_clock2-0.666)/0.333;
   #if (My_clock3over3 < 0.5)
      #declare My_clock7 = 2*My_clock3over3*My_clock3over3;
   #else 
      #declare My_clock7 = 1-( (1.0-My_clock3over3)*(1-My_clock3over3)*2.0 );
   #end
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object      // nosecone
         {
            rocket_NoseCone
            #if (My_clock2 < 0.333) 
               translate <0, 1.9, 0> +<0, 0.05, 0> +<0, -0.05*0.333*(My_clock5),0>
               rotate 45*y*My_clock5
            #end
            #if ( (0.333 <= My_clock2) & (My_clock2 < 0.666) )
               translate <0, 1.9, 0> +<0, 0.05, 0> +<0, -0.05*0.333 -0.05*0.333*(My_clock6),0>
               rotate (45*y -45*y*My_clock6)
            #end 
            #if (0.666 <= My_clock2)
               translate <0, 1.9, 0> +<0, 0.05, 0> +<0, -0.05*0.666 -0.05*0.333*(My_clock7),0>
               rotate (45*y*My_clock7)
            #end
               
         } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if (My_clock2 < 0.75)       
         #declare slug_LookAt = <0, 0.2, -0.15>;
      #end
      #if ( (0.75 <= My_clock2) & (My_clock2 < 0.8333) )
         #declare slug_LookAt = <0, 0.2, -0.15> + <10, -2.2, -9.85>*(My_clock2-0.75)/0.0833;
      #end
      #if (0.8333 <= My_clock2)
         #declare slug_LookAt = <10, -2, -10>;
      #end
      
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      
      translate <0, 0, 2.2>  // length of arm      
      translate <0, 0, -2.2>
      translate <0, 1, 0>
      translate <4.5, 0, 0>                                                                
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.4, -0.7> +<0,1,0> +<4.5, 0, 0>; //  moderate close up
   #declare camera_look_at =  <0, 2.47,0> +<0,1,0> +<4.5, 0, 0>; 
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence25; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 26               clock goes from 25.75 to 26.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence26 = 0.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence26) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence26;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence26/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare slug_LookAt = <10, -2, -10>;

      
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      
      translate <0, 0, 2.2>  // length of arm      
      translate <0, 0, -2.2>
      translate <0, 1, 0>
      translate <4.5, 0, 0>                                                                
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.4, -0.7> +<0,1,0> +<4.5, 0, 0>; //  moderate close up
   #declare camera_look_at =  <0, 2.47,0> +<0,1,0> +<4.5, 0, 0>; 
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence26; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 27_1              clock goes from 26.25 to 27.75
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence27_1 = 1.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence27_1) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence27_1;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence27_1/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare slug_LookAt = <10, -2, -10> +<-7.8-10, -2+2, -12.2+10>*My_clock3 // not technically accurate rotation movement, but close enough
                                           +<0,0,-2.25>*My_clock3; // a little more for locamotion movement.
      
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      
      translate <0, 0, 2.2>  // length of arm
      rotate -90*y*My_clock3 // rotate to the west.
            
      translate <0, 0, -2.2>
      translate <0, 1, 0>
      translate <4.5, 0, 0> +<-2.25,0,0>*My_clock2*My_clock2     // moving to the west too (not just rotating)                                                          
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.4, -0.7> +<0,1,0> +<4.5, 0, 0> //  moderate close up
                              +<0.7-2.2, 0, 0.7-2.2>*My_clock3 // rotate to the west
                              +<-2.25,0,0>*My_clock2*My_clock2 // moving to the west too.
                              +<-0.12, -0.0075, 0>*My_clock2; // we're zooming in as well.
   #declare camera_look_at =  <0, 2.47,0> +<0,1,0> +<4.5, 0, 0>
                              +<-2.2, 0, -2.2>*My_clock3 // rotate to the west
                              +<-2.25,0,0>*My_clock2*My_clock2 // moving to the west too.
                              +<0, -0.021, 0>*My_clock2; // we're zooming in as well. 
   
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence27_1; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 27_2                            clock goes from 27.75 to 29.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 
   #declare Sequence27_2 = 1.5; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence27_2) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence27_2;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence27_2/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if (My_clock2 < 0.2)
         #declare slug_LookAt = <-7.8, -2, -14.45> +<0,0,9.45>*(My_clock3-0.2)/0.8;
      #else
         #declare slug_LookAt = <-7.8, -2, -5> +<7.8+3.8, 2-2, 5-10>*(My_clock3-0.2)/0.8  
                                           +<2.25,0,0>*(My_clock3-0.2)/0.8 // a little more for locamotion movement.
                                           +<0,-3,0>*(My_clock3-0.2)/0.8; // We're moving on up.
      #end
      
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      
      translate <0, 0, 2.2>  // length of arm
      rotate -90*y +90*y*My_clock3 // rotate back to the north.
            
      translate <0, 0, -2.2>
      translate <0, 1, 0>
      translate <4.5, 0, 0> +<-2.25,0,0> +<-2.25,0,0>*(1-(1-My_clock2)*(1-My_clock2) )     // moving to the west too
      translate <0,3,0>*My_clock3 // we're moving on up.                                                           
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.4, -0.7> +<0,1,0> +<4.5, 0, 0> //  moderate close up
                              +<0.7-2.2, 0, 0.7-2.2> // rotated to the west
                              +<2.2-0.7, 0, 2.2-0.7>*My_clock3 // rotate back to north.
                              +<-2.25,0,0> +<-2.25,0,0>*(1-(1-My_clock2)*(1-My_clock2) ) // moving to the west too.
                              +<0,3,0>*My_clock3 // we're moving on up.
                              +<-0.12, -0.0075, 0> +<0.12, -0.0075, 0.24>*My_clock2; //We're zooming in as well.
   #declare camera_look_at =  <0, 2.47,0> +<0,1,0> +<4.5, 0, 0>
                              +<-2.2, 0, -2.2> // rotated to the west
                              +<2.2, 0, 2.2>*My_clock3 // rotate back to north.
                              +<-2.25,0,0> +<-2.25,0,0>*(1-(1-My_clock2)*(1-My_clock2) ) // moving to the west too. 
                              +<0,3,0>*My_clock3 // we're moving on up.
                              +<0, -0.021, 0> +<0, -0.021, 0>*My_clock2; //We're zooming in as well.
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence27_2; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 28                                clock goes from 29.25 to 31.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 
   #declare Sequence28 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence28) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence28;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence28/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if(My_clock2 < 0.125)
         #declare slug_LookAt = <6.05, -5, -10> +<-6.06, 5, 9.95>*My_clock2;  // look at snack
      #else
         #declare  slug_LookAt = <-0.01,0,-0.05>; 
      #end   
      
      #declare slug_Eyelids = 1.0 +0.2*My_clock2;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth      

      translate <0,4,0> +<0,-4,0>*My_clock3// we're moving on down.                                                           
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.4, -0.7>  //  moderate close up
                              +<0,4,0> +<0,-4,0>*My_clock3 // we're moving on down.
                              +<0,-0.015,0.24> +<0,-0.01,0.16>*My_clock2; // We're zooming in.
   #declare camera_look_at =  <0, 2.47,0>  
                              +<0,4,0> +<0,-4,0>*My_clock3 // we're moving on down.
                              +<0,-0.042,0> +<0,-0.028,0>*My_clock2; // We're zooming in.
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence28; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 29                         clock goes from 31.25 to 32
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 
   #declare Sequence29 = 0.75; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence29) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence29;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence29/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare  slug_LookAt = <-0.01,0,-0.05>; 
      
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth                                                             
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <0, 2.375, -0.3>;  //   close up
   #declare camera_look_at =  <0, 2.40,0>;    
               
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence29; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 30_1                               clock goes from 32 to 34
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 
   #declare Sequence30_1 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence30_1) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence30_1;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence30_1/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   /////////// Temporary clocks for this sequence only ///////////////////
   #declare My_clock5 = My_clock2*2; // My_clock5 counts from 0 to 2.
   #declare My_clock6 = My_clock5 - 0.25; // My_clock6 Becomes 0 and starts counting at first 1/8 of sequence.
   #declare My_clock7 = My_clock5 - 1.75; // My_clock7 Becomes 0 and starts counting at last 1/8 of sequence.  
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <12.5,0,0>}
   //object {slugStand translate <9.5,0,0>} 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare  slug_LookAt = <-0.01,0,-0.05>; 
      
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth                                                             
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #if (My_clock5 < 0.25) 
      #declare camera_location =  <0, 2.375, -0.3>
                                  +<0, -0.5*2*My_clock5*My_clock5,0>; // accelerate at 2 ft/sec^2 for 0.25 seconds. Ends 0.0625 ft lower.  
      #declare camera_look_at =  <0, 2.40,0>
                                 +<0, -0.5*2*My_clock5*My_clock5,0>; // accelerate at 2 ft/sec^2 for 0.25 seconds. Ends 0.625 ft lower.
   #end
   #if ( (0.25 <= My_clock5) & (My_clock5 < 1.75))
      #declare camera_location =  <0, 2.375, -0.3>
                                  +<0, -0.0625, 0> +<0, -0.5*My_clock6, 0>; // Decend at 0.5 ft/sec for 1.5 seconds. Ends 0.0625+0.75=0.8125 lower.  
      #declare camera_look_at =  <0, 2.40,0>
                                 +<0, -0.0625, 0> +<0, -0.5*My_clock6, 0>; // Decend at 0.5 ft/sec for 1.5 seconds. Ends 0.0625+0.75=0.8125 lower.
   #end
   #if (1.75 <= My_clock5)
      #declare camera_location =  <0, 2.375, -0.3>
                                  +<0, -0.0625, 0> +<0, -0.5*My_clock6, 0> 
                                  +<0, 0.5*2*My_clock7*My_clock7,0>;// decelerate at 2 ft/sec^2. Ends 0.0625+.75+0.625=0.875 ft lower.  
      #declare camera_look_at =  <0, 2.40,0>
                                 +<0, -0.0625, 0> +<0, -0.5*My_clock6, 0> 
                                 +<0, 0.5*2*My_clock7*My_clock7,0>;// decelerate at 2 ft/sec^2. Ends 0.0625+.75+0.625=0.875 ft lower.
   #end
      
                                 
   
     
                              
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence30_1; 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 30_2                              clock goes from 34 to 36
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence30_2 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence30_2) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence30_2;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence30_2/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock}
 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   /////////////////////////////
   // Igniter hack
   // This is a hack thrown in at the last minute for added realizm
   /////////////////////////////////////////////////////////////////
   union
   {
      blob {threshold 0.9 cylinder {<0,0.7+0.5,0>, <0.3,0.8,-0.6> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.3,0.8,-0.6>, <0.4,0.4,-1.3> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.4,0.4,-1.3>, <1,0.3,-3> 0.03, 1}}
      pigment {color <0.15,0.15,0.15>}
   }
      
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare  slug_LookAt = <-0.01,0,-0.05>; 
      
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth                                                             
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////
      #declare camera_location =  <0, 2.375, -0.3>
                                  +<0, -0.875, 0>
                                  +<0,-2.375+0.875,0.3>*My_clock3 +<0,6,-1.0>*My_clock3; // slowly move up and away.
      #declare camera_look_at =  <0, 2.40,0>
                                 +<0, -0.875, 0>
                                 +<0,-2.4+0.875,0>*My_clock3 +<0,0, -0.2>*My_clock3;
                              
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence30_2;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   //
   //     Break. Camera Changes position. Break Camera changes position. We can start fresh. Break Break Break Break. 
   //
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 
 
 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 31                              clock goes from 36 to 38
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence31 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence31) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence31;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence31/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <2.5,0,0> +<2.5,0,0>} 
 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   /////////////////////////////
   // Igniter hack
   // This is a hack thrown in at the last minute for added realizm
   /////////////////////////////////////////////////////////////////
   union
   {
      blob {threshold 0.9 cylinder {<0,0.7+0.5,0>, <0.3,0.8,-0.6> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.3,0.8,-0.6>, <0.4,0.4,-1.3> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.4,0.4,-1.3>, <1,0.3,-3> 0.03, 1}}
      pigment {color <0.15,0.15,0.15>}
   }
      
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare  slug_LookAt = <-0.01,0,-0.05>; 
      
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth                                                             
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////   
   #declare camera_location = <5.8, 0.38, -0> +<2.5,0,0>; // ball park in background 
   #declare camera_look_at =  <0, 1.3,0>;
                           
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence31;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   //
   //     Break. Camera Changes position. Break Camera changes position. We can start fresh. Break Break Break Break. 
   //
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 32                      clock goes from 38 to 47                                    Suspense shot.
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence32 = 9.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence32) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence32;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence32/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   ////// Temporary clock for this sequence only.
   #declare My_clock5 = My_clock1 - 0.5;

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <2.5,0,0> +<2.5,0,0>} 
 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   /////////////////////////////
   // Igniter hack
   // This is a hack thrown in at the last minute for added realizm
   /////////////////////////////////////////////////////////////////
   union
   {
      blob {threshold 0.9 cylinder {<0,0.7+0.5,0>, <0.3,0.8,-0.6> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.3,0.8,-0.6>, <0.4,0.4,-1.3> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.4,0.4,-1.3>, <1,0.3,-3> 0.03, 1}}
      pigment {color <0.15,0.15,0.15>}
   }
      
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare  slug_LookAt = <0,0,-10>; 
      
      #declare slug_Eyelids = 0.8;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      
      #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
   #declare slug_ScaleMouth = <0.9 + 0.2*sin(2*pi*clock+pi/8),1>;        // part of chewing.
      
      #if (My_clock1 < 0.5)
         #declare slug_MoveHead = <0,0,-0.015> +<0,0,0.0075>*My_clock1*My_clock1/0.25; // accelerate head back
      #end
      #if ( (0.5 <= My_clock1) & (My_clock1 < 1.0))
         #declare slug_MoveHead = <0,0,-0.0075> +<0,0,0.0075>*(1-(0.5-My_clock5)*(0.5-My_clock5)/0.25); // decelerate head back.
      #end
      #if (1.0 <= My_clock1)
         #declare slug_MoveHead = <0,0,0>; // head is back.
      #end  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack2b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth                                                             
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////   
   #declare camera_location = <0, 2.375, -0.3>;
   #declare camera_look_at =  <0, 2.40,0>; 
   
   #declare camera_location = <0.3*sin(2*pi*0.333*My_clock2 -pi/3), 2.375, -0.3*cos(2*pi*0.333*My_clock2 -pi/3)>;
   #declare camera_look_at =  <0, 2.40,0>;

                           
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence32;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 33                            clock 47 to 47.25                                        Lift-off
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence33 = 0.25; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence33) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence33;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence33/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   ////// Temporary clock for this sequence only.
   #declare My_clock5 = My_clock1 - 0.5;

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   //#include "grass.inc"
   //object {GrassBlock translate <2.5,0,0> +<2.5,0,0>} 
 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   /////////////////////////////
   // Igniter hack
   // This is a hack thrown in at the last minute for added realizm
   /////////////////////////////////////////////////////////////////
   union
   {
      blob {threshold 0.9 cylinder {<0,0.7+0.5,0>, <0.3,0.8,-0.6> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.3,0.8,-0.6>, <0.4,0.4,-1.3> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.4,0.4,-1.3>, <1,0.3,-3> 0.03, 1}}
      pigment {color <0.15,0.15,0.15>}
   }
      
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         //light_source                                        // Engine burn
         //{
         //   <0,0.01,0> 0
         //   looks_like
         //   {   
         //      cone 
         //      {
         //         <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
         //         pigment { colour White }
         //         finish { ambient 1.0 diffuse 0.0 }
         //      }
         //   }
         //} // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare  slug_LookAt = <0,0,-10>; 
      
      #declare slug_Eyelids = 0.8;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>   +<0, -0.02, 0>*My_clock3;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02> +<0, -0.02, 0>*My_clock3;
      
      #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
   #declare slug_ScaleMouth = <1 + 0.3*sin(2*pi*clock+pi/4),1>;        // part of chewing.
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack2b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      translate <0, 0.5*4*My_clock1*My_clock1, 0> // Accelerate up at 4 ft/sec^2, before moving to 12 ft/sec^2.                                                             
   } // end of rocket, slug, snack object. 
   
   
   ///////////////////////////
   // Camera
   ///////////////////////////   
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
   
   #declare camera_location = <0.3*sin(2*pi*0.333*(1+My_clock2/36) -pi/3), 2.375, -0.3*cos(2*pi*0.333*(1+My_clock2/36) -pi/3)>;
   #declare camera_look_at =  <0, 2.40,0>;

                           
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence33;
    //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   //
   //     Break. Camera Changes position. Break Camera changes position. We can start fresh. Break Break Break Break. 
   //
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 34                         clock goes from 47.25 to 49.25              Smoke shot
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence34 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence34) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence34;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence34/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
   #if (My_clock2 < 0.25)
      ////////////////////
      // Grass (Real stuff) 
      ////////////////////    
      #include "grass.inc"
      object {GrassBlock translate <2.5,0,0> +<2.5,0,0>}
   #end 
 
   
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   /////////////////////////////
   // Igniter hack
   // This is a hack thrown in at the last minute for added realizm
   /////////////////////////////////////////////////////////////////
   union
   {
      blob {threshold 0.9 cylinder {<0,0.7+0.5,0>, <0.3,0.8,-0.6> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.3,0.8,-0.6>, <0.4,0.4,-1.3> 0.03, 1}}
      blob {threshold 0.9 cylinder {<0.4,0.4,-1.3>, <1,0.3,-3> 0.03, 1}}
      pigment {color <0.15,0.15,0.15>}
   }
      
   
   
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         light_source                                        // Engine burn
         {
            <0,0.01,0> 0
            looks_like
            {   
               cone 
               {
                  <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
                  pigment { colour White }
                  finish { ambient 1.0 diffuse 0.0 }
               }
            }
         } // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         #declare  slug_LookAt = <-0.01,0,-0.05>; 
      
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
           
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02> +<0, -0.01, 0>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02> +<0, -0.01, 0>;  
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack1b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      translate <0,+1.5+0.15, 0> // places rocket at ground level 
      translate <0,0.7,0>         // places rocket at launch pad heighth
      translate <0, 0.5 +0.5*24*My_clock1*My_clock1 +My_clock1, 0> // Accelerate up at 24 ft/sec^2.                                                             
   } // end of rocket, slug, snack object.
   
   /////////////////////////////////
   // Smoke
   /////////////////////////////////
   object {SmokeBall scale 0.2 translate <0,0.8,0>}   // Smoke 
   object {SmokeBall scale 0.2 translate <0,1.1,0>}   // Smoke
   object {SmokeBallBlast scale <1,0.2,1> translate <0,0.8,0>}   // Smoke on blast plate 
   
   #declare loopTemp = 0;
   #while (loopTemp*0.3 <= 0.5*24*My_clock1*My_clock1 + My_clock1)
      object {SmokeBall scale 0.2 translate <0, 1.4 + 0.3*loopTemp,0>}   // Smoke
      #declare loopTemp = loopTemp+1;
   #end    
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////   
   #declare camera_location = <5.8, 0.38, -0> +<2.5,0,0>; // ball park in background 
   #declare camera_look_at =  <0, 1.3,0> +<0, 0.5 +0.5*18*My_clock1*My_clock1 +0.5*My_clock1, 0>;
                           
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence34;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   //
   //     Break. Camera Changes position. Break Camera changes position. We can start fresh. Break Break Break Break. 
   //
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 35                                clock goes from 49.25 to 52.25
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence35 = 3.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence35) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence35;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence35/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   //object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   //#include "branch.inc"  // same old branch, smaller file without tree.
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
 
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         light_source                                        // Engine burn
         {
            <0,0.01,0> 0
            looks_like
            {   
               cone 
               {
                  <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
                  pigment { colour White }
                  finish { ambient 1.0 diffuse 0.0 }
               }
            }
         } // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if (My_clock2 < 0.5)
         #declare  slug_LookAt = <0,0,-120> +<-40, -(50 -0.5*12*My_clock1*My_clock1 +24*My_clock1),0>;
      #end
      #if ( (0.5 <= My_clock2) & (My_clock2 < 0.5 + (1/12)) )
         #declare  slug_LookAt = <0,0,-120> +<-40, -(50 -0.5*12*My_clock1*My_clock1 +24*My_clock1),0> +<80,0,0>*(My_clock2-0.5)*12;
      #end
      #if (0.5+(1/12) <= My_clock2)
         #declare  slug_LookAt = <0,0,-120> +<40, -(50 -0.5*12*My_clock1*My_clock1 +24*My_clock1),0>;
      #end  
      
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
      
      #declare TempReturn = 2; // seconds it takes to return eye positions
      #if (My_clock1 < TempReturn)     
         #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>   +<0, -0.01, 0>*(1-My_clock1/TempReturn);
         #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02> +<0, -0.01, 0>*(1-My_clock1/TempReturn);
      #else
         #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
         #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #end
      
        
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug  
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack2b 
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      
      //translate <0,+1.5+0.15, 0> // places rocket at ground level 
      //translate <0,0.7,0>         // places rocket at launch pad heighth
      translate <0, 50 +0.5*12*My_clock1*My_clock1 +24*My_clock1, 0> // Accelerate up at 12 ft/sec^2.
      
                +<0.01, 0.0025,0.0015>*sin(2*pi*1.5*clock)  // plus some noise like stuff
                +<0.0015, 0.0015, 0.005>*sin(2*pi*1.7765*clock +pi/4)
                +<0.003, 0.0005, 0.0005>*sin(2*pi*2.2*clock +pi/4)
                +<0.001, 0.0005, 0.001>*sin(2*pi*3.5*clock +pi/4)
                                                                   
   } // end of rocket, slug, snack object.
   
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4> +<0, 50 +0.5*12*My_clock1*My_clock1 +24*My_clock1>;  
   #declare camera_look_at =  <0, 0.05,0> +<0, 50 +0.5*12*My_clock1*My_clock1 +24*My_clock1, 0>;
                           
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence35;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 36                            clock goes from 52.25 to 55
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence36 = 2.75; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence36) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence36;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence36/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
 
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket}                                // Rocket body less nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         light_source                                        // Engine burn
         {
            <0,0.01,0> 0
            looks_like
            {   
               cone 
               {
                  <0,0,0>, 0.001, <0, 0.5, 0>, 0.05
                  pigment { colour White }
                  finish { ambient 1.0 diffuse 0.0 }
               }
            }
         } // end light source engine burn
       } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
      #if (My_clock1 < 0.5)
         #declare  slug_LookAt = <0,0,-120> +<40, -(50 -0.5*12 +24),0>
                                            -<40, -(50 -0.5*12 +24),0>*(My_clock1/0.5);
      #else
         #declare  slug_LookAt = <0,0,-120>;
      #end
      
      
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 45*z*My_clock2
         translate <0.03, 0.1, 0>*My_clock2
          
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack2b
         translate <-0.01,0,0> // pre-rotation translation
         rotate 180*z*My_clock2
         translate <0.01,0,0> //post-rotation translation
         
         translate <0, 0.07*My_clock2, 0>
          
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*90*My_clock2*My_clock2
      
      //translate <0,+1.5+0.15, 0> // places rocket at ground level 
      //translate <0,0.7,0>         // places rocket at launch pad heighth
      translate <0, -0.5*21.818*My_clock1*My_clock1 +60*My_clock1 +176, 0> // Decelerate at 28.818 ft/sec^2.
                                                                   
   } // end of rocket, slug, snack object.
   
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4> +<0, -0.5*21.818*My_clock1*My_clock1 +60*My_clock1 +176, 0> 
                              +<0.05, 0, 0>*My_clock3;  
   #declare camera_look_at =  <0, 0.05,0> +<0, -0.5*21.818*My_clock1*My_clock1 +60*My_clock1 +176, 0>
                              +<0.05, -0.05, 0>*My_clock3;
                           
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence36;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 37                           clock goes from 55 to 57
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ 
   #declare Sequence37 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence37) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence37;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence37/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
 
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         object {rocket_Top translate <0, 1.5+0.15, 0>}    // Rocket body less bottom, nose cone and chutes
         object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         union 
         {
            object {rocket_ChuteClosed rotate (90+70*sin(2*pi*1.5*My_clock1))*z translate <-0.3,0,-0.05>}
            object {rocket_ChuteClosedLines}
            rotate z*90 
            translate <0, 1.5+0.15 -0.3, 0>
         }   
      } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////

         #declare  slug_LookAt = <0,0,-120>;
  
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 45*z +45*z*My_clock2*(Sequence37/Sequence36)
         translate <0.03, 0.1, 0> // offset from bottom 
         #if (My_clock1 <0.125)
            translate <0, -0.5*12.8*My_clock1*My_clock1, 0> // acceleration due to chute blast
         #else 
            translate <0, -0.1 + 0.1*(My_clock1-0.125), 0>
         #end 
          
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack2b
         translate <-0.01,0,0> // pre-rotation translation
         rotate 180*z +180*z*My_clock2*(Sequence37/Sequence36)
         translate <0.01,0,0> //post-rotation translation
         
         translate <0, 0.07, 0> // offset from bottom.
         #if (My_clock1 <0.125)
            translate <0, -0.5*12.8*My_clock1*My_clock1, 0> // acceleration due to chute blast
         #else 
            translate <0, -0.1 + 0.1*(My_clock1-0.125), 0>
         #end 
          
         //rotate y*90 
         translate <0, 1.5+0.15, 0>
         translate <-0.03, 0.00, -0.055>
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*90
      
      //translate <0,+1.5+0.15, 0> // places rocket at ground level 
      //translate <0,0.7,0>         // places rocket at launch pad heighth
      translate <0, 258.5, 0> // we're at the peak.
      
      #if(My_clock1 < 0.125)
         translate <0.5*12.8*My_clock1*My_clock1,0,0> // accelerate from chute blast
      #else
         translate <0.1 +1.0*(My_clock1-0.125), 0, 0> // Move away due to chute blast.
      #end
                                                                   
   } // end of rocket, slug, snack object.
   
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4> +<0, 258.5, 0> 
                              +<0.05, 0, 0>
                              +<0,0,-0.2>*My_clock2;
   #declare camera_look_at =  <0, 0.05,0> +<0, 258.5, 0>
                              +<0.05, -0.05, 0>;
                           
   camera
   { 
      location camera_location 
      look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence37;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   //
   //     Break. Camera Changes position. Break Camera changes position. We can start fresh. Break Break Break Break. 
   //
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 38                           clock goes from 57 to 59
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence38 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence38) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence38;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence38/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   #declare RotationAngle = 15*x;
   #declare RotationSpin = (360/1.5)*clock*y;
   #declare rocket_Place = <0, 258.5, 0> +<-140/293, -258/293,0>*5*My_clock1;
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         union
         {
            object {rocket_Top translate <0, 1.5+0.15, 0>}    // Rocket body less bottom, nose cone and chutes
            object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         }
         object 
         {
            rocket_Chute 
            scale 0.8  // good size for payload capsule.
            rotate 180*z
            translate <0, 1.5+0.15, 0>
            translate <0,-0.3,0>
         } 
          
      } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////

         #declare  slug_LookAt = <0,0,-0.1>;
  
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*z
         translate <0, 0.125,0> // places on top of nosecone-bottom
         translate <0, 0.07, 0> // offset from bottom
         
         #if (My_clock1 < 0.5)
            translate <0,-0.14 +0.14*My_clock1*My_clock1/0.25,0>
         #end 
         
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack2b
         rotate -90*z
         rotate -90*y 
         translate <0, 0.007, -0.058>
         //rotate -10*x
         scale <1, 0.6, 1>
         translate <0, 0.125,0> // places on top of nosecone-bottom
         
         translate <0, 0.07, 0> // offset from bottom. 
         translate <0, 1.5+0.15, 0>
         
         #if (My_clock1 < 0.8)
            translate <0,-0.14 +0.14*My_clock1*My_clock1/0.64,0>
         #end 
         
         
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*180
      rotate -RotationSpin
      translate <0,-0.7, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,0.7,0>
      rotate RotationSpin
      
      translate rocket_Place // general location of rocket
      
                                                                   
   } // end of rocket, slug, snack object.
   
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4>  
                              +<0, -0.07, 0>
                              +<0, -0.125, 0> // top of nosecone-bottom adjustment
                              //+<-0.4,0,0.4>
                              ; // testing testing remove (but leave simicolon)
   #declare camera_look_at =  <0, 0.05,0> 
                              +<0, -0.07, 0>
                              +<0, -0.125, 0>; // top of nosecone-bottom adjustment
   #declare camera_Place = rocket_Place;
                           
   camera
   {  
      location camera_location
      look_at  camera_look_at +(camera_Place-rocket_Place)
      rotate -RotationSpin
      translate <0,-0.7,0> // places camera back down to payload
      rotate RotationAngle
      translate <0,0.7,0> 
      rotate RotationSpin
      
      translate camera_Place
      
      //location camera_location 
      //look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence38;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 39                          clock goes from 59 to 61
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence39 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence39) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence39;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence39/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   #declare RotationAngle = 15*x;
   #declare RotationSpin = (360/1.5)*clock*y;
   #declare rocket_Place = <0, 258.5, 0> +10*<-140/293, -258/293,0> +<-140/293, -258/293,0>*5*My_clock1;
   /////////////////////////////////////////////////////
   // Group rocket, slug, and snack into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         union
         {
            object {rocket_Top translate <0, 1.5+0.15, 0>}    // Rocket body less bottom, nose cone and chutes
            object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         }
         object 
         {
            rocket_Chute 
            scale 0.8  // good size for payload capsule.
            rotate 180*z
            translate <0, 1.5+0.15, 0>
            translate <0,-0.3,0>
         } 
          
      } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         
      #declare  slug_LookAt = <0,0,-0.1>;
  
      #declare slug_Eyelids = 1.2;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      
      #declare slug_Mouth = 0.2 +0.8*My_clock4;
      #declare slugHeadTempy = 0.0025*My_clock4;
      #declare slugHeadTempz = -0.014*My_clock3;
      #declare slug_MoveHead = <0, slugHeadTempy, slugHeadTempz>; 
      
      #if (My_clock1 < 0.5)
         #declare  slug_LookAt = <0, 0.02-slugHeadTempy, -0.07-slugHeadTempz>*My_clock1/0.5 +<0,0,-0.1>*(1-My_clock1/0.5);
      #else 
         #declare  slug_LookAt = <0, 0.02-slugHeadTempy, -0.07-slugHeadTempz>;
      #end
 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*z
         translate <0, 0.125,0> // places on top of nosecone-bottom
         translate <0, 0.07, 0> // offset from bottom
         
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }
      
      ///////////////////////
      // Snack
      ///////////////////////
      #include "snack.inc"
      object 
      {
         LongSnack2b
         #if ( (My_clock1 > 1.29)& (My_clock1 <= 1.39) )
            translate <-0.01,0,0> // pre-rotation translation
            rotate z*90*(My_clock1-1.29)/(1.39-1.29)
            translate <0.01,0,0> //post-rotation translation
         #end
         #if (My_clock1 > 1.39) 
            translate <-0.01,0,0> // pre-rotation translation
            rotate z*90
            translate <0.01,0,0> //post-rotation translation
         #end
         rotate -90*z
         rotate -90*y 
         translate <0, 0.007, -0.058>
         //rotate -10*x
         scale <1, 0.6, 1>
         translate <0, 0.125,0> // places on top of nosecone-bottom
         
         translate <0, 0.07, 0> // offset from bottom. 
         translate <0, 1.5+0.15, 0>
         
         #if ( (My_clock1 > 1.29)& (My_clock1 <= 1.39) )
            translate <0, -0.1*(My_clock1-1.29),0>
         #end 
         #if (My_clock1 > 1.39)
            translate <0, -0.01,0>
            translate <0, 0, 0.05*(My_clock1-1.39)>
         #end 
    
      }
      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*180
      rotate -RotationSpin
      translate <0,-0.7, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,0.7,0>
      rotate RotationSpin
      
      translate rocket_Place // general location of rocket
      
                                                                   
   } // end of rocket, slug, snack object.
   
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4>  
                              +<0, -0.07, 0>
                              +<0, -0.125, 0> // top of nosecone-bottom adjustment
                              //+<-0.2,0,0.2>
                              ; // testing testing remove (but leave simicolon)
   #declare camera_look_at =  <0, 0.05,0> 
                              +<0, -0.07, 0>
                              +<0, -0.125, 0>; // top of nosecone-bottom adjustment
   #declare camera_Place = rocket_Place;
                           
   camera
   {  
      location camera_location
      look_at  camera_look_at +(camera_Place-rocket_Place)
      rotate -RotationSpin
      translate <0,-0.7,0> // places camera back down to payload
      rotate RotationAngle
      translate <0,0.7,0> 
      rotate RotationSpin
      
      translate camera_Place
      
      //location camera_location 
      //look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence39;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 40                            clock goes from 61 to 63
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   #declare Sequence40 = 2.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence40) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence40;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence40/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   #declare RotationAngle = 15*x;
   #declare RotationSpin = (360/1.5)*clock*y;
   #declare rocket_Place = <0, 258.5, 0> +20*<-140/293, -258/293,0> +<-140/293, -258/293,0>*5*My_clock1;
   /////////////////////////////////////////////////////
   // Group rocket, slug into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         union
         {
            object {rocket_Top translate <0, 1.5+0.15, 0>}    // Rocket body less bottom, nose cone and chutes
            object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         }
         object 
         {
            rocket_Chute 
            scale 0.8  // good size for payload capsule.
            rotate 180*z
            translate <0, 1.5+0.15, 0>
            translate <0,-0.3,0>
         } 
          
      } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         
      #declare  slug_LookAt = <0,0,-0.1>;
  
      #declare slug_Eyelids = 1.2-0.4*My_clock2; // ends at 0.8;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      
      #declare slug_Mouth = 0.2;
      #declare slugHeadTempy = 0;
      #declare slugHeadTempz = -0.014*(1-My_clock3);
      #declare slug_MoveHead = <0, slugHeadTempy, slugHeadTempz>;  

      #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
      #declare slug_ScaleMouth = <0.9 + 0.2*sin(2*pi*clock+pi/8),1>;        // part of chewing.
      
      #declare New_slug_LookAt = <0, -5-10*sin(2*pi*RotationAngle.x/360)*cos(2*pi*(RotationSpin.y/360)), -10>;
      #if (My_clock1 < 0.5)
         #declare  slug_LookAt = <0, 0.02-slugHeadTempy, -0.07-slugHeadTempz>*(1-My_clock1/0.5) +New_slug_LookAt*(My_clock1/0.5);
      #else 
         #declare  slug_LookAt = New_slug_LookAt;
      #end
 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*z
         translate <0, 0.125,0> // places on top of nosecone-bottom
         translate <0, 0.07, 0> // offset from bottom
         
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }

      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*180
      rotate -RotationSpin
      translate <0,-0.7, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,0.7,0>
      rotate RotationSpin
      
      translate rocket_Place // general location of rocket
      
                                                                   
   } // end of rocket, slug object.
   
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4>  
                              +<0, -0.07, 0>
                              +<0, -0.125, 0> // top of nosecone-bottom adjustment
                              //+<-0.4,0,0.4>
                              ; // testing testing remove (but leave simicolon)
   #declare camera_look_at =  <0, 0.05,0> 
                              +<0, -0.07, 0>
                              +<0, -0.125, 0>; // top of nosecone-bottom adjustment
   #declare camera_Place = rocket_Place;
                           
   camera
   {  
      location camera_location
      look_at  camera_look_at +(camera_Place-rocket_Place)
      rotate -RotationSpin
      translate <0,-0.7,0> // places camera back down to payload
      rotate RotationAngle
      translate <0,0.7,0> 
      rotate RotationSpin
      
      translate camera_Place
      
      //location camera_location 
      //look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence40;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 41                            clock goes from 63 to 66
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence41 = 3.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence41) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence41;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence41/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   #declare RotationAngle = 15*x;
   #declare RotationSpin = (360/1.5)*clock*y;
   #declare rocket_Place = <0, 258.5, 0> +30*<-140/293, -258/293,0> +<-140/293, -258/293,0>*5*My_clock1;
   /////////////////////////////////////////////////////
   // Group rocket, slug into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         union
         {
            object {rocket_Top translate <0, 1.5+0.15, 0>}    // Rocket body less bottom, nose cone and chutes
            object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         }
         object 
         {
            rocket_Chute 
            scale 0.8  // good size for payload capsule.
            rotate 180*z
            translate <0, 1.5+0.15, 0>
            translate <0,-0.3,0>
         } 
          
      } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         
      #declare  slug_LookAt = <0,0,-0.1>;
  
      #declare slug_Eyelids = 0.8;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  

      #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
      #declare slug_ScaleMouth = <0.9 + 0.2*sin(2*pi*clock+pi/8),1>;        // part of chewing.
      
      #declare New_slug_LookAt = <0, -5-10*sin(2*pi*RotationAngle.x/360)*cos(2*pi*(RotationSpin.y/360)), -10>;
      #declare  slug_LookAt = New_slug_LookAt;

 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*z
         translate <0, 0.125,0> // places on top of nosecone-bottom
         translate <0, 0.07, 0> // offset from bottom
         
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }

      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*180
      rotate -RotationSpin
      translate <0,-0.7, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,0.7,0>
      rotate RotationSpin
      
      translate rocket_Place // general location of rocket
      
                                                                   
   } // end of rocket, slug object.
   
   
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4>  
                              +<0, -0.07, 0>
                              +<0, -0.125, 0> // top of nosecone-bottom adjustment
                              //+<-0.4,0,0.4>
                              ; // testing testing remove (but leave simicolon)
   #declare camera_look_at =  <0, 0.05,0> 
                              +<0, -0.07, 0>
                              +<0, -0.125, 0>; // top of nosecone-bottom adjustment
   #declare camera_Place = rocket_Place;
                           
   camera
   {  
      location camera_location
      look_at  camera_look_at +(camera_Place-rocket_Place)
      rotate -RotationSpin
      translate <0,-0.7,0> // places camera back down to payload
      rotate RotationAngle
      translate <0,0.7,0> 
      rotate RotationSpin
      
      translate camera_Place
      
      //location camera_location 
      //look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence41;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 42                                  clock goes from 66 to 73
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence42 = 7.0; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence42) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence42;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence42/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   #declare RotationAngle = 15*x;
   #declare RotationSpin = (360/1.5)*clock*y;
   #declare rocket_Place = <0, 258.5, 0> +45*<-140/293, -258/293,0> +<-140/293, -258/293,0>*5*My_clock1;
   /////////////////////////////////////////////////////
   // Group rocket, slug into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         union
         {
            object {rocket_Top translate <0, 1.5+0.15, 0>}    // Rocket body less bottom, nose cone and chutes
            object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         }
         object 
         {
            rocket_Chute 
            scale 0.8  // good size for payload capsule.
            rotate 180*z
            translate <0, 1.5+0.15, 0>
            translate <0,-0.3,0>
         } 
          
      } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         
      #declare  slug_LookAt = <0,0,-0.1>;
  
      #declare slug_Eyelids = 0.8;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  

      #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
      #declare slug_ScaleMouth = <0.9 + 0.2*sin(2*pi*clock+pi/8),1>;        // part of chewing.
      
      #declare New_slug_LookAt = <0, -5-10*sin(2*pi*RotationAngle.x/360)*cos(2*pi*(RotationSpin.y/360)), -10>;
      #declare  slug_LookAt = New_slug_LookAt;

 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*z
         translate <0, 0.125,0> // places on top of nosecone-bottom
         translate <0, 0.07, 0> // offset from bottom
         
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }

      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*180
      rotate -RotationSpin
      translate <0,-0.7, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,0.7,0>
      rotate RotationSpin
      
      translate rocket_Place // general location of rocket
      
                                                                   
   } // end of rocket, slug object.
   
   //////////////////////////////////////////////////////////////
   // Rocket Bottom
   //////////////////////////////////////////////////////////////
   union
   {
      object {rocket_Bottom}
      object {rocket_Chute translate <0,2,0>}
      rotate -RotationSpin/0.7654
      translate <0,-2.5, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,2.5,0>
      rotate RotationSpin*0.67654
      
      translate rocket_Place +<4,0,-1> // general location of rocket
   }
      
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4>  
                              +<0, -0.07, 0>
                              +<0, -0.125, 0> // top of nosecone-bottom adjustment
                              //+<-0.4,0,0.4>
                              ; // testing testing remove (but leave simicolon)
   #declare camera_look_at =  <0, 0.05,0> 
                              +<0, -0.07, 0>
                              +<0, -0.125, 0>; // top of nosecone-bottom adjustment
   
   #if (My_clock1 < 1.5)
      #declare camera_Place = <0, 258.5, 0> +45*<-140/293, -258/293,0> +<-140/293, -258/293,0>*5*My_clock1
                              +<0.5*1.5927*My_clock1*My_clock1, 0.5*2.935*My_clock1*My_clock1, 0>;
      #declare camera_RotationCoef = (1-My_clock1/1.5);                  
   #else
      #declare camera_Place = <-23.29, 215.573, 0>;
      #declare camera_RotationCoef = 0;
   #end
   
                           
   camera
   {  
      location camera_location
      look_at  camera_look_at -(camera_Place-rocket_Place)
      rotate -RotationSpin
      translate <0,-0.7,0> // places camera back down to payload
      rotate RotationAngle*camera_RotationCoef
      translate <0,0.7,0> 
      rotate RotationSpin
      
      translate camera_Place
      
      //location camera_location 
      //look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence42;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence 43                         clock goes from 73 to 74
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   
   #declare Sequence43 = 1.000001; 
 #if ( (SequenceRun <= clock) & (clock < SequenceRun+Sequence43) )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence43;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence43/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   
   
   /////////////////////////////////
   // Light from sky, with 8 lights            // Every frame has these, except for the fade to black.
   /////////////////////////////////
   #declare SkyLightStrength = 0.35;
   #declare SkyShineColor = <0.9, 0.9, 1>;
   light_source {<2500*cos(2*pi*0/8), 2000, 2500*sin(0*pi*0/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless}    
   light_source {<2500*cos(2*pi*1/8), 2000, 2500*sin(2*pi*1/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless}     
   light_source {<2500*cos(2*pi*2/8), 2000, 2500*sin(2*pi*2/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless}
   light_source {<2500*cos(2*pi*3/8), 2000, 2500*sin(2*pi*3/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless}    
   light_source {<2500*cos(2*pi*4/8), 2000, 2500*sin(2*pi*4/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless}     
   light_source {<2500*cos(2*pi*5/8), 2000, 2500*sin(2*pi*5/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless} 
   light_source {<2500*cos(2*pi*6/8), 2000, 2500*sin(2*pi*6/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless}    
   light_source {<2500*cos(2*pi*7/8), 2000, 2500*sin(2*pi*7/8)> SkyShineColor*SkyLightStrength*(1-My_clock2) shadowless}       
   
   /////////////////////////
   // Sun                                     // Every frame has this, except for the fade to black.
   ///////////////////////// 
   light_source {
     <0, 0, 0> colour <1, 1, 0.7>*1.2*(1-My_clock2) 

     looks_like {
        sphere { <0.0, 0.0, 0.0>, 190.0
           pigment { colour <1.0, 1.0, 0.6> }
           finish { ambient 1.0 diffuse 0.0 }
        }
     }
      
     translate <200.0, 2500.0, -900.0>
   } 

   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   object {tree_Branch translate <12, -3, 30>} 
   object {tree_Branch translate <9, -2, 10>}
   
   object {tree_Branch translate <-3, -2, 40>}
   object {tree_Branch translate <4, -2, 20>}
   object {Tree translate <-16,0,80>}
   
   //trees beind ball park
   object {Tree translate <-170,0,-30>} 
   object {Tree translate <-110,0,-50>}
   object {tree_Branch translate <-90, -2, 7>}
   
   /////////////////////
   // Baseball Diamond
   /////////////////////
   #include "baseball.inc"
   object {BaseballDiamond translate <-140,0,0>}   
   
 
   ////////////////////////////
   // Launch pad
   ////////////////////////////
   #include "launchpad.inc"
   object {lauchpad translate <0.05869, 0, 0.05869>}  
   
   #declare RotationAngle = 15*x;
   #declare RotationSpin = (360/1.5)*clock*y;
   #declare rocket_Place = <0, 258.5, 0> +80*<-140/293, -258/293,0> +<-140/293, -258/293,0>*5*My_clock1;
   /////////////////////////////////////////////////////
   // Group rocket, slug into signal object.
   /////////////////////////////////////////////////////
   #include "rocket.inc"
   union
   {  
      union
      {  
         union
         {
            object {rocket_Top translate <0, 1.5+0.15, 0>}    // Rocket body less bottom, nose cone and chutes
            object {rocket_NoseCone translate <0, 1.9, 0> rotate (45*y) } // Rocket nose cone
         }
         object 
         {
            rocket_Chute 
            scale 0.8  // good size for payload capsule.
            rotate 180*z
            translate <0, 1.5+0.15, 0>
            translate <0,-0.3,0>
         } 
          
      } //end rocket union 
   
      ////////////////////////////////////
      // Time to actually declare GlueSlug
      ////////////////////////////////////
         
      #declare  slug_LookAt = <0,0,-0.1>;
  
      #declare slug_Eyelids = 0.8;
      #declare slug_Stretch = 0.9;
      
      #declare slug_LeftEye = <0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;
      #declare slug_RightEye = <-0.2/6, 0.3/6, -0.2/6> +<0, 0, 0.02>;  

      #declare slug_MoveMouth = (<0.01*sin(2*pi*clock), 0.01*sin(2*pi*clock+pi/4)>); // keep chewing 
      #declare slug_ScaleMouth = <0.9 + 0.2*sin(2*pi*clock+pi/8),1>;        // part of chewing.
      
      #declare New_slug_LookAt = <0, -5-10*sin(2*pi*RotationAngle.x/360)*cos(2*pi*(RotationSpin.y/360)), -10>;
      #declare  slug_LookAt = New_slug_LookAt;

 
      #include "glueslug.inc"
      object                // Create instance of Glue Slug
      {
         GlueSlug 
         rotate 180*z
         translate <0, 0.125,0> // places on top of nosecone-bottom
         translate <0, 0.07, 0> // offset from bottom
         
         translate <0, 1.5+0.15, 0> 
         translate <0,0,-0.025> 
      }

      translate <0,-1.5-0.15, 0>  // places payload section at <0,0,0>
      rotate -z*180
      rotate -RotationSpin
      translate <0,-0.7, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,0.7,0>
      rotate RotationSpin
      
      translate rocket_Place // general location of rocket
      
                                                                   
   } // end of rocket, slug object.
   
   //////////////////////////////////////////////////////////////
   // Rocket Bottom
   //////////////////////////////////////////////////////////////
   union
   {
      object {rocket_Bottom}
      object {rocket_Chute translate <0,2,0>}
      rotate -RotationSpin/0.7654
      translate <0,-2.5, 0> //places parachute point at <0,0,0>
      rotate RotationAngle
      translate <0,2.5,0>
      rotate RotationSpin*0.67654
      
      translate rocket_Place +<4,0,-1> // general location of rocket
   }
      
  
   ///////////////////////////
   // Camera
   ///////////////////////////
   //#declare camera_location = <0, 2.375, -0.3>;
   //#declare camera_look_at =  <0, 2.40,0>; 
      
   #declare camera_location = <0, 0.025, -0.4>  
                              +<0, -0.07, 0>
                              +<0, -0.125, 0> // top of nosecone-bottom adjustment
                              //+<-0.4,0,0.4>
                              ; // testing testing remove (but leave simicolon)
   #declare camera_look_at =  <0, 0.05,0> 
                              +<0, -0.07, 0>
                              +<0, -0.125, 0>; // top of nosecone-bottom adjustment
   
   #declare camera_Place = <-23.29, 215.573, 0>;
   #declare camera_RotationCoef = 0;

   
                           
   camera
   {  
      location camera_location
      look_at  camera_look_at -(camera_Place-rocket_Place)
      rotate -RotationSpin
      translate <0,-0.7,0> // places camera back down to payload
      rotate RotationAngle*camera_RotationCoef
      translate <0,0.7,0> 
      rotate RotationSpin
      
      translate camera_Place
      
      //location camera_location 
      //look_at camera_look_at 
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence43;
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Fin                  
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@   




 //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
   // Sequence999.   @@@@@@@@@@@@@@@ Poster @@@@@@@@@@@@@@@@@@@@@@@
   //@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

   /////////////////////////////////
   // Light from sky, with 8 lights            // Every frame has these, except for the fade to black.
   /////////////////////////////////
   #declare SkyLightStrength = 0.35;
   #declare SkyShineColor = <0.9, 0.9, 1>;
   light_source {<2500*cos(2*pi*0/8), 2000, 2500*sin(0*pi*0/8)> SkyShineColor*SkyLightStrength shadowless}    
   light_source {<2500*cos(2*pi*1/8), 2000, 2500*sin(2*pi*1/8)> SkyShineColor*SkyLightStrength shadowless}     
   light_source {<2500*cos(2*pi*2/8), 2000, 2500*sin(2*pi*2/8)> SkyShineColor*SkyLightStrength shadowless}
   light_source {<2500*cos(2*pi*3/8), 2000, 2500*sin(2*pi*3/8)> SkyShineColor*SkyLightStrength shadowless}    
   light_source {<2500*cos(2*pi*4/8), 2000, 2500*sin(2*pi*4/8)> SkyShineColor*SkyLightStrength shadowless}     
   light_source {<2500*cos(2*pi*5/8), 2000, 2500*sin(2*pi*5/8)> SkyShineColor*SkyLightStrength shadowless} 
   light_source {<2500*cos(2*pi*6/8), 2000, 2500*sin(2*pi*6/8)> SkyShineColor*SkyLightStrength shadowless}    
   light_source {<2500*cos(2*pi*7/8), 2000, 2500*sin(2*pi*7/8)> SkyShineColor*SkyLightStrength shadowless}       
   
   /////////////////////////
   // Sun                                     // Every frame has this, except for the fade to black.
   ///////////////////////// 
   light_source {
     <0, 0, 0> colour <1, 1, 0.7>*1.2 

     looks_like {
        sphere { <0.0, 0.0, 0.0>, 190.0
           pigment { colour <1.0, 1.0, 0.6> }
           finish { ambient 1.0 diffuse 0.0 }
        }
     }
      
     translate <200.0, 2500.0, -900.0>
   } 



   #declare Sequence999 = 1.0; 
 #if ( clock >= 999 )
   
   #declare My_clock1 = clock-SequenceRun;     // My_clock1 linearly varies from 0 to Sequence4.
   #declare My_clock2 = My_clock1/Sequence999;   // My_clock2 linearly varies from 0 to 1.
   
   #if (My_clock2 < 0.5)       // nonlinear acceleration movement of camera. My_clock3 varies from 0 to 1 in this sequence.  
      #declare My_clock3 = My_clock2*My_clock2*2.0;
   #else
      #declare My_clock3 = 1-( (1.0-My_clock2)*(1.0-My_clock2)*2.0 );
   #end 
   
   #if (My_clock1 < Sequence999/2)       // My_clock4 linearly varies from 0 to 1 to 0.
       #declare My_clock4 = My_clock1;
   #else 
       #declare My_clock4 = Sequence4-My_clock1;
   #end
   ///////////////////////////////////////////////
   // Openinc Credits: 
   ///////////////////////////////////////////////
   union
   {
      text { ttf "TIMESBD.ttf" "PAYLOAD" 1, 0              // Title                                         
             rotate y*95                               
             scale 6.0
             scale <0.5,1,1>                                                 
             translate <0, 0, 0> 
           }
      text { ttf "TIMESBD.ttf" "Copyright Collins Mark" 1, 0              // Credits                                         
             rotate y*95                               
             scale 2.8
             scale <0.5,1,1>                                                 
             translate <0, -2, 0> 
           }
      text { ttf "TIMESBD.ttf" "2000 C.E." 1, 0              // Year                                         
             rotate y*95                               
             scale 2.8
             scale <0.5,1,1>                                                 
             translate <0, -5, -6> 
           }
      translate <60, 11, 9>      
      pigment {color rgbf<0.9, 0.9, 0.5, 0.0>}
   }
 
   
   //////////////////////////////////
   // Real Trees.
   //////////////////////////////////
   #include "trees.inc"     
   object {Tree translate <80,0,-20>} 
   object {tree_Branch translate <30,0,5>}
   
   ////////////////////
   // Grass (Real stuff) 
   ////////////////////    
   #include "grass.inc"
   object {GrassBlock translate <12.5,0,0>}
   object {slugStand translate <10.5,0,0>}
   
   ////////////////////////////////////
   // Time to actually declare GlueSlug
   ////////////////////////////////////
   #declare slug_TailAutoWag_En = 0; 
   #declare slug_AutoEyeMovement_En = 0;
   #declare slug_AutoBlink_En = 0; 
   #declare slug_LookAt = <-0.02, 0.04, -0.2>;
   #declare slug_Eyelids = 1.1;
   
   #include "glueslug.inc"
   object                // Create instance of Glue Slug
   {
      GlueSlug 
      rotate 90*y 
      translate <10-0.1, 0.02+0.35+0.02,0+0.12>
   } 
   
   ///////////////////////////
   // Camera
   ///////////////////////////
   #declare camera_location = <10-0.3, 0.08+0.35,0.14>;
   #declare camera_look_at = <10-0.1, 0.02+0.35+0.09,0+0.12>; 
   camera
   { 
      location camera_location 
      look_at camera_look_at
      angle camera_angle  

      #if (camera_focus_en)
         focal_point camera_look_at +<60,5,-10>    
         aperture camera_aperture     
         blur_samples camera_blur_samples
      #end // camera_focus_en   
   }
   
 #end // end sequence. 
 #declare SequenceRun = SequenceRun+Sequence999;