  ////////////////////
  // Snack.inc 
  //
  // Creates a simple blade
  // of grass that the slug
  // snacks on. 
  // 
  // This was separated from grass.inc
  // to save parsing time when
  // grass feild is not visable.
  //
  // Created for the IRTC competition, "Alien Invasion".
  // Deadline for entry Oct. 15, 2000
  //
  // 
  // Copyright 2000, Collins Mark 
  //
  /////////////////////////////////
  
  #declare GrassBlade2 = difference
   {
      union
      { 
         difference
         {
            sphere {<0.1,0,0> 0.4 }
            sphere {<0.1,0,0> 0.39}
         }
         difference
         {
            sphere {<-0.1,0,0> 0.4 }
            sphere {<-0.1,0,0> 0.39}
         }
      }
      box{<0,-1,-1>, <1,1,1> rotate <0,-10,0> translate <-0.03, 0, 0>}
      box{<-1,-1,-1>, <0,1,1> rotate <0,10,0> translate < 0.03, 0, 0>}
      box{<-1,-1,-1>, <1,-0.1,1>}
      sphere {<-0.1,0,0> 0.38999}
      sphere {<0.1,0,0> 0.38999}
       
      pigment {color <0.2,0.5,0.3>}
      translate <0,0,0.395>
      scale 1.0 // 
      finish{ambient 0.2 diffuse 0.5}
   } 
   
   #declare LongSnack = difference            // No bites taken out of snack 
   { 
      object {GrassBlade2 rotate -90*x rotate -90*y scale <0.25, 0.25, 0.20>}
      box {<-0.5, -0.2, -0.2>, <0, 0.2, 0.2>}
      box {<0.045, -0.2, -0.2>, <0.3, 0.2, 0.2>}
   }  
   #declare LongSnack1b = difference          // One bite taken out of snack
   { 
      object {GrassBlade2 rotate -90*x rotate -90*y scale <0.25, 0.25, 0.20>}
      box {<-0.5, -0.2, -0.2>, <0, 0.2, 0.2>}
      box {<0.035, -0.2, -0.2>, <0.3, 0.2, 0.2>}
   }
   #declare LongSnack2b = difference          // TWo bites taken out of snack
   { 
      object {GrassBlade2 rotate -90*x rotate -90*y scale <0.25, 0.25, 0.20>}
      box {<-0.5, -0.2, -0.2>, <0, 0.2, 0.2>}
      box {<0.02, -0.2, -0.2>, <0.3, 0.2, 0.2>}
   }