   ////////////////////
   // trees.inc
   //
   // Declares trees
   //
   // Created for the IRTC competition, "Alien Invasion".
   // Deadline for entry Oct. 15, 2000
   //
   // 
   // Copyright 2000, Collins Mark 
   //
   ////////////////////
   
   #declare TreeWind = 0.2;
   
   ///////////////////////
   // Unit Leaf
   ///////////////////////
   #declare tree_Leaf = 
      cylinder 
      { <0,0,0>, <0,0.05,0>, 0.25 
         texture 
         { 
            //pigment {color White}
            pigment 
            {
               bozo
               turbulence 0.5 
               //turbulence 1
               colour_map 
               {
                  [0.0 0.6   colour red 0.2 green 0.3 blue 0.0 
                     colour red 0.4 green 0.5 blue 0.0 ]
                  [0.6 0.8   colour red 0.3 green 0.4 blue 0.0 
                     colour red 0.8 green 0.5 blue 0.2]
                  [0.8 1.001 colour red 0.8 green 0.5 blue 0.2 
                     colour red 0.7 green 0.3 blue 0.1]
               }
               //quick_colour red 0.7 green 0.7 blue 1.0
               scale 0.2
            }
         }
      }
   
   ///////////////////
   // Unit Brach
   ///////////////////
   #declare BranchLength = 8;
   #declare BranchSeed = seed(1111);
   #declare LeavesPerBrach = 1000;
   #declare i=0;  
   #declare tree_Branch = union
   {
      cone {<0,0,0> 0.25, <0,BranchLength,0> 0.125 pigment {color <0.45,0.3,0.3>}}
      #while (i<LeavesPerBrach) 
         #declare LeafBrachDistance = (BranchLength/2)*( 2*(rand(BranchSeed)-0.5) );
         #object 
         {   tree_Leaf
                  rotate TreeWind*x*4*sin(2*pi*1.5*time) // individual wind characteristic
                  rotate TreeWind*z*4*sin(2*pi*1.5*time+pi/8) // individual wind characteristic
                  rotate TreeWind*y*4*sin(2*pi*1.5*time+pi/4) // individual wind characteristic 
                  
                  rotate <180*rand(BranchSeed),0,0> //intrinsic random rotation of leaf
                  rotate <0,180*rand(BranchSeed),0> //intrinsic random rotation of leaf
                  rotate <0,0,180*rand(BranchSeed)> //intrinsic random rotation of leaf          
                  translate <LeafBrachDistance,0,0> // distance of leaf from tip of brach
                  rotate <180*rand(BranchSeed),0,0> //intrinsic random rotation around tip of branch
                  rotate <0,180*rand(BranchSeed),0> //intrinsic random rotation around tip of branch
                  rotate <0,0,180*rand(BranchSeed)> //intrinsic random rotation around tip of branch
                  
                  rotate TreeWind*x*0.5*sin(2*pi*1.5*time)   // General wind rotation
                  rotate TreeWind*y*2*sin(2*pi*1.5*time+pi/4)  // General wind rotation
                  rotate TreeWind*z*0.5*sin(2*pi*1.5*time+pi/8) // General wind rotation
                  
                  translate <0,BranchLength,0>     // Move up to tip of brach
         }
                  
         #declare i = i+1;
      #end
      
   }
   
   //////////////////////
   // Tree
   //////////////////////
   
   #declare TreeHeight = 20;
   #declare TreeSeed = seed(2112);
   #declare NumBranches = 18;
   #declare i=0;
   #declare Tree = union
   {
      cone {<0,0,0> 1.25, <0,TreeHeight,0> 0.25 pigment {color <0.45,0.3,0.3>}}
      #while (i<NumBranches)
         #object
         {
            tree_Branch
               rotate TreeWind*x*4*sin(2*pi*0.45*time) // individual wind characteristic
               rotate TreeWind*z*4*sin(2*pi*0.45*time+pi/8) // individual wind characteristic
               rotate TreeWind*y*4*sin(2*pi*0.45*time+pi/4) // individual wind characteristic 
               
               rotate <3600*rand(TreeSeed),0,0> //intrinsic random rotation of branch
               rotate <0,360*rand(TreeSeed),0> //intrinsic random rotation of branch
               rotate <0,0,360*rand(TreeSeed)> //intrinsic random rotation of branch 
               
               rotate TreeWind*x*2*sin(2*pi*0.5*time)   // General wind rotation
               rotate TreeWind*y*2*sin(2*pi*0.5*time+pi/4)  // General wind rotation
               rotate TreeWind*z*2*sin(2*pi*0.5*time+pi/8) // General wind rotation
               
               translate <0,TreeHeight,0> 
         } 
         #declare i=i+1;
      #end
   }
   
   