#declare time=20;
#include "ships.inc"

#declare Ocean = texture {
  pigment {
    bozo
    turbulence 0.5
    colour_map {
      [0.00 colour rgb <0,0,1>]
      [0.20 colour rgb <0,0,1>]
      [0.20 colour rgbt <1,1,1,1>]
      [0.80 colour rgbt <1,1,1,1>]
      [0.80 colour rgb <0,0,1>]
      [1.00 colour rgb <0,0,1>]
    }
  }
}

#declare Land = texture {
  pigment {
    agate
    turbulence 0.5
    colour_map {
      [0.00 colour rgb <.5, .4, .1>]
      [0.30 colour rgb <.3, .5, .4>]
      [0.70 colour rgb <.3, .5, .4>]
      [1.00 colour rgb <.5, .4, .1>]
    }
  }
  normal {
    bozo
    turbulence 0.5
    normal_map {  
      [0.2 wrinkles .15 scale .01]
      [0.8 granite turbulence 1]
      [1.0 wrinkles .15 scale .01]
    }
  }
}

#declare Clouds1 = pigment {
  bozo
  turbulence 1
  colour_map {
    [0.0 colour rgbt <1,1,1,1>]
    [0.5 colour rgb <1,1,1>]
    [1.0 colour rgbt <1,1,1,1>]
  }
  scale 0.25
}

#declare Clouds2 = pigment {
  bozo
  turbulence 0.5
  colour_map {
    [0.0 colour rgb <1,1,1>]
    [0.15 colour rgb <1,1,1>]
    [0.3 colour rgbt <1,1,1,1>]
    [0.7 colour rgbt <1,1,1,1>]
    [0.85 colour rgb <1,1,1>]
    [1.0 colour rgb <1,1,1>]
  }
}
  
#declare CloudCover = texture {
  pigment {
    bozo
    turbulence 0.5
    pigment_map {
      [0.00 Clouds1]
      [0.10 Clouds1]
      [0.35 Clouds2]
      [0.65 Clouds2]
      [0.90 Clouds1]
      [1.00 Clouds1]
    }
  }
}

#declare AlienCarrierHull = union { // BezPtch001
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-0.002027, -1.529642, -0.006338>, <-0.002027, -1.529645, -0.005223>, <-0.001115, -1.529649, -0.004311>, <0.000000, -1.529649, -0.004311>, 
      <-1.000000, -1.412387, -0.014746>, <-1.000000, -1.414291, 0.535251>, <-0.550000, -1.415849, 0.985248>, <0.000000, -1.415849, 0.985248>, 
      <-1.000000, -1.554940, -0.006667>, <-1.000000, -1.556845, 0.543330>, <-0.550000, -1.558403, 0.993327>, <0.000000, -1.558403, 0.993327>, 
      <-1.000000, -0.776671, -0.004862>, <-1.000000, -0.601779, 0.544883>, <-0.550000, -0.598938, 1.006787>, <0.000000, -0.596879, 1.006055>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -1.529649, -0.004311>, <0.001115, -1.529649, -0.004311>, <0.002027, -1.529645, -0.005223>, <0.002027, -1.529642, -0.006338>, 
      <0.000000, -1.415849, 0.985248>, <0.550000, -1.415849, 0.985248>, <1.000000, -1.414291, 0.535251>, <1.000000, -1.412387, -0.014746>, 
      <0.000000, -1.558403, 0.993327>, <0.550000, -1.558403, 0.993327>, <1.000000, -1.556845, 0.543330>, <1.000000, -1.554940, -0.006667>, 
      <0.000000, -0.596879, 1.006055>, <0.550000, -0.598938, 1.006787>, <1.000000, -0.601779, 0.544883>, <1.000000, -0.776671, -0.004862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.002027, -1.529642, -0.006338>, <0.002027, -1.529638, -0.007453>, <0.001115, -1.529634, -0.008383>, <0.000000, -1.529634, -0.008383>, 
      <1.000000, -1.412387, -0.014746>, <1.000000, -1.410482, -0.564742>, <1.167313, -1.408892, -1.024535>, <0.000000, -1.408892, -1.024535>, 
      <1.000000, -1.554940, -0.006667>, <1.000000, -1.553036, -0.556664>, <1.167313, -1.551445, -1.016455>, <0.000000, -1.551445, -1.016455>, 
      <1.000000, -0.776671, -0.004862>, <1.000000, -0.951550, -0.554601>, <1.167313, -0.949960, -1.014392>, <0.000000, -0.952002, -1.013684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -1.529634, -0.008383>, <-0.001115, -1.529634, -0.008383>, <-0.002027, -1.529638, -0.007453>, <-0.002027, -1.529642, -0.006338>, 
      <0.000000, -1.408892, -1.024535>, <-1.167313, -1.408892, -1.024535>, <-1.000000, -1.410482, -0.564742>, <-1.000000, -1.412387, -0.014746>, 
      <0.000000, -1.551445, -1.016455>, <-1.167313, -1.551445, -1.016455>, <-1.000000, -1.553036, -0.556664>, <-1.000000, -1.554940, -0.006667>, 
      <0.000000, -0.952002, -1.013684>, <-1.167313, -0.949960, -1.014392>, <-1.000000, -0.951550, -0.554601>, <-1.000000, -0.776671, -0.004862>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-1.000000, -0.776671, -0.004862>, <-1.000000, -0.601779, 0.544883>, <-0.550000, -0.598938, 1.006787>, <0.000000, -0.596879, 1.006055>, 
      <-1.000000, 0.001611, -0.003051>, <-1.000000, 0.353286, 0.546436>, <-0.550000, 0.360528, 1.020248>, <0.000000, 0.360528, 1.020248>, 
      <-1.186499, 0.148029, -0.000810>, <-1.372998, 0.146124, 0.549187>, <-0.550000, -0.451151, 1.743960>, <0.000000, -0.451151, 1.743960>, 
      <-1.093249, 0.279763, -0.001112>, <-1.186499, 0.277859, 0.549716>, <-0.550000, -0.021557, 1.372101>, <0.000000, -0.019539, 1.371273>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.596879, 1.006055>, <0.550000, -0.598938, 1.006787>, <1.000000, -0.601779, 0.544883>, <1.000000, -0.776671, -0.004862>, 
      <0.000000, 0.360528, 1.020248>, <0.550000, 0.360528, 1.020248>, <1.000000, 0.353286, 0.546436>, <1.000000, 0.001611, -0.003051>, 
      <0.000000, -0.451151, 1.743960>, <0.550000, -0.451151, 1.743960>, <1.372998, 0.146124, 0.549187>, <1.186499, 0.148029, -0.000810>, 
      <0.000000, -0.019539, 1.371273>, <0.550000, -0.021557, 1.372101>, <1.186499, 0.277859, 0.549716>, <1.093249, 0.279763, -0.001112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <1.000000, -0.776671, -0.004862>, <1.000000, -0.951550, -0.554601>, <1.167313, -0.949960, -1.014392>, <0.000000, -0.952002, -1.013684>, 
      <1.000000, 0.001611, -0.003051>, <1.000000, -0.350064, -0.552538>, <1.167313, -0.348474, -1.012328>, <0.000000, -0.348474, -1.012328>, 
      <1.186499, 0.148029, -0.000810>, <1.000000, 0.149933, -0.550807>, <1.167313, 0.151523, -1.010596>, <0.000000, 0.151523, -1.010596>, 
      <1.093249, 0.279763, -0.001112>, <1.000000, 0.281669, -0.550278>, <1.167313, 0.283259, -1.010066>, <0.000000, 0.281219, -1.010899>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.952002, -1.013684>, <-1.167313, -0.949960, -1.014392>, <-1.000000, -0.951550, -0.554601>, <-1.000000, -0.776671, -0.004862>, 
      <0.000000, -0.348474, -1.012328>, <-1.167313, -0.348474, -1.012328>, <-1.000000, -0.350064, -0.552538>, <-1.000000, 0.001611, -0.003051>, 
      <0.000000, 0.151523, -1.010596>, <-1.167313, 0.151523, -1.010596>, <-1.000000, 0.149933, -0.550807>, <-1.186499, 0.148029, -0.000810>, 
      <0.000000, 0.281219, -1.010899>, <-1.167313, 0.283259, -1.010066>, <-1.000000, 0.281669, -0.550278>, <-1.093249, 0.279763, -0.001112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <-1.093249, 0.279763, -0.001112>, <-1.186499, 0.277859, 0.549716>, <-0.550000, -0.021557, 1.372101>, <0.000000, -0.019539, 1.371273>, 
      <-1.000000, 0.411500, 0.000248>, <-1.000000, 0.409595, 0.550245>, <-0.550000, 0.408037, 1.000242>, <0.000000, 0.408037, 1.000242>, 
      <-0.502589, 2.985504, 0.004998>, <-0.502589, 2.984815, 0.191042>, <-0.276424, 2.984251, 0.343259>, <0.000000, 2.984251, 0.343259>, 
      <-0.197771, 0.282483, 0.001197>, <-0.197771, 0.282107, 0.109970>, <-0.108774, 0.281798, 0.198966>, <0.000000, 0.281798, 0.198966>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, -0.019539, 1.371273>, <0.550000, -0.021557, 1.372101>, <1.186499, 0.277859, 0.549716>, <1.093249, 0.279763, -0.001112>, 
      <0.000000, 0.408037, 1.000242>, <0.550000, 0.408037, 1.000242>, <1.000000, 0.409595, 0.550245>, <1.000000, 0.411500, 0.000248>, 
      <0.000000, 2.984251, 0.343259>, <0.276424, 2.984251, 0.343259>, <0.502589, 2.984815, 0.191042>, <0.502589, 2.985504, 0.004998>, 
      <0.000000, 0.281798, 0.198966>, <0.108774, 0.281798, 0.198966>, <0.197771, 0.282107, 0.109970>, <0.197771, 0.282483, 0.001197>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <1.093249, 0.279763, -0.001112>, <1.000000, 0.281669, -0.550278>, <1.167313, 0.283259, -1.010066>, <0.000000, 0.281219, -1.010899>, 
      <1.000000, 0.411500, 0.000248>, <1.000000, 0.413404, -0.549749>, <1.167313, 0.414994, -1.009535>, <0.000000, 0.414994, -1.009535>, 
      <0.502589, 2.985504, 0.004998>, <0.502589, 2.986193, -0.181045>, <0.276424, 2.986756, -0.333262>, <0.000000, 2.986756, -0.333262>, 
      <0.197771, 0.282483, 0.001197>, <0.197771, 0.282860, -0.107576>, <0.108774, 0.283168, -0.196573>, <0.000000, 0.283168, -0.196573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 5 v_steps 5,
      <0.000000, 0.281219, -1.010899>, <-1.167313, 0.283259, -1.010066>, <-1.000000, 0.281669, -0.550278>, <-1.093249, 0.279763, -0.001112>, 
      <0.000000, 0.414994, -1.009535>, <-1.167313, 0.414994, -1.009535>, <-1.000000, 0.413404, -0.549749>, <-1.000000, 0.411500, 0.000248>, 
      <0.000000, 2.986756, -0.333262>, <-0.276424, 2.986756, -0.333262>, <-0.502589, 2.986193, -0.181045>, <-0.502589, 2.985504, 0.004998>, 
      <0.000000, 0.283168, -0.196573>, <-0.108774, 0.283168, -0.196573>, <-0.197771, 0.282860, -0.107576>, <-0.197771, 0.282483, 0.001197>
    }
  }
  rotate x*-90
}

camera {
  location <-162+162*pow(clock,0.5), 70-62.5*pow(clock,2), -90-54.3*pow(pow((1-(10.5/time)),-1)*((clock-(10.5/time))),3)*((clock-(10.5/time)) > 0)>
  //look_at <0, 0, -60>
  look_at <0, 7.5, -160*pow(2*(clock-0.5),2)*((clock-0.5) > 0)>
  //location <0, 7.5, -154.2>
  //look_at <0, 7.5, -1000>
}

light_source {
  <-2500, 1500, 1500>
  colour rgb <1,1,1>
}

AlienCarrier (<0,0,0>, <0,0,0>, min(20/(5/time)*clock,20))

object { AlienFighter
  texture { Organic }
  translate <0, 0, 10-180*pow(pow((1-(-7/time)),-1)*((clock-(-7/time))),2)*((clock-(-7/time)) > 0)>
}

object { AlienFighter
  texture { Organic }
  translate <min(-7.5*pow(pow((1-(-1.5/time)),-1)*((clock-(-1/time))),3),0), 0, 10-150*pow(pow((1-(-1.5/time)),-1)*((clock-(-1.5/time))),2)*((clock-(-1.5/time)) > 0)>
}

object { AlienFighter
  texture { Organic }
  translate <max(7.5*pow(pow((1-(5/time)),-1)*((clock-(5/time))),3),0), 0, 10-150*pow(pow((1-(5/time)),-1)*((clock-(5/time))),2)*((clock-(5/time)) > 0)>
}

object { AlienFighter
  texture { Organic }
  translate <0, max(7.5*pow(pow((1-(10.5/time)),-1)*((clock-(10.5/time))),3),0), 10-150*pow(pow((1-(10.5/time)),-1)*((clock-(10.5/time))),2)*((clock-(10.5/time)) > 0)>
}

object { AlienFighter
  texture { Organic }
  translate <0, min(-7.5*pow(pow((1-(14/time)),-1)*((clock-(14/time))),3),0), 10-150*pow(pow((1-(14/time)),-1)*((clock-(14/time))),2)*((clock-(14/time)) > 0)>
}

sphere { <0,0,0>, 2
  texture { Land }
  texture { Ocean }
  texture { CloudCover }
  scale 150
  rotate y*170
  translate <15, 120, -1000>
}

object { AlienEscort
  texture { Organic }
  rotate <10, 0, -10>
  translate <-20, -10, -400>
}

AlienCarrier (<-10,0,0>, <80, 50, -350>, min(20/(5/time)*clock,20))   

object { AlienEscort
  texture { Organic }
  translate <160, -25, -250>
}

object { AlienEscort
  texture { Organic }
  translate <100, 30, -175>
}

object { AlienEscort
  texture { Organic }
  translate <350, 80, -275>
}

object { AlienEscort
  texture { Organic }
  translate <200, -50, -150>
}

object { AlienEscort
  texture { Organic }
  translate <120, -75, -75>
}

AlienCarrier (<0,0,0>, <225, -35, -210>, min(20/(5/time)*clock,20))

Stars ()