// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Checkered Floor Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
  string_encoding "ISO8859_1" 
}

// ----------------------------------------
camera
{
  location  <0.0, 0.0, -8.0>
  
  direction 1.5*z
  right     320/240*x
  orthographic
  look_at   <0.0, 0.0,  0.0>
}

#declare Sandstone = texture {
  pigment { agate frequency 10 pigment_map {
      [ 0 rgb <.6,.5,.4> ]
      [.1 rgb <.65,.6,.55> ]
      [.9 rgb <.65,.6,.55> ]
      [1  rgb <.7,.6,.5> ]
  }
  //scale <20,1,20>
  }
  normal { granite scale 10 }
}


#declare encre=texture{
gradient y+x
texture_map{               
[0  pigment {colour White} finish { ambient 1 } ]
[clock/3  pigment {colour White} finish { ambient 1 } ]
[clock/3  Sandstone finish { ambient 1 } ]
[1  Sandstone finish { ambient 1 } ]
} 
       
}        

background{Black}
// create a TrueType text shape
text
{
  ttf             // font type (only TrueType format for now)
  "times.ttf",  // Microsoft Windows-format TrueType font file name
  "(POV-Ray 3.1g+)",      // the string to create
  0.001,              // the extrusion depth
  0               // inter-character spacing
  
  texture { pigment {colour White}  finish { ambient 1 } }
#switch(clock)
#range(1,2)
  rotate <clock*360,0,0>
#break
#end
  scale 1/2
  translate <-2,-2,0>
}

text
{
  ttf             // font type (only TrueType format for now)
  "arial.ttf",  // Microsoft Windows-format TrueType font file name
  concat(chr(169)," 2000 J",chr(233),"r",chr(244),"me Grimbert"), 
  0.001,              // the extrusion depth
  0               // inter-character spacing
  
  texture { pigment {colour White}  finish { ambient 1 } }
  scale 1/2
  translate <-3,-2.7,0>
}

text
{
  ttf             // font type (only TrueType format for now)
  "times.ttf",  // Microsoft Windows-format TrueType font file name
  "Alien Invasion",      // the string to create
  0.001,              // the extrusion depth
  0               // inter-character spacing
  
  texture { 
gradient y
texture_map{  
[0 pigment {colour Green}  finish { ambient 1 } ]
[(clock-int(clock))/2 pigment {colour Green}  finish { ambient 1 } ]
[clock-int(clock) pigment {colour White}  finish { ambient 1 } ]
[1 pigment {colour White}  finish { ambient 1 } ]
}
}
  //scale 2/3
  translate <-3,2,0>
}

text
{
  ttf             // font type (only TrueType format for now)
  "arial.ttf",  // Microsoft Windows-format TrueType font file name
  "IRTC 2000-10-15",      // the string to create
  0.001,              // the extrusion depth
  0               // inter-character spacing
  
  texture { pigment {colour White}  finish { ambient 1 } }
  scale 2/3
  translate <-2.6,1,0>
}


text
{
  ttf             // font type (only TrueType format for now)
  "times.ttf",  // Microsoft Windows-format TrueType font file name
  "Sylvanus",      // the string to create
  0.001,              // the extrusion depth
  0               // inter-character spacing
  scale 1.65
  
  texture { encre  }
  translate <-3,-0.7,0>
  translate <1/3*(3-clock)*cos(clock*pi*2/3),
             1/6*(3-clock)*sin(clock*pi*2), 0>
}


