#include "colors.inc"
#include "metals.inc"
#include "golds.inc"                                                            
#include "txttree.inc"

global_settings { max_trace_level 50 }                                          
//=========================================
// Camera & light
//-----------------------------------------
#declare PdV=<30, 200+clock*10 , -20>;
#declare PdA=<0,0,-10-clock*2>;
camera {location  PdV direction <0.0 , 0.0 , 5.0-clock/9 > up y  right 4*x/3 look_at   PdA}
//-----------------------------------------
light_source{PdV color White*0.5  shadowless}
light_source{<-2000,40000,-9000> color White*1.9}

sky_sphere {
    pigment {
      gradient y
      color_map {
        [ 0.5  color CornflowerBlue ]
        [ 1.0  color MidnightBlue ]
      }
      scale 2
      translate -1
    }
}                       

#declare Sandstone = texture {
  pigment { agate frequency 10 pigment_map {
      [ 0 rgb <.6,.5,.4> ]
      [.1 rgb <.65,.6,.55> ]
      [.9 rgb <.65,.6,.55> ]
      [1  rgb <.7,.6,.5> ]
  }
  //scale <20,1,20>
  }
  normal { granite scale 10 }
}
 
difference {                    
plane{y,0 }
box { <-2,-0.5,-20000>,<2,1,20000> }
 texture { Sandstone} 
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <-1400,-5000,1500>
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <1400,-5000,1500>
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <-1400,-5000,-1500>
}

sphere { <0,0,0>,5150
 texture { Sandstone }
 translate <1400,-5000,-1500>
}

box { <-2,0,-20000>,<2,-0.5,20000>
 pigment{ Gray30}
}

#declare maxi=6+6*int(clock); /* pour clock 0-->7 */
#declare tele=maxi-6;
#declare loop=1;
#declare rayo=<9.0,0,0>;
#declare rayn=vrotate(rayo,<0,120,0>);
#declare posi=rayo;
#declare nn=1;
#while (loop<=maxi)

#declare fileTree=concat("t",str(loop,-5,0),".inc")
#declare fileLeaf=concat("f",str(loop,-5,0),".inc")
#declare Leaf=#include "leaf.inc"
#declare txtTree=texture{ txtTree_6 }
#declare txtLeaf=texture{txtLeaf_4} // Leaf texture                             

union {
  object{#include fileTree }
  object{#include fileLeaf texture{txtLeaf} }
  scale 1/10
  translate posi
}

#declare fileTree=concat("t",str(loop+1,-5,0),".inc")
#declare fileLeaf=concat("f",str(loop+1,-5,0),".inc")
#declare txtTree=texture{ txtTree_6 }
#declare txtLeaf=texture{txtLeaf_4} // Leaf texture                             

union {
  object{#include fileTree}
  object{#include fileLeaf texture{txtLeaf} }
  scale 1/10
  translate <-posi.x,posi.y,posi.z>
}
#declare teleText=texture{
spiral1 5
texture_map{
[0 pigment{ color Clear} ]
[(clock-int(clock)) pigment{ color Clear} ]
[(4*(clock-int(clock))+1)/5 pigment{ color White} finish{ ambient 1}]
[1 pigment{ color White} finish {ambient 1} ]
}
rotate <90,0,0>
}
#if (loop>tele)
cylinder{ <0,0,0>, <0,10,0>, 4 texture { teleText } no_shadow 
translate posi }
cylinder{ <0,0,0>, <0,10,0>, 4
 texture { teleText } no_shadow 
translate <-posi.x,posi.y,posi.z> }
#end

#declare posi=posi+rayn;
#if (posi.x < 8)
#declare nn=nn+1;
#declare posi=nn*rayo;
#end
#declare loop=loop+2;
#end // loop

#declare murpig=
 pigment{ brick pigment{White},pigment{Red}
 brick_size <0.4,0.1,0.2>
 mortar 0.03
 }
#declare loop=-200;
#while (loop<200)
#declare murpos=<0,0,13>+loop*<0,0,1000>;
#declare loop=loop+1;
box { <-20000,0,0>,<-2,5,1>
 pigment{murpig}
 translate murpos
}
box { <2,0,0>,<20000,5,1>
 pigment{murpig}
 translate murpos
}

difference { 
cylinder { <0,0,0>,<0,0,1>,3 }
cylinder { <0,0,-1>,<0,0,2>,2 }
plane { y , 0 }
 pigment{murpig
 rotate <90,0,0>
 warp { cylinder <0,0,0>,<1,1,6.11> }
 rotate <90,0,0>
 }
translate <0,5,0>+murpos
}
#end

