// Persistence of Vision Ray Tracer Scene Description File
// File: robot.inc
// Vers: 3.1
// Desc: 
// Date: 
// Auth: Jrme Grimbert

#include "finish.inc"

// 1 Pov = 1 m
// Devant = +x

#local empattement=1.0;
#local rayon=1.0;
#local cuisse=1.5;
#local rayon_roue = 0.12;

#local roue=union
{
  cylinder { <0,0,0.03>,<0,0,0.04>,0.1 }
  cylinder { <0,0,-0.03>,<0,0,-0.04>,0.1 }
  cylinder { <0,0,-0.045>,<0,0,0.045>,0.05 }
  difference { 
    cylinder { <0,0,0.02>,<0,0,0.05>,rayon_roue }
    cylinder { <0,0,0.01>,<0,0,0.06>,0.1 }
    }
  difference { 
    cylinder { <0,0,-0.02>,<0,0,-0.05>,rayon_roue }
    cylinder { <0,0,-0.01>,<0,0,-0.06>,0.1 }
    }
  texture { pigment { rgb <0.2,0.8,0.9> } }  
}

#local RG=array[3]
#local RD=array[3]
#local minG=0.0;
#local minD=0.0;
#local i=0;
#while(i<3)
#local RG[i]=empattement/2*z+rayon*vrotate(y,(AlphaG+120*i)*z);
#local RD[i]=-empattement/2*z+rayon*vrotate(y,(AlphaD+120*i)*z);
#local minG=min(minG,vdot(RG[i],y));
#local minD=min(minD,vdot(RD[i],y));

#local i=i+1;
#end

#local deltaG=(0-minG+rayon_roue+0.01)*y;
#local deltaD=(0-minD+rayon_roue+0.01)*y;


#local i=0;
#local droite=<0,0,0>;
#local gauche=<0,0,0>;
#while (i<3)
#local RG[i]=RG[i]+deltaG;
#local RD[i]=RD[i]+deltaD;
#local droite=droite+RD[i];
#local gauche=gauche+RG[i];
#local i=i+1;
#end
#if (Tilt>90)
#local Rac=-1;
#else 
#local Rac=1;
#end

#local droite=droite/3;
#local gauche=gauche/3;
 
#local diff=minG-minD;
#if (diff<0)
// Droite sert de reference 
#local bassin=<droite.x,droite.y,0>+<-cuisse*cos(radians(Tilt)),cuisse*sin(radians(Tilt)),0>;
// ajuste la position de Gauche
#local deltaD=<0,0,0>;

#local vect=gauche-bassin;
#local v2=droite-bassin;

#local xx=vect.x;
#local yy=vect.y; 
#local xxx=v2.x;
#local yyy=v2.y;

#local bb=2*xxx;
#local cc=(yy-yyy)*(yy-yyy)+2*(yy-yyy)*yyy;

#local alea=(bb*bb/4-cc);
#if (alea>=0)
#local delta=<-bb/2+Rac*sqrt(alea),0,0>;
#local deltaG=delta;

#else
#debug concat(str(alea,0,4),"\n")
#error "No Racine for delta-x"
#end

  

#else
// Gauche sert de reference
#local bassin=<gauche.x,gauche.y,0>+<-cuisse*cos(radians(Tilt)),cuisse*sin(radians(Tilt)),0>;
// ajuste la position de Droite
#local deltaG=<0,0,0>;

#local v2=gauche-bassin;
#local vect=droite-bassin;

#local xx=(vect.x);
#local yy=(vect.y); 
#local xxx=(v2.x);
#local yyy=(v2.y);

#local bb=2*xxx;
#local cc=(yy-yyy)*(yy-yyy)+2*(yy-yyy)*yyy;

#local alea=(bb*bb/4-cc);
#if (alea>=0)
#local delta=<-bb/2+Rac*sqrt(alea),0,0>;
#local deltaD=delta;

#else 
#debug concat(str(alea,0,4),"\n")
#error "No Racine for delta-x"
#end



#end

#local i=0;
#local droite=<0,0,0>;
#local gauche=<0,0,0>;
#while (i<3)
#local RG[i]=RG[i]+deltaG;
#local RD[i]=RD[i]+deltaD;
#local droite=droite+RD[i];
#local gauche=gauche+RG[i];
#local i=i+1;
#end

#local droite=droite/3;
#local gauche=gauche/3;
 




#local i=0;
#while (i<3)
object { roue translate RG[i] rotate <0,RY,0> translate <TX,TY,TZ>}
object { roue translate RD[i] rotate <0,RY,0> translate <TX,TY,TZ>}
#local i=i+1;
#end

union 
{
sphere { droite, 0.1 }
#local i=0;
#while(i<3)
difference {
   cone { RD[i],0.015,droite,0.1 }
   cylinder { RD[i]-0.025*z,RD[i]+0.025*z, 0.08}
   }
difference {
   cylinder { RD[i]-0.025*z,RD[i]+0.025*z, 0.08} 
   cylinder { RD[i]-0.03*z, RD[i]+0.03*z, 0.05 }
   }
sphere{ (2*RD[i]+droite)/3,0.05 }

#local i=i+1;
#end 
cylinder { (2*RD[1]+droite)/3,(2*RD[2]+droite)/3,0.05 }
cylinder { (2*RD[2]+droite)/3,(2*RD[0]+droite)/3,0.05 }
cylinder { (2*RD[0]+droite)/3,(2*RD[1]+droite)/3,0.05 }


cylinder { droite, droite+empattement/6*z, 0.2 } 
   texture { T_Robot  }
rotate <0,RY,0> 
translate <TX,TY,TZ>
}

union 
{
sphere { gauche, 0.1 }
#local i=0;
#while(i<3)
difference {
   cone { RG[i],0.015,gauche,0.1 }
   cylinder { RG[i]-0.025*z,RD[i]+0.025*z, 0.08}
   }
difference {
   cylinder { RG[i]-0.025*z,RG[i]+0.025*z, 0.08} 
   cylinder { RG[i]-0.03*z, RG[i]+0.03*z, 0.05 }
   }
   
sphere{ (2*RG[i]+gauche)/3,0.05 }
   
#local i=i+1;
#end 
cylinder { (2*RG[1]+gauche)/3,(2*RG[2]+gauche)/3,0.05 }
cylinder { (2*RG[2]+gauche)/3,(2*RG[0]+gauche)/3,0.05 }
cylinder { (2*RG[0]+gauche)/3,(2*RG[1]+gauche)/3,0.05 }

cylinder { gauche, gauche-empattement/6*z, 0.2 }
   texture { T_Robot  }
rotate <0,RY,0> 
translate <TX,TY,TZ>
} 

#local base=bassin+<cuisse*cos(radians(Tilt)),cuisse*sin(radians(Tilt)),0>;

 

union{
sphere { gauche-empattement/6*z,0.05 }
cylinder { gauche-empattement/6*z ,<bassin.x,bassin.y,gauche.z-empattement/6>,0.05 } 
sphere { <bassin.x,bassin.y,gauche.z-empattement/6>,0.1 }
cylinder { <bassin.x,bassin.y,droite.z+empattement/6>,<bassin.x,bassin.y,gauche.z-empattement/6>,0.1 }
sphere { <bassin.x,bassin.y,droite.z+empattement/6>,0.1 } 
sphere { droite+empattement/6*z,0.05 }
cylinder { droite+empattement/6*z ,<bassin.x,bassin.y,droite.z+empattement/6>,0.05 }
cylinder { bassin, base, 0.1 }
sphere { base, 0.1 }
cylinder { base, base+0.22*y, 0.05 }

superellipsoid{ <0.1,0.2> scale <1,0.75,1/4> translate <base.x,base.y+0.75+0.20,base.z>}
superellipsoid{ <0.2,0.2> scale <1/2,1/4,1> translate <base.x+0.5,base.y+0.75+0.20+0.5,base.z>}
sphere { <base.x+0.5,base.y+0.75+0.20+0.75,base.z>,1/3 } 
#local i = 0;
#while (i<36)
sphere { <base.x+0.5+(1/3+0.03)*cos(radians(i*10)),
          base.y+0.75+0.20+0.75,
          base.z+(1/3+0.03)*sin(radians(i*10))>,0.015 }
#local i=i+1;
#end 
sphere { base+<1,0.75+0.20+0.5,0.5>,1/8 texture { pigment { Black } finish { Shiny} }}
sphere { base+<1,0.75+0.20+0.5,-0.5>,1/8 texture { pigment { Black } finish { Shiny}}}
sphere { base+<0.5,0.75+0.20+0.5,1>,1/8  }
sphere { base+<0.5,0.75+0.20+0.5,-1>,1/8 }
#local i = 0;
#while (i<18)
sphere { base+<1,0.75+0.20+0.5,0.5>+<0,(1/8+0.03)*cos(radians(i*20)),(1/8+0.03)*sin(radians(i*20))>,0.015}
sphere { base+<1,0.75+0.20+0.5,-0.5>+<0,(1/8+0.03)*cos(radians(i*20)),(1/8+0.03)*sin(radians(i*20))>,0.015}
sphere { base+<0.5,0.75+0.20+0.5,1>+<(1/8+0.03)*cos(radians(i*20)),(1/8+0.03)*sin(radians(i*20)),0>,0.015  }
sphere { base+<0.5,0.75+0.20+0.5,-1>+<(1/8+0.03)*cos(radians(i*20)),(1/8+0.03)*sin(radians(i*20)),0>,0.015 }
#local i=i+1;
#end

texture { T_Robot }
rotate <0,RY,0> 
translate <TX,TY,TZ>

}

// chenille

#local lon = 3*sqrt(3)*rayon + rayon_roue * pi * 2;
///#debug concat("longueur : ",str(lon,1,5))
#macro pos(po,bas,ll,lr,base)
#local po= mod(po,lr);
#if (po<0) 
#local po = po+lr;
#end
#local a0=0;
#local a1=sqrt(3)*rayon;
#local a2=sqrt(3)*rayon+rayon_roue*pi*2/3;
#local a3=sqrt(3)*rayon+rayon_roue*pi*2/3+sqrt(3)*rayon;
#local a4=2*(sqrt(3)*rayon+rayon_roue*pi*2/3);
#local a5=2*(sqrt(3)*rayon+rayon_roue*pi*2/3)+sqrt(3)*rayon;
#local a6=lr;
#switch(po)

#range(a0,a1)
#local ll=bas[0]
   +(bas[1]-bas[0])*((po-a0)/a1)
   +(rayon_roue*vnormalize(base-bas[2]));
#break 

#range(a2,a3)
#local ll=bas[1]
    +(bas[2]-bas[1])*((po-a2)/a1)
    +(rayon_roue*vnormalize(base-bas[0]));
#break 

#range(a4,a5)
#local ll=bas[2]
   +(bas[0]-bas[2])*((po-a4)/a1)
   +(rayon_roue*vnormalize(base-bas[1]));
#break 

#range(a1,a2)
#local ll=bas[1]
   +rayon_roue*vrotate(vnormalize(base-bas[2]),
     z*(degrees((po-a1)/rayon_roue)));
#break

#range(a3,a4)
#local ll=bas[2]
   +rayon_roue*vrotate(vnormalize(base-bas[0]),
     z*(degrees((po-a3)/rayon_roue)));
#break 

#range(a5,a6)
#local ll=bas[0]
   +rayon_roue*vrotate(vnormalize(base-bas[1]),
     z*(degrees((po-a5)/rayon_roue)));
#break

#end
#end

#macro lame(dd,ff,ee)
#local VX=vnormalize(ff-dd);
#local VZ=z;
#local VY=vnormalize(vcross(VZ,VX));
#local VT=((dd+ff)/2);
  
merge{
box{ <ee/3,0.0,-0.1>,<-ee/3,-0.01,0.1> }
box{ <-ee*2/3,-0.005,0.02>,<ee*2/3,0,-0.02>}


  matrix <VX.x,VX.y,VX.z,VY.x,VY.y,VY.z,VZ.x,VZ.y,VZ.z,VT.x,VT.y,VT.z> 
 texture { T_Chenille }
 rotate <0,RY,0> 
 translate <TX,TY,TZ>
}

#end

#local deltarot= radians(RY)*empattement/2;
#local PdeltaD=-radians(AlphaD)*(rayon+rayon_roue+0.01);
#local PdeltaG=-radians(AlphaG)*(rayon+rayon_roue+0.01);

#local elemsize = 0.05;
#local debut=<0,0,0>;
#local fin=<0,0,0>;
#local iii=0;
#local ppp=0;
#while (iii<lon)
#local ppp=iii+ChenilleD+lon+deltarot+PdeltaD;
pos(ppp,RD,debut,lon,droite)
#local ppp=iii+ChenilleD+elemsize*0.95+lon+deltarot+PdeltaD;
pos(ppp,RD,fin,lon,droite)
lame(debut,fin,elemsize) 
#local ppp=iii+ChenilleG+lon-deltarot+PdeltaG;
pos(ppp,RG,debut,lon,gauche)
#local ppp=iii+ChenilleG+elemsize*0.95+lon-deltarot+PdeltaG;
pos(ppp,RG,fin,lon,gauche)
lame(debut,fin,elemsize) 

#local iii=iii+elemsize;
#end
/*
#local ppp=ChenilleD+lon+deltarot+PdeltaD;
pos(ppp,RD,debut,lon,droite)
sphere { debut, 0.1 
 rotate <0,RY,0> 
 translate <TX,TY,TZ>
texture { pigment {rgbt <1,0,0,0.5>} finish { ambient 1 } } }

#local ppp=ChenilleG+lon-deltarot+PdeltaG;
pos(ppp,RG,debut,lon,gauche)
sphere { debut, 0.1 
 rotate <0,RY,0> 
 translate <TX,TY,TZ>
texture { pigment{rgbt <0,1,0,0.5>} finish { ambient 1 } } }
 */