//blend between two numbers, using an index number and start and end values (on that index video).
//very useful for animations.
#macro blend( from, to, index, range_start, range_end )
	#if ( index <= range_start )
		#declare blended = (from);
	#else
		#if ( index >= range_end )
			#declare blended = (to);
		#else
			#local _ratio = (index-range_start)/(range_end-range_start);
			//bend on a nice curvey function to keep second order continuity.
			//dammit man, I'm a mathematician, not an animator :)
			#local _ratio = sin((_ratio-0.5)*pi)*0.5+0.5;
			#declare blended = ((from*(1-_ratio)) + (to*_ratio))
		#end
	#end
#end

#macro blendf( from, to, index, range_start, range_end )
	#if ( index <= range_start )
		#declare blendedf = (from);
	#else
		#if ( index >= range_end )
			#declare blendedf = (to);
		#else
			#local _ratio = (index-range_start)/(range_end-range_start);
			//bend on a nice curvey function to keep second order continuity.
			//dammit man, I'm a mathematician, not an animator :)
			#local _ratio = sin((_ratio-0.5)*pi)*0.5+0.5;
			#declare blendedf = ((from*(1-_ratio)) + (to*_ratio))
		#end
	#end
#end



