// Copyright (c) Duncan Gray 12.01.2001
//
//     mail:duncang@eclipse.co.uk
//     http:www.duncang.eclipse.co.uk
//
// I submit to the standard Raytracing Competition Copyright.
// any other unauthorised use of this code is expressly forbidden.
//
//	Read, Learn, Understand & Do It Yourself ... Please.
//
#ifdef (main_run)
#else

#include "colors.inc"
#include "metals.inc"

#declare amb_light=.2;
#declare dif_light=.8;
#declare pen_light=.2;
#declare lamp_pos=<0,23,-30>;
#declare cam_pos=<0,3.95,-10>;
#declare cam_tgt=<-.5,1.96,1>;

light_source { 
  0,1
  translate lamp_pos
}

light_source { 
  0,pen_light
  translate <lamp_pos.x,100,lamp_pos.z>
  shadowless
}
light_source { 
  0,pen_light
  translate <lamp_pos.x,-100,lamp_pos.z>
  shadowless
}
 
camera {
  location cam_pos
  angle 45 
  up<0,1,0>
  right <4/3,0,0>
  look_at cam_tgt
}

plane { y,0 
  texture { 
    pigment { color rgb<1,1,1> } 
    finish { 
      ambient amb_light 
      diffuse dif_light 
      roughness .1 
      specular .5
    }
  }
}

#macro flight_spline ( start_position,weight1,weight2,end_position,start_clock,end_clock,current_clock )
  #local clock_invs=(current_clock-start_clock)/(end_clock-start_clock);
  #local clock_offs=1-clock_invs;
  #if ( current_clock <= start_clock )
    (start_position)
  #end
  #if ( current_clock >= end_clock )
    (end_position)
  #end
  #if ( ( current_clock > start_clock ) & ( current_clock < end_clock ) )
    //  result = (pos1 * nt ^ 3) +          (3 * weight1 * nt ^ 2 * pt) + (3 * weight2 * pt ^ 2 * nt) + (pos2 * pt ^ 3) 
    ( ( start_position*pow(clock_offs,3) ) + ( weight1*3*pow(clock_offs,2)*clock_invs ) + ( weight2*3*pow(clock_invs,2)*clock_offs ) + ( end_position*pow(clock_invs,3) ) )
  #end
#end     

#end
             
#declare cyrus_grey=
  texture {
    pigment {
      color rgb<.2,.2,.24>
    }
    finish { 
      ambient amb_light 
      diffuse dif_light 
      roughness .1 
      specular .3
    }
  }
#declare round_knob=
difference {  
  union {
    cylinder { <0,0,1>,<0,0,-.09>,.19 }
    cone { <0,0,-.09>,.19,<0,0,-.1>,.18 }
    
    texture { cyrus_grey }
  }
  box { <-.0075,.1,-.095>,<.0075,.22,-1.05>
    texture {
      pigment { color rgb<.9,.9,.9> }
      finish { ambient amb_light diffuse dif_light roughness .05 specular .2 }
    }
  }
}

#declare amp=
  union {
    difference {
      box { <0,.025,0>,<2.2,.9,3> }
      cylinder { <0,0,.05>,<0,0,-.01>,.2 translate <.25,.5,0> }
      cylinder { <0,0,.05>,<0,0,-.01>,.2 translate <.7,.5,0> }
      cylinder { <0,0,.05>,<0,0,-.01>,.2 translate <1.15,.5,0> }
      texture { cyrus_grey }
    }
    box { <.04,.025,0>,<2,.15,.1> translate <0,-.14,0> rotate <30,0,0> translate <0,.14,0> texture { cyrus_grey } }
    box { <2.04,.035,0>,<2.16,.14,-.05> 
      texture {
        pigment { color rgb<.1,.1,.1> }
        finish { ambient amb_light diffuse dif_light roughness .05 specular .3 }
      }
    }
    object { round_knob rotate <0,0,90> translate <.25,.5,0> }
    object { round_knob rotate <0,0,-15> translate <.7,.5,.03> }
    object { round_knob rotate <0,0,15> translate <1.15,.5,.03> }
  }
#declare psx=
union {
    box { <0,.025,0>,<2.2,.9,3> }
    box { <.04,.025,0>,<2,.15,.1> translate <0,-.14,0> rotate <30,0,0> translate <0,.14,0> }
    box { <2.04,.035,0>,<2.16,.14,-.05> 
      texture {
        pigment { color rgb<.1,.1,.1> }
        finish { ambient amb_light diffuse dif_light roughness .05 specular .3 }
      }
    }
    text {
      ttf "c:\winnt\fonts\bolt.ttf"
      "PSX"
      1,0
      scale .6
      
      translate <.1,.25,-.03>
    }
    texture { cyrus_grey } 
  }
#declare window_stamp=
  difference {
    box { <-.5,-.1,-.1>,<.5,.1,.1> }
    box { <-.6,0,0>,<.6,.2,.2> rotate <45,0,0> translate <0,.1,0> }
    box { <-.6,0,0>,<.6,.2,.2> rotate <45,0,0> translate <0,-.1,0> }
    box { <0,-.2,0>,<.2,.2,.2> rotate <0,-45,0> translate <.5,0,0> }
    box { <0,-.2,0>,<.2,.2,.2> rotate <0,-45,0> translate <-.5,0,0> }
  }
   
#declare radio=
  union {
    difference {
      box { <0,.025,0>,<2.2,.9,3> }
      object { window_stamp translate <1.55,.6,0> }
      texture { cyrus_grey }
    }
    box { <-.6,-.2,.02>,<.6,.2,.1> translate <1.55,.6,0>
      texture {
        pigment { color rgb<.1,.3,.1> }
        finish { ambient amb_light diffuse dif_light/2 roughness .005 specular .6 }
      }
    }
    box { <.04,.025,0>,<2,.15,.1> translate <0,-.14,0> rotate <30,0,0> translate <0,.14,0> texture { cyrus_grey } }
    union {
      box { <0,0,-.015>,<.15,.035,.1> translate <.15,.63,0> }
      box { <0,0,-.015>,<.15,.035,.1> translate <.35,.63,0> }
      box { <2.04,.035,0>,<2.16,.14,-.05> }
      texture {
        pigment { color rgb<.1,.1,.1> }
        finish { ambient amb_light diffuse dif_light roughness .05 specular .3 }
      }
    }
    union {
      box { <0,0,-.015>,<.15,.1,.1> translate <.15,.5,0> }
      box { <0,0,-.015>,<.15,.1,.1> translate <.35,.5,0> }
      box { <0,0,-.015>,<.15,.1,.1> translate <.55,.5,0> }
      box { <0,0,-.015>,<.15,.1,.1> translate <.75,.5,0> }
      texture {
        pigment { color rgb<.4,.4,.4> }
        finish { ambient amb_light diffuse dif_light roughness .05 specular .3 }
      }
    }
  }
  
#declare cd_tray=superellipsoid{ <.1,.1> translate <1,0,1> scale <.75,.15,1> }
#declare cd=
  union {         
    difference {
      box { <0,.025,0>,<4.4,.9,2.5> }
      object { cd_tray scale <1.01,1.05,1> translate <.15,.5,-1.98> }
      object { window_stamp scale <1.55,1.5,1> translate <3.185,.57,0> }
      texture { cyrus_grey }
    }
    object { cd_tray translate <.15,.5,-.01> texture { cyrus_grey } }
    box { <-.6,-.2,.02>,<.6,.2,.1> scale <1.55,1.5,1> translate <3.185,.57,0>
      texture {
        pigment { color rgb<.1,.3,.1> }
        finish { ambient amb_light diffuse dif_light/2 roughness .005 specular .6 }
      }
    }
    
    box { <.2,.025,0>,<4.36,.15,.1> translate <0,-.14,0> rotate <30,0,0> translate <0,.14,0> texture { cyrus_grey } }
    union {
      box { <0,0,-.015>,<.17,.075,.1> translate <2.4,.25,0> }
      box { <0,0,-.015>,<.17,.075,.1> translate <2.6,.25,0> }
      box { <0,0,-.015>,<.17,.075,.1> translate <2.8,.25,0> }
      box { <0,0,-.015>,<.17,.075,.1> translate <3.0,.25,0> }
      box { <0,0,-.015>,<.17,.075,.1> translate <3.2,.25,0> }
      box { <0,0,-.015>,<.17,.075,.1> translate <3.4,.25,0> }
      box { <0,0,-.015>,<.17,.075,.1> translate <3.6,.25,0> }
      box { <0,0,-.015>,<.17,.075,.1> translate <3.8,.25,0> }
      
      box { <.04,.035,0>,<.16,.14,-.05> }
      texture {
        pigment { color rgb<.1,.1,.1> }
        finish { ambient amb_light diffuse dif_light roughness .05 specular .3 }
      }
    }
    
  }                    
  

#declare black_wood_tex=
  texture {
    pigment {
      wood
      frequency 6
      poly_wave 1
      sine_wave
      turbulence .04
      octaves 6
      lambda 2
      omega .65
      color_map {
        [ 0 color rgb<.1,.1,.1> ]
        [ .5 color rgb<.3,.3,.3> ]
        [ 1 color rgb<.1,.1,.1> ]
      } 
      scale 2
    }
    finish {
      ambient amb_light
      diffuse .5
      #ifdef (quickrender)
      #else
        reflection 0.1
      #end
      specular 0.2
      roughness 0.1
    }
  }

#declare hfu_horiz=
  union {
    box { <-5,0,0>,<5,-.2,3.5> }
    cylinder { <-5,-.1,0>,<5,-.1,0>,.1 translate <0,0,0> }
    cylinder { <-5,-.1,0>,<5,-.1,0>,.1 translate <0,0,3.5> }
    cylinder { <0,-.1,0>,<0,-.1,3.5>,.1 translate <-5,0,0> }
    cylinder { <0,-.1,0>,<0,-.1,3.5>,.1 translate <5,0,0> }
    sphere { 0,.1 translate <-5,-0.1,0> }
    sphere { 0,.1 translate <5,-0.1,0> }
    sphere { 0,.1 translate <-5,-0.1,3.5> }
    sphere { 0,.1 translate <5,-0.1,3.5> }
    texture { black_wood_tex rotate <0,90,0> }
  }
#declare hfu_vert=
  union {
    box { <-.1,0,.2>,<.1,3.4,3.3> }
    cylinder { <0,0,.2>,<0,3.4,.2>,.1 }
    texture { black_wood_tex rotate <0,90,90> }
  }
#declare hifi_unit=
  union {
    object { hfu_horiz translate <0,.5,0> }
    object { hfu_horiz translate <0,2,0> }
    object { hfu_horiz translate <0,3.5,0> }
    object { hfu_vert translate <-4.8,0,0> }
    object { hfu_vert translate <0,0,0> }
    object { hfu_vert translate <4.8,0,0> }
  }   

#declare cd_fin=
  finish {
    ambient amb_light
    diffuse dif_light
  }
#declare cd_box=
  box { <0,0,0>,<.1,1.25,1.43> }

#macro rgb_sel(hue,bri,sat)
  #local cred=(flight_spline(1,1,.75,0,0,.33,hue));
  #local cred=(flight_spline(cred,.75,1,1,.66,1,hue));
  
  #local cgreen=(flight_spline(0,.75,1,1,0,.33,hue));
  #local cgreen=(flight_spline(cgreen,1,.75,0,.33,.66,hue));
  
  #local cblue=(flight_spline(0,.75,1,1,.33,.66,hue));
  #local cblue=(flight_spline(cblue,1,.75,0,.66,1,hue));

  #local rcol=<cred,cgreen,cblue>;
  #local rcol=rcol*pow(bri,2);
  #local rcol=(flight_spline(rcol,rcol,<1,1,1>,<1,1,1>,0,1,sat));
  rcol 
#end
#declare cd_row1=
  union {
  #local cd_seed=seed(42);
  #local cd_count=0;
  #local cd_pos=.12;
  #while (cd_pos<=4.61)
    object { cd_box
      translate <cd_pos,0,.2*rand(cd_seed)>
      texture {
        pigment {
          //#local pigm=rgb_sel(cd_pos/4.8,1,0);
          #local pigm=rgb_sel(rand(cd_seed),rand(cd_seed),rand(cd_seed));
          color pigm
        }
        finish {
          cd_fin
        }
      }
    }
    #local cd_pos=cd_pos+.11;
  #end
  }
#declare cd_row2=
  union {
  #local cd_seed=seed(43);
  #local cd_count=0;
  #local cd_pos=.12;
  #while (cd_pos<=4.61)
    object { cd_box
      rotate <0,0,(flight_spline(0,0,5,30,0,4.8,cd_pos))>
      translate <cd_pos,0,.2*rand(cd_seed)>
      texture {
        pigment {
          //#local pigm=rgb_sel(cd_pos/4.8,1,0);
          #local pigm=rgb_sel(rand(cd_seed),rand(cd_seed),rand(cd_seed));
          color pigm
        }        
        finish {
          cd_fin
        }
      }
    }
    #local cd_pos=cd_pos+(flight_spline(.11,.11,.12,.25,0,4.8,cd_pos));//.11;
  #end
  }
#macro cd_pile(cd_cnt,rseed)
  union {
  
  #local rnd=seed(rseed);
  #local cd_num=0;
  #while (cd_num<cd_cnt)
    #local cd_ang=(flight_spline(-8,-2,0,0,0,.5,rand(rnd)));
    #local cd_ang=(flight_spline(cd_ang,0,2,8,.5,1,rand(rnd)));
    
    object { cd_box
      translate <0,-1.25/2,-1.43/2>
      rotate <cd_ang,0,90>
      translate <pow(rand(rnd)-.5,2)/2,cd_num*.11,pow(rand(rnd)-.5,2)/2>
      texture {
        pigment {
          #local pigm=rgb_sel(rand(cd_seed),rand(cd_seed),rand(cd_seed));
          color pigm
        }
        finish {
          cd_fin
        }        
      }
    }
    #declare cd_num=cd_num+1;
  #end
  }
#end  
#declare stereo=
union {
    object { radio translate <.15,.5,-3.7> }
    object { amp translate <.15,.5,-3.7> translate <2.25,0,0> }
    object { psx translate <.15,2,-3.7> }
    object { amp translate <.15,2,-3.7> translate <2.25,0,0> }
    object { cd translate <.2,3.5,-3.7> }
    
    object { cd_row1 translate <-4.8,.5,-3.8> }
    object { cd_row2 translate <-4.8,2,-3.8> }
    object { cd_pile(10,1) translate <-1.5,3.5,-3> }
    object { cd_pile(15,2) translate <-3.5,3.5,-2> }
    object { hifi_unit translate <0,0,-3.7> }
  }

#declare cloth_tex=
  texture {
    pigment { color rgb<.2,.2,.2> }
    finish { 
      ambient amb_light 
      diffuse dif_light
      roughness .1 
      specular .05
    }
    normal {
      crackle .1 
      poly_wave 1 
      
      scale .05
    }
  }
#declare st_tex=
  texture {
    pigment { color rgb<.15,.15,.15> }
    finish { 
      ambient amb_light 
      diffuse dif_light/2
      roughness .1 
      specular .3
    }
  }  
#declare st_base=
  difference { 
    box { <-2,0,-1.5>,<2,.3,1.5> }
    box { <-2.01,0,0>,<2.1,.5,.5> rotate <-45,0,0> translate <0,.1,-1.51> }
    box { <-2.01,0,0>,<2.1,.5,.5> rotate <-45,0,0> translate <0,.1,1.51> }
    box { <0,0,-1.51>,<.5,.5,1.51> rotate <0,0,45> translate <-2.01,.1,0> }
    box { <0,0,-1.51>,<.5,.5,1.51> rotate <0,0,45> translate <2.01,.1,0> }
  }
#declare speaker=
  union {
    box { <-2,0,-1.5>,<2,9,1.5> texture { black_wood_tex rotate <90,0,0> } }
    difference {
      box { <-1.95,.05,-1.45>,<1.95,8.95,-1.6> }
      box { <0,0,0>,<.5,9,-.5> rotate <0,45,0> scale <2,1,1> translate <-1.95,0,-1.47> }
      box { <0,0,0>,<.5,9,-.5> rotate <0,45,0> scale <2,1,1> translate <1.95,0,-1.47> }
      box { <-2,0,0>,<2,-.5,-.5> rotate <45,0,0> scale <2,1,1> translate <0,0,-1.47> }
      box { <-2,0,0>,<2,-.5,-.5> rotate <45,0,0> scale <2,1,1> translate <0,9,-1.47> }
      texture { cloth_tex }
    }
    union {
      cone { <0,0,0>,0,<0,-.2,0>,.1 translate <-1.8,0,-1.3> }
      cone { <0,0,0>,0,<0,-.2,0>,.1 translate <1.8,0,-1.3> }
      cone { <0,0,0>,0,<0,-.2,0>,.1 translate <-1.8,0,1.3> }
      cone { <0,0,0>,0,<0,-.2,0>,.1 translate <1.8,0,1.3> }
      
      cone { <0,-8,0>,.1,<0,-8.2,0>,0 translate <-1.8,0,-1.3> }
      cone { <0,-8,0>,.1,<0,-8.2,0>,0 translate <1.8,0,-1.3> }
      cone { <0,-8,0>,.1,<0,-8.2,0>,0 translate <-1.8,0,1.3> }
      cone { <0,-8,0>,.1,<0,-8.2,0>,0 translate <1.8,0,1.3> }
      texture { T_Chrome_5A } 
    }
    union {
      object { st_base translate <0,-8,0> }
      object { st_base scale <1,-1,1> translate <0,-.2,0> }
      box { <-1,-.3,-.2>,<1,-7.9,.2> }
      texture { st_tex }
    }
    
    translate <0,8.15,0>
  }

#declare tv_tubetex=
  texture {    
    pigment {
      color rgb<.1,.1,.1>
    }
    finish {
      ambient amb_light
      diffuse dif_light
      reflection .2
      roughness .01
      specular .6
    }
  }
#declare tv_boxtex=
  texture {    
    pigment {
      color rgb<.3,.3.3>
    }
    finish {
      ambient amb_light
      diffuse dif_light
      roughness .05
      specular .3
    }
  }
#declare tv_base=
  difference { 
    box { <-1.49,0,-1>,<1.49,.3,1> }
    box { <-1.5,0,0>,<1.5,.5,.5> rotate <-45,0,0> translate <0,.1,-1.01> }
    box { <-1.5,0,0>,<1.5,.5,.5> rotate <-45,0,0> translate <0,.1,1.01> }
    box { <0,0,-1.1>,<.5,.5,1.1> rotate <0,0,45> translate <-1.5,.1,0> }
    box { <0,0,-1.1>,<.5,.5,1.1> rotate <0,0,45> translate <1.5,.1,0> }
  }
#declare tv_s_leg=
  difference {
    box { <-.1,0,-.5>,<.1,2,.5> }
    cylinder { <-.11,.6,-.6>,<.11,.6,-.6>,.3 }
    cylinder { <-.11,2-.6,-.6>,<.11,2-.6,-.6>,.3 }
    box { <-.11,.6,-.6>,<.11,2-.6,-.3> }
    cylinder { <-.11,.6,.6>,<.11,.6,.6>,.3 }
    cylinder { <-.11,2-.6,.6>,<.11,2-.6,.6>,.3 }
    box { <-.11,.6,.6>,<.11,2-.6,.3> }
    matrix < 1,0,0,
             0,1,.4,
             0,0,1,
             0,0,-.3 >
  } 
#declare tv_stand=
  union {
    object { tv_base scale <1,-1,1> translate <0,2,0> }
    object { tv_s_leg translate <1.2,0,0> }
    object { tv_s_leg translate <-1.2,0,0> }
    object { tv_base translate <0,0,0> }
    texture { tv_boxtex }
    translate <0,0,1> 
  }
#declare tv_tube=
  superellipsoid{ <.3.3> scale <4/3,1,.1> }
#declare tv_box=
  difference {
    union {
      //box { <-4/3*1.2,-1.6,0>,<4/3*1.2,1.2,1.5> }
      superellipsoid { <.05,.05> scale <4/3,1,1.5> translate <0,0,1.5> scale <1.2,1.2,.5> }
      box { <-1.2,-1.6,.1>,<1.2,.5,1.4> }
      box { <-.9,-.75,1.25>,<.9,.75,1.75> }
      box { <-.7,-.6,1.25>,<.7,.6,2> }
    }
    object { tv_tube scale 1.06 translate <0,0,-.05> }
  }
#declare tv_main=
  union {
    object { tv_box texture { tv_boxtex } }
    object { tv_tube translate <0,0,.05> texture { tv_tubetex } }
    translate <0,1.4,0>
  }
#declare tv_set=
  union {
    object { tv_main scale 1.2 translate <0,2,-.1> }
    object { tv_stand }
    translate <0,0,-2>
    scale 1.5
  }

#ifdef (main_run)  
#else
  object { tv_set rotate <0,20,0> }
#end

        