
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "shapes.inc"   
#include "spline.mcr"

camera
{
  location  <5,6,2>
  angle 40
  look_at   <0,0,1.7> 
//  location  <0,35,-5>
//  look_at   <0,0,-5>  
} 

//box { <-5,34.9,-10>, <5,36,0> pigment { color rgbt <0,1,0,.5> } } used with camera location <0,35,-5> to create status screen

#declare Start    = 0.0;
#declare End      = 35.0;
#declare My_Clock = 1;//Start+(End-Start)*clock;


sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }  scale 2 translate y
}

// An infinite planar surface
// plane {<A, B, C>, D } where: A*x + B*y + C*z = D
plane
{
  y, -10.0                                           
  pigment { color rgb <0.9 0.6, 0.6> }
  hollow on
} 


light_source
{
  0*x // light's position (translated below)
  color red 0.5  green 0.5  blue 0.5  // light's color
  translate <-1, 30, -1>
}   

light_source
{
  0*x // light's position (translated below)
  color red 0.5  green 0.5  blue 0.5  // light's color
  translate <300, 3000, -3000>
} 

/*
light_source
{
  0*x // light's position (translated below)
  color White  // light's color
  translate <0, 3, 14>
}
*/

#declare RED_LANDSPEEDER = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.70
        phong_size 21.0
        metallic
    }
    pigment { rgb <0.675, 0.000, 0.000> }
}

#declare __REFERENCE = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.03
        phong_size 1.0
        metallic
    }
    pigment { rgb <0.678, 0.678, 0.678> }
}

#declare __GRID = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.03
        phong_size 1.0
        metallic
    }
    pigment { rgb <0.482, 0.482, 1.000> }
}

#declare DIRT = texture {
    pigment {
          wrinkles
          turbulence .6
          octaves 3
          lambda 3 //3 to 6
          omega 0.4 //0.2 to 0.6
          color_map { 
           [0  color rgbt <1, 1, 1, 0.9>]               
           [0.4  color rgbt <1, 1, 1, 0.9>] 
           [0.49 color rgbt <0.5, 0.1, 0.05, 0.5>]     
           [0.5  color rgbt <0.3, 0.1, 0.03, 0.8>]
           [0.6  color rgbt <0.5, 0.3, 0.1, 0.8>]
           [0.7  color rgbt <1, 1, 1, 0.9>]
           [1  color rgbt <1, 1, 1, 0.9>]
          }
          scale 0.5 //100 for Y-Wing
    } 
}

#declare YELLOW_YWING = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.70
        phong_size 21.0
    }
    pigment { rgb <1.000, 0.867, 0.043> }
}
texture { DIRT }

#declare GREY_ALUMINUM = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 1.00
        phong_size 42.0
        metallic
        reflection 0.344
    }
    pigment { rgb <0.784, 0.784, 0.784> }
}

#declare GREY_DARK = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.37
        phong_size 11.2
        metallic
    }
    pigment { rgb <0.447, 0.447, 0.447> }
}

#declare BLACK_TUBE = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.47
        phong_size 14.0
        metallic
        reflection 0.344
    }
    pigment { rgb <0.510, 0.510, 0.510> }
}

#declare Default = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 1.00
        phong_size 49.0
    }
    pigment { rgb <1.000, 1.000, 1.000> }
}

#declare ORANGE_XWING = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.70
        phong_size 21.0
    }
    pigment { rgb <1.000, 0.561, 0.043> }
}
texture { DIRT }

#declare BLUE_GLASS = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.68
        phong_size 20.3
    }
    pigment { rgbf <0.660, 0.660, 0.976, 0.8> }
}

#declare WHITE_GENERAL = texture {
    finish {
        ambient 0.20
        diffuse 0.80
        phong 0.03
        phong_size 1.0
    }
    pigment { rgb <1.000, 1.000, 1.000> }
}
texture { DIRT }

#declare BLUE_R2_D2 = texture {
    finish {
        ambient 0.20
        diffuse 0.90
        phong 0.37
        phong_size 11.2
    }
    pigment { rgb <0.000, 0.000, 0.537> }
}

#declare A_TIE_SOLARPANEL = texture {
    finish {
        ambient 0.20
        diffuse 0.90
        phong 0.8
        phong_size 25.0
    }
    pigment { rgb <0.000, 0.000, 0.239> }
}

#declare A_XWING_ORANGE = texture {
    finish {
        ambient 0.20
        diffuse 0.90
        phong 0.70
        phong_size 21.0
    }
    pigment { rgb <1.000, 0.561, 0.043> }
}

#declare A_SHIP_WHITE = texture {
    finish {
        ambient 0.20
        diffuse 0.90
        phong 0.03
        phong_size 1.0
    }
    pigment { rgb <1.000, 1.000, 1.000> }
}

#declare A_TIE_WINDOW = texture {
    finish {
        ambient 0.20
        diffuse 0.90
        phong 0.77
        phong_size 23.1
    }
    pigment { rgb <0.239, 0.000, 0.000> }
}

#declare GRAY = texture {
    finish {
        ambient 0.20
        diffuse 0.90
        phong 0.82
        phong_size 24.5
        metallic
    }
    pigment { rgb <0.278, 0.278, 0.278> }
}

#declare BLAST_RED = texture {
    finish {
        ambient 0.20
        diffuse 0.90
        phong 0.03
        phong_size 1.0
        metallic
    }
    pigment { rgb <1.000, 0.188, 0.188> }
}

#declare laser = media {
  emission 1.2
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    cylindrical
    ramp_wave
    turbulence 0.1
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.05 color rgb <0.0, 1, 0.2>]
      [0.8 color rgb <0.3, 1, 0.3>]
      [1.0 color rgb <0.6, 1, 0.4>]
    } scale 0.35
  } rotate 90*x
} 

#declare temp = 0.9;
#declare engine = media {
  emission 0.5
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    spherical
    ramp_wave
    turbulence 0.01
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.2 color rgb <1, 0.2, 0.3>]
      [temp color rgb <1, 0.5, 0.7>]
      [1.0 color rgb <1, 0.7, 0.8>]
    } scale 1
  } 
} 
/*
#declare YWPath = create_spline_from_file ("ywpoints.spl", create_hermite_spline 
  + spline_file_points (44)
  + spline_sampling (1))
  
preview_spline (YWPath, spline_radius (10))  
*/


/*Pilot***************************************************************************/
#declare Gender = 1; 
#declare move = pow(sin(0.5*(My_Clock+1.2)*pi),8);
//#declare move =1; 
#declare Head_Rotation = <15*sin(My_Clock*pi/2),-30*sin(My_Clock*pi),0>; 
#declare Neck_Rotation = transform {rotate (15-15*move)*x}
#declare Torso_Rotation = transform {rotate (-15+20*move)*x}
#declare L_Arm_Rotation = transform {rotate (-20-20*move)*x rotate 10*y rotate -20*z}
#declare L_Elbow_Rotation = transform {rotate 40*y rotate 0*z rotate -50*x}
#declare L_Hand_Position = "fist" 
#declare R_Hand_Position = "custom"
#declare R_Index_Curve = transform{ rotate x*20 }
#declare R_Index_Rotation = transform{ rotate x*(20-30*move)}
#declare R_Middle_Curve = transform{ rotate x*(20+60*move) }
#declare R_Middle_Rotation = transform{ rotate x*(20+60*move) }
#declare R_Ring_Curve = transform{ rotate x*(20+50*move) }
#declare R_Ring_Rotation = transform{ rotate x*(20+60*move) }
#declare R_Pinky_Curve = transform{ rotate x*(20+40*move) }
#declare R_Pinky_Rotation = transform{ rotate x*(20+60*move) }
#declare R_Thumb_Curve = (20+20*move);
#declare R_Thumb_Rotation = transform{ rotate z*(-35+95*move) rotate y*(-60+160*move) }

#declare R_Arm_Rotation = transform {rotate (-20-63*move)*x rotate (-4*move)*y rotate 20*z}
#declare R_Elbow_Rotation = transform {rotate (-10-50*move)*y rotate (-60+50*move)*x  rotate 0*z}
#declare L_Leg_Rotation = transform {rotate -90*x rotate -3*y rotate 5*z}
#declare R_Leg_Rotation = transform {rotate -90*x rotate 3*y rotate -5*z}
#declare L_Shin_Rotation = transform {rotate <17,2,0>}
#declare R_Shin_Rotation = transform {rotate <17,2,0>}
#ifdef (Suit_Texture) 
  #undef Suit_Texture
#end
#declare Suit_Pigment = pigment {colour rgb <.35,0.0,.75>}
#include "pilot.inc"
/***************************************************************************/

object { Pilot 
  scale 2.7
  translate <0, 0, 1.2>
} 


/***************************************************************************/
#declare Gender = 1;
#declare Head_Rotation = <15,30,0>;
#declare Torso_Rotation = transform {rotate 5*x}
#declare L_Arm_Rotation = transform {rotate -20*x rotate 0*y rotate -20*z}
#declare L_Elbow_Rotation = transform {rotate 40*y rotate 0*z rotate -50*x  }
#declare L_Hand_Position = "fist"
#declare R_Arm_Rotation = transform {rotate -50*x rotate 0*y rotate 20*z}
#declare R_Elbow_Rotation = transform {rotate -40*y rotate -10*z rotate -10*x  }
#declare L_Leg_Rotation = transform {rotate 0*x rotate -2*y rotate -5*z}
#declare R_Leg_Rotation = transform {rotate 0*x rotate 2*y rotate 5*z}
#declare R_Foot_Rotation = transform {rotate 0*x rotate 0*y rotate 0*z}  
#declare L_Foot_Rotation = transform {rotate 0*x rotate 0*y rotate 0*z}

/*#declare Face =  texture {
  pigment{ 
    image_map{ gif "mike1.gif" interpolate 2 once }
    translate <-0.5,-0.00,0>
    scale <4,4,1>
  }
  finish{ ambient 0.15 diffuse 0.85 }
} */
#ifdef (Suit_Texture) 
  #undef Suit_Texture
#end
#declare Suit_Pigment = pigment {colour rgb <1,.45,.5>}
/***************************************************************************/
//#include "pilot.inc"
/***************************************************************************/
//object { Pilot scale 2.7 rotate 180*y translate <0, 4, 0>}      

#declare x1 = sin(4*My_Clock);
#declare y1 = sin(2.5*My_Clock);
#declare z1 = sin(2*My_Clock);

#declare ab = 0.5;
#declare bf = 0.05;
#declare df = 0.1;

#include "ship.inc"
//#include "r-wing-y.inc"
//object { Ywing }  

object { ship1 scale 1 translate <0,0,0>}

/*object {
  Ywing scale <50, 5, 5> 
  rotate (1.5*cos(1.6*My_Clock)-1.5*cos(2.6*My_Clock))*z
  translate <0, 10, 0>
  animate_by_spline (YWPath, 
  even_spline_spacing (true)
  + spline_clock (My_Clock/End)
  + auto_banking (ab)
//  + max_banking_angle (Float)
//  + auto_rotate (<1,0,1>/0.1)    // Fraction for pitch/heading
  + direction_foresight (df)
  + banking_foresight (bf)
  ) 
  translate 1*<z1,y1,x1>
}               
*/

//#include "ywcockpit.inc"
//object {YWCockpit}

//#include "station.inc" 
//object {sensor }
//object { hut }
//object { gun }
//object { console }

//difference {
//  object {Ywing translate <0, 0, 0>}
//  box { <5, 2.5, 0> <-5, 6, 30>}
//} 

/*
sphere {
 0, 1
 pigment {color rgbt <1, 1, 1, 1>}
 interior { media {engine} }
 scale 2
 translate <0, 0, 0>          
 hollow
} */

/*
#declare Media = media {
  emission 1.5
  intervals 5
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  density {
    cylindrical
    ramp_wave
    turbulence 0.1
    color_map {
      [0.0 color rgb <0, 0, 0>]
      [0.05 color rgb <0.0, 1, 0.2>]
      [0.8 color rgb <0.4, 1, 0.6>]
      [1.0 color rgb <0.8, 1, 0.8>]
    } scale 0.25
  } rotate 90*x
} 

#declare shot = cylinder { 
  <0, 0, 0> <0, 0, 5> 1   
  pigment {color rgbt <1, 1, 1, 1>} 
  interior { media {Media} }
  hollow 
}

object { shot translate <9.5, 2.7, 18> }
object { shot translate <-9.5, -2.7, 18> } 
object { shot translate <-9.5, 2.7, 30> }
object { shot translate <9.5, -2.7, 30> }


cylinder { <0, 0, 0> <0, 0, 5> 1   
           pigment {color rgbt <1, 1, 1, 1>} 
           interior { media {Media} }
           translate <9.5, 2.7, 18>
           hollow 
} 
cylinder { <0, 0, 0> <0, 0, 5> 1   
           pigment {color rgbt <1, 1, 1, 1>} 
           interior { media {Media} }
           translate <-9.5, -2.7, 18>
           hollow 
} 
cylinder { <0, 0, 0> <0, 0, 5> 1   
           pigment {color rgbt <1, 1, 1, 1>} 
           interior { media {Media} }
           translate <-9.5, 2.7, 30>
           hollow 
} 
cylinder { <0, 0, 0> <0, 0, 5> 1   
           pigment {color rgbt <1, 1, 1, 1>} 
           interior { media {Media} }
           translate <9.5, -2.7, 30>
           hollow 
} */        

/*                              
sphere { <0, 0, 0> 17
         pigment {
          wrinkles
          turbulence .6
          octaves 3
          lambda 3 //3 to 6
          omega 0.4 //0.2 to 0.6
          color_map {
           [0 color rgbt <1, 0, 1, 1>]
           [0.56 color rgbt <1, 0, 1, .9>]
           [0.56 color rgbt <1, 0, 1, 0.7>]
           [0.60 color rgbt <0, 0, 1, 0.7>]
           [0.64 color rgbt <1, 0, 1, 0.7>]
           [0.64 color rgbt <1, 0, 1, 0.9>]
           [1 color rgbt <1, 0, 1, 1>]
          }
          scale 10
         } 
         no_shadow
         scale <1, 0.8, 1>
         translate <0, 0, 3>  
} */
 