#declare GREY = texture {
    finish {
        ambient 0.20
        diffuse 0.80
        phong 0.10
        metallic
        reflection 0.05
    }
    pigment { rgb <0.8, 0.8, 0.8> }
}  

#declare DKGREY = texture {
    finish {
        ambient 0.20
        diffuse 0.80
        phong 0.10
        metallic
        reflection 0.01
    }
    pigment { rgb <0.6, 0.6, 0.6> }
}

#declare DUST = texture {
    pigment {
          wrinkles
          turbulence .6
          octaves 5
          lambda 4 //3 to 6
          omega 0.3 //0.2 to 0.6
          color_map { 
           [0  color rgbt <1, 1, 1, 0.9>]               
           [0.3  color rgbt <1, 1, 1, 0.9>] 
           [0.4 color rgbt <0.5, 0.3, 0.1, 0.8>]     
           [0.5  color rgbt <0.65, 0.3, 0.05, 0.6>]
           [0.6  color rgbt <0.5, 0.3, 0.1, 0.8>]
           [0.7  color rgbt <1, 1, 1, 0.9>]
           [1  color rgbt <1, 1, 1, 0.9>]
          }
          scale 0.6
    } 
}

#declare shell = difference {
  sphere  {
    <0, 0, 0> // center of sphere <X Y Z>
    0.5       // radius of sphere
  }
  sphere  {
    <0, 0, 0> // center of sphere <X Y Z>
    0.48       // radius of sphere
  } 
  box {
    <-1, -1, -0.05>  // one corner position <X1 Y1 Z1>
    < 1,  1,  1>  // other corner position <X2 Y2 Z2>
  }
}

#ifndef (My_Clock)
  #declare My_Clock =0;
#end

#declare power = 10*0.33*(1.5+0.5*sin(20*My_Clock)+sin(5*(My_Clock+0.9))); 
#declare status = union { 
  box { 
    <-0.11, -0.04, 0.015> < 0.11,  0.04,  .03> 
    texture { GREY }
    texture { DUST }  
//    finish { reflection 0.3 }
  }
  box { 
    <-0.1, -0.03, 0.014> < 0.1,  0.03,  .03> 
    pigment { color rgb 0 }  
    finish { reflection 0.3 }
  }
  #declare num = power;
  #while (num > 0)
    #if (num < 5)
     #declare powerlight = <1, 0, 0>;
    #else 
      #if (num < 8)
       #declare powerlight = <1, 1, 0>; 
      #else 
        #declare powerlight = <0, 1, 0>; 
      #end         
    #end  
    box { 
      <-0.003, -0.01, 0.0139> < 0.003,  0.01,  0.02>
      pigment {
        color rgb powerlight 
      }  
      finish { ambient 1 reflection 0.3  }
      translate <-0.095+num*0.018, -0.01, 0>
    }
    #declare num = num-0.6;
  #end    
  rotate 8*x
}

#declare dish = union {
  object { shell scale <1, 1, 0.5>}
  cone
  {
    <0,0,-0.245>,  0.02,
    <0,0,0.05>, 0.01
  }
  sphere  {
    <0, 0, 0.05> // center of sphere <X Y Z>
    0.018       // radius of sphere
  }
  difference { 
    object { shell }   
    box { <-1, -1, -1> < 1,  -0.25,  1> }
    box { <-1, 1, -1> < 1,  0.25,  1> }
    scale <0.2, 0.2, 0.2>
    rotate 360*My_Clock*z
    translate <0, 0, 0.05>
  }
  sphere  {
    <0, 0, 0> 0.1 
    scale <1, 1, 0.5>
    translate <0, 0, -0.25>   
  }
  union {
   cylinder { <0, 0, 0>, <0, 0.09, 0.16>, 0.01 }
   cylinder { <0, 0, 0>, <0, -0.09, 0.16>, 0.01 }  
   cylinder { <0, 0, 0>, <0.09, 0,  0.16>, 0.01 } 
   cylinder { <0, 0, 0>, <-0.09, 0,  0.16>, 0.01 }       
   translate <0, 0, -0.4>
  }
  object { status translate <0, 0.15, -0.26>} 
  translate <0, 0, 0.4>
  rotate -10*x  
  texture { GREY }
  texture { DUST }
  rotate -My_Clock*180*y
}

#declare stand = union { 
  sphere  { <0, 1, 0> 0.04 } 
  cylinder { <0, 1, 0>, <0, 0, 0>, 0.02 } 
  cylinder { <0, 0.5, 0>, <0, 0.024, 0.5>, 0.015 }
  cylinder { <0, 0.5, 0>, <0.433, 0.024, -0.25>, 0.015 }  
  cylinder { <0, 0.5, 0>, <-0.433, 0.024, -0.25>, 0.015 } 
  sphere  { <0, 0, 0> 0.08 scale <1, 0.3, 1>}
  sphere  { <0, 0.024, 0> 0.04 }  
  sphere  { <0, 0, 0.5> 0.06 scale <1, 0.4, 1>}
  sphere  { <0.433, 0, -0.25> 0.06 scale <1, 0.4, 1>}
  sphere  { <-0.433, 0, -0.25> 0.06 scale <1, 0.4, 1>}
  sphere  { <0, 0.024, 0.5> 0.025 }
  sphere  { <0.433, 0.024, -0.25> 0.025 }
  sphere  { <-0.433, 0.024, -0.25> 0.025 }          
  texture { GREY }
  texture { DUST }
}

#declare sensor = union {
  object { dish translate 1*y }
  object { stand }
}  

///////////////////////////////

#declare hut = union {
  difference {
    cone { <0, 0, 0>, 4.0, <0, 9, 0>, 3 }
    cone { <0, 1, 0>, 3.7, <0, 9.01, 0>, 2.99 
      texture { GREY }
      texture { DUST scale 3 translate <0,-5,5>}
    }
    cylinder {
      <4, 1, 0>, <4, 7, 0>,  1.5
    } 
  }
  torus {
    3, 0.05
    translate <0, 9, 0> 
  }
  difference {
    sphere { <0, 8, 0> 3.17 }
    sphere { <0, 8, 0> 3.1 }    
    box { <5, 0, 5> <-5, 9, -5> }
    texture { GREY }
    normal { 
       bump_map { 
        gif "huttop.gif" // the file to read (iff/gif/tga/png/sys)
        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        once
        interpolate 2// 0=none, 1=linear, 2=bilinear, 4=normalized distance
        bump_size 1 // 0...3  
       }
      translate <-0.5,-0.5,0>
      scale 7
      rotate 90*x  
//      rotate -90*z      
//      translate <0,9,0>
    }    
    texture { DUST scale 5}
   } 
   
  light_source {
    0*x 
    color rgb <0.8,0.8,0.8>  
    translate <2, 9, 0> 
    fade_distance 4
    fade_power 2
  } 
  texture { GREY }
  texture { DUST scale 5}    
}

#declare gunbarrel = union {
  cylinder {<0, 0, 0> <0, 0, 1.5> 0.07}
  sphere {<0, 0, 0> 0.15 scale <.7, 1.2, 2.2>}
  sphere {<0, 0, 0> 0.13 scale <1, 1, 2>}  
  sphere {<0, 0, 0> 0.13 scale <1.1, 1, 1>}
  sphere { <0, 0, 0>, 0.1 scale <1, 1, 0.5> translate <0.0, 0.0, 1.5>}
  cone { <0.0, 0.0, 1.5>, 0.10, <0.0, 0.0, 1.8> 0.06 open}
  torus { 0.044, 0.016 rotate -90*x translate <0.0, 0.0, 1.8>}
  scale 2    
  rotate 90*y    
}
 
#ifndef (dir)
  #declare dir = vnormalize(<1,0.5,-.1>);  
#end
  
#if (dir.z=0)                                  
  #if (dir.x>0)
    #declare gun_rotation = 0;
  #else
    #declare gun_rotation = 180;
  #end
#else
  #declare gun_rotation = degrees(atan2(dir.z,dir.x));
#end 
#if (dir.y=0)
  #declare gun_elevation = 0;
#else
  #declare gun_elevation = 90-degrees(acos(dir.y)); //degrees(atan2(dir.y,abs(dir.x)));
#end 
 
#declare gun = union {
  difference {
    cone { <0, 0, 0>, 4.0, <0, 9, 0>, 3 scale <1.03,1,1.03>}
    cone { <0, 1, 0>, 3.7, <0, 9.01, 0>, 2.999 scale <1.03,1,1.03>}     
    box { <-5,7.5,-5> <5,0,5> } 
    box { <-5,8.5,-5> <5,10,5> }  
    texture { GREY }
    texture { DUST scale 4}  
  }  
  object { gunbarrel 
    texture { GREY }
    texture { DUST scale 4} 
    rotate gun_elevation*z
    translate <0,8.1,3.35> 
  }   
  object { gunbarrel 
    texture { GREY }
    texture { DUST scale 4}
    scale 0.5
    rotate gun_elevation*z
    translate <0,7.7,3.35> 
  }  
  object { gunbarrel 
    texture { GREY }
    texture { DUST scale 4}  
    rotate gun_elevation*z
    translate <0,8.1,-3.35> 
  }    
  object { gunbarrel 
    texture { GREY }
    texture { DUST scale 4}
    scale 0.5    
    rotate gun_elevation*z
    translate <0,7.7,-3.35> 
  }   
  rotate -gun_rotation*y    
}

#declare frame = mod(int(My_Clock*15),30)+1; 

#declare flicker = pigment { 
  gradient y 
  color_map {
    [0.0 color rgbt <0.4, 0.4, 0.4, .3>]
    [0.05 color rgbt <.5, .5, .5, .3>]
    [0.3 color rgbt <1, 1, 1, .3>]
    [1.0 color rgbt <1, 1, 1, .8>]
  } 
  scale 0.15
  translate My_Clock
} 

#declare screen = concat("cockp",str(frame,-3,0),".bmp")
#declare monitor = union {
  #declare scope = union {
    box
    {
      <-0.20, -0.25, -0.1>  // one corner position <X1 Y1 Z1>
      < 0.20,  0.25,  0.1>  // other corner position <X2 Y2 Z2>
    }
    box
    {
      <-0.25, -0.20, -0.1>  // one corner position <X1 Y1 Z1>
      < 0.25,  0.20,  0.1>  // other corner position <X2 Y2 Z2>
    }   
    cylinder { <-0.20, -0.20, -0.1>, <-0.20, -0.20, 0.1>, 0.05 }
    cylinder { < 0.20, -0.20, -0.1>, < 0.20, -0.20, 0.1>, 0.05 }
    cylinder { <-0.20, 0.20, -0.1>, <-0.20, 0.20, 0.1>, 0.05 }
    cylinder { < 0.20, 0.20, -0.1>, < 0.20, 0.20, 0.1>, 0.05 }      
  }
  object { scope pigment { color rgb <0.5, 0.5, 0.5> }}
  object { scope scale <0.9, 0.9, 1.001> pigment { color rgb <0.9, 0.9, 0.9> }}
  object { scope scale <0.85, 0.85, 1.002> 
    pigment { image_map { sys screen once} translate <-0.5, -0.5, 0> scale <.5, .43, 1>  }
    finish { ambient 0.6 phong 1 reflection 0.1 }
  }        
  object { scope scale <0.85, 0.85, 1.003> pigment { flicker }}  
  translate <0,0,-0.10> 
} 

#declare alert = union { 
  box {<-2, -0.5, -0.49>, <2, .5, 0.49> pigment { color rgb <0.8,0,0> }}  
  text { ttf "arial.ttf" "ALERT" 0.5, 0
  pigment { color rgb <1,0,0> }
  finish { ambient 1-pow(sin(2*My_Clock*pi),6) }
  translate -1.6*x translate -0.375*y translate -0.5*z  rotate 180*y  
  }
  scale 0.2 
}  
  
#declare console = union {
  difference {
    cylinder { <0, 1, 0>, <0, 7, 0>,  4 }   
    cylinder { <0, 5, 0>, <0, 8, 0>,  2.5 } 
    cylinder { <0, 0, 0>, <0, 8, 0>,  1.5 }
    cylinder { <0, 0, 0>, <0, 4.1, 0>,  3 }      
    difference {
      cylinder { <0, 0, 0>, <0, 9, 0>, 5 }
      cone { <0, 1, 0>, 3.7, <0, 9.01, 0>, 2.99 }
      cylinder { <4, 1, 0>, <4, 7, 0>,  1.5 }
    }
    cone { <0,5.01,0>, 2.5, <0,3,0>, 0 }
    box { <5,0,5>, <0.5,8,-5> rotate -40*y}      
//  box { <5,0,5>, <0.5,8,-5> rotate -80*y}
    texture { DKGREY }  
    texture { 
      pigment{ 
        image_map { png "Console3.png" map_type 2 once }
      } scale 2.9 translate 4.1*y rotate -30*y
    }     
  }
  light_source {
    0*x 
    color rgb <1-pow(sin(2*My_Clock*pi),6),0,0>  
    looks_like { alert }
    fade_distance 1.5
    fade_power 5       
    translate <0,0,0.13> rotate -35*y translate <1.5,5.35,-2.15>
  }   
//  object { monitor scale 2 rotate -35*y translate <1.5,6,-2.15>}
//  sphere {<0.5, 6, -2>,0.1 }  
  light_source {
    0*x 
    color rgb <0.2,0.2,0.4>  
    looks_like { monitor }
    fade_distance 3
    fade_power 3       
    translate <0,0,0.1> scale 2 rotate -35*y translate <1.5,6,-2.15>
  }  
}  
     