//
// FIRST RESPONSE
//
// Author: Michael Sobers
// Date: 15 January 2001
//
// Scene file for creating image maps for cockpit target indicator.
//

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc" 
#include "spline.mcr" 

#declare GREY = texture {
    finish {
        ambient 0.20
        diffuse 0.80
        phong 0.10
        metallic
        reflection 0.05
    }
    pigment { rgb <0.8, 0.8, 0.8> }
}

#declare DIRT = texture {
    pigment {
          wrinkles
          turbulence .6
          octaves 3
          lambda 3 //3 to 6
          omega 0.4 //0.2 to 0.6
          color_map { 
           [0  color rgbt <1, 1, 1, 0.9>]               
           [0.4  color rgbt <1, 1, 1, 0.9>] 
           [0.49 color rgbt <0.5, 0.1, 0.05, 0.5>]     
           [0.5  color rgbt <0.3, 0.1, 0.03, 0.8>]
           [0.6  color rgbt <0.5, 0.3, 0.1, 0.8>]
           [0.7  color rgbt <1, 1, 1, 0.9>]
           [1  color rgbt <1, 1, 1, 0.9>]
          }
          scale 0.5
    } 
} 

#declare DUST = texture {
    pigment {
          wrinkles
          turbulence .6
          octaves 5
          lambda 4 //3 to 6
          omega 0.3 //0.2 to 0.6
          color_map { 
           [0  color rgbt <1, 1, 1, 0.9>]               
           [0.3  color rgbt <1, 1, 1, 0.9>] 
           [0.4 color rgbt <0.5, 0.3, 0.1, 0.8>]     
           [0.5  color rgbt <0.65, 0.3, 0.05, 0.6>]
           [0.6  color rgbt <0.5, 0.3, 0.1, 0.8>]
           [0.7  color rgbt <1, 1, 1, 0.9>]
           [1  color rgbt <1, 1, 1, 0.9>]
          }
          scale 0.6
    } 
}


////////////////////////

// Sky
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0 color rgb <0.6, 0.4, 0.4>]
      [0.3 color rgb <0.4, 0.2, 0.2>]
      [1.0 color rgb <0.1, 0.1, 0.6>]
    }  
    scale 2
    translate -1
  }
  pigment {
    wrinkles
    turbulence .5
    octaves 6
    lambda 5 //3 to 6
    omega 0.3 //0.2 to 0.6
    color_map {
      [0 color rgbt <1, 1, 1, 1>]
      [0.5 color rgbt <0.98, 0.99, 0.99, .8>]
      [1 color rgbt <1, 1, 1, 1>]
    }
    scale <.8, .1, .8>
  }  
}

fog {
  distance 1500
  color rgbt<0.4, .45, .45, .5>
  fog_type 2
  fog_offset 1
  fog_alt 70
  turbulence 0.2
  turb_depth 0.3
 
} 

light_source{ <-10000,30000, 15000> White }
       
////////////////////////


#declare Start    = 0.0;
#declare End      = 45.0;
#declare My_Clock = Start+(End-Start)*clock;

#declare land_visible  = true;

#declare camera_location = <615,105,-125>;
#declare camera_look_at =  <615, 104, -142>; 
      

camera{   
    location camera_location
    angle 70
    look_at camera_look_at    
  }   

#declare wave = texture {
  normal { 
      gradient z
      phase My_Clock*pi
      scale <1, 2, 5>
      sine_wave
  } 
  pigment { color rgbt <0.1, 0.1, 0.6, 0.5> } 
  finish { phong 0.6 reflection 0.2 }
}

#declare bump = texture { 
  pigment { color rgbt <0.22, 0.2, 0.4, 0.4> } 
  finish { phong 0.6 reflection 0.2 }
  normal {bumps 0.5}
  scale <5, 1, 5>
  translate <My_Clock, My_Clock, My_Clock>
}                 

#if (land_visible)

box
{
  <-2000, -80, -2000>  // one corner position <X1 Y1 Z1>
  < 2000,  -110,  6000>  // other corner position <X2 Y2 Z2>
  texture { bump }
  hollow on
} 

difference {
  height_field {
      png "groundmap2.png"
      smooth
      pigment {       
      granite      
        color_map { 
          [0  color rgb <0.3, 0.1, 0.03>]      
          [0.5  color rgb <0.9, 0.5, 0.3>]
          [1  color rgb <0.5, 0.3, 0.1>]
        }
      } 
      translate <-.5, -.5, -.5>
      scale <4000, 200, 4000>   
      rotate -90*y
  }
  box {
    <-45, -7.9, -100> 
    < 45,  25,  -19>
    rotate -10*y 
    translate <-430, -35, 350>
    texture {
      finish {
          ambient 0.20
          diffuse 0.30
      }
      pigment { rgb <0.647, 0.647, 0.647> }
    }
  }
  hollow
}  

difference {
 height_field {
    png "groundmap3.png"
    smooth
    pigment {       
    granite      
      color_map { 
        [0  color rgb <0.3, 0.1, 0.03>]      
        [0.5  color rgb <0.9, 0.5, 0.3>]
        [1  color rgb <0.5, 0.3, 0.1>]
      }
    } 
    translate <-.5, -.5, -.5>
    scale <4000, 200, 4000>   
    rotate -90*y
    matrix < 1, 0, 0,
             0, 1, 0, 
             0, 0, -1,
             0, 0, 0>
    translate <0, 0, 4000 >
  }

  cylinder
  { 150*z, -20*z, 45
    texture {
      finish {
          ambient 0.10
          diffuse 0.30
      }
      pigment { rgb <0.647, 0.647, 0.647> }
    }  
  scale <2, 1, 1>  
  rotate 50*y
  translate <-450, -10, 2850>
  }
}  

intersection {
  union{
    height_field {
        png "groundmap2.png"
        smooth
        translate <-.5, -.5, -.5>
        scale <4000, 200, 4000>   
        rotate -90*y
    }
    height_field {
      png "groundmap3.png"
      smooth
      translate <-.5, -.5, -.5>
      scale <4000, 200, 4000>   
      rotate -90*y
      matrix < 1, 0, 0,
               0, 1, 0, 
               0, 0, -1,
               0, 0, 0>
      translate <0, 0, 4000 >
    } 
  }
  box {
    <500, 80, 0>
    <700, 110, -300>  
  }   
  texture {
    gradient y
    texture_map { 
     [0 pigment { color rgbt <1, 1, 1, 1>}]
     [0.8 DUST scale 20]
    }
    scale <1,20,1>
  }  
  translate .001*y     
}  

#end // #if (land_visible)

//////////////////////////////////////////////////////


/***************************************************************************/
#declare Gender = 1;
#declare Head_Rotation = <15,30,0>;
#declare L_Arm_Rotation = transform {rotate -20*x rotate 0*y rotate -20*z}
#declare L_Elbow_Rotation = transform {rotate 40*y rotate 0*z rotate -50*x  }
#declare L_Hand_Position = "fist"
#declare R_Arm_Rotation = transform {rotate -50*x rotate 0*y rotate 20*z}
#declare R_Elbow_Rotation = transform {rotate -40*y rotate -10*z rotate -10*x  }
#declare L_Leg_Rotation = transform {rotate 0*x rotate -2*y rotate -5*z}
#declare R_Leg_Rotation = transform {rotate 0*x rotate 2*y rotate 5*z}
#declare R_Foot_Rotation = transform {rotate 0*x rotate 0*y rotate 0*z}  
#declare L_Foot_Rotation = transform {rotate 0*x rotate 0*y rotate 0*z}

#ifdef (Suit_Texture) 
  #undef Suit_Texture
#end
#declare Suit_Pigment = pigment {colour rgb <.5,.45,.5>}
/***************************************************************************/
#include "pilot.inc"
/***************************************************************************/
object { Pilot scale 2.7 rotate 180*y translate <610, 99.5, -142>+<0, 4, 0>}      

#declare gun_pos = <615, 108, -138>;
#declare dir = vnormalize(<sin(2*pi*(My_Clock-2.5)/5),.5*(sin(2*pi*(My_Clock-2.5)/5)+1),1>);
#include "station.inc"
object {sensor rotate 0*y scale 3 translate <620, 99.2, -138>}
object {sensor rotate 70*y scale 3 translate <658, 99, -97>}
object {hut rotate -60*y translate <610, 99.5, -142>}
object {gun translate <610, 99.5, -142>} 
object {console translate <610, 99.5, -142>}
//plane { y, 99.1 hollow on }


