// Persistence of Vision Ray Tracer Scene Description File
// File: pe.pov
// Vers: 3.1g
// Desc: Pursuit & Escape
// Date: 2000/10/18
// Auth: Matthias M. Giwer

#version 3.1 ;

#include "colors.inc"
#include "textures.inc"

global_settings
{
  assumed_gamma 2.0
}

// ----------------------------------------
#if (clock<1)
light_source{0*x color<1,1,1>
//shadowless 
translate < 30, 30,-300>} // scene zero

//light_source{0*x color<1,1,1>
//shadowless 
//translate <-300,-300,-300>} // scene zero
#end
// scene zero

// ----------------------------------------

#declare delta=0.00001 ;

#declare target = union {
superellipsoid{< 2.9,2.9> scale 1 texture {Gold_Nugget}
rotate<0,1000*(clock),0>}

light_source{0*x color<1,1,1>translate<.8,.8,.8>
fade_distance .2 fade_power 3}
light_source{0*x color<1,1,1>translate<-.8,.8,.8>
fade_distance .2 fade_power 3}
light_source{0*x color<1,1,1>translate<.8,.8,-.8>
fade_distance .2 fade_power 3}
light_source{0*x color<1,1,1>translate<-.8,.8,-.8>
fade_distance .2 fade_power 3}
light_source{0*x color<1,1,1>translate<.8,-.8,.8>
fade_distance .2 fade_power 3}
light_source{0*x color<1,1,1>translate<-.8,-.8,.8>
fade_distance .2 fade_power 3}
light_source{0*x color<1,1,1>translate<.8,-.8,-.8>
fade_distance .2 fade_power 3}
light_source{0*x color<1,1,1>translate<-.8,-.8,-.8>
fade_distance .2 fade_power 3}
}//target


//SCENE ZERO
#if (clock >=0) 
#if (clock < 1)

camera
{location  <-1, -1+delta, -9.0>
  direction 1.5*z right 4/3*x 
look_at <-1,0,0> }

/*camera
{location  <-1, 60+delta, 0.0>
  direction 1.5*z right 4/3*x 
look_at <-1,0,0> }
*/
/*
#declare ship2 = union {
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.25,1,.25> }
#declare wings=union{
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.15,.5,.15> translate<-.75,.1,0> }
sphere { 0.0, 1 texture {pigment {radial frequency -8} finish{specular 1}} 
scale <.15,.5,.15> translate<.75,.1,0> }
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.15,.5,.15> translate<0,.1,-.75> }
sphere { 0.0, 1 texture {pigment {radial frequency -8} finish{specular 1}} 
scale <.15,.5,.15> translate<0,.1,.75> }
difference {
cylinder{-.025*z, .025*z,.75 texture {pigment {radial frequency 8} finish{specular 1}} 
translate<0, .2,0>}
cylinder{-.06*z, .06*z,.65 texture {pigment {radial frequency 8} finish{specular 1}} 
translate<0, .2,0>}
cylinder{-.07*z, .07*z,.75 texture {pigment {radial frequency -8} finish{specular 1}} 
translate<0, -.2,0>}
}
}
object{wings translate -.1*y}
object{wings rotate 90*y translate -.1*y}
} // union ship2
*/
/////////////////////////////////////////////// othership
#declare ship2 = union {
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.25,1,.25> }
#declare wings=union{
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.15,.5,.15> translate<-.75,.1,0> }
sphere { 0.0, 1 texture {pigment {radial frequency -8} finish{specular 1}} 
scale <.15,.5,.15> translate<.75,.1,0> }
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.15,.5,.15> translate<0,.1,-.75> }
sphere { 0.0, 1 texture {pigment {radial frequency -8} finish{specular 1}} 
scale <.15,.5,.15> translate<0,.1,.75> }
difference {
cylinder{-.025*z, .025*z,.75 texture {pigment {radial frequency 8} finish{specular 1}} 
translate<0, .2,0>}
cylinder{-.06*z, .06*z,.65 texture {pigment {radial frequency 8} finish{specular 1}} 
translate<0, .2,0>}
cylinder{-.07*z, .07*z,.75 texture {pigment {radial frequency -8} finish{specular 1}} 
translate<0, -.2,0>}
}
}
object{wings translate -.1*y}
object{wings rotate 90*y translate -.1*y}

light_source{ 0*x color<1,1,1>*.5translate <.3,-.3,.3>
fade_distance .3 fade_power 2}
light_source{ 0*x color<1,1,1>*.5translate <-.3,-.3,.3>
fade_distance .3 fade_power 2}
light_source{ 0*x color<1,1,1>*.5translate <.3,-.3,-.3>
fade_distance .3 fade_power 2}
light_source{ 0*x color<1,1,1>*.5translate <-.3,-.3,-.3>
fade_distance .3 fade_power 2}

} // union ship2

//////////////////////////////////////////////

object{ship2 scale 1.5 rotate<0,45,0>rotate<-360*clock+180,0,90>//1.5
//translate <10,0,20>}
//translate <10+(10*sin(  clock*2*pi/100)),0,
//	20+(-20*sin((pi/2)+(clock*2*pi/100)) )>}
translate <(-10*sin(clock*2*pi+ 4*pi/4 )),0,
	(20*cos((clock*2*pi+ 4*pi/4 )))>
translate 8.5*x
}


object {target
translate <(-10*sin(clock*2*pi+ 6*pi/4 )),0,
	(20*cos((clock*2*pi+ 6*pi/4 )))>
//translate <(10*sin(clock*2*pi/100 -0*pi/4 )),0,
//	(20*cos((clock*2*pi/100 -0*pi/4 )))>
translate <8.5,0,0>}

/*
superellipsoid{< 3,3> scale 1 texture {Gold_Nugget} scale 1 rotate<0,1000*(clock),0>
translate <(-10*sin(clock*2*pi+ 6*pi/4 )),0,
	(20*cos((clock*2*pi+ 6*pi/4 )))>
//translate <(10*sin(clock*2*pi/100 -0*pi/4 )),0,
//	(20*cos((clock*2*pi/100 -0*pi/4 )))>
translate <8.5,0,0>}
*/

#declare t1 = texture {pigment{color White}}
#declare n1 = normal {dents 4 turbulence 60 scale <1000,1,1000>}
//octaves 0 phase 0} //wrinkles 2//dents2
#declare n2 = normal {wrinkles 2 phase 0}
#declare n3 = normal {hexagon .05}
#declare f1 = finish{specular .3 ambient 0.  metallic}
#declare c1 = <.6,.8,1>;

#if (clock >=0)
#if (clock <.26)
#declare a1 = 90 - 90*clock/.25  ;
//#declare a1 = 90 ;

#declare title= union{
text { ttf "/home/matt/fonts/hamlet.ttf" " Oops" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
translate <-3 ,1.3 , 0> rotate <0,a1,0>
}
text { ttf "/home/matt/fonts/hamlet.ttf" "   by" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
translate <-3,0,0> rotate <0,a1,0>
}
text { ttf "/home/matt/fonts/hamlet.ttf" "Matt Giwer" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
translate<-4,-1.3,0> rotate <0,a1,0>
}
} //
title
#end
#end


#if (clock >=.26)
#if (clock <.5)
#declare title= union{
text { ttf "/home/matt/fonts/hamlet.ttf" " Oops" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
rotate <0,0,0> translate <-3 ,1.3 , 0>
}
text { ttf "/home/matt/fonts/hamlet.ttf" "   by" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
rotate <0,0,0> translate <-3 ,0 , 0>
}
text { ttf "/home/matt/fonts/hamlet.ttf" "Matt Giwer" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
rotate <0,0,0> translate <-4 ,-1.3 , 0>
}
} //
title
#end
#end

#if (clock >= .5)
#if (clock < 1)
#declare title2 = difference{
union{
text { ttf "/home/matt/fonts/hamlet.ttf" " Oops" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
translate<0,0,0> rotate <0,0,0> translate <-3 ,1.3 , 0>
}
text { ttf "/home/matt/fonts/hamlet.ttf" "   by" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
translate<0,0,0> rotate <0,0,0> translate <-3 ,0 , 0>
}
text { ttf "/home/matt/fonts/hamlet.ttf" "Matt Giwer" .3, 0
pigment {color c1}
normal{n1}
finish{f1}
translate<0,0,0> rotate <0,0,0> translate <-4 ,-1.3 , 0>
}
}

superellipsoid{< 3,3> scale 1 texture {Gold_Nugget} scale 1
rotate<0,1000*(.5),0>
translate <(-10*sin(.5*2*pi+ 6*pi/4 )),0,
	(20*cos((.5*2*pi+ 6*pi/4 )))>
translate <8.5,0,0>}

}
title2
#end
#end
/*
#declare title3 = difference {

union{
union{
//text { ttf "/mnt/vfat/windows/fonts/arialbd.ttf" "    Oops" .1, 0
text { ttf "/home/matt/fonts/hamlet.ttf" " Oops" .1, 0
pigment {color Red}
normal{n1}
finish{f1}
translate<0,0,0> rotate <0,0,0> translate <-3 ,1.3 , 0>
}
//text { ttf "/mnt/vfat/windows/fonts/arialbd.ttf" "       by" .1, 0
text { ttf "/home/matt/fonts/hamlet.ttf" "   by" .1, 0
pigment {color Red}
normal{n1}
finish{f1}
translate<0,0,0> rotate <0,0,0> translate <-3 ,0 , 0>
}
//text { ttf "/mnt/vfat/windows/fonts/arialbd.ttf" "Matt Giwer" .1, 0
text { ttf "/home/matt/fonts/hamlet.ttf" "Matt Giwer" .1, 0
pigment {color Red}
normal{n1}
finish{f1}
translate<0,0,0> rotate <0,0,0> translate <-4 ,-1.3 , 0>
}
}

superellipsoid{< 3,3> scale 1 texture {Gold_Nugget} scale 1
rotate<0,1000*(.5),0>
translate <(-10*sin(.5*2*pi+ 6*pi/4 )),0,
	(20*cos((.5*2*pi+ 6*pi/4 )))>
translate <8.5,0,0>}

union {
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.25,1,.25> }
#declare wings=union{
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.15,.5,.15> translate<-.75,.1,0> }
sphere { 0.0, 1 texture {pigment {radial frequency -8} finish{specular 1}} 
scale <.15,.5,.15> translate<.75,.1,0> }
sphere { 0.0, 1 texture {pigment {radial frequency 8} finish{specular 1}} 
scale <.15,.5,.15> translate<0,.1,-.75> }
sphere { 0.0, 1 texture {pigment {radial frequency -8} finish{specular 1}} 
scale <.15,.5,.15> translate<0,.1,.75> }
difference {
cylinder{-.025*z, .025*z,.75 texture {pigment {radial frequency 8} finish{specular 1}} 
translate<0, .2,0>}
cylinder{-.06*z, .06*z,.65 texture {pigment {radial frequency 8} finish{specular 1}} 
translate<0, .2,0>}
cylinder{-.07*z, .07*z,.75 texture {pigment {radial frequency -8} finish{specular 1}} 
translate<0, -.2,0>}
}
}
object{wings translate -.1*y}
object{wings rotate 90*y translate -.1*y}

light_source{ 0*x color<1,1,1>*.5translate <.3,-.3,.3>
fade_distance .3 fade_power 2}
light_source{ 0*x color<1,1,1>*.5translate <-.3,-.3,.3>
fade_distance .3 fade_power 2}
light_source{ 0*x color<1,1,1>*.5translate <.3,-.3,-.3>
fade_distance .3 fade_power 2}
light_source{ 0*x color<1,1,1>*.5translate <-.3,-.3,-.3>
fade_distance .3 fade_power 2}

scale 1.5 rotate<0,45,0>rotate<-360*.75+180,0,90>//1.5
translate <(-10*sin(.75*2*pi+ 4*pi/4 )),0,
	(20*cos((.75*2*pi+ 4*pi/4 )))>
translate 8.5*x
}
}
superellipsoid{< 3,3> scale 1 texture {Gold_Nugget} scale 1
rotate<0,1000*(.5),0>
translate <(-10*sin(.5*2*pi+ 6*pi/4 )),0,
	(20*cos((.5*2*pi+ 6*pi/4 )))>
translate <8.5,0,0>}

}//title3
title3
*/
#end
#end


// END scene one

// SCENE FOUR

#if (clock >= 4.00)
#if (clock < 4.99)

#declare sex=15*(clock-4)/.20;
#declare sey=20*(clock-4)/.20;

superellipsoid{< 3,3> texture {Gold_Nugget} scale 10 rotate<0,100*(clock-1),0>
translate<sex,sey, 200>}

camera
{location  <0,.5 +delta, 0.0>
  direction 1.5*z right 4/3*x 
  look_at <2*sex,2*sey,400> 
rotate<0,0,0>
}
/*
#declare starfield2 = union{
#declare r1=seed(2434);
#declare i=1;
#while (i<15000)//10000
//get randoms
#declare xf1=rand(r1); #declare yf1=rand(r1); #declare zf1=rand(r1);
//covert to radians
//#declare xf2=100; #declare yf2=yf1*2*pi; #declare zf2=(zf1-.5)*pi/2;
#declare xf2=xf1; #declare yf2=yf1*2*pi; #declare zf2=(zf1-.5)*pi/2;
#declare xf4=xf2*cos(yf2)*cos(zf2)*1000;
#declare yf4=xf2*sin(yf2)*cos(zf2)*1000;
#declare zf4=xf2*sin(zf2)*15000;
#if ( sqrt( xf4*xf4 + yf4*yf4 + zf4*zf4) > 400)
sphere{0,1 
texture{pigment{color<.5+rand(r1)/2, .5+rand(r1)/2 , .5+rand(r1)/2>}
finish{ambient 1 reflection 0}} translate<xf4,yf4,zf4>}
//add diffuse 1
#end
#declare i=i+1;
#end //while
}//union
object {starfield2 rotate<0,34,0>}
*/

sphere {0*x, 1000 hollow//stars
	texture {
		pigment{image_map{tga "/home/matt/images/starsa1c.tga"
			map_type 1}}
		}
	finish {ambient 1 reflection 0}
}//stars 

#declare tear = union {
light_source {<0, .50, 0> color rgb<.5,.5,1> fade_distance 20 fade_power 2 }
light_source {<0, -.7, 0> color rgb<0,0,1> fade_distance 20 fade_power 2 }
lathe { cubic_spline
11,<0,1>,<0.00756218,0.951057>,<0.0561285,0.809017>,<0.166744,0.587785>,
<0.328582,0.309017>,<0.5,0>,<0.622475,-0.309017>,<0.642273,-0.587785>,
<0.531657,-0.809017>,<0.301455,-0.951057>,<0,-1>
texture { pigment { color rgbft<1,1,1,.7,.3> }
finish { phong 5 phong_size 7 roughness .1 ambient 1 reflection 1  metallic } }
//   interior {ior .99}
}// lathe  
}// union tear

//#if ( clock-4 >= 0)
//#if ( clock-4 < .23)

#declare mdist=10 *(clock-4)*100 ;

#if (clock-4 = 0)
object {tear rotate<-90,0,0> scale <.2+2.3*mdist/200,.2+2.3*mdist/200,5> 
scale <.25,.25,1> translate<.5,0,mdist>}
object {tear rotate<-90,0,0> scale <.2+2.3*mdist/200,.2+2.3*mdist/200,5> 
scale <.25,.25,1> translate<-.5,0,mdist>}
#end

#if (clock-4 >= .01)
#if (clock-4 < .21)

object {tear rotate<-90,0,0> scale <.2+2.3*mdist/200,.2+2.3*mdist/200,5> 
translate<.5,0,mdist>}

object {tear rotate<-90,0,0> scale <.2+2.3*mdist/200,.2+2.3*mdist/200,5> 
translate<-.5,0,mdist>}
#end
#end

#if (clock-4 = .21)
sphere { 0.0, 3
texture { pigment { color rgbft<1,1,1,.7,.3> }
finish { phong 5 phong_size 7 roughness .1 ambient 1 reflection 1  metallic } }
translate<0,0,200>}
light_source {<0, .50, 0> color rgb<1,1,1> fade_distance 20 fade_power 2 
}
#end
#if (clock-4 = .22)
sphere { 0.0, 6
texture { pigment { color rgbft<1,.5,1,.7,.3> }
finish { phong 5 phong_size 7 roughness .1 ambient 1 reflection 1  metallic } }
translate<0,0,200>}
light_source {<0, .50, 0> color rgb<1,1,1> fade_distance 20 fade_power 2 
translate<0,0,200>}
#end
#if (clock-4 = .23)
sphere { 0.0, 10 
texture { pigment { color rgbft<1,0,1,.7,.3> }
finish { phong 5 phong_size 7 roughness .1 ambient 1 reflection 1  metallic } }
translate<0,0,200>}
light_source {<0, .50, 0> color rgb<1,1,1> fade_distance 20 fade_power 2
translate<0,0,200>}
#end
#if (clock-4 = .24)
sphere { 0.0, 5 
texture { pigment { color rgbft<1,0,1,.7,.3> }
finish { phong 5 phong_size 7 roughness .1 ambient 1 reflection 1  metallic } }
translate<0,0,200>}
light_source {<0, .50, 0> color rgb<.4,.4,.4> fade_distance 20 fade_power 2
translate<0,0,200>}
#end


#end
#end


// SCENE THREE
#if (clock >= 3)
#if (clock < 4)
#declare cx=0;

#declare lc=(clock-3);
#declare trad = 5+30*lc  ;
#declare ttrans = trad ;

camera
{location  <0.0, +delta, 0.0>
  direction 1.5*z right 4/3*x 
  look_at <0,0,400000> 
rotate<0,0,90>
}
light_source { 0*x color red 1  green 1  blue 1 
translate <0, 0,0>}

#declare c1=0;

#if(lc>=0)
#if(lc<.2)
#declare c1=250*(clock-3);
#end
#end

#if(lc>=.2)
#if(lc<.5)
#declare c1=250*(clock-3)-750*(clock-3.2);
#end
#end

#if(lc>=.5)
#if(lc<.99)
#declare c1=250*(clock-3)-750*(clock-3.2)+1000*(clock-3.5);
#end
#end

#declare cx=c1;
torus{-trad , -0.1 
texture{Lightening2 scale trad/4 rotate<(clock -3)*.0,-(clock-3)*60,0>} hollow
rotate<90,90,0> translate<0,-ttrans,0> rotate<0,0,cx+90>}

#declare Lightening_CMap3 =  
color_map {
    [0.00 rgbf <1,1,1,0>]
    [0.10 rgbf <0.99, 0.81, 0.94, 0.65>]
    [0.20 rgbf <0.99, 0.81, 0.94, 0.65>]
    [0.30 rgbf <0.98, 0.58, 0.87, 0.85>]
    [0.45 rgbf <0.98, 0.58, 0.87, 0.85>]
    [0.65 rgbf <0.96, 0.16, 0.73, 0.95>]
}

#declare Lightening3 = 
texture {
    pigment {
        granite
        color_map { Lightening_CMap3 }
        turbulence 0.5
    }
    finish { ambient 1 }
}

torus{-trad , -0.1 
texture{Lightening3 scale trad/4 rotate<(clock -3)*.0,-(clock-3)*75,0>} hollow
rotate<90,90,0> translate<0,-ttrans,0> rotate<0,0,(cx/2)+90>}


// STARS scene three
#declare r2=seed(3413);
#declare imax=100*(clock-2.99)  ;
#declare i=0;
#declare starfield = union {
#while (i<(imax)*40)
#declare xf1=rand(r2)-.5; #declare yf1=rand(r2)-.5;
sphere{0,1 texture{pigment{color<.5+rand(r2)/2,.5+rand(r2)/2,.5+rand(r2)/2>} 
finish{ambient 1 }} translate<xf1*(clock-3)*4000, yf1*(clock-3)*3000, 500>}
#declare i=i+1;
#end // while
}
#declare r2=seed(3413);
#declare imax=100*(clock-2.99)  ;
#declare i=0;
#declare starfield2 = union {
#while (i<(imax)*40)
#declare xf1=rand(r2)-.5; #declare yf1=rand(r2)-.5;
sphere{0,1 texture{pigment{color<.5+rand(r2)/2,.5+rand(r2)/2,.5+rand(r2)/2>} 
finish{ambient 1 }} translate<xf1*(clock-3)*2000, yf1*(clock-3)*1500, 500>}
#declare i=i+1;
#end // while
}

object {starfield rotate <0,0,cx+90>}
object {starfield2 rotate <0,0,cx+70>}

/*
sphere {0*x, 2000000 hollow//stars
	texture {
		pigment{image_map{tga "/home/matt/images/starsa1c.tga"
			map_type 1}}
		}
	finish {ambient 1 reflection 0}
}//stars 
*/
#end // => 3
#end // < 4


// STARS scenes zero, one, two

#if (clock >= 0)
#if (clock < 3) 

#declare r1=seed(1134);
#declare i=1;
#while (i<10000)//10000
//get randoms
#declare xf1=rand(r1); #declare yf1=rand(r1); #declare zf1=rand(r1);
//covert to radians
#declare xf2=xf1; #declare yf2=yf1*2*pi; #declare zf2=(zf1-.5)*pi/2;
#declare xf4=xf2*cos(yf2)*cos(zf2)*1000;
#declare yf4=xf2*sin(yf2)*cos(zf2)*1000;
#declare zf4=xf2*sin(zf2)*15000;

#if ( sqrt( xf4*xf4 + yf4*yf4 + zf4*zf4) > 500)
sphere{0,1 
texture{pigment{color<.5+rand(r1)/2, .5+rand(r1)/2 , .5+rand(r1)/2>}
finish{ambient 1 reflection 0}} translate<xf4,yf4,zf4>}
#end

#declare i=i+1;
#end //while

/*
sphere {0*x, 200000000 hollow//stars
	texture {
		pigment{image_map{tga "/home/matt/images/starsa1c.tga"
			map_type 1}}
		}
	finish {ambient 1 reflection 0}
}//stars 
*/

#end // if
#end // if




// SCENE ONE

#if (clock >= 1) 
#if (clock < 2 )
#declare spos=-4+8*(clock-1);

#if (clock < 1.5)

camera
{location  <-1.0, +delta, -4.0>
  direction 1.5*z right 4/3*x 
look_at <0,0,spos> 
}

#else

camera
{location  <-1.0 +1*(clock-1.5)/0.5  , +delta, -4.0 >
  direction 1.5*z right 4/3*x 
look_at <0,0,spos> 
}

#end


#if ( spos < -2 ) 

#declare gate = object { union {
torus { 0.9 ,.1-delta 
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.7 ,.1-delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.5 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.3 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.1 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}

light_source { 0*x color<1,0,0>
translate<0.9*sin(2*pi*0/360+(clock-1)*360*10/360),
0.9*cos(2*pi*0/360+(clock-1)*360*10/360),0.0>}

light_source { 0*x color<0,1,0> 
translate<0.9*sin(2*pi*120/360+(clock-1)*360*10/360),
0.9*cos(2*pi*120/360+(clock-1)*360*10/360), 0.0>}

light_source { 0*x color<0,0,1> 
translate<0.9*sin(2*pi*240/360+(clock-1)*360*10/360),
0.9*cos(2*pi*240/360+(clock-1)*360*10/360), 0.0>}
} // end union
} // end gate

#else

#declare gate = object { union {
torus { 0.9 ,.1-delta 
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.7 ,.1-delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,1*(spos+2)/6>}
torus { 0.5 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,2*(spos+2)/6>}
torus { 0.3 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,3*(spos+2)/6>}
torus { 0.1 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,4*(spos+2)/6>}

light_source { 0*x color<1,0,0>
translate
<
0.9*sin(2*pi*0/360+(clock-1)*360*10/360),
0.9*cos(2*pi*0/360+(clock-1)*360*10/360),
0.0>}

light_source { 0*x color<0,1,0> 
translate
<
0.9*sin(2*pi*120/360+(clock-1)*360*10/360),
0.9*cos(2*pi*120/360+(clock-1)*360*10/360),
0.0>}

light_source { 0*x color<0,0,1> 
translate
<
0.9*sin(2*pi*240/360+(clock-1)*360*10/360),
0.9*cos(2*pi*240/360+(clock-1)*360*10/360),
0.0>}

} // end union
} // end gate

#end

object {gate rotate 0*y}

#if ( spos < 0 )
/*
superellipsoid{< 3,3> texture {Gold_Nugget} scale .25 rotate<0,10*(clock-1),0>
translate<0,0, spos>}
*/
object{target scale .25 translate<0,0,spos>}

#else
/*
superellipsoid{< 3,3> texture {Gold_Nugget} scale .25*(1-(spos/4)) 
rotate<0,10*(clock-1),0> translate<0,0, spos>}
*/
object{target scale .25*(1-(spos/4)) translate<0,0,spos>}


#end

#end// 1 to 2
#end 

// SCENE TWO

#if (clock >= 2) 
#if (clock < 3 )
#declare spos=-4+8*(clock-1);

//go to six from 2-2.1, 5 just seen

// .12 

torus{.1+(clock-2)*27.5 - 0 ,.1-delta 
	texture{Lightening2 scale (clock-2)*100} 
	rotate<90,0, (clock-2)*10> translate<0,0,5>}

torus{0+(clock-2)*27.5 - 0 , .2-delta //-.15
	texture{Lightening2 scale(clock-2)*150 } 
	rotate<90,0, (clock-2)*20> translate<0,0,5>}

torus{0+(clock-2)*27.5 - 0 , .3-delta //-.25
	texture{Lightening2 scale(clock-2)*200 } 
	rotate<90,0,-(clock-2)*30> translate<0,0,5>}

#if (clock >=2)
#if (clock < 2.3)
#declare cpos=(clock - 2.0);
camera
{location  <0.0, +delta, -4.0+2*cpos/.3>
  direction 1.5*z right 4/3*x 
look_at <0,0,4> //z=spos 
}
#end
#end
/*
#if (clock >= 2.2)
#if (clock < 2.3)
#declare cpos =(clock - 2.2); // 0-.09

camera
 {location <0, +delta, -4+2*cpos/.09>
//{location  <-1.0, +delta, -4.0>
  direction 1.5*z right 4/3*x 
look_at <0,0,4> //z=spos 
}

#end
#end
*/
#if (clock >= 2.3)
#if (clock < 3)
#declare cpos = clock - 2.3 ; // 0-.69
camera
 {location <0, +delta, -2+6*cpos/.69>
//{location  <-1.0, +delta, -4.0>
  direction 1.5*z right 4/3*x 
look_at <0,0,40000> //z=cpos 
}

#declare gate = object { union {
torus { 0.9 ,.1-delta 
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.7 ,.1-delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,1*cpos/.69 >}
torus { 0.5 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,2*cpos/.69>}
torus { 0.3 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,3*cpos/.69>}
torus { 0.1 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,4*cpos/.69>}

light_source { 0*x color<1,0,0>
translate<0.9*sin(2*pi*0/360+(clock-1)*360*10/360),
0.9*cos(2*pi*0/360+(clock-1)*360*10/360),0.0>}

light_source { 0*x color<0,1,0> 
translate<0.9*sin(2*pi*120/360+(clock-1)*360*10/360),
0.9*cos(2*pi*120/360+(clock-1)*360*10/360), 0.0>}

light_source { 0*x color<0,0,1> 
translate<0.9*sin(2*pi*240/360+(clock-1)*360*10/360),
0.9*cos(2*pi*240/360+(clock-1)*360*10/360), 0.0>}
} // end union
} // end gate


#end
#end



#if (clock >= 2.2 ) 
#if (clock < 2.3 )

#declare gate = object { union {
torus { 0.9 ,.1-delta 
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.7 ,.1-delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.5 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.3 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.1 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}

light_source { 0*x color<1,0,0>
translate<0.9*sin(2*pi*0/360+(clock-1)*360*10/360),
0.9*cos(2*pi*0/360+(clock-1)*360*10/360),0.0>}

light_source { 0*x color<0,1,0> 
translate<0.9*sin(2*pi*120/360+(clock-1)*360*10/360),
0.9*cos(2*pi*120/360+(clock-1)*360*10/360), 0.0>}

light_source { 0*x color<0,0,1> 
translate<0.9*sin(2*pi*240/360+(clock-1)*360*10/360),
0.9*cos(2*pi*240/360+(clock-1)*360*10/360), 0.0>}
} // end union
} // end gate

#end
#end

#if (clock >= 2)
#if (clock < 2.2) 

#declare gate = object { union {
torus { 0.9 ,.1-delta 
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,0>}
torus { 0.7 ,.1-delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,1 - 1*(clock-2)/.2>}
torus { 0.5 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,2 - 2*(clock-2)/.2>}
torus { 0.3 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,3 - 3*(clock-2)/.2>}
torus { 0.1 ,.1 -delta
texture{pigment{color rgbt <1,1,1,1>}} interior{ior 0.9} finish{phong 5 phong_size
7} rotate <90,0,0> translate <0,0,4 -4*(clock-2)/.2 >}

light_source { 0*x color<1,0,0>
translate
<
0.9*sin(2*pi*0/360+(clock-1)*360*10/360),
0.9*cos(2*pi*0/360+(clock-1)*360*10/360),
0.0>}

light_source { 0*x color<0,1,0> 
translate
<
0.9*sin(2*pi*120/360+(clock-1)*360*10/360),
0.9*cos(2*pi*120/360+(clock-1)*360*10/360),
0.0>}

light_source { 0*x color<0,0,1> 
translate
<
0.9*sin(2*pi*240/360+(clock-1)*360*10/360),
0.9*cos(2*pi*240/360+(clock-1)*360*10/360),
0.0>}

} // end union
} // end gate

#end 
#end

object {gate rotate 0*y}


/*
#if ( spos < 0 )

superellipsoid{< 3,3> texture {Gold_Nugget} scale .25 rotate<0,10*(clock-1),0>
translate<0,0, spos>}


#else

superellipsoid{< 3,3> texture {Gold_Nugget} scale .25*(1-(spos/4)) 
rotate<0,10*(clock-1),0> translate<0,0, spos>}

#end
*/
#end// 1 to 2
#end 

