 
Pellet.pov  UQlM  8"lLJ J+UQHUVTVC   lM UTEXTNPOV       ;+  ˶u                       Ӵ  // Persistence of Vision Ray Tracer Scene Description File
// File: Pellet.pov
// Vers: 3.1
// Desc: PacMan and the Ghosts do their thing in the Maze
// Date: 
// Auth: 


#version 3.1;
//#version unofficial MegaPov 0.6;

//#include "colors.inc"
#include "maze.inc"
#include "newghost.inc"
#include "pellets.inc"
//#include "pac.inc"





// ----------------------------------------
#declare OverViewCam =
camera
{
  location  <0.0,190, -70.0>
  direction 1*z
  right     4/3*x
  look_at   <0.0, 5.0, 30.0>
}


#macro Orient_Z(v1,v2)
  #local nz = vnormalize(v2 - v1);
  #local nx = vnormalize(vcross(nz,y));
  #local ny = vcross(nz,nx);
  matrix <nx.x,nx.y,nx.z,
          ny.x,ny.y,ny.z,
          nz.x,nz.y,nz.z,
          v1.x,v1.y,v1.z>
#end

// Macro that builds the Pac
#macro PacMan(pclock,pos,rot)
difference { 
  sphere { <0,0,0> 4 pigment { rgb <1,1,0> } finish { ambient 0.4 }}
  sphere { <0,0,0> 3.8 pigment { rgb 0 } }
  box { <-5,0,0> <5,9,9> 
        rotate 45*x 
        scale <1,(1*pow(sin(2*pi*pclock)+0.001,2)),1> 
        translate 0.25*z 
        pigment { rgb <1,1,0> }}
  translate 5*y 
  rotate rot
  translate pos }
#end


#macro ReportV(SV)
  #render concat("\nReported Vector is <" + str(SV.x,5,5) + "," +
          str(SV.y,5,5) + "," + str(SV.z,5,5) + ">" )
#end

#declare useBlur = false;
#declare anim_clock = clock;


////Declare Shot numbers
#switch(anim_clock)
  #range ( 0, 1) 
    #render "\nCamera Shot 1"
    #declare Shot = 1; 
    #declare local_clock = (anim_clock - 0)/( 1- 0); 
    #break
  #range ( 1, 7) 
    #render "\nCamera Shot 2"
    #declare Shot = 2; 
    #declare local_clock = (anim_clock - 1)/( 7- 1); 
    #break
  #range ( 7, 9) #declare Shot = 3; #declare local_clock = (anim_clock - 7)/( 9- 7); #break
  #range ( 9,10) #declare Shot = 4; #declare local_clock = (anim_clock - 9)/(10- 9); #break
  #range (10,13) #declare Shot = 5; #declare local_clock = (anim_clock -10)/(13-10); #break
  #range (13,14) #declare Shot = 6; #declare local_clock = (anim_clock -13)/(14-13); #break
  #range (14,15) #declare Shot = 7; #declare local_clock = (anim_clock -14)/(15-14); #break
  #range (15,17) #declare Shot = 8; #declare local_clock = (anim_clock -15)/(17-15); #break
  #range (17,18) #declare Shot = 9; #declare local_clock = (anim_clock -17)/(18-17); #break
  #range (18,20) #declare Shot =10; #declare local_clock = (anim_clock -18)/(20-18); #break
  #range (20,20.5)
    #render "\nCamera Shot 11"
    #declare Shot = 11;
    #declare local_clock = (anim_clock - 20)/(20.5-20);
    #break
  #range(20.5,22)
    #render "\nCamera Shot 12"
    #declare Shot = 12;
    #declare local_clock = ( anim_clock - 20.5)/(22-20.5);
    #break
  #range(22,22.5)
    #render "\nCamera Shot 13"
    #declare Shot = 13;
    #declare local_clock = (anim_clock - 22)/(22.5 - 22);
    #break
  #range(22.5,23.5)
    #render "\nCamera Shot 14"
    #declare Shot = 14;
    #declare local_clock = (anim_clock - 22.5)/(23.5-22.5);
    #break
  #range(23.5,26)
    #render "\nCamera Shot 15"
    #declare Shot = 15;
    #declare local_clock = (anim_clock - 23.5)/(26-23.5);
    #break
  #range (26,26.5)
    #render "\nCamera Shot 16"
    #declare Shot = 16;
    #declare local_clock = (anim_clock - 26)/(26.5-26);
    #break
  #range (26.5,27)
    #render "\nCamera Chost 17"
    #declare Shot = 17;
    #declare local_clock = (anim_clock - 26.5)/(27-26.5);
    #break
  #range(27,30)
    #render "\nCamera Shot 18"
    #declare Shot = 18;
    #declare local_clock = (anim_clock -27)/(30-27);
    #break
  #range(30,31)
    #render "\nCamera Shot 19"
    #declare Shot = 19;
    #declare local_clock = (anim_clock -30)/(31-30);
    #break
  #range(31,32)
    #render "\nCamera Shot 20"
    #declare Shot = 20;
    #declare local_clock = (anim_clock-31)/(32-31);
    #break
#end

global_settings
{
  assumed_gamma 1
  // When we are looking through PacMan or a Ghosts POV, color everything
  #switch(anim_clock)
    #range(14.01,14.99) ambient_light (BlinkyColor+<1,1,1>)*3 #break // Blinky
    #range(17.01,17.99) ambient_light (BlinkyColor+<1,1,1>)*3 #break // Blinky
    #else ambient_light <1,1,1>
  #end
}


#render concat("\nCamera value is " + str(anim_clock,6,6))
// Take the camera shots and work them
#include "PacCams.inc" // Extra camera definitions for space saving
#switch (Shot)
  #case(1)
    camera { Camera1 }
    #break
  #case(2)
    #include "camShot2.inc"
    #break
  #case(3)
    #render "\nCamera Shot 3"
    camera { location <-40,5,-4.99> direction 1*z right 4/3*x look_at <local_clock*-40,5,0> }
    #break
  #case(4)
    #render "\nCamera Shot 4"
    #include "camShot4.inc"
    #break
  #case(5)
    #render "\nCamera Shot 5"
    #include "camShot5.inc"
    #break
  #case(6)
    #render "\nCamera Shot 6"
    camera { location <50,8,135> right 4/3*x direction 1*z look_at <50,5,120> }
    #break
  #case(7) // Camera looks from Blinky's POV
     #render "\nCamera Shot 7"
     camera { Camera7 }
     #break
  #case(8)
    #render "\nCamera Shot 8"
    camera { location <50,6,135> right 4/3*x direction 1*z look_at <50,5,120> } // hieight is 8
    #break
  #case(9) // Camera looks from BLinky's POV
    #render "\nCamera Shot 9"
    camera { Camera9 }
    #break
  #case(10)
    #render "\nCamera Shot 10"
    camera { location <50+local_clock*40,7,130> right 4/3*x direction 1*z look_at <50+local_clock*30,5,120> }
    #break
  #case(11)
    camera { location <90,7,130-local_clock*20>
             right 4/3*x direction (1-local_clock*0.25)*z 
             look_at <80,5,120-local_clock*10> }
    #break
  #case(12) // Pull Back while Blinky turns Blue
    camera { location <80,5,110-34*local_clock> right 4/3*x direction (1+local_clock*2.5)*z look_at <80,5,120> }
    #break
  #case(13)
    camera { location <80,7,100> right 4/3*x direction 1*z look_at <80,5,120> }
    #break
  #case(14)
    camera { location <80,7,100-20*local_clock> right 4/3*x direction 1*z look_at<80,5,120-20*local_clock> }
    #break
  #case(15)
    camera { location <50,25,80> right 4/3*x direction 1*z angle 80 look_at <60-local_clock*20,5,100> }
    #break
  #case(16)
    camera { location <5,5,30> right 4/3*x direction 1*z look_at <5,5,26> }
    #break
  #case(17)
    camera { location <5+local_clock*10,5,30+local_clock*10> 
             right 4/3*x direction 1*z 
             look_at <5-local_clock*5,5,26+local_clock*4> }
    #break
  #case(18)
    camera { location <15,5,40> right 4/3*x direction 1*z look_at <0,5,30> }
    #break
  #case(19)
    camera { location <20,6,16> right 4/3*x direction 1*z look_at <0,5,20> }
    //sphere { <00,5,20> 2 pigment { rgb <0,1,0> } }
    #break
  #case(20)
    camera { location <0,5,20> right 4/3*x direction 1*z look_at <-10,5,20> }
    #break
  #else
    camera { OverViewCam }
#end

#include "poster.inc"

// Sphere around camera at beginning
#if (Shot = 1 )
  sphere { <0,0,0> 1 hollow 
           pigment { cylindrical 
                     color_map { [ pow(1-local_clock,1.1) rgb 0 ] 
                                 [ pow(1-local_clock,0.9) rgbf 1] }
                     rotate 90*x 
                     turbulence 0.15 octaves 9 omega 0.4 lambda 4} 
           scale 0.25
           Orient_Z (<30,8,124.9>,<30,5,120>) }
#end


// Pac Man declarations
#switch(anim_clock)
  #range(0,7)
    object { PacMan(0,0,<0,-90,0>) }
    #break
  #range(7,10)
    #declare pac_clock = (anim_clock - 7)/(10-7);
    object { PacMan(anim_clock,<pac_clock*-60,0,0>,<0,-90,0>) }
    #break
  #range(15,17)
    #declare PacPlace = <35,0,100> + local_clock*(<65,0,100> - <35,0,100>);
    object { PacMan(anim_clock,PacPlace,<0,90,0>) }
    #break
  #range(18,20)
    object { PacMan(0,<80,0,100>,180) }
    #break
  #range(20,20.5)
    object { PacMan(anim_clock,<80,0,100+local_clock*10>,0) }
    #break
  #range(22,23.5)
    #declare p_clock = (anim_clock - 22)/(23.5 - 22);
    object { PacMan(anim_clock,<80-p_clock*30,0,120>,<0,-90,0>) }
    #break
  #range(30,32)
    #declare pclock = anim_clock - 30;
    object { PacMan(anim_clock,<-30+pclock*20,0,20>,<0,90,0>) }
    #break
#end

// pos is positiong
// rot is global roatation
// turn is the ghosts looking left or right
// ColorMode 0 normal 1 turning blue 2 is blue 3 going back
// colorclock is a normalized clock value for transitions
//#macro MakeGhost(ghost,pos,rot,turn,colm,colk)
// Blinky
#switch(anim_clock)
  #range (1,7)
    MakeGhost(Blinky,<0,0,50>,<0,180,0>0,0,0)
    #break
  #range (10,13)
    #local ghost_clock = (anim_clock-10)/(13-10);
    #declare b_start = <50,0,50>;
    #declare b_end = <50,0,120>;
    #declare b_place  = b_start + ghost_clock*(b_end - b_start);
    MakeGhost(Blinky,b_place,180,0,0,0)
    #break
  #range(13,14)
    #declare ghost_clock = (anim_clock-13)/(14-13);
    MakeGhost(Blinky,<50,0,120>,180,-80*sin(ghost_clock*pi/2),0,0)
    #break
  #range(15,17)
    MakeGhost(Blinky,<50,0,120>,180,-80*cos(local_clock*pi),0,0) 
    #break
  #range(18,20)
    #declare b_place = <50+local_clock*30,0,120>;
    #if (local_clock < 0.75 )
      #declare b_turn = 0;
    #else 
      #declare turn_clock = (local_clock - 0.75)/0.25;
      #declare b_turn = 90*sin(pi*turn_clock/2);
    #end
    MakeGhost(Blinky,b_place,270,b_turn,0,0)
    #break
  #range(20,20.5)
    MakeGhost(Blinky,<80,0,120>,270+90*local_clock,90-90*local_clock,0,0)
    #break
  #range(20.5,21.99)
    MakeGhost(Blinky,<80,0,120>,0,0.01,1,local_clock)
    #break
  #range(22,22.5) // No more blinky, just the eyes
    object { GhostEyes(0) rotate 180*y translate <80,0,120> }
    #break
  #range(22.5,23.5)
    #if (local_clock > 0.75)
       #declare gturn = 90*pow(sin(pi/2*(local_clock-0.75)/0.25),2);
    #else
       #declare gturn = 0;
    #end
    object { GhostEyes(0) rotate gturn*y translate <80,0,120-local_clock*20> }
    #break
  #range(23.5,26)
    #declare gpl = (anim_clock - 23.5)/(26-23.5);
    #if (anim_clock > 25.5 )
      #declare gturn = 90*cos(pi/2*(anim_clock-25.5)/.5);
    #else gturn = 90;
    #end
    object { GhostEyes(0) rotate gturn*y translate <80-gpl*50,0,100> }
    #break
  #range (26,28)
    #declare gclock = (anim_clock-26)/(28-26);
    object { GhostEyes(0) translate <0,0,55-gclock*20> }
    #break
  #range (28,30)
    #declare dh = (anim_clock-28);
    difference {
      sphere { <0,5,35> 4 pigment { BlinkyColor } }
      sphere { <0,5,35> 3.99999 pigment { BlinkyColor } }
      cylinder { <0,0,35> <0,9-2*dh,35> 5 pigment { rgbf 1 } } }
    object { GhostEyes(0) rotate <0,0,0> translate <0,0,35> }
    //sphere { <0,5,35> 1 pigment { rgb 1 } }
    #break
#end

// Pinky, Inky, and Clyde
#switch(anim_clock)
  #range (1,7)
    MakeGhost(Pinky,<-10+20*local_clock,0,30>,<0,-90,0>,0,0,0)
    MakeGhost(Inky,<10-20*local_clock,0,40>,<0,90,0>,0,0,0)
    MakeGhost(Clyde,<-20,0,30+local_clock*20>,<0,0,0>,0,0,0)
    #break
  #range (26,27)
    #declare gpl = <-10+(anim_clock-26)*20,0,60>;
    MakeGhost(Pinky,gpl,-90,0,2,0)
    #break
#end

// Inky


// Ghost Rejuvie Machine
#if (anim_clock > 25.9 )
#render "\nPlaque"
box { <0,0,0> <1,1,-0.1>
      pigment { image_map { tga "plaquetext.tga" map_type 0 interpolate 2 } }
      //normal { bump_map { tga "plaquebump.tga" map_type 0 interpolate 2 bump_size 0.5 } }
      finish { ambient 0.2 }
      scale <2,1,1>*1.1
      translate -1*x
      rotate 180*y
      translate <5.5,5,26> }

torus { 3.75, 0.5 scale <1,0.25,1> texture {railtexture } translate 35*z }
#if (anim_clock > 28 )
  #declare dh = (anim_clock-28);
  difference {
    disc { <0,9-2*dh,35> y 9-dh pigment { BlinkyColor } }
    sphere { <0,5,35> 3.99999 pigment { rgbf 1 } } }
#else
  disc { <0,9,35> y 7 pigment { BlinkyColor } }
#end

#end

//Pellets and when they get destroyed
#if(anim_clock > 7.5) #declare dpcnt[78] = false; #end
#if(anim_clock > 8.0) #declare dpcnt[77] = false; #end
#if(anim_clock > 8.5) #declare dpcnt[76] = false; #end
#if(anim_clock > 9.0) #declare dpcnt[75] = false; #end

// Pellets for Camera Shot 5 gone


#if(anim_clock > 10.0) #declare dpcnt[23] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[24] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[25] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[26] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[27] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[28] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[29] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[30] = false; #end
#if(anim_clock > 16.0) #declare dpcnt[31] = false; #end
#if(anim_clock > 16.5) #declare dpcnt[32] = false; #end
#if(anim_clock > 17.0) #declare dpcnt[33] = false; #end
#if(anim_clock > 17.5) #declare dpcnt[34] = false; #end

#if(anim_clock > 10.0) #declare dpcnt[36] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[37] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[38] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[39] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[40] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[46] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[47] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[48] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[49] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[50] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[51] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[52] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[57] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[59] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[61] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[63] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[65] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[67] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[69] = false; #end
#if(anim_clock > 10.0) #declare dpcnt[74] = false; #end

#if(anim_clock > 22.0) #declare dpcnt[16] = false; #end
#if(anim_clock > 22.5) #declare dpcnt[15] = false; #end
#if(anim_clock > 23.0) #declare dpcnt[14] = false; #end
#if(anim_clock > 23.5) #declare dpcnt[13] = false; #end
#if ( Shot != 12 )
  DrawPellets()
#end

// Power Pellets
object { PowerPellet translate <-80,5,-30> }
object { PowerPellet translate < 80,5,-30> }
object { PowerPellet translate <-80,5,110> }
#if (anim_clock < 20.5 )
  object { PowerPellet translate < 80,5,110> }
#end


#if (Shot = 19)
#declare cherry =
lathe {
	cubic_spline
	8, 
	<-0.16774, 0.37419>,
	<0.01290, -0.00000>,
	<0.35484, 0.14194>,
	<0.49677, 0.50968>,
	<0.40000, 0.81290>,
	<0.10968, 1.00000>,
	<0.00645, 0.89677>,
	<-0.05161, 0.80000>
	sturm
	texture {
		pigment {
			rgb <1, 0,0>
		}
		finish {
			//reflection 0.1
			ambient 0.2
		}
	}
}

#declare ch2 =
union {
  object { cherry }
  intersection {
    torus { 2, 0.05 pigment { rgb <0.647059,0.164706,0.164706>/2 } rotate 90*x translate -2*x } 
    box { <-0.25,0,-0.1> <0.1,0.75,0.1> pigment { rgb <0.647059,0.164706,0.164706>/2 } }
    translate 0.9*y } }

union {
object { ch2 translate <0.15,-1.65,0> rotate <5,0,15> }
object { ch2 translate <0.15,-1.65,0> scale <-1,1,1> rotate <-5,0,-15>}
sphere { <0,0,0> 0.09 pigment { rgb <0.647059,0.164706,0.164706>/2 } }
rotate anim_clock* y translate <0,5.65,20> }


#end

//camera { OverViewCam }

                                                                                               .com/pics/thumbs/034.jpg 0NI:0NI:      Zacks Redheaded Teen - Small tittOI:4OI:        http://www.classynudes.com/pics/thumbs/034.jpg 0NI:0NI:      Zacks Redheaded Teen - Small titted redhOI:4OI:        http://www.classynudes.com/pi            @      f4ttxt8BIMGKONGKONTVOD     	                        >                       'w    A  rpza                  /M  * )U     d      +      6           Trillian                   XBD    m
colors.inc                                                      |jTEXTNPOV                   Include     m  `     2Trillian:Applications:POV-Ray 3:Include:colors.inc  der           	    	         $  6 -8                      BD          =     SELc   *FPRF   6NwPM   Bstyl   NNwPo   Z        6                         [XPOV-Ray File Prefs                                                                                       