// Persistence of Vision Ray Tracer Scene Description File
// File: Cam4.inc
// Vers: 3.1
// Desc: Fourth Camera in Pellet Power
// Date: 
// Auth: JRE

    #declare CamLook = <-40,5,0>; // Camera's Look_at
    #declare CamLoc = <-40,5,-4.99>; //where the camera's location is
    #declare cam_z = 1; //the amount of camera zoom you want
    #declare back_dist = 9; // how far away the background is
    #declare cam_a = 4/3; // camera aspect ratio     
    #declare cam_s = <0,1,0>; // camera sky vectoy
    #declare cam_d = vnormalize(CamLook-CamLoc);
    #declare cam_r = vnormalize(vcross(cam_s,cam_d));
    #declare cam_u = vnormalize(vcross(cam_d,cam_r)); // camera up vector
    #declare cam_dir = cam_d * cam_z;
    #declare cam_right = cam_r * cam_a;
    camera { location CamLoc up cam_u right cam_r * cam_a direction (cam_d * cam_z) }

