 newghost.incUQlM  8"lLJ J+UQHUVTVh   lM UTEXTNPOV           [                       (p  // Persistence of Vision Ray Tracer Scene Description File
// File: NewGhost.inc
// Vers: 3.1
// Desc: Ghost include file for Pellet Power
// Date: Declared Suitable 12-15-2000
// Auth: Josh English
//

#version 3.1;
//#version unofficial MegaPov 0.6;

//#include "colors.inc"
//#include "pellets.inc"




// ----------------------------------------
//camera
//{
//  location  <0,10, 130>
//  direction 1*z
//  right     4/3*x
//  look_at   <0.0, 4.0,  110.0>
//}
//
//
//
//light_source
//{
//  0*x // light's position (translated below)
//  color red 1.0  green 1.0  blue 1.0  // light's color
//  translate <0,20, 130>
//}

//Basic Colors
#declare BlinkyColor = rgbf <1,0,0,0.1>; // Shadow
#declare PinkyColor = rgbf <1,0.5,0.5,0.1>; // Speedy
#declare InkyColor = rgbf <0,0.95,0.95,0.1>; // Bashful
#declare ClydeColor = rgbf <1,0.5,0.0,0.1>; // Pokey
#declare BlueColor = rgbf <0.1,0.1,1,0.1>; // Chomp

#declare Blinky = 0;
#declare Pinky = 1;
#declare Inky = 2;
#declare Clyde = 3;


#declare flare = 0.4;
#declare hstp = 4/10;
#switch (clock)
  #range (0,0.25)
    #declare local_clock = clock*4;
    #declare turn = 45*sin(local_clock*pi/2);
    #break
  #range (0.25,0.75)
    #declare turn = 45;
    #break
  #range (0.75,1)
    #declare local_clock = (clock-0.75)/(1-0.75);
    #declare turn = 45*sin((local_clock-1)*pi/2);
    #break
  #else
    #declare turn = 0;
#end

#macro turnskirt(turn)
	#declare rcnt = 0;
	#declare num = 90;
	#declare step = 360/num;
	mesh {
	#declare hcnt = 1;
	#while ( hcnt < 5 )
	  #declare rcnt = 0;
	  #while ( rcnt< num)
	    #declare cfl = flare - flare*pow(((hcnt -1)/4),0.5);
	    #declare nfl = flare - flare*pow((((hcnt+hstp)-1)/4),0.5);
	
	    #declare p0 = <4,0,0> + <sin(((rcnt/num)+(clock/24))*pi*24)*(sin((clock+(rcnt/num)*pi))*cfl),0,0>;
	    #declare p0 = vrotate(p0,<0,rcnt*step+turn*((hcnt-1)/4),0>);
	    #declare p0 = p0 + <0,hcnt,0>;
	
	    #declare p1 = <4,0,0> + <sin((((rcnt+1)/num)+(clock/24))*pi*24)*(sin((clock+((rcnt+1)/num)*pi))*cfl),0,0>;
	    #declare p1 = vrotate(p1,<0,(rcnt+1)*step+turn*((hcnt-1)/4),0>);
	    #declare p1 = p1 + <0,hcnt,0>;
	
	    #declare p2 = <4,0,0> + <sin(((rcnt/num)+(clock/24))*pi*24)*(sin((clock+(rcnt/num)*pi))*nfl),0,0>;
	    #declare p2 = vrotate(p2,<0,rcnt*step+turn*(((hcnt+hstp)-1)/4),0>);
	    #declare p2 = p2 + <0,hcnt+hstp,0>;
	
	    #declare p3 = <4,0,0> + <sin((((rcnt+1)/num)+(clock/24))*pi*24)*(sin((clock+((rcnt+1)/num)*pi))*nfl),0,0>;
	    #declare p3 = vrotate(p3,<0,(rcnt+1)*step+turn*(((hcnt+hstp)-1)/4),0>);
	    #declare p3 = p3 + <0,hcnt+hstp,0>;
	
	    triangle { p0 p1 p2 }
	    triangle { p1 p3 p2 }
	    #declare rcnt = rcnt + 1;
	  #end
	#declare hcnt = hcnt + hstp;
	#end
	}
#end // turnskirt Macro

 
// Mode0 look straight ahead
// Mode1 look back and forth
#macro GhostEyes(mode)
	union {
	sphere { <0,0,0> 1
	         pigment { wood 
	                   color_map { [ 0.4 rgb 0] [0.4 rgb 2 ] } 
	                   scale 1.5 
	                  #if(mode) rotate 18*sin(clock*pi)*y #end
	                   }
	         finish { ambient 0.5 }
	         scale <0.75,1,0.125>
	         translate <0.8,6.0,-4> }
	sphere { <0,0,0> 1
	         pigment { wood 
	                   color_map { [ 0.4 rgb 0] [0.4 rgb 2 ] } 
	                   scale 1.5 
	                  #if(mode) rotate 18*sin(clock*pi)*y #end
	                  }
	         finish { ambient 0.5 }
	         scale <0.75,1,0.125>
	         translate <-0.8,6,-4> }
	}
#end // Ghosteyes

// pos is positiong
// rot is global roatation
// turn is the ghoshts looking left or right
// ColorMode 0 normal 1 turning blue 2 is blue 3 going back
// colorclock is a normalized clock value for transitions
#macro MakeGhost(ghost,pos,rot,turn,colm,colk)
#local eyeMode = ((turn=0)?1:0);
#switch(ghost)
  #case (Blinky)
    #declare ThisColor = BlinkyColor;
    #break
  #case (Pinky)
    #declare ThisColor = PinkyColor;
   #break
  #case (Inky)
    #declare ThisColor = InkyColor;
   #break
  #case (Clyde)
    #declare ThisColor = ClydeColor;
   #break
  #else
    #declare ThisColor = rgb <1,1,1>;
    #render "\n Improper Ghost selected."
#end
  
//#render concat("\neyemode is " + str(eyeMode,1,1))
union { 
  union {
    difference {
      sphere { <0,5,0> 4 }
      box { <-4,1,-4> <4,5,4> } }
    object { turnskirt(turn) }
    #switch(colm)
    #case (0)
      pigment { ThisColor }
      #break
    #case(1)
      pigment { gradient y scale 8 translate 9*y color_map { [ pow(colk,2) BlueColor] [pow(colk,1) ThisColor ] } }
      #break
    #case(2)
      pigment { BlueColor }
      #break
    #case(3)
      pigment { gradient y scale 8 translate 1*y color_map { [pow(colk,2) ThisColor][pow(colk,1) BlueColor ] }}
      #break
    #else
      pigment { ThisColor }
    #end
    finish { ambient 0.2 } 
    interior { ior 0.95 }}
    
  object { GhostEyes(eyeMode) rotate turn*y}
  rotate rot*y
  translate pos
}
#end

// Examples of how to get the ghosts
//MakeGhost(Blinky,<9,0,105>,180,-45,0,0.0) 
//MakeGhost(Pinky,<-9,00,105>,180,45,1,clock)
//MakeGhost(Inky,<-5,0,95>,180,0,1,0.0)
//MakeGhost(Clyde,<5,0,95>,180,0,1,clock) 



                                                                                                                                      RIVNAPPL      " @RIVNAPPL      b RIVNAPPL      b RIVNDATA       RIVNDATA       RIVNDATA       RIVNDATA       @RIVNDATA       RIVNDATA       RIVNGAME       RIVNGAME      "      _  _     6           Trillian                   XBD    m
colors.inc                                                      |jTEXTNPOV                   Include     m  `     2Trillian:Applications:POV-Ray 3:Include:colors.inc                	    	         $  6 0\                           @      f4ttxt8BIMGKONGKONTVOD     	                        >                               ?  rpza                  /M  *   ~     d     {           8<     SELc   *NwPM   6styl   BNwPo   NFPRF   Z                 
       $    6    L,POV-Ray File Prefs                                                                                       