// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1;

//#include "colors.inc"
//
//global_settings
//{
//  assumed_gamma 1.0
//}
//
//// ----------------------------------------
//camera
//{
//  location  <0.0, 4.5, -1.0>
//  direction 1.*z
//  right     4/3*x
//  look_at   <0.0, 0.0,  0.0>
//}
//
//sky_sphere
//{
//  pigment
//  {
//    gradient y
//    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
//  }
//}
//
//light_source
//{
//  0*x // light's position (translated below)
//  color red 1.0  green 1.0  blue 1.0  // light's color
//  translate <-30, 30, -30>
//}
//
//// ----------------------------------------
//plane { y,0 pigment {color rgb <0.7,0.5,0.3>filter 0.5}}

// This file attempts to create a new, smoother, system for connecting several points.


//#declare lst = plist
// We need a way to point out where these points are.
#macro PlotPoints(lst,rad)
  #declare cnt = 0;
  #while ( cnt < dimension_size(lst,1) )
    sphere { lst[cnt], rad pigment { rgb <0,1,0> } finish { phong 1 } no_shadow }
    #if ( cnt > 0 )
      cylinder { lst[cnt-1] lst[cnt] rad pigment { rgb <0,1,0> } finish { phong 1 } no_shadow }
    #end
    //#render str(cnt,3,0)
    #declare cnt = cnt + 1;
  #end
#end

// lst is the pointlist to work with
// ent is the entrance vector 0 points directly at next point, 1 is parallel
#macro CreateFullCurve(lst,ent,ext,rat)
	// We need to create a new array to fit all the individual splines
	#declare tmp = (dimension_size(lst,1) -1) *3 +1;
//	#render concat("\nLonglist size: " + str(tmp,3,0))
	#local longlist = array[tmp][2]

	
	// Filling out the first two entries
	#local longlist[0][0] = lst[0];
	#local v0 = lst[1]-lst[0];
	#local v1 = lst[1]-lst[2];
	#local vn = vnormalize(vcross(v0,v1));
	#local v2 = vaxis_rotate(v0,vn,ent*degrees(acos(vdot(v0,v1)/(vlength(v0)*vlength(v1))))); 
	#local vl = vlength(lst[0] -lst[1])/3;
	#local longlist[1][0] = longlist[0][0]+vnormalize(v2)*vl;
	//cylinder { longlist[0] longlist[1] 0.04 pigment { blue 1 } }
	
	// FIlling out the middle of longlist
	#declare cnt = 1; // start at the second point
	#while ( cnt < dimension_size(lst,1)-1) // end one before the last one
	  #local onLong = 3*cnt; // find out where we are on longlist
	  #local longlist[onLong][0] = lst[cnt]; // fill in long list 3^n
	  //find the vector from cnt+1 to cnt -1
	  #local thisway = lst[cnt-1] - lst[cnt+1];
	  #local thatway = lst[cnt+1] - lst[cnt-1];
	
	  #local thislength = (rat)*vlength(lst[cnt]-lst[cnt-1])/(vlength(lst[cnt]-lst[cnt-1])+vlength(lst[cnt]-lst[cnt+1]));
	  #local thatlength = (rat)*vlength(lst[cnt]-lst[cnt+1])/(vlength(lst[cnt]-lst[cnt-1])+vlength(lst[cnt]-lst[cnt+1]));
	
	  #local thisway = vnormalize(thisway)*thislength;
	  #local thatway = vnormalize(thatway)*thatlength;
	
	  //cylinder { lst[cnt] (lst[cnt] + thisway) 0.04 pigment { green 1 } }
	  //cylinder { lst[cnt] (lst[cnt] + thatway) 0.04 pigment { blue 1 } }
	  #local longlist[onLong-1][0] = lst[cnt] + thisway;
	  #local longlist[onLong+1][0] = lst[cnt] + thatway;
	  #declare cnt = cnt + 1;
	#end
	
	//Fill out the last two entries
	#local tmp = dimension_size(longlist,1) -1;
	#local tm = dimension_size(lst,1)-1;
	#local longlist[tmp][0] = lst[cnt];
	
	#local v0 = lst[tm-1]-lst[tm];
	#local v1 = lst[tm-1]-lst[tm-2];
	#local vn = vnormalize(vcross(v0,v1));
	#local v2 = vaxis_rotate(v0,vn,ext*degrees(acos(vdot(v0,v1)/(vlength(v0)*vlength(v1))))); 
	#local vl = vlength(lst[tm] -lst[tm-1])/3;
	#declare longlist[tmp-1][0]= longlist[tmp][0] + vnormalize(v2)*vl;
	
	// The x component of the second vector will contain a "timestop."
	#local longlist[0][1] = <0,0,0>;
	#local longlist[dimension_size(longlist,1) -1][1] = <1,0,0>;
	#declare cnt = 0;
	#declare totallength = 0;
	#while ( cnt < dimension_size(lst,1)-1)
	  #declare thislength = vlength(lst[cnt+1]-lst[cnt]);
	 // #render concat("\n"+str(thislength,6,6))
	  #declare totallength = totallength + thislength;
	  #declare cnt = cnt + 1;
	#end
	
	#declare cnt = 1;
	#declare onlist = 3;
	#declare totalsofar = 0;
	#while ( cnt < dimension_size(lst,1)-1)
	  #declare totalsofar = totalsofar+vlength(lst[cnt+1]-lst[cnt])/totallength;
//	  #render concat("\n"+str(totalsofar,6,6))
	  #local longlist[onlist][1] = <totalsofar,0,0>;
	  //#declare totallength = totallength + thislength;
	  #declare cnt = cnt + 1;
	  #declare onlist = onlist+3;
	#end
	
	longlist
#end


// hokay, now I have a pointlist, I can define a unique long list, now draw bezier curves.
// culled and adjusted from bezier.inc
#macro ReturnPosition(A,B,C,D,num)
  #local m = 1 - num;
  #local this = A*pow(m,3) + 
                B*num*3*pow(m,2) + 
                C*3*pow(num,2)*m + 
                D*pow(num,3);
  this
#end

#macro PreviewCurve(lst,rad)
	#declare seg = 0;
	#while ( seg < dimension_size(lst,1)-3 )
	  #declare cnt = 0;
	  #while (cnt <= 1.00001 )
	    #local here = ReturnPosition(lst[seg+0][0],lst[seg+1][0],lst[seg+2][0],lst[seg+3][0],cnt);
	    sphere { here rad pigment { red 1 } }
	    #if ( cnt > 0 )
	      #local there = ReturnPosition(lst[seg+0][0],lst[seg+1][0],lst[seg+2][0],lst[seg+3][0],cnt-1/20);
	      cylinder { here there rad pigment { red 1 }}
	    #end
	    #declare cnt = cnt + 1/20;
	  #end
	  #declare seg = seg + 3;
	#end
#end

// Need to take a normalized position and find appropriate place on spline
#macro GetPlace(lst,n)
  #local n = max(0,min(n,1));
  //#render concat("\n n is " + str(n,4,4))
  #declare onList = 0;
  #while (vlength(lst[onList+3][1]) < n )
     #declare onList = onList + 3;
  #end

//  #render concat("\n SPline segment  is " + str(onList,4,4))
//  #render concat("\n vlength(lst[onList][1])  is " + str(vlength(lst[onList][1]),4,4))
//  #render concat("\n vlength(lst[onList+3][1]) is " + str(vlength(lst[onList+3][1]),4,4))
  #local localposition =  (n - vlength(lst[onList][1]))/(vlength(lst[onList+3][1]) - vlength(lst[onList][1]));
//  #render concat("\n localpoisition  is " + str(localposition,4,4))
  ReturnPosition(lst[onList+0][0],lst[onList+1][0],lst[onList+2][0],lst[onList+3][0],localposition)
#end

// Start with a list of points to connect.
//#declare plist = array[5]
//  { <-1.5,0,0.15><-2,1,1>  <0.5,1,-0.5> <2,0,0> <2,0,1> }
//
//#declare flist = CreateFullCurve(plist,0.95,0.1)
//
//PlotPoints(plist,0.05)
////PlotPoints(flist,0.02)
//
//PreviewCurve(flist,0.06)
//#declare P = GetPlace(flist,clock);
//
//sphere { P 0.07 pigment { rgb <1,1,0> } }