#version unofficial Megapov 0.7

#declare sun_clock=clock/10;

#macro spectral_color(phi)
  #declare cred=cos(phi)/2+0.5;
  #declare cgreen=cos(phi+2*pi/3)/2+0.5;
  #declare cblue=cos(phi+4*pi/3)/2+0.5;
  <cred,cgreen,cblue>
#end

#declare rr=max(0.1,5-clock/4);
  
//background { color rgb <0,0,1> }

#declare xcolor=spectral_color(-clock/20*2*pi);



#declare flares = density {
  spherical sine_wave frequency 2 phase sun_clock*2
  turbulence 0.5
  scale 1
  color_map {
    [0.00 color rgb xcolor*0.4]
    [0.95 color rgb xcolor*0.5]  
    [0.96 color rgb xcolor*0.6]
    [0.97 color rgb xcolor*0.7]
    [0.98 color rgb xcolor*0.8]
    [0.99 color rgb xcolor*0.9]
    [1.00 color rgb xcolor*1.0]
    }
  }

#declare halo = density {
  spherical
  color_map {
    [0.0 color 0]
    [0.2 color rgb 0]
    [0.3 color rgb xcolor/2]
    [0.5 color rgb xcolor]
    } 
  }
               
#declare corona = media {
  emission 1/10
  intervals 30
  samples 1,1
  density {
    spherical
    density_map {   
      [0.0 color 0]
      [0.2 flares]
      [0.5 halo]
      [1.0 color rgb <2,0.9,0.5>]
      }
    }
  }
      
 
#declare sun = object {
  union {
    sphere { 0,1
      pigment {
        bumps sine_wave
        phase clock/4
        color_map {
          [0.0 color rgb xcolor/2+clock/20]
          [1.0 color rgb xcolor/2+clock/20+0.01]
          }
        scale 0.2
        //turbulence 0.2
        }
      finish {
        ambient 1
        diffuse 0
        }
      scale 1
      no_shadow
      }    
      
    sphere { 0, 1
      pigment { color rgbf<1, 1, 1, 1> }
      finish { ambient 0 diffuse 0 }
      interior {
        //media { flares scale 0.8}
        //media { halo scale 0.7 } 
        media { corona }
        }
      scale 2
      hollow
      no_shadow
      }
     
    }
  }

// ++++++++++++++++++ Large Mass ++++++++++++++++++++

#declare xpos=0;
#declare zpos=0;

//#declare rr=1;
#declare mm=20;


//#declare px=sqrt((pr^2+sqrt(pr^4-0.25*m))/2)
//#declare py=-m/px

// x^6 + m^2/r^2 * x^2 -m^2 = 0

#declare aa=mm;    
//#render concat("aa ",str(aa,10,10),"\n")
#declare bb=0;
#declare cc=-mm*(rr^2);
//#render concat("cc ",str(cc,10,10),"\n")

#declare pp=(3*bb-(aa^2))/3; 
//#render concat("pp ",str(pp,10,10),"\n")
#declare qq=cc+2*(aa^3)/27-(aa*bb/cc);
//#render concat("qq ",str(qq,10,10),"\n")

#declare DD=(pp/3)^3+(qq/2)^2;

//#render concat("DD ",str(DD,10,10),"\n")

#if (DD>=0)
  #declare uu=(-qq/2+sqrt(DD))^(1/3);
  //#render concat("uu ",str(uu,10,10),"\n")
  #declare vv=(-qq/2-sqrt(DD))^(1/3);
  //#render concat("vv ",str(vv,10,10),"\n")

  #declare xx=sqrt(-aa/3+uu+vv);
#end

#if (DD<0)                                   
  #declare cospsi=-qq/(2*sqrt((abs(pp)/3)^3));
  #declare psi=acos(cospsi);
  #declare xx=(-aa/3+2*sqrt(abs(pp)/3)*cos(psi/3));
#end

//#render concat("px ",str(xx,10,10),"\n")
                         
#declare px=xx;
#declare py=-mm/px; 


#declare sy=sqrt(rr*rr-px*px);


//#render concat("px ",str(px,10,10),"\n")
//#render concat("py ",str(py,10,10),"\n")
//#render concat("sy ",str(sy,10,10),"\n")

/*
disc {
  <0,py,0>,<0,1,0>,px
  pigment {
    color rgb <1,0,0>
    }
  finish {
    ambient 0.5
    diffuse 0.5
    }
  }
*/

light_source {
  <0,py+sy,0>
  color rgb xcolor
  }
  
object { sun
  scale rr
  translate <0,py+sy,0>
  }
/*      
sphere {
  <xpos,py+sy,zpos>,rr
  pigment {
    color rgbt <1,1,1,0>
    }
  finish {
    ambient 1
    diffuse 1
    brilliance 0.5
    }
  }
*/


#declare grid=2-clock/10;
  
isosurface { 

  

    function {
    y*sqrt((x-xpos)*(x-xpos)+(z-zpos)*(z-zpos))+mm}
     threshold 0
    max_gradient 10
    accuracy 0.000001
 
  
   
 
  
  contained_by { box { <-500,-40,-500>, <500,500,500> } }
  //clipped_by { box { <-400,-400,-400><400,400,400> } }
  
  #include "universe_texture2.inc"
  
  universe_texture(grid,<1,1,1>*2) 
  no_shadow
  
  }


#declare psi=-clock/20*9
#declare rad=20-clock;

camera {
  #declare cx=rad*sin(psi);
  #declare cz=rad*cos(psi);
  #declare cy=-mm/rad+5
  location <cx,cy,cz>
  look_at <0,py+sy,0>
  //orthographic
  angle 60-clock
  }

plane {
  y,-40
  }
    