#version unofficial Megapov 0.7   

#declare test=0;
#declare dont_display_comet = 0;

/*
Gravity animation
name    start  end      objects                 scene name
1      -01.0 - 12.0     earth,moon               view earth, moon passes by
2       12.0 - 18.0     earth,moon,comet         camera spots comet
3       18.0 - 25.0     sun,comet,orbits               camera flies with comet, comet passes sun,...
4       25 - 38         sun,orbits
*/

#declare show_orbit = min(1,max(0,(clock-22)/3));
#render concat ("Show orbit=",str(show_orbit,1,3),"\n")

//--------------- move the camera -----------------                                                                                          
#declare camera_location=array[16] {
//<x,y,z,timestamp>
//  <0,-10,-5,0>,
  <1/13,0.01,-1/13*20+3.3,-1>,
  <0,0.01,3.3,0>,
  //<-1/13,0.01,1/13*20+3.3,0.999999999>,
  <-0.5-1/13,0.01,1/13*20+3.3,1>,
  <-2/13-3,0.01,2/13*20+3,2>,
  <-3/13-5,0.01,3/13*20+1,3>,
  <-2/13-1,1,6/13*20-13,6>,
  //<,4,8/13*20-17,7.99999>,
  <0,4,8/13*20-17,8>,
  //<-5,8,10/13*20-24,11>,
  //<3,15,-7,14>,
  <1,10,-14,12>,
  <20,10,0,15>,
  <60,10,100,17>,
  <-120,20,220,21>,
  //<-75,4,210,22>,
  <-400,60,100,25>,
  <-600,150,-50,28>,
  <-800,500,-200,30>,
  <-1200,1500,-800,32>,
  <-2000,8000,-4000,35>
  }

#declare camera_lookat=array[18] {
//<x,y,z,timestamp>
  <0,4,0,0>,
  <-1/13,4,1/13*20,1>,
  <-2/13,3,2/13*20,2>,
  <-3/13,2,3/13*20,3>,
  <-6/13,0,6/13*20,6>,
  <-8/13,0,8/13*20+0.5,8>,
  <-10/13,0,10/13*20+1.5,10>,
  <-13/13,0,13/13*20+2,12.99999>,
  <-13/13,0,13/13*20+2,13>,
  <90,0,171,17>,
  <35,0,165,18>,
 // <66,1,239,17>,
 // <-2,1,228,19>,
  <-93,1,135,20>,
  <-177,3,94,21>,
  <-233,3,34,22>,
  //<-200,2,100,22.5>,
  <-200,3,0,25>,
  <-200,3,0,27>,
  <-250,10,-80,30>,
  <-250,10,-80,35>
  }

#declare camera_angle=array[9] {
//<angle,timestamp>
  <65,0>,
  <65,2>,
  <60,4>,
  <50,8>,
  <50,14>,
  <60,17>,
  <65,22>,
  <65,30>,
  <65,35>
  }
  
#declare grid_scale=array[7] {
//<size,timestamp>
  <0,0>,
  <1,13>,
  <2,16>,
  <2.5,20>,
  <3,30>,
  <4,35>,
  <5,38>
  }  
//-------------------------------------------------  

#include "camera.inc"
#include "universe_texture.inc"

#if (clock<39) #declare scene=4 #end
#if (clock<25) #declare scene=3 #end
#if (clock<18) #declare scene=2 #end
#if (clock<12) #declare scene=1 #end
#if (test) #declare scene=-test #end

#render "\n------------------------------------------------\n"
#render concat ("Clock=",str(clock,1,2)," frame=",str(frame_number,1,0)," scene=",str(scene,1,0),"\n")

global_settings {
  #if (!test)
    motion_blur 5,clock_delta
  #end       
  ambient_light <1,1,1>
  }
background { color rgb <0,0,0> }

// ******************** scene 1 ********************

#if (scene=1)
  #declare scene_clock=clock/13;
  #include "earth.inc"
  #include "moon.inc"
  
  //earth and moon
  
  #include "scene1+2.inc"

  //universe
  
  #declare universe = isosurface { 
    function { universe }
    threshold 0
    max_gradient 2
    contained_by { box { -1000, 1000 } }
    //clipped_by { box { <-400,-400,-400><400,400,400> } }
    universe_texture(<0,0,0.7>)
    no_shadow
    }
      
  object { universe }
  light_source { <-200,-20,0> color rgb <1,1,1> }
  
  camera {
    //#declare yoff=0;
    #declare loc=eval_camera_location(clock);
    #declare yoff=-eval_universe(loc*<1,0,1>);
    #if (yoff<earthpos.y) #declare yoff=earthpos.y #end
    #declare cl=loc+<0,yoff,0>;
    #declare look=eval_camera_lookat(clock);
    #declare yoff=-eval_universe(look*<1,0,1>);
    #if (yoff<earthpos.y) #declare yoff=earthpos.y #end
    #declare la=look+<0,yoff,0>;
    #declare ang=eval_camera_angle(clock);
    #debug concat("camera location=<",str(cl.x,1,3),",",str(cl.y,1,3),",",str(cl.z,1,3),"> look_at=<",str(la.x,1,3),",",str(la.y,1,3),",",str(la.z,1,3),"> angle=",str(ang,1,3),"\n")
    location cl
    look_at la
    angle ang
    }
    
#end

// ******************** scene 2 ********************

#if (scene=2)
  #declare scene_clock=clock/13;
  #declare comet_clock=clock;
  #include "earth.inc"
  #include "moon.inc"
   
  //earth and moon
  
  #include "scene1+2.inc"

  //universe
  
  #declare universe = isosurface { 
    function { universe }
    threshold 0
    max_gradient 2
    contained_by { box { -5000, 5000 } }
    //clipped_by { box { <-400,-400,-400><400,400,400> } }
    universe_texture(<0,0,0.7>)
    no_shadow
    }
 
  // comet 
  
  #include "comet.inc"
  display_comet()
        
  object { universe }
  light_source { <-200,-20,0> color rgb <1,1,1> }

  camera {
    //#declare yoff=0;
    #declare loc=eval_camera_location(clock);
    #declare yoff=-eval_universe(loc*<1,0,1>);
    #if (yoff<earthpos.y) #declare yoff=earthpos.y #end
    #declare cl=loc+<0,yoff,0>;
    #declare look=eval_camera_lookat(clock);
    #declare yoff=-eval_universe(look*<1,0,1>);
    #if (yoff<earthpos.y) #declare yoff=earthpos.y #end
    #declare la=look+<0,yoff,0>;
    #declare ang=eval_camera_angle(clock);
    #render concat("camera location=<",str(cl.x,1,3),",",str(cl.y,1,3),",",str(cl.z,1,3),"> look_at=<",str(la.x,1,3),",",str(la.y,1,3),",",str(la.z,1,3),"> angle=",str(ang,1,3),"\n")
    location cl
    look_at la
    angle ang
    }
      
#end

// ******************** scene 3 ********************

#if (scene=3)
  #declare comet_clock=clock; 
  //#declare comet_clock=0.65;
  #declare sun_clock=clock/5;
  #include "sun.inc"  
  
  //the sun
  
  #include "scene3+4.inc"

  //universe
  
  #declare universe = isosurface { 
    function { universe }
    threshold 0
    max_gradient 2
    contained_by { box { -10000, 10000 } }
   // clipped_by { box { <-400,-400,-400><400,400,400> } }
    universe_texture(<0.25,0,0>)
    no_shadow
    }
      
  object { universe }

  // comet

  #include "comet.inc"
  display_comet()
  #include "orbits.inc"
  
  light_source { <-200,-20,0> color rgb <1,1,1> }
 // plane { y,0
 //   pigment { color rgbt <0,0,1,0.5> }
 //   finish { ambient 1 }
 // }
 
  camera {
    //#declare yoff=0;
    #declare loc=eval_camera_location(clock);
    #declare yoff=-eval_universe(loc*<1,0,1>);
    #declare cl=loc+<0,yoff,0>;
    #declare look=eval_camera_lookat(clock);
    #declare yoff=-eval_universe(look*<1,0,1>);
    #declare la=look+<0,yoff,0>;
    #declare ang=eval_camera_angle(clock);
    #render concat("camera location=<",str(cl.x,1,3),",",str(cl.y,1,3),",",str(cl.z,1,3),"> look_at=<",str(la.x,1,3),",",str(la.y,1,3),",",str(la.z,1,3),"> angle=",str(ang,1,3),"\n")
    location cl
    look_at la
    angle ang
    }
      
#end 


// ******************** scene 4 ********************

#if (scene=4)
  
  #declare sun_clock=clock/5;
  #include "sun.inc"  
  
  //the sun
  
  #include "scene3+4.inc"

  //universe
  
  #declare universe = isosurface { 
    function { universe }
    threshold 0
    max_gradient 2
    contained_by { box { -20000, 20000 } }
   // clipped_by { box { <-400,-400,-400><400,400,400> } }
    universe_texture(<0.25,0,0>)
    no_shadow
    }
      
  object { universe }

  include "orbits.inc"
  
  light_source { <-200,-20,0> color rgb <1,1,1> }
 // plane { y,0
 //   pigment { color rgbt <0,0,1,0.5> }
 //   finish { ambient 1 }
 // }
 
  camera {
    //#declare yoff=0;
    #declare loc=eval_camera_location(clock);
    #declare yoff=-eval_universe(loc*<1,0,1>);
    #declare cl=loc+<0,yoff,0>;
    #declare look=eval_camera_lookat(clock);
    #declare yoff=-eval_universe(look*<1,0,1>);
    #declare la=look+<0,yoff,0>;
    #declare ang=eval_camera_angle(clock);
    #render concat("camera location=<",str(cl.x,1,3),",",str(cl.y,1,3),",",str(cl.z,1,3),"> look_at=<",str(la.x,1,3),",",str(la.y,1,3),",",str(la.z,1,3),"> angle=",str(ang,1,3),"\n")
    location cl
    look_at la
    angle ang
    }
      
#end 


// ******************** (test 1) ********************
//                  sun-grav_field
// **************************************************

#if (scene=-1)
  #declare sun_clock=0;
  #include "sun.inc"
  
  //the sun
  
  #include "scene3+4.inc"

  //universe
  
  #declare universe = isosurface { 
    function {
      y
      +sun_f
      }
    threshold 0
    max_gradient 2
    contained_by { box { -500, 500 } }
    clipped_by { box { <-400,-200,-200><200,200,200> } }
    universe_texture(<0.5,0,0>)
    //pigment { color rgbt <0,0,0,0.5> }
    no_shadow
    }
      
  object { universe }
  light_source { <-200,-60,0> color rgb <1,1,1> }
  //box {
  //  <-400,0,-200><200,200,200>
  //  pigment { color rgbt <0,0,1,0.8> }
  //  finish { ambient 1 }
  //  }
  
  camera {
    location <-100,200,-500>
    look_at <-200,00,0>
    orthographic
    }

  background { color rgb <1,1,1> }    
#end 

// ******************** (test 2) ********************
//              sun-earth-moon-grav_field
// **************************************************

#if (scene=-2)
  #declare scene_clock=0;
  #include "earth.inc"
  #include "moon.inc"
  
  //the sun
  
  #include "scene1+2.inc"

  //universe
  
  #declare universe = isosurface { 
    function {
      y
      +sun_f+large+small
      }
    threshold 0
    max_gradient 2
    contained_by { box { -500, 500 } }
    clipped_by { box { <-400,-200,-200><200,200,200> } }
    universe_texture(<0.5,0,0>)
    //pigment { color rgbt <0,0,0,0.5> }
    no_shadow
    }
      
  object { universe }
  light_source { <-200,-60,0> color rgb <1,1,1> }
  //box {
  //  <-400,0,-200><200,200,200>
  //  pigment { color rgbt <0,0,1,0.8> }
  //  finish { ambient 1 }
  //  }
  
  camera {
    location <-100,400,-500>
    look_at <-5,-55,0>
    angle 2
    orthographic
    }

  background { color rgb <1,1,1> }    
#end 

// ******************** (test 3) ********************
//              comet-positions/comet_clock
// **************************************************

#if (scene=-3)
  #declare comet_clock=0;
  #declare sun_clock=0; 
  #include "sun.inc"
  #include "scene3+4.inc"
  #include "comet.inc"
  #declare x_clock=14;
  #while (x_clock<50)
    #declare comet_clock=(x_clock-13)/24;
    #declare comet_pos=comet_position(comet_clock);
    #render concat ("clock=",str(x_clock,1,2)," comet_position x=",str(comet_pos.x,1,2)," y=",str(comet_pos.y,1,2), " z=",str(comet_pos.z,1,2),"\n") 
    #declare x_clock=x_clock+1;
  #end
#end 

// ******************** (test 4) ********************
//                display camera splines
// **************************************************
      
#if (scene=-4)
  #declare dont_display_comet = 1;
  #declare comet_clock = 0;
  #include "comet.inc"
  camera {
    location <0,100,0>
    look_at <0,0,0>
    }
  plane {
    y,-1
    pigment { checker scale 10}
    finish { ambient 0.2 diffuse 0 }
    } 
  display_motion_path (0.2,0,16,0.1,1,14)
  //display_comet_path (2,-1,30,0.1,20)
  //print_cometpos(21)
#end  

// ******************** (test 5) ********************
//                display planet orbits
// **************************************************
      
#if (scene=-5)            
  #declare sun_clock=0;
  #include "sun.inc"
  #include "scene3+4.inc"
  #include "orbits.inc"
  
  camera {
    location <10000,20000,10000>/4
    look_at <0,0,0>
    } 
  #declare universe = isosurface { 
    function { universe }
    threshold 0
    max_gradient 2
    contained_by { box { -100000, 100000 } }
    //clipped_by { box { <-10000,-00,-400><400,400,400> } }
    universe_texture(<0.25,0,0>)
    no_shadow
    }
  object { universe no_shadow}
  light_source { <-200,-20,0> color rgb <1,1,1> }

  
#end                          